/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.utilities.studio;

import com.sas.olapadmin.designer.model.AggregationSet;
import com.sas.olapadmin.designer.model.ModelUtilities;
import com.sas.olapadmin.designer.model.OLAPAggregation;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.visuals.VisualUtilities;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.olapadmin.utilities.studio.PerformanceOptionsPanel;
import com.sas.swing.models.CollectionToListModelAdapter;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAdminResource;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class PerformanceAggregationOptionsTab
extends WAPropertyTab {
    private static final long serialVersionUID = 1L;
    private static WAdminResource bundle = new WAdminResource(PerformanceAggregationOptionsTab.class);
    private JLabel aggregationName;
    private OLAPCube olapCube;
    private boolean initialized;
    private Vector aggregationDataPaths;
    private Vector aggregationIndexPaths;
    private PerformanceOptionsPanel options;
    private CollectionToListModelAdapter listModel;
    private JList list;
    private OLAPAggregation currentAggregation;
    private List listOfAggregations;
    private AggregationSet aggregationSet;
    private TreeSet sortAggrs;
    private boolean isCoalesce;
    private HashMap currentValues;
    private List sharedOptions;
    private boolean isTuning;

    public PerformanceAggregationOptionsTab(OLAPCube cube, Vector datapaths, Vector indexpaths, boolean coalesce, List optionList) {
        this(cube, datapaths, indexpaths, coalesce, optionList, false);
    }

    public PerformanceAggregationOptionsTab(OLAPCube CM, Vector datapaths, Vector indexpaths, boolean coalesce, List optionList, boolean tuning) {
        this.olapCube = CM;
        this.aggregationDataPaths = datapaths;
        this.aggregationIndexPaths = indexpaths;
        this.isCoalesce = coalesce;
        this.isTuning = tuning;
        this.currentValues = new HashMap();
        this.sharedOptions = optionList;
        this.setHelpProduct("olapadmin");
        this.setHelpTopic("cd_perf_aggr");
        this.setLayout(new GridBagLayout());
        this.layoutWidgets();
    }

    public boolean doDataExchange(boolean saveToModel) {
        return true;
    }

    public void moveDataToStore() {
        this.updateValues(this.currentAggregation);
    }

    public void moveDataToView() {
        if (!this.initialized) {
            this.list.addListSelectionListener(new AggregationSelectionListener());
            this.list.setSelectionMode(0);
            this.aggregationSet = this.olapCube.getAggregationSet();
            this.sortAggrs = new TreeSet();
            this.listModel.setModel((Collection)this.sortAggrs);
            this.initialized = true;
        }
        try {
            this.listOfAggregations = this.isCoalesce ? this.aggregationSet.getCoalescedAggregations() : this.aggregationSet.getAggregations();
        }
        catch (OLAPException e) {
            ExceptionHandler.handleException((Exception)((Object)e));
        }
        this.sortAggrs.clear();
        int size = this.listOfAggregations.size();
        for (int j = 0; j < size; ++j) {
            OLAPAggregation aggr = (OLAPAggregation)this.listOfAggregations.get(j);
            if (this.isTuning && (!this.isTuning || aggr.isNway())) continue;
            this.sortAggrs.add(aggr);
        }
        this.listModel.refresh();
        if (!this.listOfAggregations.isEmpty()) {
            if (this.currentAggregation != null && this.listOfAggregations.contains(this.currentAggregation)) {
                this.list.setSelectedValue(this.currentAggregation, true);
            } else {
                this.list.setSelectedIndex(0);
                this.currentAggregation = (OLAPAggregation)this.list.getSelectedValue();
            }
        }
        this.options.refreshDropDownLists(this.olapCube);
    }

    protected void layoutWidgets() {
        JPanel listboxPanel = new JPanel();
        listboxPanel.setLayout(new GridBagLayout());
        this.listModel = new CollectionToListModelAdapter();
        this.list = new JList(this.listModel);
        this.list.setCellRenderer(new AggrListCellRenderer());
        JScrollPane scrollPane = new JScrollPane(this.list);
        scrollPane.setName("AggrCoalesceList");
        JLabel labelBox = new JLabel();
        VisualUtilities.setLabelTextAndMnemonic(labelBox, bundle.getString("AggregationsOptions.List.control.label"));
        labelBox.setLabelFor(this.list);
        scrollPane.setPreferredSize(new Dimension(150, 200));
        listboxPanel.add((Component)labelBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 10, 0), 0, 0));
        listboxPanel.add((Component)scrollPane, new GridBagConstraints(0, 1, 1, 3, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(listboxPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 1, new Insets(0, 0, 0, 20), 0, 0));
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        this.aggregationName = new JLabel();
        JLabel instructions = new JLabel(bundle.getString("AggregationsOptions.instructions.txt"));
        this.options = new PerformanceOptionsPanel(null, this.aggregationDataPaths, this.aggregationIndexPaths, false, null, null, null, this.sharedOptions, false);
        this.options.setPreferredSize(new Dimension(400, 200));
        panel.add((Component)this.aggregationName, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 10, 0), 0, 0));
        panel.add((Component)instructions, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 10, 0), 0, 0));
        panel.add((Component)((Object)this.options), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(panel, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void onParentOK() {
        try {
            this.updateValues(this.currentAggregation);
            for (OLAPAggregation aggr : this.currentValues.keySet()) {
                HashMap values = (HashMap)this.currentValues.get(aggr);
                if (values.containsKey("PARTSIZE")) {
                    Integer partsize = (Integer)values.get("PARTSIZE");
                    aggr.setPerformanceOptionPartsize(partsize);
                }
                if (values.containsKey("SEGSIZE")) {
                    Integer segsize = (Integer)values.get("SEGSIZE");
                    aggr.setPerformanceOptionSegsize(segsize);
                }
                if (values.containsKey("DATAPATH")) {
                    String datapath = (String)values.get("DATAPATH");
                    aggr.setPerformanceOptionDatapath(datapath);
                }
                if (values.containsKey("INDEXPATH")) {
                    String indexpath = (String)values.get("INDEXPATH");
                    aggr.setPerformanceOptionIndexpath(indexpath);
                }
                if (values.containsKey("COMPRESS")) {
                    Boolean compress = (Boolean)values.get("COMPRESS");
                    aggr.setPerformanceOptionCompress(compress);
                }
                if (!values.containsKey("INDEX")) continue;
                Boolean index = (Boolean)values.get("INDEX");
                aggr.setPerformanceOptionIndex(index);
            }
        }
        catch (OLAPException e) {
            ExceptionHandler.handleException((Exception)((Object)e));
        }
    }

    private void updateValues(OLAPAggregation inputAggr) {
        if (inputAggr == null) {
            return;
        }
        try {
            Boolean compress;
            boolean hasPartsize = false;
            boolean hasSegsize = false;
            boolean hasDatapath = false;
            boolean hasIndexpath = false;
            boolean hasCompress = false;
            boolean hasIndex = false;
            if (!this.currentValues.containsKey(inputAggr)) {
                this.currentValues.put(inputAggr, new HashMap());
            }
            HashMap aggrValues = (HashMap)this.currentValues.get(inputAggr);
            aggrValues.clear();
            Integer newValue = null;
            String value = this.options.getPartsize();
            Integer partsize = inputAggr.getPerformanceOptionPartsize();
            boolean bl = hasPartsize = partsize != null;
            if (!ModelUtilities.isBlank((String)value)) {
                hasPartsize = true;
                newValue = Integer.valueOf(value);
                if (!newValue.equals(partsize)) {
                    aggrValues.put("PARTSIZE", newValue);
                }
            } else if (partsize != null) {
                aggrValues.put("PARTSIZE", null);
                hasPartsize = false;
            }
            value = this.options.getSegsize();
            Integer segsize = inputAggr.getPerformanceOptionSegsize();
            boolean bl2 = hasSegsize = segsize != null;
            if (!ModelUtilities.isBlank((String)value)) {
                hasSegsize = true;
                newValue = Integer.valueOf(value);
                if (!newValue.equals(segsize)) {
                    aggrValues.put("SEGSIZE", newValue);
                }
            } else if (segsize != null) {
                aggrValues.put("SEGSIZE", null);
                hasSegsize = false;
            }
            value = this.options.getDatapath();
            String datapath = inputAggr.getPerformanceOptionDatapath();
            boolean bl3 = hasDatapath = datapath != null;
            if (!ModelUtilities.isBlank((String)value)) {
                if (!value.equals(datapath)) {
                    hasDatapath = true;
                    aggrValues.put("DATAPATH", value);
                    if (!this.aggregationDataPaths.contains(value)) {
                        this.aggregationDataPaths.remove(value);
                        this.aggregationDataPaths.insertElementAt(value, 0);
                        if (this.aggregationDataPaths.size() > VisualUtilities.MAX_PATHS) {
                            this.aggregationDataPaths.remove(VisualUtilities.MAX_PATHS);
                        }
                    }
                }
            } else if (datapath != null) {
                aggrValues.put("DATAPATH", null);
                hasDatapath = false;
            }
            value = this.options.getIndexpath();
            String indexpath = inputAggr.getPerformanceOptionIndexpath();
            boolean bl4 = hasIndexpath = indexpath != null;
            if (!ModelUtilities.isBlank((String)value)) {
                if (!value.equals(indexpath)) {
                    hasIndexpath = true;
                    aggrValues.put("INDEXPATH", value);
                    if (!this.aggregationIndexPaths.contains(value)) {
                        this.aggregationIndexPaths.remove(value);
                        this.aggregationIndexPaths.insertElementAt(value, 0);
                        if (this.aggregationIndexPaths.size() > VisualUtilities.MAX_PATHS) {
                            this.aggregationIndexPaths.remove(VisualUtilities.MAX_PATHS);
                        }
                    }
                }
            } else if (indexpath != null) {
                aggrValues.put("INDEXPATH", null);
                hasIndexpath = false;
            }
            hasCompress = (compress = inputAggr.getPerformanceOptionCompress()) != null;
            String currValue = this.options.getCompress();
            Boolean newBoolean = null;
            if (currValue.equals(PerformanceOptionsPanel.ON)) {
                newBoolean = true;
            } else if (currValue.equals(PerformanceOptionsPanel.OFF)) {
                newBoolean = false;
            }
            if (newBoolean == null && compress != null) {
                aggrValues.put("COMPRESS", null);
                hasCompress = false;
            } else if (newBoolean != null && !newBoolean.equals(compress)) {
                aggrValues.put("COMPRESS", newBoolean);
                hasCompress = true;
            }
            newBoolean = null;
            Boolean index = inputAggr.getPerformanceOptionIndex();
            hasIndex = index != null;
            currValue = this.options.getIndex();
            if (currValue.equals(PerformanceOptionsPanel.ON)) {
                newBoolean = true;
            } else if (currValue.equals(PerformanceOptionsPanel.OFF)) {
                newBoolean = false;
            }
            if (newBoolean == null && index != null) {
                aggrValues.put("INDEX", null);
                hasIndex = false;
            } else if (newBoolean != null && !newBoolean.equals(index)) {
                aggrValues.put("INDEX", newBoolean);
                hasIndex = true;
            }
            boolean hasoptions = hasPartsize | hasSegsize | hasDatapath | hasIndexpath | hasCompress | hasIndex;
            aggrValues.put("HASOPTIONS", hasoptions);
        }
        catch (OLAPException e) {
            ExceptionHandler.handleException((Exception)((Object)e));
        }
    }

    public boolean validateData() {
        boolean ok = true;
        try {
            if (this.currentAggregation != null) {
                String value = this.options.getPartsize();
                if (!ModelUtilities.isBlank((String)value)) {
                    this.currentAggregation.verifyPerformanceOptionPartsize(Integer.valueOf(value));
                }
                if (!ModelUtilities.isBlank((String)(value = this.options.getSegsize()))) {
                    this.currentAggregation.verifyPerformanceOptionSegsize(Integer.valueOf(value));
                }
            }
        }
        catch (IllegalArgumentException error) {
            ok = false;
            ExceptionHandler.handleException((Exception)error);
        }
        return ok;
    }

    class AggregationSelectionListener
    implements ListSelectionListener {
        AggregationSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            boolean updateOK = true;
            OLAPAggregation nextAggregation = (OLAPAggregation)PerformanceAggregationOptionsTab.this.list.getSelectedValue();
            if (PerformanceAggregationOptionsTab.this.currentAggregation != null && !PerformanceAggregationOptionsTab.this.currentAggregation.equals(nextAggregation) && (updateOK = PerformanceAggregationOptionsTab.this.validateData())) {
                PerformanceAggregationOptionsTab.this.updateValues(PerformanceAggregationOptionsTab.this.currentAggregation);
            }
            if (updateOK) {
                if (nextAggregation != null) {
                    PerformanceAggregationOptionsTab.this.aggregationName.setText(bundle.formatString("AggregationsOptions.AggregationName.fmt.txt", (Object)nextAggregation.getName()));
                } else {
                    PerformanceAggregationOptionsTab.this.aggregationName.setText(bundle.formatString("AggregationsOptions.AggregationName.fmt.txt", (Object)""));
                }
                try {
                    if (nextAggregation == null || !nextAggregation.equals(PerformanceAggregationOptionsTab.this.currentAggregation)) {
                        HashMap aggrValues = (HashMap)PerformanceAggregationOptionsTab.this.currentValues.get(nextAggregation);
                        PerformanceAggregationOptionsTab.this.options.setValues(nextAggregation, aggrValues);
                    }
                }
                catch (OLAPException error) {
                    ExceptionHandler.handleException((Exception)((Object)error));
                }
                PerformanceAggregationOptionsTab.this.currentAggregation = nextAggregation;
            } else if (PerformanceAggregationOptionsTab.this.currentAggregation != null) {
                PerformanceAggregationOptionsTab.this.list.setSelectedValue(PerformanceAggregationOptionsTab.this.currentAggregation, true);
            }
        }
    }

    class AggrListCellRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 1L;

        AggrListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list1, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list1, value, index, isSelected, cellHasFocus);
            OLAPAggregation aggr = (OLAPAggregation)value;
            this.setText(aggr.getName());
            try {
                boolean hasOptions;
                HashMap aggrValues = (HashMap)PerformanceAggregationOptionsTab.this.currentValues.get(aggr);
                if (aggrValues == null || aggrValues.isEmpty()) {
                    hasOptions = aggr.hasPerformanceOptions();
                } else {
                    Boolean temp = (Boolean)aggrValues.get("HASOPTIONS");
                    hasOptions = temp;
                }
                if (hasOptions) {
                    this.setIcon(bundle.getImageIcon("AggregationOptions.Options.image"));
                } else {
                    this.setIcon(bundle.getImageIcon("AggregationOptions.OptionsBlank.image"));
                }
            }
            catch (OLAPException e) {
                ExceptionHandler.handleException((Exception)((Object)e));
                this.setIcon(bundle.getImageIcon("AggregationOptions.OptionsBlank.image"));
            }
            return this;
        }
    }
}

