/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.utilities.studio;

import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.OLAPSchema;
import com.sas.olapadmin.designer.model.AbstractOLAPModel;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPSharedDimension;
import com.sas.olapadmin.designer.visuals.VisualUtilities;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.olapadmin.utilities.Utilities;
import com.sas.olapadmin.utilities.studio.ChangeOLAPSchemaPanel;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.mgmt.visuals.OLAPSchemaWizard;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import javax.swing.JButton;

public class OLAPSchemaNewButton
extends JButton
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private static WAdminResource bundle = new WAdminResource(OLAPSchemaNewButton.class);
    private ChangeOLAPSchemaPanel panelToUpdate;
    private OLAPCube olapCube;
    private OLAPSharedDimension olapDim;

    public OLAPSchemaNewButton(ChangeOLAPSchemaPanel panel, AbstractOLAPModel object) {
        this.setName("newButton");
        VisualUtilities.setButtonTextAndMnemonic(this, bundle.getString("Common.New.txt"));
        this.addActionListener(this);
        this.panelToUpdate = panel;
        if (object instanceof OLAPCube) {
            this.olapCube = (OLAPCube)object;
            this.setToolTipText(bundle.getString("OLAPSchema.olapschemaToolTip.txt"));
        } else if (object instanceof OLAPSharedDimension) {
            this.olapDim = (OLAPSharedDimension)object;
            this.setToolTipText(bundle.getString("OLAPSchema.olapschemaToolTip.Dimension.tip"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (Utilities.isConnectedToMetadataServer((boolean)true)) {
            MdObjectStore child = null;
            try {
                OLAPSchema schema;
                child = Workspace.getMdFactory().createObjectStore(null, "OLAPSchemaNewButton");
                OLAPSchemaWizard schemaWizard = new OLAPSchemaWizard((Frame)Workspace.getWorkspace(), bundle.getString("OLAPSchemaWizard.title.txt"), Workspace.getMdFactory().getOMIUtil().getFoundationReposID(), (MdStore)child, true);
                schemaWizard.show();
                if (!(schemaWizard.getReturnValue() != 1 && schemaWizard.getReturnValue() != 3 || (schema = (OLAPSchema)schemaWizard.getWizardData("MASTEROBJECT")) == null || schema.isNewObject())) {
                    OLAPSchema newSchema = null;
                    if (this.olapCube != null) {
                        newSchema = (OLAPSchema)Workspace.getMdFactory().createComplexMetadataObject(this.olapCube.getObjectStore(), (CMetadata)schema);
                    } else if (this.olapDim != null) {
                        newSchema = (OLAPSchema)Workspace.getMdFactory().createComplexMetadataObject(this.olapDim.getObjectStore(), (CMetadata)schema);
                    }
                    if (newSchema != null) {
                        this.panelToUpdate.addOLAPSchemaToList(newSchema);
                        this.panelToUpdate.setSelectedOLAPSchema(newSchema);
                    }
                }
            }
            catch (RemoteException e) {
                ExceptionHandler.handleException((Exception)e);
            }
            catch (MdException e) {
                ExceptionHandler.handleException((Exception)((Object)e));
            }
            finally {
                try {
                    if (child != null) {
                        child.dispose();
                    }
                }
                catch (RemoteException e) {}
            }
        }
    }
}

