/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.utilities.studio;

import com.sas.olapadmin.designer.model.AbstractOLAPModel;
import com.sas.olapadmin.utilities.studio.OLAPAbstractTreeModel;
import com.sas.services.ServiceException;
import com.sas.services.information.Filter;
import com.sas.services.information.FilterInterface;
import com.sas.services.information.MetadataServerInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.browse.BrowseMetadataInterface;
import com.sas.services.information.publicobject.TypeDescriptorInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.Workspace;
import com.sas.workspace.models.IPublicTypeFilter;
import com.sas.workspace.models.ISimpleObjectHierarchyElement;
import com.sas.workspace.models.ISimpleObjectHierarchyModel;
import com.sas.workspace.models.SimpleBrowseObject;
import com.sas.workspace.models.SimpleObject;
import com.sas.workspace.models.impl.SimpleBrowseObjectImpl;
import com.sas.workspace.models.impl.SimpleObjectHierarchyModel;
import com.sas.workspace.models.tree.AbstractTreeNode;
import com.sas.workspace.models.tree.CategoryTreeNode;
import com.sas.workspace.models.tree.IDataTreeNode;
import com.sas.workspace.models.tree.ITreeNode;
import com.sas.workspace.models.tree.inventory.LibraryElement;
import com.sas.workspace.models.tree.inventory.TableElement;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class OLAPInventoryTreeModel
extends OLAPAbstractTreeModel {
    private static final long serialVersionUID = 1L;
    private Map m_categoryMap = new HashMap();
    private IPublicTypeFilter m_categoryFilter = this.createDefaultCategoryFilter();
    private ISimpleObjectHierarchyModel m_hierarchyModel = this.createDefaultHierarchyModel();
    private boolean multiLanguage;

    public OLAPInventoryTreeModel(UserContextInterface userContext, AbstractOLAPModel inObject, boolean inMultiLanguage) {
        super(userContext, null, inObject);
        cInventoryRootNode inventoryRoot = new cInventoryRootNode();
        inventoryRoot.setTreeModel(this);
        this.setRoot((TreeNode)((Object)inventoryRoot));
        this.multiLanguage = inMultiLanguage;
    }

    protected IPublicTypeFilter createDefaultCategoryFilter() {
        return new cDefaultCategoryFilter();
    }

    public void setCategoryFilter(IPublicTypeFilter categoryFilter) {
        this.m_categoryFilter = categoryFilter;
    }

    protected ISimpleObjectHierarchyModel createDefaultHierarchyModel() {
        return new cDefaultInventoryHierarchyModel(this.m_server);
    }

    public void setHierarchyModel(ISimpleObjectHierarchyModel hierarchyModel) {
        this.m_hierarchyModel = hierarchyModel;
    }

    public boolean isValidParent(ITreeNode nodeParent, ITreeNode nodeChild) {
        if (nodeChild instanceof CategoryTreeNode) {
            return nodeParent.equals(this.getRoot());
        }
        if (nodeChild instanceof IDataTreeNode && nodeParent instanceof CategoryTreeNode) {
            try {
                TypeDescriptorInterface tdi = (TypeDescriptorInterface)((CategoryTreeNode)nodeParent).getCategoryObject();
                SimpleObject simpleObj = (SimpleObject)((IDataTreeNode)nodeChild).getData();
                if (tdi.getTypeName().equals(simpleObj.getPublicType())) {
                    return true;
                }
            }
            catch (ServiceException ex) {
                MessageUtil.displayServiceExceptionMessage((ServiceException)ex);
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        }
        if (this.m_hierarchyModel != null && nodeChild instanceof IDataTreeNode && nodeParent instanceof IDataTreeNode) {
            SimpleObject parent = (SimpleObject)((IDataTreeNode)nodeParent).getData();
            SimpleObject child = (SimpleObject)((IDataTreeNode)nodeChild).getData();
            SimpleBrowseObject[] aParents = this.m_hierarchyModel.getParentsOf(child);
            for (int i = 0; i < aParents.length; ++i) {
                if (!aParents[i].getID().equals(parent.getID())) continue;
                return true;
            }
        }
        return false;
    }

    public void addChildren(ITreeNode parentNode) {
        if (parentNode.equals(this.getRoot())) {
            this.addInventoryCategories();
        } else if (parentNode instanceof CategoryTreeNode) {
            TypeDescriptorInterface tdi = (TypeDescriptorInterface)((CategoryTreeNode)parentNode).getCategoryObject();
            try {
                Filter filter = new Filter("PublicType", 0, tdi.getTypeName());
                filter.setType(tdi.getMetadataType());
                filter.setOMRTemplate(m_browseFilter.getOMRTemplate());
                filter.setOMRFlags(m_browseFilter.getOMRFlags() | 0x80 | 0x100 | 0x2000);
                List lObjects = this.m_server.browseSearch((FilterInterface)filter);
                if (this.multiLanguage && tdi.getTypeName().equals("Table")) {
                    List listOfMLSTables = this.filterMLSTables(this.m_hierarchyModel);
                    for (int i = lObjects.size() - 1; i >= 0; --i) {
                        BrowseMetadataInterface browseObj = (BrowseMetadataInterface)lObjects.get(i);
                        String objectId = (String)browseObj.get("Id");
                        if (listOfMLSTables.contains(objectId)) continue;
                        lObjects.remove(browseObj);
                    }
                }
                for (BrowseMetadataInterface browseObj : lObjects) {
                    SimpleBrowseObjectImpl simpleObj = new SimpleBrowseObjectImpl(browseObj);
                    if (!this.isValidObject((SimpleBrowseObject)simpleObj)) continue;
                    ITreeNode childNode = this.createNode(simpleObj);
                    this.addChild(childNode, parentNode);
                }
            }
            catch (ServiceException ex) {
                MessageUtil.displayServiceExceptionMessage((ServiceException)ex);
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        } else if (parentNode instanceof IDataTreeNode && this.m_hierarchyModel != null) {
            SimpleObject simpleObj = (SimpleObject)((IDataTreeNode)parentNode).getData();
            SimpleBrowseObject simpleBrowse = (SimpleBrowseObject)simpleObj;
            SimpleBrowseObject[] aChildren = this.m_hierarchyModel.getChildrenOf(simpleObj);
            if (this.multiLanguage && simpleObj.getMetadataType().equals("SASLibrary")) {
                HashMap<SimpleBrowseObject, SimpleBrowseObject[]> libraryMap = new HashMap<SimpleBrowseObject, SimpleBrowseObject[]>();
                libraryMap.put(simpleBrowse, aChildren);
                List listOfMLSTables = this.filterMLSByLibrary(libraryMap);
                for (int i = aChildren.length - 1; i >= 0; --i) {
                    SimpleBrowseObject browseObj = aChildren[i];
                    String objectId = browseObj.getID();
                    if (listOfMLSTables.contains(objectId)) continue;
                    aChildren[i] = null;
                }
            }
            for (int i = 0; i < aChildren.length; ++i) {
                if (aChildren[i] == null || !this.isValidObject(aChildren[i])) continue;
                ITreeNode childNode = this.createNode(aChildren[i]);
                this.addChild(childNode, parentNode);
            }
        }
    }

    public void addChild(IDataTreeNode nodeNew) {
        List lParentNodes = this.findParentNodes((SimpleBrowseObject)nodeNew.getData());
        if (lParentNodes.size() > 0) {
            this.addChild((ITreeNode)nodeNew, (ITreeNode)lParentNodes.get(0));
        }
    }

    @Override
    public ITreeNode createNode(Object userObject) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)super.createNode(userObject);
        boolean bAllowsChildren = false;
        if (userObject instanceof SimpleObject && this.m_hierarchyModel != null) {
            bAllowsChildren = this.m_hierarchyModel.areChildrenAllowed((SimpleObject)userObject);
        }
        node.setAllowsChildren(bAllowsChildren);
        return (ITreeNode)node;
    }

    public List findParentNodes(SimpleBrowseObject object) {
        ArrayList<ITreeNode> lParentNodes = new ArrayList<ITreeNode>();
        ITreeNode parentNode = (ITreeNode)this.m_categoryMap.get(object.getPublicType());
        if (parentNode != null) {
            lParentNodes.add(parentNode);
        }
        if (this.m_hierarchyModel != null) {
            SimpleBrowseObject[] aParents = this.m_hierarchyModel.getParentsOf((SimpleObject)object);
            for (int i = 0; i < aParents.length; ++i) {
                lParentNodes.addAll(this.findNodes(aParents[i].getID()));
            }
        }
        return lParentNodes;
    }

    public CategoryTreeNode getLibraryNode() {
        CategoryTreeNode libraryNode = null;
        if (this.m_categoryMap != null) {
            libraryNode = (CategoryTreeNode)this.m_categoryMap.get("Library");
        }
        return libraryNode;
    }

    protected void addInventoryCategories() {
        this.m_categoryMap.clear();
        try {
            Map typesMap = ((MetadataServerInterface)this.m_server).getTypeDictionaryMap();
            if (typesMap == null) {
                return;
            }
            for (TypeDescriptorInterface tdi : typesMap.values()) {
                String sPublicType = tdi.getTypeName();
                if (!this.m_categoryFilter.accept(sPublicType)) continue;
                CategoryTreeNode inventoryNode = new CategoryTreeNode((Object)tdi.getType());
                inventoryNode.setCategoryObject((Object)tdi);
                this.addChild((ITreeNode)inventoryNode, (ITreeNode)this.getRoot());
                this.m_categoryMap.put(sPublicType, inventoryNode);
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        catch (ServiceException ex) {
            MessageUtil.displayServiceExceptionMessage((ServiceException)ex);
        }
    }

    @Override
    protected boolean doesNodeAllowChildren(IDataTreeNode node) {
        Object dataObject = node.getData();
        if (dataObject instanceof SimpleObject && this.m_hierarchyModel != null) {
            return this.m_hierarchyModel.areChildrenAllowed((SimpleObject)dataObject);
        }
        return super.doesNodeAllowChildren(node);
    }

    @Override
    protected void updateModifiedObjects(Map objectsMap) {
        super.updateModifiedObjects(objectsMap);
        this.addCreatedObjects(objectsMap);
    }

    public void setMLS(boolean inMLS) {
        this.multiLanguage = inMLS;
    }

    private class cInventoryRootNode
    extends AbstractTreeNode {
        private static final long serialVersionUID = 1L;

        public cInventoryRootNode() {
            super((Object)"InventoryRoot");
        }

        public Icon getIcon() {
            return null;
        }

        public boolean isFolder() {
            return true;
        }
    }

    private class cDefaultCategoryFilter
    implements IPublicTypeFilter {
        private cDefaultCategoryFilter() {
        }

        public boolean accept(String sPublicType) {
            return true;
        }
    }

    private class cDefaultInventoryHierarchyModel
    extends SimpleObjectHierarchyModel {
        public cDefaultInventoryHierarchyModel(ServerInterface server) {
            super(server);
            this.addElement((ISimpleObjectHierarchyElement)new LibraryElement(), "Library");
            this.addElement((ISimpleObjectHierarchyElement)new TableElement(false), "Table");
        }
    }
}

