/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.utilities.studio;

import com.sas.olapadmin.designer.model.AbstractOLAPModel;
import com.sas.olapadmin.designer.model.CodeGeneration;
import com.sas.olapadmin.designer.model.ModelUtilities;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPSharedDimension;
import com.sas.olapadmin.designer.visuals.VisualUtilities;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.olapadmin.utilities.Utilities;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;

public class CubeSaveProcOlapPanel
extends WAPanel {
    private static final long serialVersionUID = 1L;
    private static WAdminResource bundle = new WAdminResource(CubeSaveProcOlapPanel.class);
    private WAComboBox longFormPath;
    private JCheckBox longFormBox;
    private JLabel labelDirections;
    private OLAPCube olapCube;
    private OLAPSharedDimension olapDim;
    private Vector paths;
    private JButton browse;
    private int append;
    private int shortAppend;
    private WAComboBox shortFormPath;
    private JCheckBox shortFormBox;
    private Vector shortPaths;
    private JButton shortBrowse;
    private boolean isCube;

    public CubeSaveProcOlapPanel(AbstractOLAPModel inputObject) {
        if (inputObject instanceof OLAPCube) {
            this.isCube = true;
            this.olapCube = (OLAPCube)inputObject;
        } else if (inputObject instanceof OLAPSharedDimension) {
            this.olapDim = (OLAPSharedDimension)inputObject;
        }
        this.setLayout(new GridBagLayout());
        this.layoutWidgets();
    }

    public boolean validateData() {
        if (!Utilities.isConnectedToMetadataServer((boolean)true)) {
            return false;
        }
        boolean longFormSelected = this.longFormBox.isSelected();
        boolean shortFormSelected = this.shortFormBox.isSelected();
        if (!longFormSelected && !shortFormSelected) {
            MessageUtil.displayMessage((String)bundle.getString("SaveProcCode.CheckboxNotSelected.txt"), (int)2);
            return false;
        }
        this.append = 0;
        this.shortAppend = 0;
        String savePath = (String)this.longFormPath.getSelectedItem();
        String shortSavePath = (String)this.shortFormPath.getSelectedItem();
        if (longFormSelected & ModelUtilities.isBlank((String)savePath) || shortFormSelected & ModelUtilities.isBlank((String)shortSavePath)) {
            MessageUtil.displayMessage((String)bundle.getString("CubeDesigner.EmptyCubePath.NoWrite.txt"), (int)2);
            return false;
        }
        boolean pathsOK = true;
        File longPathFile = null;
        if (!ModelUtilities.isBlank((String)savePath)) {
            longPathFile = new File(savePath);
        }
        File shortPathFile = null;
        if (!ModelUtilities.isBlank((String)shortSavePath)) {
            shortPathFile = new File(shortSavePath);
        }
        if (longFormSelected && shortFormSelected && longPathFile != null && longPathFile.compareTo(shortPathFile) == 0) {
            pathsOK = this.validatePath(longPathFile, savePath, "BOTH");
        } else {
            if (longFormSelected && !ModelUtilities.isBlank((String)savePath)) {
                pathsOK = this.validatePath(longPathFile, savePath, "LONGFORM");
            }
            if (pathsOK && shortFormSelected && !ModelUtilities.isBlank((String)shortSavePath)) {
                pathsOK = this.validatePath(shortPathFile, shortSavePath, "SHORTFORM");
            }
        }
        return pathsOK;
    }

    private boolean validatePath(File storeFileTo, String pathToValidate, String type) {
        if (storeFileTo.isDirectory()) {
            MessageUtil.displayMessage((String)bundle.getString("CubeDesigner.DirectoryEntered.txt"));
            return false;
        }
        if (storeFileTo.exists() && !storeFileTo.canWrite()) {
            MessageUtil.displayMessage((String)bundle.formatString("CubeDesigner.FileExistReadOnly.fmt.txt", (Object)storeFileTo), (int)2);
            return false;
        }
        try {
            new FileWriter(storeFileTo, true);
        }
        catch (IOException oError) {
            MessageUtil.displayMessage((String)bundle.getString("CubeDesigner.SaveCubePath.NoWrite.txt"));
            return false;
        }
        if (storeFileTo.length() > 0L) {
            int returnValue = Utilities.displayFileExistsMessage((String)pathToValidate);
            if (returnValue == 0) {
                if (type.equals("BOTH")) {
                    this.append = 1;
                    this.shortAppend = 1;
                } else if (type.equals("LONGFORM")) {
                    this.append = 1;
                } else {
                    this.shortAppend = 1;
                }
            } else if (returnValue == 1) {
                if (type.equals("BOTH")) {
                    this.append = 0;
                    this.shortAppend = 1;
                } else if (type.equals("LONGFORM")) {
                    this.append = 0;
                } else {
                    this.shortAppend = 0;
                }
            } else if (returnValue == 2) {
                return false;
            }
        } else if (type.equals("BOTH")) {
            this.append = 1;
            this.shortAppend = 1;
        }
        return true;
    }

    public boolean doDataExchange(boolean saveToModel) {
        if (!saveToModel) {
            boolean longFormVisible = false;
            boolean shortFormVisible = false;
            if (this.isCube) {
                longFormVisible = VisualUtilities.getLongForm();
                shortFormVisible = VisualUtilities.getShortForm();
            } else {
                longFormVisible = VisualUtilities.getSharedDimLongForm();
                shortFormVisible = VisualUtilities.getSharedDimShortForm();
            }
            if (!longFormVisible & !shortFormVisible) {
                this.longFormPath.setEnabled(true);
                this.longFormBox.setSelected(true);
                this.shortFormPath.setEnabled(false);
                this.shortFormBox.setSelected(false);
                this.shortBrowse.setEnabled(false);
                this.browse.setEnabled(true);
            } else {
                this.longFormPath.setEnabled(longFormVisible);
                this.longFormBox.setSelected(longFormVisible);
                this.browse.setEnabled(longFormVisible);
                this.shortFormPath.setEnabled(shortFormVisible);
                this.shortFormBox.setSelected(shortFormVisible);
                this.shortBrowse.setEnabled(shortFormVisible);
            }
        } else {
            String savePath = this.longFormPath.getText();
            String saveShortPath = this.shortFormPath.getText();
            boolean longFormSetting = this.longFormBox.isSelected();
            boolean shortFormSetting = this.shortFormBox.isSelected();
            boolean longComplete = false;
            boolean shortComplete = false;
            try {
                String exportFile = null;
                String absolutePath = null;
                String absoluteShortPath = null;
                if (longFormSetting && !ModelUtilities.isBlank((String)savePath)) {
                    if (this.isCube) {
                        CodeGeneration.saveFullProcCode((OLAPCube)this.olapCube, (String)savePath, (int)this.append);
                    } else if (this.olapDim != null) {
                        CodeGeneration.saveFullProcCodeSharedDim((OLAPSharedDimension)this.olapDim, (String)savePath, (int)this.append);
                    }
                    exportFile = savePath;
                    longComplete = true;
                    File exportPath = new File(savePath);
                    absolutePath = exportPath.getAbsolutePath();
                    this.paths.remove(savePath);
                    this.paths.insertElementAt(savePath, 0);
                    if (this.isCube) {
                        VisualUtilities.setSaveProcCodePaths(this.paths);
                    } else {
                        VisualUtilities.setSharedDimSaveProcCodePaths(this.paths);
                    }
                }
                if (shortFormSetting && !ModelUtilities.isBlank((String)saveShortPath)) {
                    if (this.isCube) {
                        CodeGeneration.saveShortProcCode((OLAPCube)this.olapCube, (String)saveShortPath, (int)this.shortAppend);
                    } else if (this.olapDim != null) {
                        CodeGeneration.saveShortProcCodeSharedDim((OLAPSharedDimension)this.olapDim, (String)saveShortPath, (int)this.shortAppend);
                    }
                    exportFile = saveShortPath;
                    shortComplete = true;
                    File exportShortPath = new File(saveShortPath);
                    absoluteShortPath = exportShortPath.getAbsolutePath();
                    this.shortPaths.remove(saveShortPath);
                    this.shortPaths.insertElementAt(saveShortPath, 0);
                    if (this.isCube) {
                        VisualUtilities.setShortSaveProcCodePaths(this.shortPaths);
                    } else {
                        VisualUtilities.setSharedDimShortSaveProcCodePaths(this.shortPaths);
                    }
                }
                if (this.isCube) {
                    VisualUtilities.setLongForm(longFormSetting);
                    VisualUtilities.setShortForm(shortFormSetting);
                } else {
                    VisualUtilities.setSharedDimLongForm(longFormSetting);
                    VisualUtilities.setSharedDimShortForm(shortFormSetting);
                }
                if (longFormSetting && longComplete && shortFormSetting && shortComplete) {
                    if (!absolutePath.equals(absoluteShortPath)) {
                        MessageUtil.displayMessage((String)bundle.formatString("ExportCode.longANDshort.confirmation.fmt.txt", (Object)absolutePath, (Object)absoluteShortPath), (int)1);
                    } else {
                        MessageUtil.displayMessage((String)bundle.formatString("ExportCodePanel.confirmation.fmt.txt", (Object)absolutePath), (int)1);
                    }
                } else if (exportFile != null && this.longFormBox.isSelected()) {
                    MessageUtil.displayMessage((String)bundle.formatString("ExportCodePanel.confirmation.fmt.txt", (Object)absolutePath), (int)1);
                } else if (exportFile != null && this.shortFormBox.isSelected()) {
                    MessageUtil.displayMessage((String)bundle.formatString("ExportCodePanel.confirmation.fmt.txt", (Object)absoluteShortPath), (int)1);
                }
            }
            catch (OLAPException OLAPError) {
                return ExceptionHandler.handleException((Exception)((Object)OLAPError));
            }
        }
        return true;
    }

    protected void layoutWidgets() {
        this.browse = new JButton();
        this.browse.addActionListener(new browseListener());
        this.labelDirections = new JLabel(bundle.getString("CubeDesigner.Finish.saveProcCode.tooltip.txt"));
        this.longFormBox = new JCheckBox();
        this.longFormBox.addActionListener(new shortLongcheckBoxListener());
        this.longFormBox.setToolTipText(bundle.getString("CubeDesigner.Finish.saveProcCode.tooltip.txt"));
        this.paths = this.isCube ? VisualUtilities.getSaveProcCodePaths() : VisualUtilities.getSharedDimSaveProcCodePaths();
        this.longFormPath = new WAComboBox(this.paths.toArray());
        this.longFormPath.setEditable(true);
        this.longFormPath.setPreferredSize(new Dimension(300, 20));
        if (!this.paths.isEmpty()) {
            this.longFormPath.setSelectedIndex(0);
        }
        this.longFormPath.setName("SaveProcPath");
        this.longFormBox.setName("SaveProcPathLabel");
        this.longFormPath.setToolTipText(bundle.getString("CubeDesigner.Finish.saveProcCode.tooltip.txt"));
        VisualUtilities.setButtonTextAndMnemonic(this.longFormBox, bundle.getString("CubeDesigner.SaveCubePath.Long.txt"));
        this.browse.setName("browseForPathButton");
        VisualUtilities.setButtonTextAndMnemonic(this.browse, bundle.getString("CubeDesigner.SaveCubePath.LongBrowse.txt"));
        this.shortBrowse = new JButton();
        this.shortBrowse.addActionListener(new shortBrowseListener());
        this.shortBrowse.setToolTipText(bundle.getString("CubeDesigner.SaveCubePath.Browse.tooltip.txt"));
        this.browse.setToolTipText(bundle.getString("CubeDesigner.SaveCubePath.Browse.tooltip.txt"));
        this.labelDirections = new JLabel(bundle.getString("CubeDesigner.Finish.saveProcCode.Instruction.txt"));
        this.shortFormBox = new JCheckBox();
        this.shortFormBox.addActionListener(new shortLongcheckBoxListener());
        this.longFormBox.setToolTipText(bundle.getString("SaveProcCode.LongFormCheckbox.tooltip.txt"));
        this.shortPaths = this.isCube ? VisualUtilities.getShortSaveProcCodePaths() : VisualUtilities.getSharedDimShortSaveProcCodePaths();
        this.shortFormPath = new WAComboBox(this.shortPaths.toArray());
        this.shortFormPath.setEditable(true);
        this.longFormPath.setPreferredSize(new Dimension(400, 10));
        this.shortFormPath.setPreferredSize(new Dimension(400, 10));
        if (!this.shortPaths.isEmpty()) {
            this.shortFormPath.setSelectedIndex(0);
        }
        this.shortFormPath.setName("SaveShortProcPath");
        this.shortFormBox.setName("SaveShortProcPathLabel");
        this.shortFormPath.setToolTipText(bundle.getString("CubeDesigner.Finish.shortSaveProcCode.tooltip.txt"));
        this.shortFormBox.setToolTipText(bundle.getString("SaveProcCode.ShortFormCheckbox.tooltip.txt"));
        VisualUtilities.setButtonTextAndMnemonic(this.shortFormBox, bundle.getString("CubeDesigner.SaveCubePath.Short.txt"));
        this.browse.setName("browseShortForPathButton");
        VisualUtilities.setButtonTextAndMnemonic(this.shortBrowse, bundle.getString("CubeDesigner.SaveCubepath.ShortBrowse.txt"));
        JLabel longformLabel = new JLabel();
        VisualUtilities.setLabelTextAndMnemonic(longformLabel, bundle.getString("SaveProcCode.LongFormItem1.txt"));
        JLabel shortformLabel = new JLabel();
        VisualUtilities.setLabelTextAndMnemonic(shortformLabel, bundle.getString("SaveProcCode.ShortFormItem1.txt"));
        this.add(this.labelDirections, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(7, 7, 10, 0), 0, 0));
        this.add(this.longFormBox, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 5, 0, 0), 0, 0));
        this.add((Component)this.longFormPath, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 17, 1, new Insets(0, 25, 0, 0), 0, 0));
        this.add(this.browse, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 13, 2, new Insets(0, 3, 0, 0), 0, 0));
        this.add(longformLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 1, new Insets(0, 25, 20, 0), 0, 0));
        this.add(this.shortFormBox, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 5, 0, 0), 0, 0));
        this.add((Component)this.shortFormPath, new GridBagConstraints(0, 5, 2, 1, 1.0, 0.0, 17, 1, new Insets(0, 25, 0, 0), 0, 0));
        this.add(this.shortBrowse, new GridBagConstraints(2, 5, 1, 1, 0.0, 0.0, 13, 2, new Insets(0, 3, 0, 0), 0, 0));
        this.add(shortformLabel, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 13, 1, new Insets(0, 25, 0, 0), 0, 0));
    }

    private class browseListener
    implements ActionListener {
        private browseListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser chooser = new JFileChooser();
            chooser.setSelectedFile(new File(CubeSaveProcOlapPanel.this.longFormPath.getText()));
            chooser.setDialogTitle(bundle.getString("SaveProcCode.Browse.txt"));
            int fileReturn = chooser.showSaveDialog((Component)Workspace.getWorkspace());
            if (fileReturn == 0) {
                String newPath = chooser.getSelectedFile().getPath();
                if (!CubeSaveProcOlapPanel.this.paths.contains(newPath)) {
                    CubeSaveProcOlapPanel.this.paths.add(newPath);
                    CubeSaveProcOlapPanel.this.longFormPath.addItem((Object)newPath);
                }
                CubeSaveProcOlapPanel.this.longFormPath.setSelectedItem((Object)newPath);
            }
        }
    }

    private class shortLongcheckBoxListener
    implements ActionListener {
        private shortLongcheckBoxListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (event.getSource().equals(CubeSaveProcOlapPanel.this.longFormBox)) {
                if (CubeSaveProcOlapPanel.this.longFormBox.isSelected()) {
                    CubeSaveProcOlapPanel.this.longFormPath.setEnabled(true);
                    CubeSaveProcOlapPanel.this.browse.setEnabled(true);
                } else {
                    CubeSaveProcOlapPanel.this.longFormPath.setEnabled(false);
                    CubeSaveProcOlapPanel.this.browse.setEnabled(false);
                }
            } else if (CubeSaveProcOlapPanel.this.shortFormBox.isSelected()) {
                CubeSaveProcOlapPanel.this.shortFormPath.setEnabled(true);
                CubeSaveProcOlapPanel.this.shortBrowse.setEnabled(true);
            } else {
                CubeSaveProcOlapPanel.this.shortFormPath.setEnabled(false);
                CubeSaveProcOlapPanel.this.shortBrowse.setEnabled(false);
            }
        }
    }

    private class shortBrowseListener
    implements ActionListener {
        private shortBrowseListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser chooser = new JFileChooser();
            chooser.setSelectedFile(new File(CubeSaveProcOlapPanel.this.shortFormPath.getText()));
            chooser.setDialogTitle(bundle.getString("SaveProcCode.Browse.txt"));
            int fileReturn = chooser.showSaveDialog((Component)Workspace.getWorkspace());
            if (fileReturn == 0) {
                String newPath = chooser.getSelectedFile().getPath();
                if (!CubeSaveProcOlapPanel.this.shortPaths.contains(newPath)) {
                    CubeSaveProcOlapPanel.this.shortPaths.add(newPath);
                    CubeSaveProcOlapPanel.this.shortFormPath.addItem((Object)newPath);
                }
                CubeSaveProcOlapPanel.this.shortFormPath.setSelectedItem((Object)newPath);
            }
        }
    }
}

