/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.utilities.studio;

import com.sas.olapadmin.designer.model.AbstractOLAPModel;
import com.sas.olapadmin.designer.model.OLAPAggregation;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPHierarchy;
import com.sas.olapadmin.designer.model.OLAPLevel;
import com.sas.olapadmin.designer.model.OLAPList;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAdminResource;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class AggregationPreviewLevelsPanel
extends WAPanel {
    private static final long serialVersionUID = 1L;
    protected static WAdminResource bundle = new WAdminResource(AggregationPreviewLevelsPanel.class);
    private DefaultTreeModel available;
    private JTree aggrSelector;
    private String title;
    private boolean isNoItemsMessageEnabled;

    public AggregationPreviewLevelsPanel(String inTitle) {
        this(inTitle, false);
    }

    public AggregationPreviewLevelsPanel(String inTitle, boolean inDisplayMessage) {
        this.isNoItemsMessageEnabled = inDisplayMessage;
        this.setLayout(new GridBagLayout());
        this.title = inTitle;
        this._layoutWidgets();
    }

    public void enableNoItemsMessage(boolean isMsgEnabled) {
        this.isNoItemsMessageEnabled = isMsgEnabled;
    }

    public boolean validateData() {
        return true;
    }

    public void updateChildren(AbstractOLAPModel olapObject, OLAPList listOfChildren) {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.available.getRoot();
        DefaultMutableTreeNode objectNode = this.getNode(olapObject, root);
        if (objectNode != null) {
            objectNode.removeAllChildren();
            DefaultMutableTreeNode childLeaf = null;
            int size = listOfChildren.size();
            for (int i = 0; i < size; ++i) {
                AbstractOLAPModel child = (AbstractOLAPModel)listOfChildren.get(i);
                childLeaf = new DefaultMutableTreeNode(child);
                objectNode.insert(childLeaf, i);
            }
            this.available.reload(objectNode);
            this.aggrSelector.expandPath(new TreePath(objectNode.getPath()));
        }
        this.checkIfNoItemsInTree();
    }

    public void removeNode(AbstractOLAPModel olapObject) {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.available.getRoot();
        DefaultMutableTreeNode objectNode = this.getNode(olapObject, root);
        if (objectNode != null) {
            this.available.removeNodeFromParent(objectNode);
        }
        this.checkIfNoItemsInTree();
    }

    public void clear() {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.available.getRoot();
        root.removeAllChildren();
        this.available.nodeStructureChanged(root);
        this.checkIfNoItemsInTree();
    }

    public void setSelectedAggregations(List listOfAggregations) {
        try {
            int i;
            DefaultMutableTreeNode aggrLeaf = null;
            DefaultMutableTreeNode levelLeaf = null;
            ArrayList<DefaultMutableTreeNode> newlyAddedNodes = new ArrayList<DefaultMutableTreeNode>();
            DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)this.available.getRoot();
            for (i = 0; i < rootNode.getChildCount(); ++i) {
                DefaultMutableTreeNode aggrNode = (DefaultMutableTreeNode)rootNode.getChildAt(i);
                boolean isExpanded = this.aggrSelector.isExpanded(new TreePath(aggrNode.getPath()));
                if (isExpanded) {
                    newlyAddedNodes.add(aggrNode);
                }
                this.aggrSelector.expandPath(new TreePath(aggrNode.getPath()));
            }
            int size = listOfAggregations.size();
            for (int j = 0; j < size; ++j) {
                OLAPAggregation aggregation = (OLAPAggregation)listOfAggregations.get(j);
                aggrLeaf = new DefaultMutableTreeNode(aggregation);
                rootNode.add(aggrLeaf);
                newlyAddedNodes.add(aggrLeaf);
                OLAPList levels = aggregation.getLevels();
                int sizeLevels = levels.size();
                for (int m = 0; m < sizeLevels; ++m) {
                    OLAPLevel LM = (OLAPLevel)levels.get(m);
                    levelLeaf = new DefaultMutableTreeNode(LM);
                    aggrLeaf.add(levelLeaf);
                }
            }
            this.available.reload();
            int sizeNodes = newlyAddedNodes.size();
            for (i = 0; i < sizeNodes; ++i) {
                DefaultMutableTreeNode aggrNode = (DefaultMutableTreeNode)newlyAddedNodes.get(i);
                this.aggrSelector.expandPath(new TreePath(aggrNode.getPath()));
            }
            this.checkIfNoItemsInTree();
        }
        catch (OLAPException oError) {
            ExceptionHandler.handleException((Exception)((Object)oError));
        }
    }

    private void checkIfNoItemsInTree() {
        if (this.isNoItemsMessageEnabled) {
            DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)this.available.getRoot();
            if (rootNode.getChildCount() > 0) {
                this.aggrSelector.setRootVisible(false);
            } else {
                this.aggrSelector.setRootVisible(true);
            }
        }
    }

    public void setSelectedHierarchies(List listOfHierarchies) {
        try {
            int i;
            DefaultMutableTreeNode aggrLeaf = null;
            DefaultMutableTreeNode levelLeaf = null;
            ArrayList<DefaultMutableTreeNode> newlyAddedNodes = new ArrayList<DefaultMutableTreeNode>();
            DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)this.available.getRoot();
            for (i = 0; i < rootNode.getChildCount(); ++i) {
                DefaultMutableTreeNode aggrNode = (DefaultMutableTreeNode)rootNode.getChildAt(i);
                boolean isExpanded = this.aggrSelector.isExpanded(new TreePath(aggrNode.getPath()));
                if (isExpanded) {
                    newlyAddedNodes.add(aggrNode);
                }
                this.aggrSelector.expandPath(new TreePath(aggrNode.getPath()));
            }
            int size = listOfHierarchies.size();
            for (int j = 0; j < size; ++j) {
                OLAPHierarchy hierarchy = (OLAPHierarchy)listOfHierarchies.get(j);
                aggrLeaf = new DefaultMutableTreeNode(hierarchy);
                rootNode.add(aggrLeaf);
                newlyAddedNodes.add(aggrLeaf);
                OLAPList levels = hierarchy.getLevels();
                int sizeLevels = levels.size();
                for (int m = 0; m < sizeLevels; ++m) {
                    OLAPLevel LM = (OLAPLevel)levels.get(m);
                    levelLeaf = new DefaultMutableTreeNode(LM);
                    aggrLeaf.add(levelLeaf);
                }
            }
            this.available.reload();
            int sizeNodes = newlyAddedNodes.size();
            for (i = 0; i < sizeNodes; ++i) {
                DefaultMutableTreeNode aggrNode = (DefaultMutableTreeNode)newlyAddedNodes.get(i);
                this.aggrSelector.expandPath(new TreePath(aggrNode.getPath()));
            }
            this.checkIfNoItemsInTree();
        }
        catch (OLAPException oError) {
            ExceptionHandler.handleException((Exception)((Object)oError));
        }
    }

    public boolean doDataExchange(boolean saveToModel) {
        return true;
    }

    private void _layoutWidgets() {
        if (this.title != null) {
            JLabel label = new JLabel(this.title);
            this.add(label, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
        this.aggrSelector = new JTree(new Vector());
        this.aggrSelector.setBackground(SystemColor.control);
        this.available = (DefaultTreeModel)this.aggrSelector.getModel();
        this.aggrSelector.setRootVisible(false);
        this.aggrSelector.setName("PreviewAggregationTree");
        DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)this.available.getRoot();
        rootNode.setUserObject(bundle.getString("ExportCode.NoItemsSelected.txt"));
        this.checkIfNoItemsInTree();
        this.aggrSelector.setCellRenderer(new AvailableTreeCellRenderer());
        JScrollPane treePane = new JScrollPane(this.aggrSelector);
        treePane.setPreferredSize(new Dimension(150, 150));
        this.add(treePane, new GridBagConstraints(0, 1, 3, 2, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private DefaultMutableTreeNode getNode(AbstractOLAPModel olapObject, DefaultMutableTreeNode node) {
        if (node == null) {
            return null;
        }
        int numChildNodes = node.getChildCount();
        DefaultMutableTreeNode foundNode = null;
        for (int i = 0; i < numChildNodes && foundNode == null; ++i) {
            AbstractOLAPModel nodeMetadata;
            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)node.getChildAt(i);
            Object userObject = childNode.getUserObject();
            if (!(userObject instanceof AbstractOLAPModel) || !(nodeMetadata = (AbstractOLAPModel)userObject).equals(olapObject)) continue;
            foundNode = childNode;
        }
        return foundNode;
    }

    protected class AvailableTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 1L;

        protected AvailableTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            this.setIcon(null);
            this.setBackgroundSelectionColor(SystemColor.control);
            this.setBackgroundNonSelectionColor(SystemColor.control);
            this.setForeground(SystemColor.textText);
            return this;
        }
    }
}

