/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.update;

import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.olapadmin.designer.model.AbstractOLAPModel;
import com.sas.olapadmin.designer.model.LanguageSet;
import com.sas.olapadmin.designer.model.ModelUtilities;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.TableSet;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.olapadmin.utilities.studio.DrillTableChangeEvent;
import com.sas.olapadmin.utilities.studio.DrillTableSelectionListener;
import com.sas.olapadmin.utilities.studio.PhysicalTableSelector;
import com.sas.services.ServiceException;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.rmi.RemoteException;
import java.util.List;
import javax.swing.JCheckBox;

public class UpdateOptionsTablePanel
extends WAPanel
implements DrillTableSelectionListener {
    private static final long serialVersionUID = 1L;
    protected static WAdminResource bundle = new WAdminResource(UpdateOptionsTablePanel.class);
    private PhysicalTableSelector tree;
    private PhysicalTable physicalTable;
    private OLAPCube olapCube;
    private String options;
    private JCheckBox dtLangSupport;
    private boolean dtLanginit;

    public UpdateOptionsTablePanel(OLAPCube inOlapCube, PhysicalTable inPhysTable, String tableOptions, boolean dtlangsupport2) {
        this.olapCube = inOlapCube;
        this.physicalTable = inPhysTable;
        this.options = tableOptions;
        this.dtLanginit = dtlangsupport2;
        this.setLayout(new GridBagLayout());
        this._layoutWidgets();
    }

    public boolean doDataExchange(boolean saveToModel) {
        if (!saveToModel) {
            this.initialize();
        }
        return true;
    }

    protected void initialize() {
        try {
            LanguageSet languageSet;
            if (this.physicalTable != null) {
                this.tree.initializeSelectedTable(this.physicalTable);
                if (!ModelUtilities.isBlank((String)this.options)) {
                    this.tree.setOptions(this.options);
                }
            }
            if ((languageSet = this.olapCube.getLanguageSet()).isCubeMultipleLanguageSupported()) {
                this.dtLangSupport.setEnabled(this.physicalTable != null);
                this.dtLangSupport.setSelected(this.dtLanginit);
                this.tree.setTreatAsDrillThru(true);
                if (languageSet.isCubeMultipleLanguageSupported()) {
                    this.tree.addDrillTableSelectionListener(this);
                }
            } else {
                this.dtLangSupport.setEnabled(false);
                this.dtLangSupport.setSelected(false);
            }
            this.tree.populateStore();
            this.tree.moveDataToView();
        }
        catch (MdException mdError) {
            ExceptionHandler.handleException((Exception)((Object)new OLAPException(mdError.getLocalizedMessage(), (Throwable)mdError, 12)));
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        catch (OLAPException e) {
            ExceptionHandler.handleException((Exception)((Object)e));
        }
    }

    public boolean getMLSDrillThruState() {
        return this.dtLangSupport.isSelected();
    }

    public String getOptions() {
        return this.options;
    }

    public PhysicalTable getTable() {
        return this.physicalTable;
    }

    private void _layoutWidgets() {
        this.setLayout(new GridBagLayout());
        this.tree = new PhysicalTableSelector((AbstractOLAPModel)this.olapCube, 1, true, true, false, false, false);
        this.tree.setName("UpdateTableSelection");
        this.add((Component)((Object)this.tree), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.dtLangSupport = new JCheckBox(bundle.getString("CubeUpdate.SelectTable.SupportMLSDrillThrough.checkbox.label"));
        this.add(this.dtLangSupport, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 0, 0), 0, 0));
    }

    public void saveSettingsAndCleanUp() {
        this.tree.saveSettingsAndCleanUp();
    }

    public boolean validateData() {
        try {
            TableSet tableSet;
            List missingTables;
            this.physicalTable = this.tree.getSelectedTable();
            if (this.dtLangSupport.isSelected() && this.physicalTable != null && !(missingTables = (tableSet = this.olapCube.getTableSet()).checkForLanguageTables(this.physicalTable)).isEmpty()) {
                String message = bundle.getString("CubeUpdate.SelectTable.ReachThru.MissingLanguages.txt");
                MessageUtil.displayListMessage((String)message, (List)missingTables, (String)bundle.getString("CubeUpdate.SelectTable.ReachThruConfirm.window.title"), (int)1, (int)-1);
                return false;
            }
        }
        catch (RemoteException e) {
            ExceptionHandler.handleException((Exception)e);
        }
        catch (ServiceException e) {
            ExceptionHandler.handleException((Exception)((Object)e));
        }
        catch (OLAPException e) {
            ExceptionHandler.handleException((Exception)((Object)e));
        }
        catch (MdException e) {
            ExceptionHandler.handleException((Exception)((Object)e));
        }
        this.options = this.tree.getOptions();
        return true;
    }

    @Override
    public void drillTableChanged(DrillTableChangeEvent e) {
        this.dtLangSupport.setEnabled(e.getDrillSelectedState());
        if (!e.getDrillSelectedState()) {
            this.dtLangSupport.setSelected(false);
        }
    }
}

