/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.update;

import com.sas.metadata.remote.MdObjectStore;
import com.sas.olapadmin.designer.model.AddDataModel;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPSharedDimension;
import com.sas.olapadmin.update.CubeUpdateSaveProcOlapDialog;
import com.sas.olapadmin.update.SharedDimUpdateDimensionTab;
import com.sas.olapadmin.update.SharedDimUpdateFinishTab;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.olapadmin.utilities.Utilities;
import com.sas.olapadmin.utilities.WsRunCode;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.OpRequestUI;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WizardTabInfo;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsButtonsLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;

public class SharedDimUpdateDesigner
extends WAWizardDialog {
    private static final long serialVersionUID = 1L;
    protected static WAdminResource bundle = new WAdminResource(SharedDimUpdateDesigner.class);
    protected JButton exportCode;
    private OLAPSharedDimension olapDim;
    private AddDataModel dataModel;
    private WsAppServer server;
    private WsRunCode wsRunCode;

    public SharedDimUpdateDesigner(Frame frame, String title, OLAPSharedDimension inputDim) {
        super(frame, title, true);
        try {
            this.dataModel = new AddDataModel(inputDim);
            this.olapDim = inputDim;
            this.dataModel.setTypeOfUpdate(0);
            this.setCanFinishEarly(true);
            this.addTab(bundle.getString("CubeUpdate.General.header.title"), "DIMENSIONS", (WAPropertyTab)new SharedDimUpdateDimensionTab(this.dataModel), null, null, true);
            this.addTab(bundle.getString("CubeUpdate.Finish.groupbox.title"), "FINISH", (WAPropertyTab)new SharedDimUpdateFinishTab(this.dataModel), null, null, true);
        }
        catch (OLAPException oError) {
            ExceptionHandler.handleException((Exception)((Object)oError));
        }
    }

    protected void updateButtonsPanel() {
        if (SharedDimUpdateDesigner.isUsingNewStyle()) {
            this.m_pnlButtons.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        }
        this.m_pnlButtons.removeAll();
        JPanel subPanel2 = new JPanel((LayoutManager)new WsButtonsLayout());
        subPanel2.add(this.exportCode);
        JPanel subPanel1 = new JPanel(new cWizardButtonsPaneLayout());
        this.m_pnlButtons.setLayout(new BorderLayout());
        subPanel1.add(this.m_btnHelp);
        subPanel1.add(this.m_btnCancel);
        subPanel1.add(this.m_btnBack);
        subPanel1.add(this.m_btnNext);
        subPanel1.add(this.m_btnFinish);
        this.m_pnlButtons.add((Component)subPanel2, "West");
        this.m_pnlButtons.add((Component)subPanel1, "East");
        this.updateNavigationButtons();
    }

    protected void initialize() {
        super.initialize();
        this.m_btnFinish = new JButton();
        this.m_btnBack = new JButton();
        this.exportCode = new JButton();
        this.m_btnNext = new JButton();
        Utilities.setButtonTextAndMnemonic((AbstractButton)this.exportCode, (String)bundle.getString("CubeDesigner.Finish.saveProcCode.txt"));
        Utilities.setButtonTextAndMnemonic((AbstractButton)this.m_btnBack, (String)bundle.getString("Common.Back.control.label"));
        Utilities.setButtonTextAndMnemonic((AbstractButton)this.m_btnNext, (String)bundle.getString("Common.Next.control.label"));
        Utilities.setButtonTextAndMnemonic((AbstractButton)this.m_btnFinish, (String)bundle.getString("Common.Finish.control.label"));
        this.m_btnBack.addActionListener((ActionListener)((Object)this));
        this.m_btnNext.addActionListener((ActionListener)((Object)this));
        this.m_btnFinish.addActionListener((ActionListener)((Object)this));
        this.exportCode.addActionListener(new SaveButtonListener());
    }

    public boolean onCancel() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean onFinish() {
        boolean okFinish = true;
        WizardTabInfo currentPanel = this.m_WizardModel.getCurrent();
        okFinish = currentPanel.getTab().validateData();
        if (okFinish) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.server = WsRunCode.getServer();
            this.setCursor(Cursor.getPredefinedCursor(0));
            if (this.server != null) {
                this.wsRunCode = new WsRunCode(this.server);
                if (this.wsRunCode.hasSubmitError) {
                    return false;
                }
            } else {
                MessageUtil.displayMessage((String)bundle.getString("CubeUpdate.Finish.ServerNeeded.txt"));
                return false;
            }
            if (this.dataModel.getTypeOfUpdate() == 0) {
                String str1 = bundle.getString("CubeUpdate.WriteMetadataProgressIndicator.Msg.Title.txt");
                String str2 = bundle.getString("CubeUpdate.WriteMetadataProgressIndicator.Msg.Message.txt");
                UpdateMetadata updateMetadata = new UpdateMetadata();
                OpRequestUI request = new OpRequestUI((Frame)Workspace.getWorkspace(), str2, str1);
                request.setProgressShownOnStatusBar(false);
                request.execute((Runnable)updateMetadata);
            }
            String str3 = bundle.getString("UpdateCubeProgressIndicator.Msg.Title.txt");
            String str4 = bundle.getString("UpdateCubeProgressIndicator.Msg.Message.txt");
            if (this.server != null) {
                try {
                    this.wsRunCode.executeCode(this.dataModel.generateCodeSharedUpdate(true), str4, str3);
                }
                catch (OLAPException error) {
                    ExceptionHandler.handleException((Exception)((Object)error));
                }
                finally {
                    this.cleanup();
                }
            } else {
                MessageUtil.displayMessage((String)bundle.getString("CubeUpdate.Finish.NoUpdate.txt"));
                this.cleanup();
            }
            this.cleanup();
        }
        return true;
    }

    private void cleanup() {
        MdObjectStore objectStore = (MdObjectStore)this.getWizardData("OBJECTSTORE");
        try {
            if (objectStore != null) {
                objectStore.dispose();
            }
            objectStore = null;
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        this.addWizardData("OBJECTSTORE", null);
        if (this.server != null) {
            this.wsRunCode.term();
        }
        this.server = null;
    }

    protected class cWizardButtonsPaneLayout
    implements LayoutManager {
        protected static final int cxSmallButtonGap = 7;
        protected static final int cxLargeButtonGap = 20;
        protected static final int cxTotalButtonGap = 67;
        private static final int wTinyButtonGap = 1;
        private static final int wLargeButtonGap = 12;
        private static final int wSmallButtonGap = 5;

        protected cWizardButtonsPaneLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component c) {
        }

        @Override
        public void removeLayoutComponent(Component c) {
        }

        @Override
        public Dimension preferredLayoutSize(Container c) {
            int wTotalButtonGap = 67;
            int nButtons = 6;
            if (WAWizardDialog.isUsingNewStyle()) {
                if (!SharedDimUpdateDesigner.this.canFinishEarly()) {
                    --nButtons;
                    wTotalButtonGap = 18;
                } else {
                    wTotalButtonGap = 30;
                }
            }
            Dimension dimButton = this.getPreferredButtonSize();
            Dimension dimLayout = new Dimension(dimButton.width * nButtons + wTotalButtonGap, dimButton.height);
            Insets insContainer = c.getInsets();
            dimLayout.width += insContainer.left + insContainer.right;
            dimLayout.height += insContainer.top + insContainer.bottom;
            return dimLayout;
        }

        @Override
        public Dimension minimumLayoutSize(Container c) {
            return this.preferredLayoutSize(c);
        }

        @Override
        public void layoutContainer(Container c) {
            Insets insContainer = c.getInsets();
            boolean bLeftToRight = SharedDimUpdateDesigner.this.getComponentOrientation().isLeftToRight();
            int cxPanel = c.getWidth();
            Dimension dimButton = this.getPreferredButtonSize();
            int cxButton = dimButton.width;
            int cyButton = dimButton.height;
            if (!WAWizardDialog.isUsingNewStyle()) {
                int xBtn = bLeftToRight ? insContainer.left : cxPanel - insContainer.right - cxButton;
                SharedDimUpdateDesigner.this.m_btnHelp.setBounds(xBtn, insContainer.top, cxButton, cyButton);
                xBtn = bLeftToRight ? cxPanel - insContainer.right - cxButton : insContainer.left;
                SharedDimUpdateDesigner.this.m_btnFinish.setBounds(xBtn, insContainer.top, cxButton, cyButton);
                SharedDimUpdateDesigner.this.m_btnNext.setBounds(xBtn += bLeftToRight ? -(cxButton + 20) : cxButton + 20, insContainer.top, cxButton, cyButton);
                SharedDimUpdateDesigner.this.m_btnBack.setBounds(xBtn += bLeftToRight ? -(cxButton + 7) : cxButton + 7, insContainer.top, cxButton, cyButton);
                SharedDimUpdateDesigner.this.m_btnCancel.setBounds(xBtn += bLeftToRight ? -(cxButton + 20) : cxButton + 20, insContainer.top, cxButton, cyButton);
            } else {
                int xBtn = bLeftToRight ? cxPanel - insContainer.right - cxButton : insContainer.left;
                SharedDimUpdateDesigner.this.m_btnHelp.setBounds(xBtn, insContainer.top, cxButton, cyButton);
                SharedDimUpdateDesigner.this.m_btnCancel.setBounds(xBtn += bLeftToRight ? -(cxButton + 5) : cxButton + 5, insContainer.top, cxButton, cyButton);
                SharedDimUpdateDesigner.this.m_btnFinish.setBounds(xBtn += bLeftToRight ? -(cxButton + 12) : cxButton + 12, insContainer.top, cxButton, cyButton);
                if (SharedDimUpdateDesigner.this.canFinishEarly()) {
                    xBtn += bLeftToRight ? -(cxButton + 12) : cxButton + 12;
                }
                SharedDimUpdateDesigner.this.m_btnNext.setBounds(xBtn, insContainer.top, cxButton, cyButton);
                SharedDimUpdateDesigner.this.m_btnBack.setBounds(xBtn += bLeftToRight ? -(cxButton + 1) : cxButton + 1, insContainer.top, cxButton, cyButton);
                xBtn += bLeftToRight ? -(cxButton + 12) : cxButton + 1;
            }
        }

        protected Dimension getPreferredButtonSize() {
            cMaxDimension dim = new cMaxDimension(0, 0);
            dim.max(SharedDimUpdateDesigner.this.m_btnHelp.getPreferredSize());
            dim.max(SharedDimUpdateDesigner.this.m_btnNext.getPreferredSize());
            dim.max(SharedDimUpdateDesigner.this.m_btnBack.getPreferredSize());
            dim.max(SharedDimUpdateDesigner.this.m_btnFinish.getPreferredSize());
            dim.max(SharedDimUpdateDesigner.this.m_btnCancel.getPreferredSize());
            return dim;
        }

        protected class cMaxDimension
        extends Dimension {
            private static final long serialVersionUID = 1L;

            public cMaxDimension(int Width, int Height) {
                super(Width, Height);
            }

            public void max(Dimension dim) {
                this.width = Math.max(this.width, dim.width);
                this.height = Math.max(this.height, dim.height);
            }
        }
    }

    private final class SaveButtonListener
    implements ActionListener {
        private SaveButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            WizardTabInfo currentPanel = SharedDimUpdateDesigner.this.m_WizardModel.getCurrent();
            boolean canExportcode = currentPanel.getTab().validateData();
            if (canExportcode) {
                Workspace m_workspace = Workspace.getWorkspace();
                CubeUpdateSaveProcOlapDialog saveProcDialog = new CubeUpdateSaveProcOlapDialog(m_workspace, bundle.getString("SaveProcCode.Title.txt"), SharedDimUpdateDesigner.this.dataModel);
                saveProcDialog.show();
            }
        }
    }

    class UpdateMetadata
    implements Runnable {
        public boolean returnValue = true;

        UpdateMetadata() {
        }

        @Override
        public void run() {
            try {
                SharedDimUpdateDesigner.this.dataModel.updateMetadata();
            }
            catch (OLAPException OLAPError) {
                this.returnValue = ExceptionHandler.handleException((Exception)((Object)OLAPError));
            }
        }

        public boolean getReturnValue() {
            return this.returnValue;
        }
    }
}

