/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.update;

import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.visuals.VisualUtilities;
import com.sas.olapadmin.update.DistinctCountOptionsPanel;
import com.sas.olapadmin.update.UpdateCaptionsPanel;
import com.sas.olapadmin.update.UpdateDefaultMemberPanel;
import com.sas.olapadmin.update.UpdateOptionsPanel;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.olapadmin.utilities.ExportCodeDialog;
import com.sas.olapadmin.utilities.Utilities;
import com.sas.olapadmin.utilities.WsRunCode;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPropertyDialog;
import com.sas.workspace.WARootPane;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsButtonsLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JPanel;

public class QuickEditDialog
extends WAPropertyDialog {
    private static final long serialVersionUID = 1L;
    private static final WAdminResource bundle = new WAdminResource(QuickEditDialog.class);
    private JButton exportCode;
    private WsAppServer applicationServer;
    private UpdateCaptionsPanel captionsPanel;
    private UpdateDefaultMemberPanel defaultMemberPanel;
    private UpdateOptionsPanel optionsPanel;
    private DistinctCountOptionsPanel countOptionsPanel;
    private OLAPCube olapCube;

    public QuickEditDialog(Frame frmOwner, String title, boolean modal, OLAPCube inCube) {
        super(frmOwner, title, modal);
        this.olapCube = inCube;
        this.captionsPanel = new UpdateCaptionsPanel(inCube);
        this.addTab(bundle.getString("UpdateCaptionsPanel.tab.title"), this.captionsPanel);
        this.defaultMemberPanel = new UpdateDefaultMemberPanel(inCube, this);
        this.addTab(bundle.getString("UpdateDefaultMember.tab.title"), this.defaultMemberPanel);
        this.optionsPanel = new UpdateOptionsPanel(inCube, this);
        this.addTab(bundle.getString("UpdateOptions.tab.title"), this.optionsPanel);
        this.countOptionsPanel = new DistinctCountOptionsPanel(inCube, this);
        this.addTab(bundle.getString("DistinctCountOptions.tab.title"), this.countOptionsPanel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean doDataExchange(boolean saveToModel) {
        if (saveToModel) {
            Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(3));
            WsRunCode wsRunCode = null;
            try {
                if (this.applicationServer != null) {
                    wsRunCode = new WsRunCode(this.applicationServer);
                    if (wsRunCode.hasSubmitError) return true;
                    String message = bundle.getString("QuickEditProgressIndicator.Message.txt");
                    String title = bundle.getString("ProgressIndicator.window.title");
                    wsRunCode.executeCode(this.getCode(), message, title);
                    return true;
                }
                MessageUtil.displayMessage((String)bundle.getString("QuickEditDialog.NoServer.txt"), (int)1);
                return true;
            }
            catch (OLAPException e) {
                ExceptionHandler.handleException((Exception)((Object)e));
                return true;
            }
            finally {
                if (wsRunCode != null) {
                    wsRunCode.term();
                    wsRunCode = null;
                }
                Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(0));
            }
        } else {
            super.doDataExchange(saveToModel);
        }
        return true;
    }

    private StringBuffer getCode() throws OLAPException {
        StringBuffer code = null;
        HashMap changes = this.captionsPanel.getChanges();
        HashMap memberChanges = this.defaultMemberPanel.getChanges();
        HashMap optionsMap = this.optionsPanel.getChanges();
        HashMap countOptionsMap = this.countOptionsPanel.getChanges();
        try {
            code = this.olapCube.generateCodeUpdateDisplayNames((HashMap)changes.get("Captions"), (HashMap)changes.get("Descriptions"), memberChanges, optionsMap, countOptionsMap);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return code;
    }

    protected void updateButtonsPanel() {
        this.removeKeyListeners(this.m_pnlButtons, this.m_KeyHandler);
        this.m_pnlButtons.removeAll();
        JPanel subPanel1 = new JPanel((LayoutManager)new WsButtonsLayout());
        this.setOKButtonVisible(true);
        this.setCancelButtonVisible(true);
        this.setCloseButtonVisible(false);
        this.setApplyButtonVisible(false);
        this.setHelpButtonVisible(true);
        Utilities.setButtonTextAndMnemonic((AbstractButton)this.m_btnOk, (String)bundle.getString("QuickEditDialog.SubmitNow.action.label"));
        this.m_btnOk.setToolTipText(bundle.getString("QuickEditDialog.SubmitNow.tip"));
        subPanel1.add(this.m_btnOk);
        subPanel1.add(this.m_btnCancel);
        subPanel1.add(this.m_btnHelp);
        JPanel subPanel2 = new JPanel((LayoutManager)new WsButtonsLayout());
        this.exportCode = new JButton();
        Utilities.setButtonTextAndMnemonic((AbstractButton)this.exportCode, (String)bundle.getString("QuickEditDialog.ExportCode.action.label"));
        this.exportCode.addActionListener(new ExportCodeActionListener());
        this.exportCode.setToolTipText(bundle.getString("QuickEditDialog.ExportCode.tip"));
        subPanel2.add(this.exportCode);
        ((WARootPane)this.getRootPane()).setRealDefaultButton(this.exportCode);
        this.m_pnlButtons.setLayout(new BorderLayout());
        this.m_pnlButtons.add((Component)subPanel2, "West");
        this.m_pnlButtons.add((Component)subPanel1, "East");
        this.addKeyListeners(this.m_pnlButtons, this.m_KeyHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean validateData() {
        boolean dataOk = super.validateData();
        boolean captionsChanged = false;
        if (this.captionsPanel.hasBeenShown()) {
            captionsChanged = this.captionsPanel.captionsHaveChanged();
        }
        boolean defaultMemberChanged = false;
        if (this.defaultMemberPanel.hasBeenShown()) {
            defaultMemberChanged = this.defaultMemberPanel.membersHaveChanged();
        }
        boolean optionsHaveChanged = false;
        if (this.optionsPanel.hasBeenShown()) {
            optionsHaveChanged = this.optionsPanel.optionsHaveChanged();
        }
        boolean countOptionsHaveChanged = false;
        if (this.countOptionsPanel.hasBeenShown()) {
            countOptionsHaveChanged = this.countOptionsPanel.optionsHaveChanged();
        }
        if (!(captionsChanged || defaultMemberChanged || optionsHaveChanged || countOptionsHaveChanged)) {
            MessageUtil.displayMessage((String)bundle.getString("QuickEditDialog.NoChangesSubmit.txt"), (int)1);
            dataOk = false;
        } else if (Utilities.isConnectedToMetadataServer((boolean)true)) {
            Workspace workspace = Workspace.getWorkspace();
            workspace.setCursor(Cursor.getPredefinedCursor(3));
            Object wsRunCode = null;
            try {
                this.applicationServer = WsRunCode.getServer();
                if (this.applicationServer == null) {
                    MessageUtil.displayMessage((String)bundle.getString("QuickEditDialog.NoServer.txt"), (int)1);
                    dataOk = false;
                }
            }
            catch (UnsupportedOperationException e) {
                MessageUtil.displayMessage((String)e.getLocalizedMessage());
            }
            finally {
                if (wsRunCode != null) {
                    wsRunCode.term();
                    wsRunCode = null;
                }
                workspace.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
        return dataOk;
    }

    private class ExportCodeActionListener
    implements ActionListener {
        private ExportCodeActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            try {
                boolean captionsChanged = false;
                if (QuickEditDialog.this.captionsPanel.hasBeenShown()) {
                    captionsChanged = QuickEditDialog.this.captionsPanel.captionsHaveChanged();
                }
                boolean defaultMemberChanged = false;
                if (QuickEditDialog.this.defaultMemberPanel.hasBeenShown()) {
                    defaultMemberChanged = QuickEditDialog.this.defaultMemberPanel.membersHaveChanged();
                }
                boolean optionsHaveChanged = false;
                if (QuickEditDialog.this.optionsPanel.hasBeenShown()) {
                    optionsHaveChanged = QuickEditDialog.this.optionsPanel.optionsHaveChanged();
                }
                boolean countOptionsHaveChanged = false;
                if (QuickEditDialog.this.countOptionsPanel.hasBeenShown()) {
                    countOptionsHaveChanged = QuickEditDialog.this.countOptionsPanel.optionsHaveChanged();
                }
                if (captionsChanged || defaultMemberChanged || optionsHaveChanged || countOptionsHaveChanged) {
                    StringBuffer code = QuickEditDialog.this.getCode();
                    String instructions = bundle.getString("QuickEditDialog.ExportCodeInstructions.txt");
                    Vector paths = VisualUtilities.getSaveProcCodePaths();
                    ExportCodeDialog savedlg = new ExportCodeDialog(instructions, code, paths);
                    savedlg.setHelpProduct("olapadmin");
                    savedlg.setHelpTopic("export_code_update");
                    savedlg.show();
                    if (savedlg.getReturnValue() == 1) {
                        VisualUtilities.setSaveProcCodePaths(paths);
                    }
                } else {
                    MessageUtil.displayMessage((String)bundle.getString("QuickEditDialog.NoChangesExport.txt"), (int)1);
                }
            }
            catch (OLAPException e) {
                ExceptionHandler.handleException((Exception)((Object)e));
            }
        }
    }
}

