/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.update;

import com.sas.metadata.remote.MdException;
import com.sas.olapadmin.designer.model.MeasureSet;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPList;
import com.sas.olapadmin.update.DistinctCountOptionsModel;
import com.sas.olapadmin.update.QuickEditDialog;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WATextArea;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsTable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.rmi.RemoteException;
import java.util.HashMap;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.table.TableCellEditor;

public class DistinctCountOptionsPanel
extends WAPropertyTab {
    private static final long serialVersionUID = 1L;
    private static final WAdminResource bundle = new WAdminResource(DistinctCountOptionsPanel.class);
    private OLAPCube olapCube;
    private boolean initialized;
    public String conditionState;
    private DistinctCountOptionsModel tableModel;
    private WsTable detailsTable;
    private MeasureSet measureSet;

    public DistinctCountOptionsPanel(OLAPCube inCube, QuickEditDialog quickEditDialog) {
        this.olapCube = inCube;
        this.layoutWidgets();
        this.initialized = false;
        this.setHelpProduct("olapadmin");
        this.setHelpTopic("distinct_count_options");
    }

    public HashMap getChanges() {
        HashMap<String, HashMap> list = new HashMap<String, HashMap>();
        list.put("Statistic Value", this.tableModel.getHashMap());
        return list;
    }

    public boolean optionsHaveChanged() {
        HashMap statColVal;
        TableCellEditor ce = this.detailsTable.getCellEditor();
        if (ce != null) {
            ce.stopCellEditing();
        }
        return !(statColVal = this.tableModel.getHashMap()).isEmpty();
    }

    public void moveDataToView() {
        try {
            super.moveDataToView();
            if (!this.initialized) {
                this.initialized = true;
                this.measureSet = this.olapCube.getMeasureSet();
                this.populateTable();
            }
        }
        catch (RemoteException e) {
            ExceptionHandler.handleException((Exception)e);
        }
        catch (MdException e) {
            ExceptionHandler.handleException((Exception)((Object)e));
        }
        catch (OLAPException e) {
            ExceptionHandler.handleException((Exception)((Object)e));
        }
    }

    protected void layoutWidgets() {
        this.setLayout(new GridBagLayout());
        JPanel sourcePanel = new JPanel();
        sourcePanel.setLayout(new GridBagLayout());
        WATextArea DistinctCountText = new WATextArea();
        DistinctCountText.setColumns(30);
        DistinctCountText.setBehavior(1);
        DistinctCountText.setBackground((Color)SystemColor.control);
        DistinctCountText.setAutosize(true);
        DistinctCountText.setText(bundle.getString("CubeUpdate.General.DistinctText.control.label"));
        sourcePanel.add((Component)DistinctCountText, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(25, 5, 5, 5), 0, 0));
        JPanel sourcePanel2 = new JPanel();
        this.add(sourcePanel, new GridBagConstraints(0, 0, 3, 3, 0.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add(sourcePanel2, new GridBagConstraints(0, 6, 3, 3, 0.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.tableModel = new DistinctCountOptionsModel(this.olapCube, this);
        this.detailsTable = new WsTable((WsAbstractTableModel)this.tableModel);
        this.detailsTable.setNonEditableCellBackground(UIManager.getColor("TextField.inactiveBackground"));
        this.detailsTable.setSortingEnabled(true);
        this.detailsTable.setColumnHidingEnabled(false);
        this.detailsTable.setColumnsReorderable(false);
        this.detailsTable.setRowHoldingEnabled(false);
        this.detailsTable.setColumnHeaderPopupMenuEnabled(false);
        this.detailsTable.setOriginPopupMenuEnabled(false);
        this.detailsTable.setPopupMenuEnabled(false);
        this.detailsTable.setRowHeaderPopupMenuEnabled(false);
        this.detailsTable.setTablePopupMenuEnabled(false);
        this.detailsTable.setViewportPopupMenuEnabled(false);
        this.detailsTable.setPreferredScrollableViewportSize(new Dimension(300, 300));
        this.detailsTable.setAutoResizeMode(0);
        this.detailsTable.getRowHeader().setWidth(30);
        JScrollPane tableScroll = new JScrollPane((Component)this.detailsTable);
        this.add(tableScroll, new GridBagConstraints(0, 12, 3, 3, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void populateTable() throws OLAPException {
        OLAPList measures = this.measureSet.getMeasures();
        this.detailsTable.clearSortMemory();
        this.tableModel.setLists(measures);
        this.tableModel.moveDataToModel();
    }

    public void saveSettingsAndCleanUp() {
        this.olapCube.getTableSet().removeFromMetadataListener();
        super.saveSettingsAndCleanUp();
    }

    public boolean validateData() {
        return true;
    }
}

