/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.update;

import com.sas.metadata.remote.MdException;
import com.sas.olapadmin.designer.model.AbstractOLAPModel;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPList;
import com.sas.olapadmin.designer.model.OLAPMeasure;
import com.sas.olapadmin.update.DistinctCountOptionsPanel;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.olapadmin.utilities.studio.PopulateOnDemandDisabledWideCombo;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsAbstractTableColumn;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsObjectTableColumn;
import com.sas.workspace.WsStringTableColumn;
import com.sas.workspace.WsTable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.swing.JTable;

public class DistinctCountOptionsModel
extends WsAbstractTableModel {
    private static final long serialVersionUID = 1L;
    private static WAdminResource bundle = WAdminResource.getBundle(DistinctCountOptionsModel.class);
    public static final int MEASURE_NAME = 0;
    public static final int STATISTIC = 1;
    public static final int CAPTION = 2;
    public static final int MEASURE = 3;
    private static final int TOTAL_COLS = 3;
    private static final int TOTAL_HIDDEN_COLS = 1;
    private OLAPList measures;
    private static final String NUNIQUE_INCLUDE = bundle.getString("UpdateCountOptions.include.txt");
    private static final String NUNIQUE_EXCLUDE = bundle.getString("UpdateCountOptions.exclude.txt");
    private HashMap originalStatValue = new HashMap();
    private HashMap changedStatValue = new HashMap();

    public DistinctCountOptionsModel(OLAPCube cube, DistinctCountOptionsPanel measuresTab) {
        this.createColumnDefinitions();
    }

    public void addMeasures(List newmeasures) {
        if (newmeasures != null) {
            int start = this.getRowCount();
            for (int i = 0; i < newmeasures.size(); ++i) {
                OLAPMeasure measure = (OLAPMeasure)newmeasures.get(i);
                this.createRow(measure);
            }
            int end = this.getRowCount();
            if (start != end) {
                this.fireTableRowsInserted(start, end - 1);
            }
        }
    }

    protected void createColumnDefinitions() {
        this.m_aColumns = new WsAbstractTableColumn[this.getColumnCount() + this.getHiddenColumnCount()];
        this.m_aColumns[0] = new WsStringTableColumn(0, bundle.getString("CubeDesigner.MeasuresModel.Name.header.title"), 130, 32);
        this.m_aColumns[0].setEditable(false);
        this.m_aColumns[1] = new StatisticsColumn(1, bundle.getString("CubeDesigner.MeasuresModel.Stat.header.title"), 240);
        this.m_aColumns[2] = new WsStringTableColumn(2, bundle.getString("CubeDesigner.MeasuresModel.Caption.header.title"), 220, 32);
        this.m_aColumns[2].setEditable(false);
        this.m_aColumns[3] = new WsObjectTableColumn();
    }

    private void createRow(OLAPMeasure measure) {
        ArrayList<String> alRow = new ArrayList<String>(this.getColumnCount() + this.getHiddenColumnCount());
        try {
            if (measure.isNunique() != null && measure.isNunique().booleanValue()) {
                alRow.add(0, measure.getName());
                boolean include = measure.getIncludeCalculatedMembers();
                if (include) {
                    this.originalStatValue.put(measure, "1");
                    alRow.add(1, NUNIQUE_INCLUDE);
                } else {
                    this.originalStatValue.put(measure, "0");
                    alRow.add(1, NUNIQUE_EXCLUDE);
                }
            }
            alRow.add(2, measure.getDesc());
            alRow.add(3, (String)measure);
        }
        catch (OLAPException e) {
            ExceptionHandler.handleException((Exception)((Object)e));
        }
        this.m_lData.add(alRow);
    }

    public int getColumnCount() {
        return 3;
    }

    public int getHiddenColumnCount() {
        return 1;
    }

    public OLAPMeasure getMeasureForRow(int rowNum) {
        return (OLAPMeasure)this.getValueAt(rowNum, 3);
    }

    public boolean isCellEditable(int row, int col) {
        OLAPMeasure measure;
        boolean isEditable = true;
        isEditable = col == 1 ? (measure = this.getMeasureForRow(row)).isNunique().booleanValue() : super.isCellEditable(row, col);
        return isEditable;
    }

    public void moveDataToModel() {
        int nRows = this.m_lData.size();
        if (nRows > 0) {
            this.m_lData.clear();
            this.fireTableRowsDeleted(0, nRows - 1);
        }
        nRows = this.measures.size();
        for (int i = 0; i < nRows; ++i) {
            OLAPMeasure measure = (OLAPMeasure)this.measures.get(i);
            if (!measure.isNunique().booleanValue()) continue;
            this.createRow(measure);
        }
        this.fireTableModelPopulated();
    }

    public void moveDataToStore() throws MdException, RemoteException {
    }

    public void populateStore() {
    }

    public void setValueAt(Object value, int iRow, int iCol) {
        OLAPMeasure measure = (OLAPMeasure)this.getValueAt(iRow, 3);
        if (iCol == 1) {
            String newStatValue = (String)value;
            if (newStatValue.equals(NUNIQUE_EXCLUDE)) {
                this.changedStatValue.put(measure, "0");
            } else {
                this.changedStatValue.put(measure, "1");
            }
        }
        super.setValueAt(value, iRow, iCol);
    }

    public void setLists(OLAPList measures2) {
        this.measures = measures2;
    }

    public HashMap getHashMap() {
        int rowCount = this.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            List row = this.getRowValues(i);
            Object[] rowObjs = row.toArray();
            if (!(rowObjs[3] instanceof AbstractOLAPModel)) continue;
            String origValueString = null;
            AbstractOLAPModel olapObj = (AbstractOLAPModel)rowObjs[3];
            String currentValue = (String)rowObjs[1];
            String origValue = (String)this.originalStatValue.get(olapObj);
            if (origValue == "1") {
                origValueString = bundle.getString("UpdateCountOptions.include.txt");
            } else if (origValue == "0") {
                origValueString = bundle.getString("UpdateCountOptions.exclude.txt");
            }
            if (!(currentValue != null && !currentValue.equals(origValueString) || currentValue == null && origValueString != null)) {
                this.changedStatValue.remove(olapObj);
                continue;
            }
            this.changedStatValue.put(olapObj, currentValue);
        }
        return this.changedStatValue;
    }

    private class StatisticsColumn
    extends PopulateOnDemandDisabledWideCombo {
        protected String[] nuniqueStats;

        public StatisticsColumn(int modelIndex, String name, int cxWidth) {
            super(modelIndex, name, cxWidth);
            this.nuniqueStats = new String[2];
            this.nuniqueStats[0] = NUNIQUE_EXCLUDE;
            this.nuniqueStats[1] = NUNIQUE_INCLUDE;
        }

        protected void populate(JTable table, int row, int column) {
            OLAPMeasure measure = (OLAPMeasure)DistinctCountOptionsModel.this.getValueAt(row = ((WsTable)table).convertRowIndexToModel(row), 3);
            if (measure.isNunique() != null && measure.isNunique().booleanValue()) {
                this.setDefaultValue(this.nuniqueStats[0]);
                this.setPossibleValues(Arrays.asList(this.nuniqueStats));
            }
        }
    }
}

