/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.update;

import com.sas.olapadmin.designer.model.AddDataModel;
import com.sas.olapadmin.designer.model.CodeGeneration;
import com.sas.olapadmin.designer.model.ModelUtilities;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.visuals.VisualUtilities;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.olapadmin.utilities.Utilities;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;

public class CubeUpdateSaveProcOlapPanel
extends WAPanel {
    private static final long serialVersionUID = 1L;
    private static WAdminResource bundle = new WAdminResource(CubeUpdateSaveProcOlapPanel.class);
    private WAComboBox inputPath;
    private JLabel labelPath;
    private JLabel labelDirections;
    private Vector paths;
    private JButton browse;
    private int append;
    private Object model;

    public CubeUpdateSaveProcOlapPanel(Object inputModel) {
        this.model = inputModel;
        this.setLayout(new GridBagLayout());
        this.layoutWidgets();
    }

    public boolean validateData() {
        this.append = 0;
        String savePath = (String)this.inputPath.getSelectedItem();
        if (!ModelUtilities.isBlank((String)savePath)) {
            File storeFileTo = new File(savePath);
            try {
                new FileWriter(storeFileTo, true);
            }
            catch (IOException oError) {
                MessageUtil.displayMessage((String)oError.getLocalizedMessage(), (int)2);
                return false;
            }
            if (!storeFileTo.canWrite()) {
                MessageUtil.displayMessage((String)bundle.getString("CubeDesigner.SaveCubePath.NoWrite.Long.txt"), (int)2);
            }
            if (storeFileTo.length() > 0L) {
                int returnValue = Utilities.displayFileExistsMessage((String)savePath);
                if (returnValue == 0) {
                    this.append = 1;
                } else if (returnValue == 2) {
                    return false;
                }
            }
            this.paths.remove(savePath);
            this.paths.insertElementAt(savePath, 0);
            VisualUtilities.setAddDataSaveProcCodePaths(this.paths);
        }
        return true;
    }

    public boolean doDataExchange(boolean saveToModel) {
        if (saveToModel) {
            String savePath = this.inputPath.getText();
            try {
                if (!ModelUtilities.isBlank((String)((String)this.inputPath.getSelectedItem()))) {
                    if (this.model instanceof AddDataModel) {
                        AddDataModel dataModel = (AddDataModel)this.model;
                        if (dataModel.isAddDataForCube()) {
                            CodeGeneration.saveAddDataProcCode((AddDataModel)dataModel, (String)savePath, (int)this.append);
                        } else {
                            CodeGeneration.saveAddDataSharedDimProcCode((AddDataModel)dataModel, (String)savePath, (int)this.append);
                        }
                    } else if (this.model instanceof OLAPCube) {
                        OLAPCube olapCube = (OLAPCube)this.model;
                        CodeGeneration.saveCoalesceProcCode((OLAPCube)olapCube, (String)savePath, (int)this.append);
                    }
                    String absolutePath = null;
                    File exportPath = new File(savePath);
                    absolutePath = exportPath.getAbsolutePath();
                    if (savePath != null) {
                        MessageUtil.displayMessage((String)bundle.formatString("SaveProcCode.file.confirmation.fmt.txt", (Object)absolutePath), (int)1);
                    }
                }
            }
            catch (OLAPException OLAPError) {
                return ExceptionHandler.handleException((Exception)((Object)OLAPError));
            }
        }
        return true;
    }

    protected void layoutWidgets() {
        this.browse = new JButton();
        this.browse.addActionListener(new browseListener());
        this.labelDirections = new JLabel(bundle.getString("CubeUpdate.Finish.saveProcCode.Instruction.txt"));
        this.labelPath = new JLabel();
        this.paths = VisualUtilities.getAddDataSaveProcCodePaths();
        this.inputPath = new WAComboBox(this.paths.toArray());
        this.inputPath.setEditable(true);
        if (!this.paths.isEmpty()) {
            this.inputPath.setSelectedIndex(0);
        }
        this.inputPath.setName("UpdateSaveProcPath");
        this.labelPath.setName("UpdateSaveProcPathLabel");
        this.inputPath.setToolTipText(bundle.getString("CubeUpdate.Finish.saveProcCode.tooltip.txt"));
        VisualUtilities.setLabelTextAndMnemonic(this.labelPath, bundle.getString("CubeDesigner.Common.path.txt"));
        this.labelPath.setLabelFor((Component)this.inputPath);
        this.inputPath.setPreferredSize(new Dimension(400, 10));
        this.browse.setName("browseForPathButton");
        VisualUtilities.setButtonTextAndMnemonic(this.browse, bundle.getString("CubeDesigner.SaveCubePath.LongBrowse.txt"));
        this.add(this.labelDirections, new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 5, 10), 0, 0));
        this.add(this.labelPath, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 7, 5, 5), 0, 0));
        this.add((Component)this.inputPath, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add(this.browse, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
    }

    private class browseListener
    implements ActionListener {
        private browseListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser chooser = new JFileChooser(CubeUpdateSaveProcOlapPanel.this.inputPath.getText());
            chooser.setDialogTitle(bundle.getString("SaveProcCode.Browse.txt"));
            int fileReturn = chooser.showSaveDialog((Component)Workspace.getWorkspace());
            if (fileReturn == 0) {
                String newPath = chooser.getSelectedFile().getPath();
                if (!CubeUpdateSaveProcOlapPanel.this.paths.contains(newPath)) {
                    CubeUpdateSaveProcOlapPanel.this.paths.add(newPath);
                    CubeUpdateSaveProcOlapPanel.this.inputPath.addItem((Object)newPath);
                }
                CubeUpdateSaveProcOlapPanel.this.inputPath.setSelectedItem((Object)newPath);
            }
        }
    }
}

