/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.update;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.Cube;
import com.sas.metadata.remote.Job;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactoryEvent;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.OLAPSchema;
import com.sas.metadata.remote.TransformationActivity;
import com.sas.metadata.remote.TransformationStep;
import com.sas.olapadmin.designer.model.AddDataModel;
import com.sas.olapadmin.designer.model.ModelUtilities;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.visuals.VisualUtilities;
import com.sas.olapadmin.update.CubeUpdateSaveProcOlapDialog;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.olapadmin.utilities.WsRunCode;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.OpRequestUI;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.visuals.WizardFinishTab;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;

public class CubeUpdateFinishTab
extends WizardFinishTab {
    private static final long serialVersionUID = 1L;
    protected static WAdminResource bundle = new WAdminResource(CubeUpdateFinishTab.class);
    private boolean initialized;
    private JButton saveProcCode;
    private WAWizardDialog parent;
    private WsAppServer server;
    private AddDataModel dataModel;
    private WsRunCode wsRunCode;

    public CubeUpdateFinishTab(AddDataModel inputDataModel) {
        super(bundle.getString("CubeUpdate.Finish.groupbox.title"));
        this.dataModel = inputDataModel;
        this.setHelpProduct("olapadmin");
        this.setHelpTopic("cube_update_finish");
        this._layoutWidgets();
    }

    protected void initialize() {
        this.parent = (WAWizardDialog)this.getTopLevelAncestor();
        this.saveProcCode.setName("UpdateFinishSaveProcCode");
        this.saveProcCode.setToolTipText(bundle.getString("CubeDesigner.Finish.saveProcCode.tooltip.txt"));
        this.saveProcCode.addActionListener(new SaveButtonListener());
        this.initialized = true;
    }

    public boolean validateData() {
        this.parent.setCursor(Cursor.getPredefinedCursor(3));
        this.server = WsRunCode.getServer();
        this.parent.setCursor(Cursor.getPredefinedCursor(0));
        if (this.server != null) {
            this.wsRunCode = new WsRunCode(this.server);
            return !this.wsRunCode.hasSubmitError;
        }
        MessageUtil.displayMessage((String)bundle.getString("CubeUpdate.Finish.ServerNeeded.txt"));
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public boolean doDataExchange(boolean bSaveToModel) throws MdException, RemoteException {
        if (!bSaveToModel) {
            super.doDataExchange(bSaveToModel);
            if (!this.initialized) {
                this.initialize();
            }
        } else {
            if (this.dataModel.getTypeOfUpdate() == 0) {
                str1 = CubeUpdateFinishTab.bundle.getString("CubeUpdate.WriteMetadataProgressIndicator.Msg.Title.txt");
                str2 = CubeUpdateFinishTab.bundle.getString("CubeUpdate.WriteMetadataProgressIndicator.Msg.Message.txt");
                updateMetadata = new UpdateMetadata();
                request = new OpRequestUI((Frame)Workspace.getWorkspace(), str2, str1);
                request.setProgressShownOnStatusBar(false);
                request.execute((Runnable)updateMetadata);
            }
            str3 = CubeUpdateFinishTab.bundle.getString("UpdateCubeProgressIndicator.Msg.Title.txt");
            str4 = CubeUpdateFinishTab.bundle.getString("UpdateCubeProgressIndicator.Msg.Message.txt");
            if (this.server != null) {
                try {
                    this.wsRunCode.executeCode(this.dataModel.generateAddDataCode(true), str4, str3);
                    if (this.dataModel.getTypeOfUpdate() == 1) {
                        str1 = CubeUpdateFinishTab.bundle.getString("CubeUpdate.WriteMetadataProgressIndicator.Msg.Title.txt");
                        str2 = CubeUpdateFinishTab.bundle.getString("CubeUpdate.WriteMetadataProgressIndicator.Msg.Message.txt");
                        updateFormatSASCode = this.dataModel.generateUpdateFormatSASCode();
                        if (!ModelUtilities.isBlank((String)updateFormatSASCode.toString())) {
                            this.wsRunCode.executeCode(updateFormatSASCode, str2, str1);
                        }
                    }
                    if ((jomaCube = ModelUtilities.getCube((String)this.dataModel.getName(), (OLAPSchema)this.dataModel.getOLAPSchema())) == null) ** GOTO lbl49
                    jomaJob = this.getJob(jomaCube);
                    factory = Workspace.getWorkspace().getMdObjectFactory();
                    map = new HashMap<String, String>(2);
                    map.put(jomaCube.getFQID(), "Cube");
                    map.put(jomaJob.getFQID(), "Job");
                    try {
                        Workspace.getMdFactory().fireMdObjectsModified(new MdFactoryEvent(factory, map));
                    }
                    catch (RemoteException e) {
                        throw new OLAPException(CubeUpdateFinishTab.bundle.getString("MdException.GenericError.txt"), (Throwable)e, 12);
                    }
                }
                catch (OLAPException error) {
                    ExceptionHandler.handleException((Exception)error);
                }
                finally {
                    this.cleanup();
                }
            } else {
                MessageUtil.displayMessage((String)CubeUpdateFinishTab.bundle.getString("CubeUpdate.Finish.NoUpdate.txt"));
                this.cleanup();
            }
lbl49:
            // 4 sources

            this.cleanup();
        }
        return true;
    }

    private Job getJob(Cube cube) throws RemoteException, MdException {
        TransformationActivity activity;
        AssociationList jobs;
        TransformationStep step;
        AssociationList activities;
        AssociationList steps;
        Job job = null;
        AssociationList maps = cube.getTargetClassifierMaps(true);
        ClassifierMap classifierMap = null;
        int i = maps.size() - 1;
        while (i >= 0 & classifierMap == null) {
            classifierMap = (ClassifierMap)maps.get(i);
            if (!classifierMap.getName().equals("Load Map")) {
                classifierMap = null;
            }
            --i;
        }
        if (!(classifierMap == null || (steps = classifierMap.getSteps(true)).isEmpty() || (activities = (step = (TransformationStep)steps.get(0)).getActivities(true)).isEmpty() || (jobs = (activity = (TransformationActivity)activities.get(0)).getJobs(true)).isEmpty())) {
            job = (Job)jobs.get(0);
        }
        return job;
    }

    protected void _layoutWidgets() {
        Component component = this.getComponent(0);
        JScrollPane componentPanel = (JScrollPane)component;
        this.removeAll();
        componentPanel.setPreferredSize(new Dimension(300, 200));
        componentPanel.setName("FinishStringTextArea");
        this.add(componentPanel, new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        JLabel bottomLabel = new JLabel(bundle.getString("CubeUpdate.Finish.Instructions.txt"));
        this.add(bottomLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 1, new Insets(5, 0, 0, 0), 0, 0));
        this.saveProcCode = new JButton();
        VisualUtilities.setButtonTextAndMnemonic(this.saveProcCode, bundle.getString("CubeDesigner.Finish.saveProcCode.txt"));
        this.saveProcCode.setToolTipText(bundle.getString("Update.Finish.saveProcCode.tooltip.txt"));
        this.add(this.saveProcCode, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 14, 0, new Insets(5, 5, 2, 0), 0, 0));
    }

    private void cleanup() {
        MdObjectStore objectStore = (MdObjectStore)this.parent.getWizardData("OBJECTSTORE");
        try {
            if (objectStore != null) {
                objectStore.dispose();
            }
            objectStore = null;
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        this.parent.addWizardData("OBJECTSTORE", null);
        if (this.server != null) {
            this.wsRunCode.term();
        }
        this.server = null;
    }

    private final class SaveButtonListener
    implements ActionListener {
        private SaveButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Workspace m_workspace = Workspace.getWorkspace();
            CubeUpdateSaveProcOlapDialog saveProcDialog = new CubeUpdateSaveProcOlapDialog(m_workspace, bundle.getString("SaveProcCode.Title.txt"), CubeUpdateFinishTab.this.dataModel);
            saveProcDialog.show();
        }
    }

    class UpdateMetadata
    implements Runnable {
        public boolean returnValue = true;

        UpdateMetadata() {
        }

        @Override
        public void run() {
            try {
                CubeUpdateFinishTab.this.dataModel.updateMetadata();
            }
            catch (OLAPException OLAPError) {
                this.returnValue = ExceptionHandler.handleException((Exception)((Object)OLAPError));
            }
        }

        public boolean getReturnValue() {
            return this.returnValue;
        }
    }
}

