/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.shareddims.visuals;

import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.olapadmin.designer.model.AbstractOLAPModel;
import com.sas.olapadmin.designer.model.LanguageSet;
import com.sas.olapadmin.designer.model.ModelUtilities;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPList;
import com.sas.olapadmin.designer.model.OLAPSharedDimension;
import com.sas.olapadmin.designer.model.SharedDimensionTable;
import com.sas.olapadmin.designer.model.TableSet;
import com.sas.olapadmin.designer.visuals.CubeStructureMessagePanel;
import com.sas.olapadmin.shareddims.visuals.SharedDimDesigner;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.olapadmin.utilities.Utilities;
import com.sas.olapadmin.utilities.studio.DetailsMessage;
import com.sas.olapadmin.utilities.studio.PhysicalTableSelector;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WATextArea;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class SharedDimSelectTablePanel
extends WAPanel {
    private static final long serialVersionUID = 1L;
    protected static WAdminResource bundle = new WAdminResource(SharedDimSelectTablePanel.class);
    private OLAPSharedDimension olapDim;
    private PhysicalTableSelector tree;
    private LanguageSet languageSet;
    private TableSet tableSet;
    private boolean isMultiLanguage;
    private boolean initialized;
    private PhysicalTable previousMappedTable;
    private SharedDimDesigner parent;

    public SharedDimSelectTablePanel(OLAPSharedDimension inOLAPDim, SharedDimDesigner inParent) {
        this.olapDim = inOLAPDim;
        this.parent = inParent;
        this.setLayout(new GridBagLayout());
        this.layoutWidgets();
    }

    public boolean doDataExchange(boolean saveToModel) {
        if (!saveToModel && !this.initialized) {
            this.initialize();
        }
        return true;
    }

    protected void initialize() {
        if (Utilities.isConnectedToMetadataServer((boolean)true)) {
            try {
                this.initialized = true;
                SharedDimensionTable dimTable = this.olapDim.getSharedDimensionTable();
                if (dimTable != null) {
                    this.tree.initializeSelectedTable(dimTable.getTable());
                }
                String tableOptions = this.olapDim.getTableOptions();
                this.setCursor(Cursor.getPredefinedCursor(3));
                if (!ModelUtilities.isBlank((String)tableOptions)) {
                    this.tree.setOptions(tableOptions);
                }
                this.tree.populateStore();
                this.tree.moveDataToView();
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
            catch (MdException mdError) {
                ExceptionHandler.handleException((Exception)((Object)new OLAPException(mdError.getLocalizedMessage(), (Throwable)mdError, 12)));
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
            catch (OLAPException OLAPError) {
                ExceptionHandler.handleException((Exception)((Object)OLAPError));
            }
        }
    }

    public void saveSettingsAndCleanUp() {
        this.tree.saveSettingsAndCleanUp();
    }

    public boolean validateData() {
        PhysicalTable table = this.tree.getSelectedTable();
        if (table == null) {
            MessageUtil.displayMessage((String)bundle.getString("SharedDimSelectTable.DimensionTables.NoTableError.txt"), (int)2);
            return false;
        }
        if (!Utilities.isConnectedToMetadataServer((boolean)true)) {
            return false;
        }
        try {
            table = this.tree.getSelectedTable();
            SharedDimensionTable dimensionTable = this.olapDim.getSharedDimensionTable();
            if (dimensionTable == null && table != null) {
                dimensionTable = this.tableSet.getSharedDimensionTable(table);
                this.olapDim.setSharedDimensionTable(dimensionTable);
            } else if (dimensionTable != null && !dimensionTable.equals(table)) {
                if (this.previousMappedTable != null && this.previousMappedTable != table) {
                    dimensionTable.clearMap();
                    this.olapDim.clearMapping();
                }
                if (dimensionTable != null && this.olapDim.hasStructure()) {
                    dimensionTable.mapTable(table);
                }
                if (table != null) {
                    boolean setLoadTable = true;
                    boolean hasAdvancedOptions = false;
                    ArrayList<String> dimOptions = new ArrayList<String>();
                    LanguageSet languageSet = this.olapDim.getLanguageSet();
                    OLAPList listOfLevels = this.olapDim.getLevels();
                    if (listOfLevels != null && !listOfLevels.isEmpty() || !ModelUtilities.isBlank((String)this.olapDim.getSASCode()) || this.olapDim.getEmptyChar() != null || this.olapDim.getEmptyNum() != null || languageSet.getSelectedLocales().size() > 0) {
                        String dimOption = this.olapDim.getSASCode();
                        dimOptions.add(dimOption);
                        hasAdvancedOptions = !ModelUtilities.isBlank((String)dimOption);
                        dimOption = this.olapDim.getEmptyChar();
                        dimOptions.add(dimOption);
                        hasAdvancedOptions = hasAdvancedOptions || !ModelUtilities.isBlank((String)dimOption);
                        dimOption = this.olapDim.getEmptyNum();
                        dimOptions.add(dimOption);
                        boolean bl = hasAdvancedOptions = hasAdvancedOptions || !ModelUtilities.isBlank((String)dimOption);
                        if (this.olapDim.getLanguageSet().getSelectedLocales().size() > 0) {
                            dimOptions.add("languages!");
                            hasAdvancedOptions = true;
                        } else {
                            dimOptions.add(null);
                        }
                    }
                    boolean validStructure = true;
                    if (!this.olapDim.mapHasValidStructure()) {
                        validStructure = false;
                    }
                    PhysicalTable mappedTable = null;
                    if (dimensionTable != null && this.olapDim.hasStructure()) {
                        mappedTable = dimensionTable.getMappedTable();
                    }
                    boolean perfectMap = true;
                    if (mappedTable != null) {
                        perfectMap = dimensionTable.isPerfectMap();
                    }
                    boolean hasMapChanged = dimensionTable.isMapChanged();
                    if (mappedTable != null) {
                        this.previousMappedTable = mappedTable;
                        if (!perfectMap || hasMapChanged) {
                            StringBuffer message = new StringBuffer();
                            if (dimensionTable != null) {
                                message.append(dimensionTable.getMappedMessage());
                            }
                            List messages = dimensionTable.getMappedTableStructureChanges();
                            int messagesSize = messages.size();
                            message.append(bundle.getString("SharedDimSelectTable.InputChanged.Warning.txt"));
                            if (!hasAdvancedOptions && messagesSize > 0) {
                                message.append(bundle.getString("SharedDimSelectTable.InputPanel.MappedTableDetailsStructureOnly.txt"));
                            } else if (hasAdvancedOptions && messagesSize > 0) {
                                message.append(bundle.getString("SharedDimSelectTable.InputPanel.MappedTableDetails.txt"));
                            } else if (hasAdvancedOptions && messagesSize < 1) {
                                message.append(bundle.getString("SharedDimSelectTable.InputPanel.MappedTableDetailsOptionsOnly.txt"));
                            }
                            CubeStructureMessagePanel messagePanel = new CubeStructureMessagePanel(messages, (AbstractOLAPModel)this.olapDim, dimOptions);
                            int option = 0;
                            option = hasAdvancedOptions || messages.size() > 0 ? DetailsMessage.showDialog(message.toString(), bundle.getString("SharedDimSelectTable.Mapping.MapLoadTable.ChangeStructureMessage.title.txt"), 2, 0, messagePanel) : MessageUtil.displayMessage((String)message.toString(), (int)2, (int)0);
                            if (option == 0) {
                                messagePanel.saveToModel();
                                if (!validStructure) {
                                    this.olapDim.reset();
                                    this.parent.addWizardData("LEVELSCHANGED", "1");
                                    if (dimensionTable != null) {
                                        dimensionTable.clearMap();
                                    }
                                } else {
                                    this.olapDim.resetOptions();
                                }
                                dimensionTable.setTable(table);
                                setLoadTable = false;
                            }
                            if (option != 0) {
                                return false;
                            }
                        }
                    } else if (hasAdvancedOptions && this.olapDim.hasStructure()) {
                        int option = 0;
                        CubeStructureMessagePanel messagePanel = new CubeStructureMessagePanel(null, (AbstractOLAPModel)this.olapDim, dimOptions);
                        option = MessageUtil.displayDetailsMessage((String)bundle.getString("CubeDesigner.InputPanel.MappedTableDetailsOptionsOnly.txt"), (String)bundle.getString("MapLoadTable.ChangeStructureMessage.title.txt"), (int)2, (int)2, (JComponent)messagePanel);
                        if (option == 0) {
                            messagePanel.saveToModel();
                            this.olapDim.resetOptions();
                        } else {
                            return false;
                        }
                    }
                    if (setLoadTable) {
                        dimensionTable.setTable(table);
                    }
                    if (dimensionTable != null) {
                        dimensionTable.clearMap();
                    }
                    this.olapDim.clearMapping();
                    mappedTable = null;
                }
            }
            String tableOptions = this.tree.getOptions();
            this.olapDim.setTableOptions(tableOptions);
            SharedDimensionTable sharedTable = this.olapDim.getSharedDimensionTable();
            sharedTable.clearMap();
            if (sharedTable != null) {
                sharedTable.setSASLibrary();
            }
        }
        catch (OLAPException oError) {
            ExceptionHandler.handleException((Exception)((Object)oError));
        }
        return true;
    }

    protected void layoutWidgets() {
        try {
            this.languageSet = this.olapDim.getLanguageSet();
            this.tableSet = this.olapDim.getTableSet();
            this.isMultiLanguage = this.languageSet.isCubeMultipleLanguageSupported();
            WATextArea m_instructions = new WATextArea();
            JLabel l = new JLabel();
            m_instructions.setFont(l.getFont());
            m_instructions.setColumns(30);
            m_instructions.setBehavior(1);
            m_instructions.setBackground((Color)SystemColor.control);
            m_instructions.setAutosize(true);
            if (this.isMultiLanguage) {
                this.tree = new PhysicalTableSelector((AbstractOLAPModel)this.olapDim, 1, true, true, true, true, false);
                m_instructions.setText(bundle.getString("SharedDimSelectTable.DimensionTables.MLSinstruct.txt"));
            } else {
                this.tree = new PhysicalTableSelector((AbstractOLAPModel)this.olapDim, 1, true, true, false, true, false);
                m_instructions.setText(bundle.getString("SharedDimSelectTable.DimensionTables.instruct.txt"));
            }
            this.tree.setName("DimensionTablesSelection");
            this.add((Component)m_instructions, new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 20, 5), 0, 0));
            this.add((Component)((Object)this.tree), new GridBagConstraints(0, 1, 3, 3, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
        catch (OLAPException oError) {
            ExceptionHandler.handleException((Exception)((Object)oError));
        }
    }
}

