/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.shareddims.visuals;

import com.sas.graphics.map.ESRIConnection;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.AuthenticationDomain;
import com.sas.metadata.remote.COMConnection;
import com.sas.metadata.remote.File;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.SASLibrary;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.TableCollection;
import com.sas.olapadmin.designer.model.OLAPColumn;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPLevel;
import com.sas.olapadmin.designer.model.OLAPList;
import com.sas.olapadmin.designer.model.OLAPSharedDimension;
import com.sas.olapadmin.designer.model.SharedDimensionTable;
import com.sas.olapadmin.designer.visuals.ESRITestDialog;
import com.sas.olapadmin.shareddims.visuals.SharedDimGISMapDialog;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.olapadmin.utilities.Utilities;
import com.sas.olapadmin.utilities.WsRunCode;
import com.sas.rio.MVAConnection;
import com.sas.util.SasPasswordEncodingException;
import com.sas.util.SasPasswordString;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsAppServerCodeException;
import com.sas.workspace.WsAppServerFailException;
import com.sas.workspace.WsAppServerLibraryException;
import com.sas.workspace.connection.ConnectionManager;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SharedDimGISMapPanel
extends WAPanel {
    private static final long serialVersionUID = 1L;
    private static WAdminResource bundle = new WAdminResource(SharedDimGISMapPanel.class);
    private WAComboBox server;
    private WAComboBox service;
    private WAComboBox layer;
    private WAComboBox id;
    private WAComboBox column;
    private JButton testMap;
    private List mapServers;
    private ServerComponent selectedServer;
    private TableCollection selectedMap;
    private OLAPColumn selectedLayer;
    private Property selectedId;
    private int selectedIndex;
    private JList levelsBox;
    private DefaultListModel levelsModel;
    private Object[][] levelLayers;
    private OLAPSharedDimension geoDimension;

    public SharedDimGISMapPanel(OLAPSharedDimension inGeoDimension) {
        this.geoDimension = inGeoDimension;
        this.setLayout(new GridBagLayout());
        this.layoutWidgets();
    }

    protected void layoutWidgets() {
        Dimension comboboxSize = new Dimension(150, 20);
        this.setLayout(new GridBagLayout());
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new GridBagLayout());
        JLabel serverLabel = new JLabel();
        Utilities.setLabelTextAndMnemonic((JLabel)serverLabel, (String)bundle.getString("SharedDimDesigner.Server.txt"));
        this.server = new WAComboBox(true, true);
        this.server.setPreferredSize(comboboxSize);
        this.server.addActionListener((ActionListener)new ServerActionListener());
        serverLabel.setLabelFor((Component)this.server);
        this.server.setToolTipText(bundle.getString("SharedDimDesigner.Server.tooltip.txt"));
        topPanel.add((Component)serverLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 5, 5), 0, 0));
        topPanel.add((Component)this.server, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 18, 2, new Insets(5, 5, 5, 0), 0, 0));
        JLabel serviceLabel = new JLabel();
        Utilities.setLabelTextAndMnemonic((JLabel)serviceLabel, (String)bundle.getString("SharedDimDesigner.Service.txt"));
        this.service = new WAComboBox(true, true);
        this.service.setPreferredSize(comboboxSize);
        this.service.addActionListener((ActionListener)new FileActionListener());
        serviceLabel.setLabelFor((Component)this.service);
        this.service.setToolTipText(bundle.getString("SharedDimDesigner.Service.tooltip.txt"));
        topPanel.add((Component)serviceLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 0, 5), 0, 0));
        topPanel.add((Component)this.service, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 18, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.add(topPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0));
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new GridBagLayout());
        JLabel levelsLabel = new JLabel();
        Utilities.setLabelTextAndMnemonic((JLabel)levelsLabel, (String)bundle.getString("SharedDimDesigner.Levels.txt"));
        this.levelsModel = new DefaultListModel();
        this.levelsBox = new JList(this.levelsModel);
        levelsLabel.setLabelFor(this.levelsBox);
        this.levelsBox.setSelectionMode(0);
        this.levelsBox.addListSelectionListener(new LevelBoxListener());
        this.levelsBox.setToolTipText(bundle.getString("SharedDimDesigner.Levels.tooltip.txt"));
        JScrollPane scrollPane = new JScrollPane(this.levelsBox);
        scrollPane.setPreferredSize(new Dimension(125, 125));
        bottomPanel.add((Component)levelsLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 5, 0), 0, 0));
        bottomPanel.add((Component)scrollPane, new GridBagConstraints(0, 1, 1, 3, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 10), 0, 0));
        JPanel mapPanel = new JPanel();
        mapPanel.setLayout(new GridBagLayout());
        mapPanel.setBorder(new TitledBorder(bundle.getString("SharedDimDesigner.MapFields.Title.txt")));
        JLabel layerLabel = new JLabel();
        Utilities.setLabelTextAndMnemonic((JLabel)layerLabel, (String)bundle.getString("SharedDimDesigner.Layer.txt"));
        this.layer = new WAComboBox();
        this.layer.setPreferredSize(comboboxSize);
        this.layer.addActionListener((ActionListener)new LayerActionListener());
        layerLabel.setLabelFor((Component)this.layer);
        this.layer.setToolTipText(bundle.getString("SharedDimDesigner.Layer.tooltip.txt"));
        mapPanel.add((Component)layerLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        mapPanel.add((Component)this.layer, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 5, 5, 0), 0, 0));
        JLabel idLabel = new JLabel();
        Utilities.setLabelTextAndMnemonic((JLabel)idLabel, (String)bundle.getString("SharedDimDesigner.Id.txt"));
        this.id = new WAComboBox(true, true);
        this.id.setPreferredSize(comboboxSize);
        this.id.addActionListener((ActionListener)new IdActionListener());
        idLabel.setLabelFor((Component)this.id);
        this.id.setToolTipText(bundle.getString("SharedDimDesigner.Id.tooltip.txt"));
        mapPanel.add((Component)idLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        mapPanel.add((Component)this.id, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 5, 0), 0, 0));
        bottomPanel.add((Component)mapPanel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0));
        JPanel tablePanel = new JPanel();
        tablePanel.setLayout(new GridBagLayout());
        tablePanel.setBorder(new TitledBorder(bundle.getString("SharedDimDesigner.InputFields.Title.txt")));
        JLabel columnLabel = new JLabel();
        Utilities.setLabelTextAndMnemonic((JLabel)columnLabel, (String)bundle.getString("SharedDimDesigner.IdColumn.txt"));
        this.column = new WAComboBox(true, true);
        this.column.setPreferredSize(comboboxSize);
        columnLabel.setLabelFor((Component)this.column);
        this.column.setToolTipText(bundle.getString("SharedDimDesigner.IdColumn.tooltip.txt"));
        tablePanel.add((Component)columnLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        tablePanel.add((Component)this.column, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
        bottomPanel.add((Component)tablePanel, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add(bottomPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0));
        JPanel testPanel = new JPanel();
        testPanel.setLayout(new GridBagLayout());
        JLabel testLabel = new JLabel();
        Utilities.setLabelTextAndMnemonic((JLabel)testLabel, (String)bundle.getString("SharedDimDesigner.TestLabel.control.label"));
        this.testMap = new JButton();
        Utilities.setButtonTextAndMnemonic((AbstractButton)this.testMap, (String)bundle.getString("SharedDimDesigner.TestButton.control.label"));
        this.testMap.addActionListener(new TestMapButtonListener());
        testPanel.add((Component)testLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 5, 5), 0, 0));
        testPanel.add((Component)this.testMap, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 18, 2, new Insets(5, 5, 5, 0), 0, 0));
        this.add(testPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
    }

    public boolean doDataExchange(boolean bSaveToModel) {
        if (!bSaveToModel) {
            super.initialize();
            if (Utilities.isConnectedToMetadataServer((boolean)true)) {
                this.service.setEnabled(false);
                this.levelsBox.setEnabled(false);
                this.layer.setEnabled(false);
                this.id.setEnabled(false);
                this.column.setEnabled(false);
                this.testMap.setEnabled(false);
                this.server.addItem((Object)" ");
                try {
                    this.mapServers = this.geoDimension.getDimensionSet().getMapServers(this.geoDimension);
                }
                catch (OLAPException oError) {
                    ExceptionHandler.handleException((Exception)((Object)oError));
                }
                for (int i = 0; i < this.mapServers.size(); ++i) {
                    this.server.addItem(this.mapServers.get(i));
                }
                try {
                    OLAPList levels = this.geoDimension.getLevels();
                    for (int i = 0; i < levels.size(); ++i) {
                        this.levelsModel.addElement(levels.get(i));
                    }
                    this.selectedIndex = -1;
                    SharedDimensionTable table = this.geoDimension.getSharedDimensionTable();
                    OLAPList columns = table.getColumns();
                    this.column.addItem((Object)" ");
                    for (int i = 0; i < columns.size(); ++i) {
                        this.column.addItem(columns.get(i));
                    }
                    this.column.setSelectedItem((Object)" ");
                    TableCollection source = this.geoDimension.getMapService();
                    ServerComponent mapserver = this.geoDimension.getMapServer();
                    if (mapserver != null) {
                        this.server.setSelectedItem((Object)mapserver);
                    }
                    if (source != null) {
                        this.service.setSelectedItem((Object)source);
                    }
                    this.levelLayers = this.getLevelInformation();
                }
                catch (OLAPException e1) {
                    ExceptionHandler.handleException((Exception)((Object)e1));
                }
            }
        } else {
            try {
                if (this.selectedServer != null) {
                    boolean found = false;
                    this.geoDimension.setMapServer(this.selectedServer);
                    this.geoDimension.setMapService(this.selectedMap);
                    for (int i = 0; i < this.levelsModel.size(); ++i) {
                        OLAPLevel level = (OLAPLevel)this.levelsModel.elementAt(i);
                        if (this.levelLayers[i][0] != null && this.levelLayers[i][0] instanceof OLAPColumn) {
                            found = true;
                            level.setMapLayer((OLAPColumn)this.levelLayers[i][0]);
                            level.setMapFieldId((Property)this.levelLayers[i][1]);
                            level.setMapOLAPPropertyField((OLAPColumn)this.levelLayers[i][2]);
                            level.createMapOLAPMemberProperty();
                        } else {
                            level.deleteMapInformation();
                        }
                        level.apply();
                    }
                    if (!found) {
                        this.geoDimension.deleteMapInformation();
                    }
                } else {
                    this.geoDimension.deleteMapInformation();
                }
                this.geoDimension.apply();
            }
            catch (OLAPException e) {
                ExceptionHandler.handleException((Exception)((Object)e));
            }
        }
        return true;
    }

    public boolean validateData() {
        boolean dataOK = true;
        if (this.selectedServer != null && this.selectedMap == null) {
            MessageUtil.displayMessage((String)bundle.getString("SharedDimDesigner.NoMapService.txt"), (int)0);
            dataOK = false;
        } else if (this.selectedServer != null && this.selectedMap != null) {
            this.saveLevelSelections();
            int count = 0;
            for (int i = 0; i < this.levelsModel.size(); ++i) {
                String message;
                OLAPLevel level = (OLAPLevel)this.levelsModel.get(i);
                if (this.levelLayers[i][0] == null || !(this.levelLayers[i][0] instanceof OLAPColumn)) continue;
                ++count;
                if (this.levelLayers[i][1] == null || this.levelLayers[i][1] instanceof String) {
                    message = bundle.formatString("SharedDimDesigner.NoIdAssigned.fmt.txt", (Object)level.getName());
                    MessageUtil.displayMessage((String)message, (int)0);
                    dataOK = false;
                    continue;
                }
                if (this.levelLayers[i][2] != null && !(this.levelLayers[i][2] instanceof String)) continue;
                message = bundle.formatString("SharedDimDesigner.NoColumnAssigned.fmt.txt", (Object)level.getName());
                MessageUtil.displayMessage((String)message, (int)0);
                dataOK = false;
            }
            if (count <= 0) {
                MessageUtil.displayMessage((String)bundle.getString("SharedDimDesigner.NoLayersAssigned.txt"), (int)0);
                dataOK = false;
            }
        }
        return dataOK;
    }

    private void saveLevelSelections() {
        if (this.selectedIndex > -1) {
            this.levelLayers[this.selectedIndex][0] = this.layer.getSelectedItem();
            this.levelLayers[this.selectedIndex][1] = this.id.getSelectedItem();
            this.levelLayers[this.selectedIndex][2] = this.column.getSelectedItem();
        }
    }

    private Object[][] getLevelInformation() {
        OLAPList levels = null;
        Object[][] levelInfo = null;
        try {
            levels = this.geoDimension.getLevels();
            levelInfo = new Object[levels.size()][3];
            if (!levels.isEmpty()) {
                this.levelLayers = new Object[levels.size()][3];
                for (int i = 0; i < levels.size(); ++i) {
                    OLAPLevel level = (OLAPLevel)levels.get(i);
                    levelInfo[i][0] = level.getMapLayer();
                    levelInfo[i][1] = level.getMapFieldId();
                    levelInfo[i][2] = level.getMapOLAPPropertyField();
                }
            }
        }
        catch (OLAPException oError) {
            ExceptionHandler.handleException((Exception)((Object)oError));
        }
        return levelInfo;
    }

    static /* synthetic */ Object[][] access$502(SharedDimGISMapPanel x0, Object[][] x1) {
        x0.levelLayers = x1;
        return x1;
    }

    public class ServerActionListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            Object selectedObject = ((WAComboBox)e.getSource()).getSelectedItem();
            if (selectedObject instanceof ServerComponent && !((ServerComponent)selectedObject).equals((Object)SharedDimGISMapPanel.this.selectedServer)) {
                SharedDimGISMapPanel.this.selectedServer = (ServerComponent)selectedObject;
                SharedDimGISMapPanel.this.service.removeAllItems();
                SharedDimGISMapPanel.this.service.addItem((Object)" ");
                try {
                    List collections = SharedDimGISMapPanel.this.geoDimension.getDimensionSet().getMapServices(SharedDimGISMapPanel.this.selectedServer);
                    for (int j = 0; j < collections.size(); ++j) {
                        SharedDimGISMapPanel.this.service.addItem(collections.get(j));
                    }
                }
                catch (OLAPException oError) {
                    ExceptionHandler.handleException((Exception)((Object)oError));
                }
                SharedDimGISMapPanel.this.service.setSelectedItem((Object)" ");
                SharedDimGISMapPanel.this.service.setEnabled(true);
            } else if (selectedObject instanceof String) {
                SharedDimGISMapPanel.this.selectedServer = null;
                SharedDimGISMapPanel.this.service.removeAllItems();
                SharedDimGISMapPanel.this.service.addItem((Object)" ");
                SharedDimGISMapPanel.this.service.setSelectedItem((Object)" ");
                SharedDimGISMapPanel.this.service.setEnabled(false);
                SharedDimGISMapPanel.this.testMap.setEnabled(false);
            }
        }
    }

    public class FileActionListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            Object selectedObject = ((WAComboBox)e.getSource()).getSelectedItem();
            if (selectedObject instanceof TableCollection && !((TableCollection)selectedObject).equals((Object)SharedDimGISMapPanel.this.selectedMap)) {
                SharedDimGISMapPanel.this.selectedMap = (TableCollection)selectedObject;
                SharedDimGISMapPanel.access$502(SharedDimGISMapPanel.this, new Object[SharedDimGISMapPanel.this.levelsModel.size()][3]);
                SharedDimGISMapPanel.this.layer.removeAllItems();
                SharedDimGISMapPanel.this.layer.addItem((Object)" ");
                try {
                    List layers = SharedDimGISMapPanel.this.geoDimension.getDimensionSet().getMapServiceColumns(SharedDimGISMapPanel.this.selectedMap);
                    for (int i = 0; i < layers.size(); ++i) {
                        SharedDimGISMapPanel.this.layer.addItem(layers.get(i));
                    }
                }
                catch (OLAPException e1) {
                    ExceptionHandler.handleException((Exception)((Object)e1));
                }
                SharedDimGISMapPanel.this.levelsBox.setEnabled(true);
                SharedDimGISMapPanel.this.layer.setEnabled(false);
                SharedDimGISMapPanel.this.testMap.setEnabled(true);
            } else if (selectedObject instanceof String) {
                SharedDimGISMapPanel.this.selectedMap = null;
                SharedDimGISMapPanel.access$502(SharedDimGISMapPanel.this, null);
                SharedDimGISMapPanel.this.layer.removeAllItems();
                SharedDimGISMapPanel.this.layer.addItem((Object)" ");
                SharedDimGISMapPanel.this.levelsBox.setEnabled(false);
                SharedDimGISMapPanel.this.layer.setEnabled(false);
                SharedDimGISMapPanel.this.testMap.setEnabled(false);
            }
            SharedDimGISMapPanel.this.levelsBox.clearSelection();
            SharedDimGISMapPanel.this.layer.setSelectedItem((Object)" ");
        }
    }

    public class LevelBoxListener
    implements ListSelectionListener {
        @Override
        public void valueChanged(ListSelectionEvent e) {
            int index;
            if (!e.getValueIsAdjusting() && (index = SharedDimGISMapPanel.this.levelsBox.getSelectedIndex()) != SharedDimGISMapPanel.this.selectedIndex) {
                SharedDimGISMapPanel.this.saveLevelSelections();
                SharedDimGISMapPanel.this.selectedIndex = index;
                if (index == -1) {
                    SharedDimGISMapPanel.this.layer.setSelectedItem((Object)" ");
                    SharedDimGISMapPanel.this.layer.setEnabled(false);
                } else {
                    if (SharedDimGISMapPanel.this.levelLayers[index][0] != null) {
                        SharedDimGISMapPanel.this.layer.setSelectedItem(SharedDimGISMapPanel.this.levelLayers[index][0]);
                    } else {
                        SharedDimGISMapPanel.this.layer.setSelectedItem((Object)" ");
                    }
                    if (SharedDimGISMapPanel.this.levelLayers[index][1] != null) {
                        SharedDimGISMapPanel.this.id.setSelectedItem(SharedDimGISMapPanel.this.levelLayers[index][1]);
                    } else {
                        SharedDimGISMapPanel.this.id.setSelectedItem((Object)" ");
                    }
                    if (SharedDimGISMapPanel.this.levelLayers[index][2] != null) {
                        SharedDimGISMapPanel.this.column.setSelectedItem(SharedDimGISMapPanel.this.levelLayers[index][2]);
                    } else {
                        SharedDimGISMapPanel.this.column.setSelectedItem((Object)" ");
                    }
                    SharedDimGISMapPanel.this.layer.setEnabled(true);
                }
            }
        }
    }

    public class LayerActionListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            Object selectedObject = ((WAComboBox)e.getSource()).getSelectedItem();
            if (selectedObject instanceof OLAPColumn && !((OLAPColumn)selectedObject).equals(SharedDimGISMapPanel.this.selectedLayer)) {
                SharedDimGISMapPanel.this.selectedLayer = (OLAPColumn)selectedObject;
                SharedDimGISMapPanel.this.id.setEnabled(true);
                SharedDimGISMapPanel.this.id.removeAllItems();
                SharedDimGISMapPanel.this.id.addItem((Object)" ");
                try {
                    List ids = SharedDimGISMapPanel.this.selectedLayer.getProperties();
                    for (int i = 0; i < ids.size(); ++i) {
                        SharedDimGISMapPanel.this.id.addItem(ids.get(i));
                    }
                }
                catch (OLAPException e1) {
                    ExceptionHandler.handleException((Exception)((Object)e1));
                }
            } else if (selectedObject instanceof String) {
                SharedDimGISMapPanel.this.selectedLayer = null;
                SharedDimGISMapPanel.this.id.removeAllItems();
                SharedDimGISMapPanel.this.id.addItem((Object)" ");
                SharedDimGISMapPanel.this.id.setEnabled(false);
            }
            SharedDimGISMapPanel.this.id.setSelectedItem((Object)" ");
        }
    }

    public class IdActionListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            Object selectedObject = ((WAComboBox)e.getSource()).getSelectedItem();
            if (selectedObject instanceof Property && !((Property)selectedObject).equals((Object)SharedDimGISMapPanel.this.selectedId)) {
                SharedDimGISMapPanel.this.selectedId = (Property)selectedObject;
                SharedDimGISMapPanel.this.column.setEnabled(true);
            } else if (selectedObject instanceof String) {
                SharedDimGISMapPanel.this.selectedId = null;
                SharedDimGISMapPanel.this.column.setEnabled(false);
            }
            SharedDimGISMapPanel.this.column.setSelectedItem((Object)" ");
        }
    }

    public class TestMapButtonListener
    implements ActionListener {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent arg0) {
            WsAppServer appServer = null;
            try {
                int choice = MessageUtil.displayMessage((String)bundle.getString("SharedDimDesigner.ConfirmTestMappings.txt"), (String)bundle.getString("Common.warning.window.title"), (int)2, (int)2);
                if (choice == 0) {
                    SharedDimGISMapPanel.this.setCursor(Cursor.getPredefinedCursor(3));
                    SharedDimGISMapPanel.this.saveLevelSelections();
                    int count = 0;
                    for (int i = 0; i < SharedDimGISMapPanel.this.levelsModel.size(); ++i) {
                        if (SharedDimGISMapPanel.this.levelLayers[i][0] == null || !(SharedDimGISMapPanel.this.levelLayers[i][0] instanceof OLAPColumn) || SharedDimGISMapPanel.this.levelLayers[i][1] == null || SharedDimGISMapPanel.this.levelLayers[i][1] instanceof String || SharedDimGISMapPanel.this.levelLayers[i][2] == null || SharedDimGISMapPanel.this.levelLayers[i][2] instanceof String) continue;
                        ++count;
                    }
                    if (count <= 0) {
                        SharedDimGISMapPanel.this.setCursor(Cursor.getPredefinedCursor(0));
                        MessageUtil.displayMessage((String)bundle.getString("SharedDimDesigner.IncompleteLayerAssigned.txt"), (int)0);
                        return;
                    }
                    AssociationList sourceConnections = SharedDimGISMapPanel.this.selectedServer.getSourceConnections();
                    ESRIConnection esriConnect = this.getESRIConnection(sourceConnections);
                    appServer = WsRunCode.getServer();
                    if (esriConnect != null && appServer != null) {
                        PhysicalTable table = SharedDimGISMapPanel.this.geoDimension.getSharedDimensionTable().getTable();
                        SASLibrary sasLib = SharedDimGISMapPanel.this.geoDimension.getSharedDimensionTable().getSASLibrary();
                        appServer.assignLibref(sasLib);
                        String selectStmt = this.getSelectStatement(table, sasLib);
                        MVAConnection mvaconnection = null;
                        mvaconnection = appServer.isSQLConnectionOpen() ? appServer.getSQLConnection() : appServer.openSQLConnection();
                        ResultSet results = null;
                        if (mvaconnection != null) {
                            results = mvaconnection.createStatement(1004, 1007).executeQuery(selectStmt);
                        }
                        if (results != null) {
                            SharedDimGISMapDialog parent = (SharedDimGISMapDialog)((Object)SharedDimGISMapPanel.this.getTopLevelAncestor());
                            ESRITestDialog dialog = new ESRITestDialog(parent, results, esriConnect, SharedDimGISMapPanel.this.levelLayers, SharedDimGISMapPanel.this.levelsModel);
                            dialog.show();
                        }
                    }
                }
            }
            catch (MdException e) {
                ExceptionHandler.handleException((Exception)((Object)e));
            }
            catch (RemoteException e) {
                ExceptionHandler.handleException((Exception)e);
            }
            catch (SasPasswordEncodingException e) {
                ExceptionHandler.handleException((Exception)((Object)e));
            }
            catch (OLAPException e) {
                ExceptionHandler.handleException((Exception)((Object)e));
            }
            catch (WsAppServerLibraryException e) {
                ExceptionHandler.handleException((Exception)((Object)e));
            }
            catch (WsAppServerFailException e) {
                ExceptionHandler.handleException((Exception)((Object)e));
            }
            catch (WsAppServerCodeException e) {
                ExceptionHandler.handleException((Exception)((Object)e));
            }
            catch (SQLException e) {
                ExceptionHandler.handleException((Exception)e);
            }
            finally {
                if (appServer != null) {
                    appServer.close();
                }
                SharedDimGISMapPanel.this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }

        private String getSelectStatement(PhysicalTable table, SASLibrary sasLib) throws RemoteException {
            String statement = "Select ";
            String columns = "";
            for (int i = 0; i < SharedDimGISMapPanel.this.levelLayers.length; ++i) {
                if (SharedDimGISMapPanel.this.levelLayers[i][0] == null || !(SharedDimGISMapPanel.this.levelLayers[i][0] instanceof OLAPColumn) || SharedDimGISMapPanel.this.levelLayers[i][1] == null || SharedDimGISMapPanel.this.levelLayers[i][1] instanceof String || SharedDimGISMapPanel.this.levelLayers[i][2] == null || SharedDimGISMapPanel.this.levelLayers[i][2] instanceof String) continue;
                if (!Utilities.isBlank((String)columns)) {
                    columns = columns + ",";
                }
                OLAPColumn col = (OLAPColumn)SharedDimGISMapPanel.this.levelLayers[i][2];
                columns = columns + " " + col.getSASColumnName();
            }
            statement = statement + columns;
            statement = statement + " from ";
            statement = statement + sasLib.getLibref().trim() + "." + table.getSASTableName();
            statement = statement + "(obs=1000)";
            return statement;
        }

        private ESRIConnection getESRIConnection(AssociationList sourceConnections) throws RemoteException, MdException, SasPasswordEncodingException {
            ESRIConnection esriConnect = null;
            String domain = "";
            for (int i = 0; i < sourceConnections.size() && esriConnect == null; ++i) {
                String userid;
                if (!(sourceConnections.get(i) instanceof COMConnection)) continue;
                COMConnection connection = (COMConnection)sourceConnections.get(i);
                String machine = connection.getHostName();
                AuthenticationDomain authDomain = connection.getDomain();
                ConnectionManager connMgr = Workspace.getWorkspace().getConnectionManager();
                if (connMgr.getLogin(authDomain.getName()) == null) {
                    MessageUtil.displayMessage((String)bundle.formatString("SharedDimDesigner.NoCredentials.fmt.txt", (Object)SharedDimGISMapPanel.this.selectedServer.getName(), (Object)authDomain.getName()), (int)0);
                    continue;
                }
                String uid = connMgr.getLogin(authDomain.getName()).getUserName();
                int pos = uid.indexOf("\\");
                if (pos > 0) {
                    domain = uid.substring(0, pos);
                    userid = uid.substring(pos + 1);
                } else {
                    userid = uid;
                }
                esriConnect = new ESRIConnection(machine, domain, userid, SasPasswordString.decode((String)new String(connMgr.getLogin(authDomain.getName()).getPassword())));
                AssociationList files = SharedDimGISMapPanel.this.selectedMap.getCollectionLocations();
                if (!files.isEmpty()) {
                    File file = (File)files.elementAt(0);
                    esriConnect.setMapServiceName(file.getName());
                    continue;
                }
                esriConnect = null;
            }
            return esriConnect;
        }
    }
}

