/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.shareddims.visuals;

import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPLevel;
import com.sas.olapadmin.designer.model.OLAPList;
import com.sas.olapadmin.designer.model.OLAPSharedDimension;
import com.sas.olapadmin.shareddims.visuals.SharedDimDimensionRenameDialog;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.olapadmin.utilities.Utilities;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAdminResource;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class SharedDimDimensionRenamePanel
extends WAPanel {
    private static final long serialVersionUID = 1L;
    protected static WAdminResource bundle = new WAdminResource(SharedDimDimensionRenamePanel.class);
    protected JTextField inp_Name;
    protected JLabel label_Name;
    protected JLabel label_directions;
    protected OLAPSharedDimension dimensionObject;

    public SharedDimDimensionRenamePanel(OLAPSharedDimension inDimensionObject) {
        this.dimensionObject = inDimensionObject;
        this.setLayout(new GridBagLayout());
        this._layoutWidgets();
    }

    public boolean validateData() {
        String newName = this.inp_Name.getText();
        if (newName.length() < 1) {
            MessageUtil.displayMessage((String)bundle.getString("DimDesigner.No.Name.txt"), (int)2);
            return false;
        }
        boolean levelNameIsFound = false;
        OLAPList availableLevels = null;
        try {
            availableLevels = this.dimensionObject.getLevels();
        }
        catch (OLAPException OLAPError) {
            return ExceptionHandler.handleException((Exception)((Object)OLAPError));
        }
        int i = 0;
        int size = availableLevels.size();
        while (i < size & !levelNameIsFound) {
            OLAPLevel level = (OLAPLevel)availableLevels.get(i);
            String levelName = level.getName();
            if (levelName.equalsIgnoreCase(newName)) {
                levelNameIsFound = true;
            }
            ++i;
        }
        if (levelNameIsFound) {
            MessageUtil.displayMessage((String)bundle.getString("SharedDimDesigner.No.Name.txt"), (int)2);
            return false;
        }
        return true;
    }

    public boolean doDataExchange(boolean saveToModel) {
        if (saveToModel) {
            String newName = this.inp_Name.getText();
            SharedDimDimensionRenameDialog parent = (SharedDimDimensionRenameDialog)((Object)this.getTopLevelAncestor());
            parent.setDimensionName(newName);
        }
        return true;
    }

    private void _layoutWidgets() {
        this.label_directions = new JLabel(bundle.getString("SharedDimDesigner.Change.DimensionName.tooltip.txt"));
        this.label_Name = new JLabel();
        Utilities.setLabelTextAndMnemonic((JLabel)this.label_Name, (String)bundle.getString("SharedDimDesigner.General.dimname.txt"));
        this.inp_Name = new JTextField();
        this.inp_Name.setName("sharedDimDimensionNameChange");
        this.label_Name.setName("sharedDimDimensionNameChangeLabel");
        this.inp_Name.setToolTipText(bundle.getString("SharedDimDesigner.Change.DimensionName.tooltip.txt"));
        this.label_Name.setLabelFor(this.inp_Name);
        this.add(this.label_directions, new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 17, 1, new Insets(5, 10, 5, 10), 0, 0));
        this.add(this.label_Name, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 10, 5, 10), 0, 0));
        this.add(this.inp_Name, new GridBagConstraints(1, 1, 2, 1, 1.0, 1.0, 17, 1, new Insets(5, 10, 5, 10), 0, 0));
    }
}

