/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.shareddims.visuals;

import com.sas.metadata.remote.PhysicalTable;
import com.sas.olapadmin.designer.model.DimensionSet;
import com.sas.olapadmin.designer.model.ModelUtilities;
import com.sas.olapadmin.designer.model.OLAPColumn;
import com.sas.olapadmin.designer.model.OLAPDimension;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPLevel;
import com.sas.olapadmin.designer.model.OLAPList;
import com.sas.olapadmin.designer.model.OLAPSharedDimension;
import com.sas.olapadmin.designer.model.SharedDimensionTable;
import com.sas.olapadmin.designer.visuals.DimLevelSuppliedDialog;
import com.sas.olapadmin.designer.visuals.VisualUtilities;
import com.sas.olapadmin.shareddims.visuals.SharedDimDetailLevelTable;
import com.sas.olapadmin.shareddims.visuals.SharedDimLevelDialog;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.wadmin.visuals.ComboButton;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsPopupMenuRequestListener;
import com.sas.workspace.WsTable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;

public class SharedDimDetailLevelPanel
extends WAPropertyTab {
    private static final long serialVersionUID = 1L;
    protected static WAdminResource bundle = new WAdminResource(SharedDimDetailLevelPanel.class);
    private OLAPSharedDimension dimensionModel;
    private SharedDimDetailLevelTable tableModel;
    private WsTable detailsTable;
    private JButton add;
    private ComboButton comboButton;
    private JButton duplicate;
    private JButton delete;
    private boolean initialized;
    private JButton arrowUpButton;
    private JButton arrowDownButton;
    protected WsAbstractAction duplicateAction;
    protected WsAbstractAction deleteAction;
    private DimensionSet dimensionSet;
    private int previousDimensionSortOrder;
    private WAWizardDialog parent;
    private WAPanel buttonPanel;
    private String previousDimensionType;
    private PhysicalTable previousDimensionTable;
    private static final String TIME = "TIME";

    public SharedDimDetailLevelPanel(OLAPSharedDimension inDimensionModel) {
        this.dimensionModel = inDimensionModel;
        this.setLayout(new GridBagLayout());
        this._layoutWidgets();
    }

    public boolean doDataExchange(boolean saveToModel) {
        if (!saveToModel) {
            if (!this.initialized) {
                this.initialize();
            } else {
                try {
                    String dimensionType = this.dimensionModel.getType();
                    PhysicalTable table = this.dimensionModel.getSharedDimensionTable().getTable();
                    if (!this.previousDimensionTable.equals((Object)table)) {
                        this.parent.removeWizardData("ORDEROFLEVELS");
                        this.tableModel.clearTable();
                        this.tableModel.getOrderLevels().clear();
                        this.previousDimensionTable = table;
                    }
                    if (!dimensionType.equalsIgnoreCase(this.previousDimensionType) && this.dimensionModel.isTime()) {
                        this.buttonPanel.remove((Component)this.add);
                        this.buttonPanel.remove((Component)this.duplicate);
                        this.buttonPanel.remove((Component)this.delete);
                        this.buttonPanel.add((Component)this.comboButton, (Object)new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 13, 2, new Insets(5, 5, 0, 5), 0, 0));
                        this.buttonPanel.add((Component)this.duplicate, (Object)new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 13, 2, new Insets(5, 5, 0, 5), 0, 0));
                        this.buttonPanel.add((Component)this.delete, (Object)new GridBagConstraints(3, 0, 1, 1, 1.0, 1.0, 13, 2, new Insets(5, 5, 0, 0), 0, 0));
                    } else if (!dimensionType.equalsIgnoreCase(this.previousDimensionType) && !this.dimensionModel.isTime()) {
                        this.buttonPanel.remove((Component)this.comboButton);
                        this.buttonPanel.remove((Component)this.duplicate);
                        this.buttonPanel.remove((Component)this.delete);
                        this.buttonPanel.add((Component)this.add, (Object)new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 13, 2, new Insets(5, 5, 0, 5), 0, 0));
                        this.buttonPanel.add((Component)this.duplicate, (Object)new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 13, 2, new Insets(5, 5, 0, 5), 0, 0));
                        this.buttonPanel.add((Component)this.delete, (Object)new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 13, 2, new Insets(5, 5, 0, 0), 0, 0));
                    }
                    OLAPList listOfLevels = this.dimensionModel.getLevels();
                    if (listOfLevels.size() < 2) {
                        this.arrowUpButton.setEnabled(false);
                        this.arrowDownButton.setEnabled(false);
                    } else {
                        this.detailsTable.selectCell(0, 0);
                    }
                    int size = listOfLevels.size();
                    for (int i = 0; i < size; ++i) {
                        int levelSortOrder;
                        OLAPLevel levelModel = (OLAPLevel)listOfLevels.get(i);
                        int levelType = levelModel.getType();
                        if (this.dimensionModel.isTime() && levelType == 1) {
                            levelModel.setType(8192);
                        } else if (this.dimensionModel.isStandard() && levelType > 1) {
                            levelModel.setType(1);
                        }
                        int dimensionSortOrder = this.dimensionSet.getDisplaySort(this.dimensionModel.getSortOrder());
                        if (this.previousDimensionSortOrder == dimensionSortOrder || (levelSortOrder = this.dimensionSet.getDisplaySort(levelModel.getSortOrder())) != this.previousDimensionSortOrder) continue;
                        levelModel.setSortOrder(this.dimensionModel.getSortOrder());
                    }
                    this.previousDimensionSortOrder = this.dimensionSet.getDisplaySort(this.dimensionModel.getSortOrder());
                    this.previousDimensionType = dimensionType;
                    this.tableModel.clearTable();
                    this.tableModel.moveDataToModel();
                }
                catch (OLAPException oError) {
                    ExceptionHandler.handleException((Exception)((Object)oError));
                }
            }
        }
        return true;
    }

    protected void initialize() {
        this.initialized = true;
        try {
            PhysicalTable table;
            this.previousDimensionTable = table = this.dimensionModel.getSharedDimensionTable().getTable();
        }
        catch (OLAPException oError) {
            ExceptionHandler.handleException((Exception)((Object)oError));
        }
        this.dimensionSet = this.dimensionModel.getDimensionSet();
        this.duplicateAction = new DuplicateRowAction();
        this.deleteAction = new DeleteRowAction();
        this.tableModel.populateStore();
        this.tableModel.moveDataToModel();
        this.parent = (WAWizardDialog)this.getTopLevelAncestor();
        this.tableModel.setParentDialog(this.parent);
        this.parent.addWizardData("LEVELSDELETED", (Object)"0");
        if (this.tableModel.getRowCount() > 0) {
            this.detailsTable.selectCell(0, 0);
        }
        if (this.tableModel.getRowCount() < 2) {
            this.arrowUpButton.setEnabled(false);
            this.arrowDownButton.setEnabled(false);
        }
        this.previousDimensionSortOrder = this.dimensionSet.getDisplaySort(this.dimensionModel.getSortOrder());
        if (this.dimensionModel.isTime()) {
            this.buttonPanel.add((Component)this.comboButton, (Object)new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 13, 2, new Insets(5, 5, 0, 5), 0, 0));
            this.buttonPanel.add((Component)this.duplicate, (Object)new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 13, 2, new Insets(5, 5, 0, 5), 0, 0));
            this.buttonPanel.add((Component)this.delete, (Object)new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 13, 2, new Insets(5, 5, 0, 0), 0, 0));
        } else {
            this.buttonPanel.add((Component)this.add, (Object)new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 13, 2, new Insets(5, 0, 0, 5), 0, 0));
            this.buttonPanel.add((Component)this.duplicate, (Object)new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 13, 2, new Insets(5, 5, 0, 5), 0, 0));
            this.buttonPanel.add((Component)this.delete, (Object)new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 13, 2, new Insets(5, 5, 0, 0), 0, 0));
        }
        this.previousDimensionType = this.dimensionModel.getType();
    }

    private void _layoutWidgets() {
        JLabel tableTitle = new JLabel(bundle.getString("SharedDimDesigner.LevelDetail.control.label"));
        this.tableModel = new SharedDimDetailLevelTable(this.dimensionModel);
        this.detailsTable = new WsTable((WsAbstractTableModel)this.tableModel);
        this.detailsTable.setName("LevelsDetailTable");
        this.detailsTable.setSortingEnabled(false);
        this.detailsTable.setColumnHidingEnabled(false);
        this.detailsTable.setRowSelectionAllowed(false);
        this.detailsTable.setColumnsReorderable(true);
        this.detailsTable.setRowHoldingEnabled(true);
        this.detailsTable.setColumnHeaderPopupMenuEnabled(true);
        this.detailsTable.setOriginPopupMenuEnabled(true);
        this.detailsTable.setPopupMenuEnabled(true);
        this.detailsTable.setRowHeaderPopupMenuEnabled(true);
        this.detailsTable.setTablePopupMenuEnabled(true);
        this.detailsTable.setViewportPopupMenuEnabled(true);
        this.detailsTable.setPreferredScrollableViewportSize(new Dimension(300, 200));
        this.detailsTable.setAutoResizeMode(0);
        this.detailsTable.getSelectionModel().addListSelectionListener(new RowSelectionListener());
        this.detailsTable.setTablePopupMenuRequestListener((WsPopupMenuRequestListener)new DefaultTablePopupMenuRequestListener());
        this.detailsTable.getRowHeader().setWidth(30);
        JScrollPane topPanel = new JScrollPane((Component)this.detailsTable);
        this.add = new JButton();
        this.add.setName("LevelAdd");
        this.add.setToolTipText(bundle.getString("SharedDimDesigner.AddSupplied.action.label.tip"));
        VisualUtilities.setButtonTextAndMnemonic(this.add, bundle.getString("SharedDimDesigner.AddSupplied.action.label.txt"));
        this.add.addActionListener(new AddListener());
        this.duplicate = new JButton();
        this.duplicate.setName("LevelDuplicate");
        this.duplicate.setToolTipText(bundle.getString("SharedDimDesigner.Duplicate.action.label.tip"));
        this.duplicate.addActionListener(new DuplicateListener());
        VisualUtilities.setButtonTextAndMnemonic(this.duplicate, bundle.getString("SharedDimDesigner.Duplicate.action.label.txt"));
        this.delete = new JButton();
        this.delete.setName("LevelDelete");
        this.delete.addActionListener(new DeleteListener());
        this.delete.setToolTipText(bundle.getString("SharedDimDesigner.Delete.action.label.tip"));
        VisualUtilities.setButtonTextAndMnemonic(this.delete, bundle.getString("SharedDimDesigner.Delete.action.label.txt"));
        ImageIcon arrowDown = bundle.getImageIcon("Common.DownArrow.image");
        this.arrowDownButton = new JButton(arrowDown);
        this.arrowDownButton.setName("ArrowDown");
        this.arrowDownButton.setToolTipText(bundle.getString("SharedDimDesigner.DownArrow.tip"));
        this.arrowDownButton.addActionListener(new DownArrowListener());
        this.arrowDownButton.setPreferredSize(new Dimension(25, 25));
        ImageIcon arrowUp = bundle.getImageIcon("Common.UpArrow.image");
        this.arrowUpButton = new JButton(arrowUp);
        this.arrowUpButton.setName("ArrowUp");
        this.arrowUpButton.setToolTipText(bundle.getString("SharedDimDesigner.UpArrow.tip"));
        this.arrowUpButton.addActionListener(new UpArrowListener());
        this.arrowUpButton.setPreferredSize(new Dimension(25, 25));
        WAPanel imagePanel = new WAPanel();
        imagePanel.setLayout((LayoutManager)new GridBagLayout());
        imagePanel.add((Component)this.arrowUpButton, (Object)new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 0, 0, 0), 0, 0));
        imagePanel.add((Component)this.arrowDownButton, (Object)new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.add(tableTitle, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 0), 0, 0));
        this.add(topPanel, new GridBagConstraints(0, 1, 6, 3, 1.0, 1.0, 17, 1, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)imagePanel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
        this.buttonPanel = new WAPanel();
        this.buttonPanel.setLayout((LayoutManager)new GridBagLayout());
        ArrayList<WsAbstractAction> listOfActions = new ArrayList<WsAbstractAction>();
        listOfActions.add(new AddAction());
        listOfActions.add(new SuppliedAction());
        this.comboButton = new ComboButton((Action)((Object)new AddAction(true)), listOfActions);
        JButton combo1 = (JButton)this.comboButton.getComponent(1);
        combo1.setToolTipText(null);
        this.add((Component)this.buttonPanel, new GridBagConstraints(3, 4, 3, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 0), 0, 0));
    }

    public void onBack() {
        int i;
        this.parent = (WAWizardDialog)this.getTopLevelAncestor();
        int howManyLevels = this.tableModel.getRowCount();
        int[] orderLevelsToView = new int[howManyLevels];
        ArrayList<OLAPLevel> orderofLevels = new ArrayList<OLAPLevel>();
        for (i = 0; i < howManyLevels; ++i) {
            orderLevelsToView[i] = i;
            orderofLevels.add(null);
        }
        this.detailsTable.convertRowIndexesToView(orderLevelsToView);
        for (i = 0; i < howManyLevels; ++i) {
            int order = orderLevelsToView[i];
            String levelName = (String)this.tableModel.getValueAt(i, 0);
            OLAPLevel level = (OLAPLevel)this.tableModel.getLevelsByName().get(levelName);
            orderofLevels.remove(order);
            orderofLevels.add(order, level);
        }
        this.parent.addWizardData("ORDEROFLEVELS", orderofLevels);
        this.tableModel.setOrderLevels(orderofLevels);
        TableCellEditor ce = this.detailsTable.getCellEditor();
        if (ce != null) {
            ce.stopCellEditing();
        }
    }

    public void onNext() {
        TableCellEditor ce = this.detailsTable.getCellEditor();
        if (ce != null) {
            ce.stopCellEditing();
        }
    }

    public boolean validateData() {
        try {
            OLAPList levels = this.dimensionModel.getLevels();
            boolean timeDimension = this.dimensionModel.isTime();
            if (levels.size() == 0) {
                MessageUtil.displayMessage((String)bundle.getString("DimDesigner.NoLevelsDefined.txt"), (int)1);
                return false;
            }
            int size = levels.size();
            for (int i = 0; i < size; ++i) {
                OLAPLevel level = (OLAPLevel)levels.get(i);
                if (timeDimension && level.getType() == 8192) {
                    MessageUtil.displayMessage((String)bundle.getString("SharedDimDesigner.DetailLevel.MustHaveTimeTypes.txt"), (int)1);
                    return false;
                }
                this.dimensionModel.verifyLevelNameUnique(level);
            }
            OLAPList hierarchies = this.dimensionModel.getHierarchies();
            if (hierarchies.isEmpty() || hierarchies.size() == 1) {
                this.parent = (WAWizardDialog)this.getTopLevelAncestor();
                int howManyLevels = this.tableModel.getRowCount();
                if (howManyLevels != 0) {
                    int i;
                    int[] orderLevelsToView = new int[howManyLevels];
                    ArrayList<OLAPLevel> orderofLevels = new ArrayList<OLAPLevel>(howManyLevels - 1);
                    for (i = 0; i < howManyLevels; ++i) {
                        orderLevelsToView[i] = i;
                        orderofLevels.add(null);
                    }
                    this.detailsTable.convertRowIndexesToView(orderLevelsToView);
                    for (i = 0; i < howManyLevels; ++i) {
                        int order = orderLevelsToView[i];
                        String levelName = (String)this.tableModel.getValueAt(i, 0);
                        OLAPLevel level = (OLAPLevel)this.tableModel.getLevelsByName().get(levelName);
                        orderofLevels.remove(order);
                        orderofLevels.add(order, level);
                    }
                    this.parent.addWizardData("ORDEROFLEVELS", orderofLevels);
                }
            }
        }
        catch (OLAPException oError) {
            ExceptionHandler.handleException((Exception)((Object)oError));
            return false;
        }
        return true;
    }

    private boolean isFormatDates(String format) {
        boolean found = false;
        if (!ModelUtilities.isBlank((String)format)) {
            int size = ModelUtilities.dateCheck.size();
            for (int i = 0; i < size && !found; ++i) {
                String nextFormat = (String)ModelUtilities.dateCheck.get(i);
                if (format.indexOf(nextFormat) <= -1 || format.indexOf("DATETIME") >= 0 || format.indexOf("DTDATE") >= 0 || format.indexOf("DATEAMPM") >= 0 || format.indexOf("datetime") >= 0 || format.indexOf("dtdate") >= 0 || format.indexOf("dateampm") >= 0) continue;
                found = true;
            }
        }
        return found;
    }

    public JPopupMenu createTablePopupMenu() {
        JPopupMenu mnuPopup = new JPopupMenu();
        mnuPopup.add((Action)this.duplicateAction);
        mnuPopup.add((Action)this.deleteAction);
        return mnuPopup;
    }

    protected class DuplicateRowAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public DuplicateRowAction() {
            super(bundle, "SharedDimDesigner.Duplicate.action.label", 0);
        }

        public void actionPerformed(ActionEvent e) {
            SharedDimDetailLevelPanel.this.duplicate.doClick();
        }
    }

    protected class DeleteRowAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public DeleteRowAction() {
            super(bundle, "SharedDimDesigner.Delete.action.label", 0);
        }

        public void actionPerformed(ActionEvent e) {
            SharedDimDetailLevelPanel.this.delete.doClick();
        }
    }

    class RowSelectionListener
    implements ListSelectionListener,
    WsPopupMenuRequestListener {
        RowSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            ListSelectionModel selectionModel = (ListSelectionModel)e.getSource();
            if (selectionModel.isSelectionEmpty()) {
                SharedDimDetailLevelPanel.this.delete.setEnabled(false);
                SharedDimDetailLevelPanel.this.duplicate.setEnabled(false);
                SharedDimDetailLevelPanel.this.arrowUpButton.setEnabled(false);
                SharedDimDetailLevelPanel.this.arrowDownButton.setEnabled(false);
            } else {
                int[] selectedRows = SharedDimDetailLevelPanel.this.detailsTable.getSelectedRowsFromSelectedCells();
                if (selectedRows.length > 1) {
                    SharedDimDetailLevelPanel.this.duplicate.setEnabled(false);
                    SharedDimDetailLevelPanel.this.delete.setEnabled(true);
                    SharedDimDetailLevelPanel.this.arrowUpButton.setEnabled(false);
                    SharedDimDetailLevelPanel.this.arrowDownButton.setEnabled(false);
                } else {
                    SharedDimDetailLevelPanel.this.duplicate.setEnabled(true);
                    SharedDimDetailLevelPanel.this.delete.setEnabled(true);
                    int selected = selectedRows[0];
                    int totalRows = SharedDimDetailLevelPanel.this.tableModel.getRowCount();
                    if (selected == 0 && totalRows > 1) {
                        SharedDimDetailLevelPanel.this.arrowUpButton.setEnabled(false);
                        SharedDimDetailLevelPanel.this.arrowDownButton.setEnabled(true);
                    } else if (selected == 0 && totalRows == 1) {
                        SharedDimDetailLevelPanel.this.arrowUpButton.setEnabled(false);
                        SharedDimDetailLevelPanel.this.arrowDownButton.setEnabled(false);
                    } else if (selected == totalRows - 1) {
                        SharedDimDetailLevelPanel.this.arrowUpButton.setEnabled(true);
                        SharedDimDetailLevelPanel.this.arrowDownButton.setEnabled(false);
                    } else {
                        SharedDimDetailLevelPanel.this.arrowUpButton.setEnabled(true);
                        SharedDimDetailLevelPanel.this.arrowDownButton.setEnabled(true);
                    }
                }
            }
        }

        public void popupMenuRequested(MouseEvent e) {
            JPopupMenu mnuPopup = SharedDimDetailLevelPanel.this.createTablePopupMenu();
            mnuPopup.show((Component)e.getSource(), e.getX(), e.getY());
        }
    }

    protected class DefaultTablePopupMenuRequestListener
    implements WsPopupMenuRequestListener {
        protected DefaultTablePopupMenuRequestListener() {
        }

        public void popupMenuRequested(MouseEvent e) {
            JPopupMenu mnuPopup = SharedDimDetailLevelPanel.this.createTablePopupMenu();
            mnuPopup.show((Component)e.getSource(), e.getX(), e.getY());
        }
    }

    private class AddListener
    implements ActionListener {
        private AddListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            SharedDimLevelDialog addDialog = new SharedDimLevelDialog(Workspace.getWorkspace(), bundle.getString("SharedDimLevel.window.title"), SharedDimDetailLevelPanel.this.dimensionModel);
            addDialog.show();
            SharedDimDetailLevelPanel.this.tableModel.moveDataToModel();
            int start = SharedDimDetailLevelPanel.this.tableModel.getStartSelected();
            int stop = SharedDimDetailLevelPanel.this.tableModel.getStopSelected();
            int[] selectThese = new int[stop - start];
            int size = stop - start;
            for (int i = 0; i < size; ++i) {
                selectThese[i] = start++;
            }
            SharedDimDetailLevelPanel.this.detailsTable.selectRows(selectThese);
            if (SharedDimDetailLevelPanel.this.tableModel.getRowCount() < 2 || selectThese.length != 1) {
                SharedDimDetailLevelPanel.this.arrowUpButton.setEnabled(false);
                SharedDimDetailLevelPanel.this.arrowDownButton.setEnabled(false);
            } else {
                SharedDimDetailLevelPanel.this.arrowUpButton.setEnabled(true);
                SharedDimDetailLevelPanel.this.arrowDownButton.setEnabled(true);
            }
        }
    }

    private class DuplicateListener
    implements ActionListener {
        private DuplicateListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            try {
                int[] selectedRows = SharedDimDetailLevelPanel.this.detailsTable.getSelectedRowsFromSelectedCells();
                SharedDimDetailLevelPanel.this.detailsTable.convertRowIndexesToModel(selectedRows);
                if (selectedRows.length > 0) {
                    int selectedRow = selectedRows[0];
                    List rowContents = SharedDimDetailLevelPanel.this.tableModel.getRowValues(selectedRow);
                    SharedDimDetailLevelPanel.this.tableModel.duplicateRow(rowContents, selectedRow);
                    SharedDimDetailLevelPanel.this.detailsTable.selectRow(selectedRow + 1);
                }
            }
            catch (OLAPException oError) {
                ExceptionHandler.handleException((Exception)((Object)oError));
            }
        }
    }

    private class DeleteListener
    implements ActionListener {
        private DeleteListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            try {
                int[] selectedRows = SharedDimDetailLevelPanel.this.detailsTable.getSelectedRowsFromSelectedCells();
                SharedDimDetailLevelPanel.this.detailsTable.convertRowIndexesToModel(selectedRows);
                TableCellEditor cellEditor = SharedDimDetailLevelPanel.this.detailsTable.getCellEditor();
                if (cellEditor != null) {
                    cellEditor.cancelCellEditing();
                }
                int choice = 0;
                if (selectedRows.length == 1) {
                    int row = selectedRows[0];
                    String levelName = (String)SharedDimDetailLevelPanel.this.tableModel.getValueAt(row, 0);
                    choice = MessageUtil.displayMessage((String)bundle.formatString("SharedDimDesigner.Delete.Message.fmt.txt", (Object)levelName), (String)bundle.getString("SharedDimDesigner.DeleteLevel.window.title"), (int)1, (int)0);
                } else {
                    choice = MessageUtil.displayMessage((String)bundle.getString("SharedDimDesigner.DeleteLevels.txt"), (String)bundle.getString("SharedDimDesigner.DeleteLevels.window.title"), (int)1, (int)0);
                }
                if (choice == 0) {
                    ArrayList<OLAPLevel> deletedLevels = new ArrayList<OLAPLevel>();
                    Map levelsByName = SharedDimDetailLevelPanel.this.tableModel.getLevelsByName();
                    OLAPLevel levelObject = null;
                    for (int i = selectedRows.length - 1; i >= 0; --i) {
                        levelObject = (OLAPLevel)SharedDimDetailLevelPanel.this.tableModel.getValueAt(selectedRows[i], 8);
                        deletedLevels.add(levelObject);
                    }
                    int size = deletedLevels.size();
                    for (int t = 0; t < size; ++t) {
                        levelObject = (OLAPLevel)deletedLevels.get(t);
                        if (levelObject != null) {
                            levelObject.delete();
                            levelsByName.remove(levelObject.getName());
                            SharedDimDetailLevelPanel.this.parent.addWizardData("LEVELSCHANGED", (Object)"1");
                        }
                        SharedDimDetailLevelTable sharedDimDetailLevelTable = SharedDimDetailLevelPanel.this.tableModel;
                        SharedDimDetailLevelPanel.this.tableModel;
                        int[] rowNumber = sharedDimDetailLevelTable.findRows(8, levelObject);
                        if (rowNumber.length <= 0) continue;
                        SharedDimDetailLevelPanel.this.tableModel.deleteRow(rowNumber[0]);
                    }
                    SharedDimDetailLevelPanel.this.arrowUpButton.setEnabled(false);
                    SharedDimDetailLevelPanel.this.arrowDownButton.setEnabled(false);
                }
            }
            catch (OLAPException oError) {
                ExceptionHandler.handleException((Exception)((Object)oError));
            }
        }
    }

    private class DownArrowListener
    implements ActionListener {
        private DownArrowListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            int[] selectedRows = SharedDimDetailLevelPanel.this.detailsTable.getSelectedRowsFromSelectedCells();
            int selected = selectedRows[0];
            if (selectedRows.length == 1) {
                SharedDimDetailLevelPanel.this.detailsTable.moveRow(selected, selected + 1);
            }
            SharedDimDetailLevelPanel.this.parent.addWizardData("LEVELSCHANGED", (Object)"1");
        }
    }

    private class UpArrowListener
    implements ActionListener {
        private UpArrowListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            int[] selectedRows = SharedDimDetailLevelPanel.this.detailsTable.getSelectedRowsFromSelectedCells();
            int selected = selectedRows[0];
            if (selectedRows.length == 1) {
                SharedDimDetailLevelPanel.this.detailsTable.moveRow(selected, selected - 1);
            }
            SharedDimDetailLevelPanel.this.parent.addWizardData("LEVELSCHANGED", (Object)"1");
        }
    }

    protected class AddAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public AddAction() {
            super(bundle, "SharedDimDesigner.DropDownMenuAdd.action.longLabel", 256);
        }

        public AddAction(boolean isDefault) {
            super(bundle, "SharedDimDesigner.AddSupplied.action.label", 0);
        }

        public void actionPerformed(ActionEvent e) {
            SharedDimLevelDialog addDialog = new SharedDimLevelDialog(Workspace.getWorkspace(), bundle.getString("SharedDimLevel.window.title"), SharedDimDetailLevelPanel.this.dimensionModel);
            addDialog.setResizable(true);
            addDialog.show();
            SharedDimDetailLevelPanel.this.tableModel.moveDataToModel();
            int start = SharedDimDetailLevelPanel.this.tableModel.getStartSelected();
            int stop = SharedDimDetailLevelPanel.this.tableModel.getStopSelected();
            int[] selectThese = new int[stop - start];
            int size = stop - start;
            for (int i = 0; i < size; ++i) {
                selectThese[i] = start++;
            }
            SharedDimDetailLevelPanel.this.detailsTable.selectRows(selectThese);
            if (SharedDimDetailLevelPanel.this.tableModel.getRowCount() < 2 || selectThese.length != 1) {
                SharedDimDetailLevelPanel.this.arrowUpButton.setEnabled(false);
                SharedDimDetailLevelPanel.this.arrowDownButton.setEnabled(false);
            } else {
                SharedDimDetailLevelPanel.this.arrowUpButton.setEnabled(true);
                SharedDimDetailLevelPanel.this.arrowDownButton.setEnabled(true);
            }
        }
    }

    protected class SuppliedAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public SuppliedAction() {
            super(bundle, "SharedDimLevel.DropDownMenuSupplied.action.longlabel", 256);
        }

        public void actionPerformed(ActionEvent event) {
            try {
                ArrayList<OLAPColumn> mostLikely = new ArrayList<OLAPColumn>();
                SharedDimensionTable inputTable = SharedDimDetailLevelPanel.this.dimensionModel.getSharedDimensionTable();
                List numericColumns = inputTable.getAllNumericColumns();
                int size = numericColumns.size();
                for (int i = 0; i < size; ++i) {
                    OLAPColumn nextColumn = (OLAPColumn)numericColumns.get(i);
                    if (!SharedDimDetailLevelPanel.this.isFormatDates(nextColumn.getSASFormat())) continue;
                    mostLikely.add(nextColumn);
                }
                if (mostLikely.isEmpty()) {
                    MessageUtil.displayMessage((String)bundle.formatString("SharedDimDesigner.DetailLevel.NoDataColumns.fmt.txt", (Object)SharedDimDetailLevelPanel.this.dimensionModel.getName()), (int)1);
                    return;
                }
                DimLevelSuppliedDialog suppliedDialog = new DimLevelSuppliedDialog(Workspace.getWorkspace(), bundle.getString("SharedDimLevelSupplied.window.title"), (OLAPDimension)SharedDimDetailLevelPanel.this.dimensionModel, mostLikely);
                suppliedDialog.setResizable(true);
                suppliedDialog.show();
                SharedDimDetailLevelPanel.this.tableModel.moveDataToModel();
                int start = SharedDimDetailLevelPanel.this.tableModel.getStartSelected();
                int stop = SharedDimDetailLevelPanel.this.tableModel.getStopSelected();
                int[] selectThese = new int[stop - start];
                int size2 = stop - start;
                for (int i = 0; i < size2; ++i) {
                    selectThese[i] = start++;
                }
                SharedDimDetailLevelPanel.this.detailsTable.selectRows(selectThese);
                if (SharedDimDetailLevelPanel.this.tableModel.getRowCount() < 2 || selectThese.length != 1) {
                    SharedDimDetailLevelPanel.this.arrowUpButton.setEnabled(false);
                    SharedDimDetailLevelPanel.this.arrowDownButton.setEnabled(false);
                } else {
                    SharedDimDetailLevelPanel.this.arrowUpButton.setEnabled(true);
                    SharedDimDetailLevelPanel.this.arrowDownButton.setEnabled(true);
                }
            }
            catch (OLAPException oError) {
                ExceptionHandler.handleException((Exception)((Object)oError));
            }
        }
    }
}

