/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.shareddims.visuals;

import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdFactoryEvent;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.OLAPSchema;
import com.sas.metadata.remote.Tree;
import com.sas.olapadmin.designer.model.AbstractOLAPModel;
import com.sas.olapadmin.designer.model.ModelUtilities;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPList;
import com.sas.olapadmin.designer.model.OLAPSharedDimension;
import com.sas.olapadmin.designer.model.SharedDimensionTable;
import com.sas.olapadmin.designer.visuals.VisualUtilities;
import com.sas.olapadmin.shareddims.visuals.SharedDimDetailLevelTab;
import com.sas.olapadmin.shareddims.visuals.SharedDimFinishButtonDialog;
import com.sas.olapadmin.shareddims.visuals.SharedDimFinishTab;
import com.sas.olapadmin.shareddims.visuals.SharedDimGeneralTab;
import com.sas.olapadmin.shareddims.visuals.SharedDimHierTab;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.olapadmin.utilities.Utilities;
import com.sas.olapadmin.utilities.WsRunCode;
import com.sas.olapadmin.utilities.studio.CubeSaveProcOlapDialog;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.OpRequestUI;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WARootPane;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WizardTabInfo;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsButtonsLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class SharedDimDesigner
extends WAWizardDialog {
    private static final long serialVersionUID = 1L;
    protected static WAdminResource bundle = new WAdminResource(SharedDimDesigner.class);
    private static final String GENERAL = "GENERAL";
    private static final String LEVELS = "LEVELS";
    private static final String HIERARCHY = "HIERARCHY";
    private OLAPSharedDimension dimensionModel;
    private JButton exportCode;
    private WsAppServer server;
    private WsRunCode wsRunCode;

    public SharedDimDesigner(Frame frame, String title) {
        super(frame, title, true);
        MdObjectStore MdOS = (MdObjectStore)this.getWizardData("OBJECTSTORE");
        this.setCanFinishEarly(true);
        try {
            this.dimensionModel = new OLAPSharedDimension(MdOS);
        }
        catch (OLAPException e) {
            this.dimensionModel = null;
        }
        if (this.dimensionModel != null) {
            this.SetUpSharedDimDesigner();
        }
    }

    public SharedDimDesigner(Frame frame, String title, OLAPSharedDimension inputDimensionModel) {
        super(frame, title, true);
        this.setCanFinishEarly(true);
        this.dimensionModel = inputDimensionModel;
        this.SetUpSharedDimDesigner();
    }

    private void SetUpSharedDimDesigner() {
        ImageIcon image = bundle.getImageIcon("SharedDimDesigner.General.image");
        ImageIcon image2 = bundle.getImageIcon("SharedDimDesigner.LevelDetail.image");
        ImageIcon image3 = bundle.getImageIcon("SharedDimDesigner.Hierarchy.image");
        ImageIcon image5 = bundle.getImageIcon("SharedDimDesigner.Finish.image");
        String imagename = bundle.getString("SharedDimDesigner.General.image");
        String imagename2 = bundle.getString("SharedDimDesigner.LevelDetail.image");
        String imagename3 = bundle.getString("SharedDimDesigner.Hierarchy.image");
        String finish = bundle.getString("SharedDimDesigner.Finish.image");
        this.addTab(bundle.getString("SharedDimDesigner.General.window.title"), GENERAL, (WAPropertyTab)new SharedDimGeneralTab(this.dimensionModel), imagename, image, true);
        this.addTab(bundle.getString("SharedDimDesigner.DetailLevel.window.title"), LEVELS, (WAPropertyTab)new SharedDimDetailLevelTab(this.dimensionModel), imagename2, image2, true);
        this.addTab(bundle.getString("SharedDimDesigner.Hierarchypanel.window.title"), HIERARCHY, (WAPropertyTab)new SharedDimHierTab(this.dimensionModel), imagename3, image3, true);
        this.addTab(bundle.getString("SharedDimFinish.finish.window.title"), "tab5", (WAPropertyTab)new SharedDimFinishTab(), finish, image5, true);
    }

    protected void initialize() {
        super.initialize();
        this.m_btnFinish = new JButton();
        this.m_btnBack = new JButton();
        this.exportCode = new JButton();
        this.m_btnNext = new JButton();
        Utilities.setButtonTextAndMnemonic((AbstractButton)this.exportCode, (String)bundle.getString("Common.ExportCode.control.label"));
        Utilities.setButtonTextAndMnemonic((AbstractButton)this.m_btnBack, (String)bundle.getString("Common.Back.control.label"));
        Utilities.setButtonTextAndMnemonic((AbstractButton)this.m_btnNext, (String)bundle.getString("Common.Next.control.label"));
        Utilities.setButtonTextAndMnemonic((AbstractButton)this.m_btnFinish, (String)bundle.getString("Common.Finish.control.label"));
        this.m_btnBack.addActionListener((ActionListener)((Object)this));
        this.m_btnNext.addActionListener((ActionListener)((Object)this));
        this.m_btnFinish.addActionListener((ActionListener)((Object)this));
        this.exportCode.addActionListener(new SaveButtonListener());
    }

    protected boolean onCancel() {
        boolean cancelOK = true;
        if (WAStandardDialog.isUserPreferenceToShowTheDiscardChangesMessage()) {
            Workspace workspace = Workspace.getWorkspace();
            JCheckBox checkbox = new JCheckBox();
            VisualUtilities.setButtonTextAndMnemonic(checkbox, bundle.getString("Common.ShowMessage.checkbox.label"));
            String message = new String(bundle.getString("SharedDimDesigner.Common.DiscardChanges.txt"));
            Object[] allObjects = new Object[]{message, " ", checkbox};
            String titleMessage = bundle.getString("SharedDimDesigner.Common.DiscardChanges.window.title");
            int optionSelected = JOptionPane.showConfirmDialog((Component)workspace, allObjects, titleMessage, 2, 2);
            WAStandardDialog.setUserPreferenceToShowTheDiscardChangesMessage((!checkbox.isSelected() ? 1 : 0) != 0);
            cancelOK = optionSelected == 0 ? super.onCancel() : false;
        } else {
            cancelOK = super.onCancel();
        }
        return cancelOK;
    }

    protected boolean onFinish() {
        Workspace m_workspace = Workspace.getWorkspace();
        boolean okFinish = true;
        WizardTabInfo currentPanel = this.m_WizardModel.getCurrent();
        okFinish = currentPanel.getTab().validateData();
        if (okFinish) {
            while (this.m_WizardModel.hasNext() && okFinish) {
                this.m_WizardModel.next();
                WizardTabInfo nextPanel = this.m_WizardModel.getCurrent();
                okFinish = nextPanel.getTab().validateData();
            }
        }
        if (okFinish) {
            SharedDimFinishButtonDialog finishDialog = new SharedDimFinishButtonDialog(m_workspace, bundle.getString("SharedDimFinish.finish.window.title"), this.dimensionModel);
            finishDialog.show();
            if (finishDialog.getReturnValue() == 1) {
                super.onFinish();
                boolean buildCube = finishDialog.isBuildSelected();
                boolean okToGo = this.runCode(buildCube);
                if (okToGo) {
                    return true;
                }
            } else {
                while (this.m_WizardModel.hasPrev() && !this.m_WizardModel.getCurrent().equals(currentPanel)) {
                    this.m_WizardModel.prev();
                }
            }
        } else {
            while (this.m_WizardModel.hasPrev() && !this.m_WizardModel.getCurrent().equals(currentPanel)) {
                this.m_WizardModel.prev();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean runCode(boolean buildCube) {
        String str1 = bundle.getString("WriteMetadataProgressIndicator.Msg.Title.txt");
        String str2 = bundle.getString("WriteMetadataProgressIndicator.Msg.Message.txt");
        boolean doUpdate = true;
        boolean doCreate = true;
        boolean continueCleanUp = false;
        boolean mustDelete = this.dimensionModel.physicallyExists();
        try {
            if (buildCube | mustDelete) {
                this.server = WsRunCode.getServer();
                if (this.server != null) {
                    this.wsRunCode = new WsRunCode(this.server);
                    if (this.wsRunCode.hasSubmitError) {
                        boolean bl = false;
                        return bl;
                    }
                } else {
                    if (mustDelete) {
                        MessageUtil.displayMessage((String)bundle.getString("SharedDimDesigner.Finish.ServerRequired.txt"));
                    } else {
                        MessageUtil.displayMessage((String)bundle.getString("SharedDimDesigner.Finish.ServerOptional.txt"));
                    }
                    boolean bl = false;
                    return bl;
                }
            }
            if (mustDelete && this.server != null) {
                str1 = bundle.getString("DeleteDimProgressIndicator.Msg.Title.txt");
                str2 = bundle.getString("DeleteDimProgressIndicator.Msg.Message.txt");
                this.wsRunCode.showLogMessagesInDetails(true);
                boolean submitError = this.wsRunCode.executeCode(this.dimensionModel.generateCodeDeletePhysical(false), str2, str1);
                if (submitError) {
                    doUpdate = false;
                    doCreate = false;
                    boolean bl = false;
                    return bl;
                }
            } else if (mustDelete && this.server == null) {
                MessageUtil.displayMessage((String)bundle.getString("SharedDimDesigner.Finish.NoEdit.txt"));
                doUpdate = false;
                doCreate = false;
                boolean submitError = false;
                return submitError;
            }
            if (doUpdate) {
                str1 = bundle.getString("WriteMetadataProgressIndicator.Msg.Title.txt");
                str2 = bundle.getString("WriteMetadataProgressIndicator.Msg.Message.txt");
                UpdateMetadata updateMetadata = new UpdateMetadata(this.dimensionModel);
                OpRequestUI request = new OpRequestUI((Frame)Workspace.getWorkspace(), str2, str1);
                request.setProgressShownOnStatusBar(false);
                request.execute((Runnable)updateMetadata);
                doCreate = updateMetadata.getReturnValue();
            }
            if (doCreate && buildCube && this.server != null) {
                String message = bundle.getString("CreateSharedDimProgressIndicator.Msg.Message.txt");
                String title = bundle.getString("CreateSharedDimProgressIndicator.Msg.window.title");
                this.wsRunCode.showLogMessagesInDetails(false);
                this.wsRunCode.executeCode(this.dimensionModel.generateCodeCreate(), message, title);
            } else if (doCreate && buildCube && this.server == null) {
                MessageUtil.displayMessage((String)bundle.getString("SharedDimDesigner.Finish.NoCreate.txt"));
                boolean message = false;
                return message;
            }
            continueCleanUp = true;
            MdFactory factory = Workspace.getWorkspace().getMdObjectFactory();
            HashMap<String, String> map = new HashMap<String, String>(1);
            map.put(this.dimensionModel.getFQID(), "SharedDimension");
            try {
                Workspace.getMdFactory().fireMdObjectsModified(new MdFactoryEvent(factory, map));
            }
            catch (RemoteException e) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), (Throwable)e, 12);
            }
        }
        catch (OLAPException error) {
            ExceptionHandler.handleException((Exception)((Object)error));
        }
        finally {
            if (continueCleanUp) {
                this.cleanup();
            }
        }
        return true;
    }

    private void cleanup() {
        MdObjectStore objectStore = (MdObjectStore)this.getWizardData("OBJECTSTORE");
        if (objectStore != null) {
            try {
                objectStore.dispose();
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        objectStore = null;
        this.addWizardData("OBJECTSTORE", null);
        if (this.server != null) {
            this.wsRunCode.term();
        }
        this.server = null;
    }

    public void setFinishExportEnabled(boolean isEnabled) {
        this.m_btnFinish.setEnabled(isEnabled);
        this.exportCode.setEnabled(isEnabled);
    }

    protected void updateButtonsPanel() {
        if (SharedDimDesigner.isUsingNewStyle()) {
            this.m_pnlButtons.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        }
        this.m_pnlButtons.removeAll();
        JPanel subPanel2 = new JPanel((LayoutManager)new WsButtonsLayout());
        subPanel2.add(this.exportCode);
        JPanel subPanel1 = new JPanel(new cWizardButtonsPaneLayout());
        this.m_pnlButtons.setLayout(new BorderLayout());
        subPanel1.add(this.m_btnHelp);
        subPanel1.add(this.m_btnCancel);
        subPanel1.add(this.m_btnBack);
        subPanel1.add(this.m_btnNext);
        subPanel1.add(this.m_btnFinish);
        this.m_pnlButtons.add((Component)subPanel2, "West");
        this.m_pnlButtons.add((Component)subPanel1, "East");
        this.updateNavigationButtons();
    }

    protected void updateNavigationButtons() {
        try {
            this.m_btnBack.setEnabled(this.m_WizardModel.hasPrev());
            this.m_btnNext.setEnabled(this.m_WizardModel.hasNext());
            this.m_btnFinish.setEnabled(false);
            this.exportCode.setEnabled(false);
            if (this.dimensionModel.isNewObject()) {
                WizardTabInfo currentPanel = this.m_WizardModel.getCurrent();
                String panelName = currentPanel.getTabName();
                if (!panelName.equals(GENERAL) && !panelName.equals(LEVELS)) {
                    this.m_btnFinish.setEnabled(true);
                    this.exportCode.setEnabled(true);
                }
            } else {
                SharedDimensionTable table = this.dimensionModel.getSharedDimensionTable();
                OLAPList levelsList = this.dimensionModel.getLevels();
                OLAPList hierList = this.dimensionModel.getHierarchies();
                if (table != null && !levelsList.isEmpty() && !hierList.isEmpty()) {
                    this.m_btnFinish.setEnabled(true);
                    this.exportCode.setEnabled(true);
                }
            }
            if (!this.m_btnNext.isEnabled()) {
                ((WARootPane)this.getRootPane()).setRealDefaultButton(this.m_btnFinish);
            } else {
                ((WARootPane)this.getRootPane()).setRealDefaultButton(this.m_btnNext);
            }
            Component cmp = this.getDefaultFocusComponent();
            if (cmp != null) {
                cmp.requestFocus();
            }
        }
        catch (OLAPException oError) {
            ExceptionHandler.handleException((Exception)((Object)oError));
        }
    }

    private final class SaveButtonListener
    implements ActionListener {
        private SaveButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Workspace m_workspace = Workspace.getWorkspace();
            WizardTabInfo currentPanel = SharedDimDesigner.this.m_WizardModel.getCurrent();
            boolean canExportcode = currentPanel.getTab().validateData();
            if (canExportcode) {
                CubeSaveProcOlapDialog saveProcDialog = new CubeSaveProcOlapDialog(m_workspace, bundle.getString("SaveProcCode.window.title"), (AbstractOLAPModel)SharedDimDesigner.this.dimensionModel);
                saveProcDialog.show();
            }
        }
    }

    class UpdateMetadata
    implements Runnable {
        OLAPSharedDimension dimensionModel;
        public boolean returnValue = true;

        public UpdateMetadata(OLAPSharedDimension dimensionModel) {
            this.dimensionModel = dimensionModel;
        }

        private void updateDimensionPaths() throws OLAPException {
            Vector dimPaths = VisualUtilities.getSharedDimPaths();
            String dimPath = this.dimensionModel.getPath();
            dimPaths.remove(dimPath);
            dimPaths.add(0, dimPath);
            VisualUtilities.setSharedDimPaths();
        }

        private void updateDefaultOLAPSchema() throws OLAPException {
            ModelUtilities.setDefaultOLAPSchema((OLAPSchema)this.dimensionModel.getAssociatedOLAPSchema());
        }

        private void updateDefaultFolder() throws OLAPException {
            ModelUtilities.setDefaultFolder((Tree)this.dimensionModel.getFolder());
        }

        @Override
        public void run() {
            try {
                this.dimensionModel.updateMetadata();
                this.returnValue = this.dimensionModel.getUpdateMetadataStatus();
                this.updateDimensionPaths();
                this.updateDefaultOLAPSchema();
                this.updateDefaultFolder();
            }
            catch (OLAPException OLAPError) {
                this.returnValue = ExceptionHandler.handleException((Exception)((Object)OLAPError));
            }
        }

        public boolean getReturnValue() {
            return this.returnValue;
        }
    }

    protected class cWizardButtonsPaneLayout
    implements LayoutManager {
        protected static final int cxSmallButtonGap = 7;
        protected static final int cxLargeButtonGap = 20;
        protected static final int cxTotalButtonGap = 67;
        private static final int wTinyButtonGap = 1;
        private static final int wLargeButtonGap = 12;
        private static final int wSmallButtonGap = 5;

        protected cWizardButtonsPaneLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component c) {
        }

        @Override
        public void removeLayoutComponent(Component c) {
        }

        @Override
        public Dimension preferredLayoutSize(Container c) {
            int wTotalButtonGap = 67;
            int nButtons = 6;
            if (WAWizardDialog.isUsingNewStyle()) {
                if (!SharedDimDesigner.this.canFinishEarly()) {
                    --nButtons;
                    wTotalButtonGap = 18;
                } else {
                    wTotalButtonGap = 30;
                }
            }
            Dimension dimButton = this.getPreferredButtonSize();
            Dimension dimLayout = new Dimension(dimButton.width * nButtons + wTotalButtonGap, dimButton.height);
            Insets insContainer = c.getInsets();
            dimLayout.width += insContainer.left + insContainer.right;
            dimLayout.height += insContainer.top + insContainer.bottom;
            return dimLayout;
        }

        @Override
        public Dimension minimumLayoutSize(Container c) {
            return this.preferredLayoutSize(c);
        }

        @Override
        public void layoutContainer(Container c) {
            Insets insContainer = c.getInsets();
            boolean bLeftToRight = SharedDimDesigner.this.getComponentOrientation().isLeftToRight();
            int cxPanel = c.getWidth();
            Dimension dimButton = this.getPreferredButtonSize();
            int cxButton = dimButton.width;
            int cyButton = dimButton.height;
            if (!WAWizardDialog.isUsingNewStyle()) {
                int xBtn = bLeftToRight ? insContainer.left : cxPanel - insContainer.right - cxButton;
                SharedDimDesigner.this.m_btnHelp.setBounds(xBtn, insContainer.top, cxButton, cyButton);
                xBtn = bLeftToRight ? cxPanel - insContainer.right - cxButton : insContainer.left;
                SharedDimDesigner.this.m_btnFinish.setBounds(xBtn, insContainer.top, cxButton, cyButton);
                SharedDimDesigner.this.m_btnNext.setBounds(xBtn += bLeftToRight ? -(cxButton + 20) : cxButton + 20, insContainer.top, cxButton, cyButton);
                SharedDimDesigner.this.m_btnBack.setBounds(xBtn += bLeftToRight ? -(cxButton + 7) : cxButton + 7, insContainer.top, cxButton, cyButton);
                SharedDimDesigner.this.m_btnCancel.setBounds(xBtn += bLeftToRight ? -(cxButton + 20) : cxButton + 20, insContainer.top, cxButton, cyButton);
            } else {
                int xBtn = bLeftToRight ? cxPanel - insContainer.right - cxButton : insContainer.left;
                SharedDimDesigner.this.m_btnHelp.setBounds(xBtn, insContainer.top, cxButton, cyButton);
                SharedDimDesigner.this.m_btnCancel.setBounds(xBtn += bLeftToRight ? -(cxButton + 5) : cxButton + 5, insContainer.top, cxButton, cyButton);
                SharedDimDesigner.this.m_btnFinish.setBounds(xBtn += bLeftToRight ? -(cxButton + 12) : cxButton + 12, insContainer.top, cxButton, cyButton);
                if (SharedDimDesigner.this.canFinishEarly()) {
                    xBtn += bLeftToRight ? -(cxButton + 12) : cxButton + 12;
                }
                SharedDimDesigner.this.m_btnNext.setBounds(xBtn, insContainer.top, cxButton, cyButton);
                SharedDimDesigner.this.m_btnBack.setBounds(xBtn += bLeftToRight ? -(cxButton + 1) : cxButton + 1, insContainer.top, cxButton, cyButton);
                xBtn += bLeftToRight ? -(cxButton + 12) : cxButton + 1;
            }
        }

        protected Dimension getPreferredButtonSize() {
            cMaxDimension dim = new cMaxDimension(0, 0);
            dim.max(SharedDimDesigner.this.m_btnHelp.getPreferredSize());
            dim.max(SharedDimDesigner.this.m_btnNext.getPreferredSize());
            dim.max(SharedDimDesigner.this.m_btnBack.getPreferredSize());
            dim.max(SharedDimDesigner.this.m_btnFinish.getPreferredSize());
            dim.max(SharedDimDesigner.this.m_btnCancel.getPreferredSize());
            return dim;
        }

        protected class cMaxDimension
        extends Dimension {
            private static final long serialVersionUID = 1L;

            public cMaxDimension(int Width, int Height) {
                super(Width, Height);
            }

            public void max(Dimension dim) {
                this.width = Math.max(this.width, dim.width);
                this.height = Math.max(this.height, dim.height);
            }
        }
    }
}

