/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.scheduling;

import com.sas.metadata.remote.Job;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.ServerContext;
import com.sas.metadata.remote.Tree;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPJobCube;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.scheduler.api.deployjob.DeployedJobCodeGenerationInterface;
import com.sas.scheduler.api.deployjob.DeployedJobDialog;
import com.sas.scheduler.model.SchedulerException;
import com.sas.services.user.UserContextInterface;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceFile;
import java.rmi.RemoteException;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;

public abstract class AbstractJobSchedulingDialog
implements DeployedJobCodeGenerationInterface {
    private static final String LAST_DEPLOYDIR = "CubeStudio.LastDeploymentDir";
    protected JFrame parentFrame;
    protected OLAPJobCube codeGenerator;
    protected WorkspaceFile fileAppDefaults;
    protected String currFilename;
    private DeployedJobDialog dialog;
    protected JobDialogCreationParms dialogParms;

    public String generateSource() throws SchedulerException {
        String generatedCode = null;
        try {
            generatedCode = this.codeGenerator.generateSource();
        }
        catch (OLAPException chained) {
            String msg = chained.getLocalizedMessage();
            SchedulerException ex = new SchedulerException(msg);
            ex.initCause((Throwable)chained);
            throw ex;
        }
        return generatedCode;
    }

    private void setLastDeploymentDir(String value) {
        if (this.fileAppDefaults != null) {
            this.fileAppDefaults.setPropertyString(LAST_DEPLOYDIR, value);
        }
    }

    protected String getLastDeploymentDir() {
        String retVal = null;
        if (this.fileAppDefaults != null) {
            retVal = this.fileAppDefaults.getPropertyString(LAST_DEPLOYDIR);
        }
        return retVal;
    }

    public boolean setAppServer(ServerContext serverContext) {
        try {
            Workspace.getWorkspace().getConnectionManager().setLoginCallbackHostName(serverContext.getName());
        }
        catch (RemoteException ex) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)ex);
        }
        finally {
            this.codeGenerator.setAppServer((Object)serverContext);
        }
        return true;
    }

    public boolean setFilename(String currentFilename) {
        this.currFilename = currentFilename;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setJob(Job job) {
        String lastUsedDir = null;
        try {
            lastUsedDir = this.dialog.getDirectoryName();
        }
        catch (RemoteException e) {
            ExceptionHandler.handleException((Exception)e);
        }
        finally {
            if (!this.codeGenerator.isUsingJob((Object)job)) {
                return false;
            }
            if (lastUsedDir != null) {
                this.setLastDeploymentDir(lastUsedDir);
            }
        }
        return true;
    }

    protected abstract DeployedJobDialog createDialog() throws MdException, RemoteException, SchedulerException;

    protected abstract void setDialogDefaults(DeployedJobDialog var1);

    protected abstract String getStoreName();

    protected abstract String getTitle(List var1);

    protected abstract void populateDeploymentList(List var1) throws OLAPException, RemoteException, MdException, SchedulerException;

    public final void show() {
        UserContextInterface userContext = (UserContextInterface)this.codeGenerator.getUserContext();
        try {
            ArrayList jomaJobs = new ArrayList();
            this.codeGenerator.prepareForDeployment();
            this.populateDeploymentList(jomaJobs);
            this.dialogParms = new JobDialogCreationParms();
            this.dialogParms.owner = this.parentFrame;
            this.dialogParms.userContext = userContext;
            this.dialogParms.jobs = jomaJobs;
            this.dialogParms.callback = this;
            this.dialogParms.sTitle = this.getTitle(jomaJobs);
            this.dialogParms.store = (MdObjectStore)this.codeGenerator.getStore();
            this.dialogParms.reposid = Workspace.getMdFactory().getOMIUtil().getFoundationReposID();
            this.dialogParms.folder = (Tree)this.codeGenerator.getFolder();
            this.dialogParms.jobFileContent = null;
            this.dialog = this.createDialog();
            this.setDialogDefaults(this.dialog);
            this.dialog.makeVisible();
        }
        catch (OLAPException e) {
            ExceptionHandler.handleException((Exception)((Object)e));
        }
        catch (RemoteException e) {
            ExceptionHandler.handleException((Exception)e);
        }
        catch (MdException e) {
            ExceptionHandler.handleException((Exception)((Object)e));
        }
        catch (SchedulerException e) {
            ExceptionHandler.handleException((Exception)((Object)e));
        }
        catch (InvalidParameterException e) {
            ExceptionHandler.handleException((Exception)e);
        }
    }

    protected static class JobDialogCreationParms {
        public JFrame owner;
        public UserContextInterface userContext;
        public List jobs;
        public DeployedJobCodeGenerationInterface callback;
        public String sTitle;
        public MdObjectStore store;
        public String reposid;
        public Tree folder;
        public String jobFileContent;

        protected JobDialogCreationParms() {
        }
    }
}

