/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.properties;

import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.OLAPSchema;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WATextArea;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAdminResource;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.rmi.RemoteException;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class PropertiesLocationPanel
extends WAPanel {
    private static final long serialVersionUID = 1L;
    protected static WAdminResource bundle = new WAdminResource(PropertiesLocationPanel.class);
    private JLabel schemaLabel;
    private WATextField schemaValue;
    private JLabel cubePathLabel;
    private WATextField cubePathValue;
    private JLabel workPathLabel;
    private WATextField workPathValue;
    private OLAPCube olapCube;
    private OLAPSchema olapSchema;
    private String schemaName;
    private String workPath;
    private String cubePath;
    private WATextArea cubeFolderField;
    private String cubeFolder;

    public PropertiesLocationPanel(OLAPCube olapcube) {
        this.layoutWidgets();
        this.olapCube = olapcube;
    }

    protected void layoutWidgets() {
        this.setLayout(new GridBagLayout());
        this.schemaLabel = new JLabel(bundle.getString("Properties.Location.OLAPSchema.txt"));
        this.schemaValue = new WATextField();
        this.schemaLabel.setLabelFor((Component)this.schemaValue);
        this.cubePathLabel = new JLabel(bundle.getString("Properties.Location.CubePath.txt"));
        this.cubePathValue = new WATextField();
        this.cubePathLabel.setLabelFor((Component)this.cubePathValue);
        this.workPathLabel = new JLabel(bundle.getString("Properties.Location.WorkPath.txt"));
        this.workPathValue = new WATextField();
        this.workPathLabel.setLabelFor((Component)this.workPathValue);
        this.cubeFolderField = new WATextArea();
        JLabel l = new JLabel();
        this.cubeFolderField.setFont(l.getFont());
        this.cubeFolderField.setBehavior(1);
        this.cubeFolderField.setBackground((Color)SystemColor.control);
        this.cubeFolderField.setAutosize(true);
        this.setEditable(false);
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        panel.add((Component)this.schemaLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 5, 5), 0, 0));
        panel.add((Component)this.schemaValue, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 5, 5, 0), 0, 0));
        panel.add((Component)this.cubePathLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 5, 5), 0, 0));
        panel.add((Component)this.cubePathValue, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 5, 0), 0, 0));
        panel.add((Component)this.workPathLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 5, 5), 0, 0));
        panel.add((Component)this.workPathValue, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 5, 0), 0, 0));
        this.add(panel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 1, new Insets(10, 10, 0, 0), 0, 0));
        this.add((Component)this.cubeFolderField, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 2, new Insets(10, 10, 0, 0), 0, 0));
    }

    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.schemaValue.setEditable(bEditable);
        this.cubePathValue.setEditable(bEditable);
        this.workPathValue.setEditable(bEditable);
    }

    public void moveDataToView() throws MdException, RemoteException {
        this.schemaValue.setText(this.schemaName);
        this.workPathValue.setText(this.workPath);
        this.cubePathValue.setText(this.cubePath);
        if (this.olapCube.physicallyExists()) {
            this.cubeFolderField.setText(bundle.formatString("Properties.Location.CubeFolderExists.fmt.txt", (Object)this.cubeFolder, (Object)this.cubePath));
        } else {
            this.cubeFolderField.setText(bundle.getString("Properties.Location.CubeFolderNotExist.txt"));
        }
    }

    public void populateStore() throws MdException, RemoteException {
        try {
            this.olapSchema = this.olapCube.getAssociatedOLAPSchema();
            if (this.olapSchema != null) {
                this.schemaName = this.olapSchema.getName();
            }
            this.workPath = this.olapCube.getWorkPath();
            this.cubePath = this.olapCube.getPath();
            this.cubeFolder = this.olapCube.getCubeFolder();
        }
        catch (OLAPException e) {
            ExceptionHandler.handleException((Exception)((Object)e));
        }
    }
}

