/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.properties;

import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.olapadmin.actions.PropertiesAction;
import com.sas.olapadmin.designer.model.LoadTable;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.ReachThruTable;
import com.sas.olapadmin.designer.visuals.VisualUtilities;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.olapadmin.utilities.Utilities;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WATextArea;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.models.SimpleObject;
import com.sas.workspace.models.impl.SimpleObjectImpl;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;

public class PropertiesInputPanel
extends WAPanel {
    private static final long serialVersionUID = 1L;
    protected static WAdminResource bundle = new WAdminResource(PropertiesInputPanel.class);
    private JLabel typeLabel;
    private WATextField typeValue;
    private JLabel tableLibraryLabel;
    private WATextField tableLibraryValue;
    private JLabel inputTableLabel;
    private WATextField inputTableValue;
    private JButton propertiesButton;
    private JButton drillPropertiesButton;
    private JLabel optionsLabel;
    private WATextArea optionsValue;
    private JScrollPane optionsScrollPane;
    private JLabel drillTableLabel;
    private JLabel drillOptionsLabel;
    private JLabel drillTableLibraryLabel;
    private WATextField drillTableLibraryValue;
    private WATextField drillTableValue;
    private WATextArea drillOptionsValue;
    private JScrollPane drillOptionsScrollPane;
    private OLAPCube olapCube;
    private String typeName;
    String tableName;
    private String options;
    String drillTableName;
    private String drillOptions;
    private ActionListener tablePropertiesListener;
    private ActionListener drillTablePropertiesListener;
    private WAPanel inputPanel;
    private WAPanel drillPanel;
    private WAPanel typePanel;
    LoadTable loadTable;
    ReachThruTable drillTable;
    private String tableLibrary;
    private String drillTableLibrary;

    public PropertiesInputPanel(OLAPCube olapcube) {
        this.layoutWidgets();
        this.olapCube = olapcube;
    }

    protected void layoutWidgets() {
        this.setLayout(new GridBagLayout());
        this.typePanel = new WAPanel();
        this.typePanel.setLayout((LayoutManager)new GridBagLayout());
        this.inputPanel = new WAPanel();
        this.inputPanel.setLayout((LayoutManager)new GridBagLayout());
        this.drillPanel = new WAPanel();
        this.drillPanel.setLayout((LayoutManager)new GridBagLayout());
        this.inputPanel.setBorder((Border)BorderFactory.createTitledBorder(bundle.getString("Properties.Input.InputTitleBorder.txt")));
        this.drillPanel.setBorder((Border)BorderFactory.createTitledBorder(bundle.getString("Properties.Input.DrillTitleBorder.txt")));
        this.typeLabel = new JLabel(bundle.getString("Properties.Input.Type.txt"));
        this.typeValue = new WATextField();
        this.typeLabel.setLabelFor((Component)this.typeValue);
        this.tableLibraryLabel = new JLabel(bundle.getString("Properties.Input.Library.txt"));
        this.inputTableLabel = new JLabel(bundle.getString("Properties.Input.Table.txt"));
        this.tableLibraryValue = new WATextField();
        this.tableLibraryLabel.setLabelFor((Component)this.tableLibraryValue);
        this.inputTableValue = new WATextField();
        this.inputTableLabel.setLabelFor((Component)this.inputTableValue);
        this.propertiesButton = new JButton();
        VisualUtilities.setButtonTextAndMnemonic(this.propertiesButton, bundle.getString("Properties.Input.Properties.txt"));
        this.tablePropertiesListener = new cTablePropertiesListener();
        this.propertiesButton.addActionListener(this.tablePropertiesListener);
        this.drillPropertiesButton = new JButton();
        VisualUtilities.setButtonTextAndMnemonic(this.drillPropertiesButton, bundle.getString("Properties.Input.Properties.txt"));
        this.drillTablePropertiesListener = new cDrillTablePropertiesListener();
        this.drillPropertiesButton.addActionListener(this.drillTablePropertiesListener);
        this.optionsLabel = new JLabel(bundle.getString("Properties.Input.TableOptions.txt"));
        this.optionsValue = new WATextArea();
        this.optionsLabel.setLabelFor((Component)this.optionsValue);
        this.optionsScrollPane = new JScrollPane((Component)this.optionsValue);
        this.drillTableLibraryLabel = new JLabel(bundle.getString("Properties.Input.Library.txt"));
        this.drillTableLabel = new JLabel(bundle.getString("Properties.Input.Table.txt"));
        this.drillOptionsLabel = new JLabel(bundle.getString("Properties.Input.TableOptions.txt"));
        this.drillTableLibraryValue = new WATextField();
        this.drillTableLibraryLabel.setLabelFor((Component)this.drillTableLibraryValue);
        this.drillTableValue = new WATextField();
        this.drillTableLabel.setLabelFor((Component)this.drillTableValue);
        this.drillOptionsValue = new WATextArea();
        this.drillOptionsLabel.setLabelFor((Component)this.drillOptionsValue);
        this.drillOptionsScrollPane = new JScrollPane((Component)this.drillOptionsValue);
        this.setEditable(false);
        this.typePanel.add((Component)this.typeLabel, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.typePanel.add((Component)this.typeValue, (Object)new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 5, 0, 5), 0, 0));
        this.add((Component)this.typePanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.inputPanel.add((Component)this.tableLibraryLabel, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.inputPanel.add((Component)this.tableLibraryValue, (Object)new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.inputPanel.add((Component)this.inputTableLabel, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.inputPanel.add((Component)this.inputTableValue, (Object)new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.inputPanel.add((Component)this.propertiesButton, (Object)new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.inputPanel.add((Component)this.optionsLabel, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 1.0, 18, 0, new Insets(5, 0, 0, 5), 0, 0));
        this.inputPanel.add((Component)this.optionsScrollPane, (Object)new GridBagConstraints(1, 2, 2, 1, 1.0, 1.0, 18, 1, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this.inputPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.5, 18, 1, new Insets(5, 0, 5, 0), 0, 0));
        this.drillPanel.add((Component)this.drillTableLibraryLabel, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.drillPanel.add((Component)this.drillTableLibraryValue, (Object)new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.drillPanel.add((Component)this.drillTableLabel, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.drillPanel.add((Component)this.drillTableValue, (Object)new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.drillPanel.add((Component)this.drillPropertiesButton, (Object)new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.drillPanel.add((Component)this.drillOptionsLabel, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 1.0, 18, 0, new Insets(5, 0, 0, 5), 0, 0));
        this.drillPanel.add((Component)this.drillOptionsScrollPane, (Object)new GridBagConstraints(1, 2, 2, 1, 1.0, 1.0, 18, 1, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this.drillPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.5, 18, 1, new Insets(5, 0, 0, 0), 0, 0));
    }

    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.typeValue.setEditable(bEditable);
        this.inputTableValue.setEditable(bEditable);
        this.tableLibraryValue.setEditable(bEditable);
        this.optionsValue.setEditable(bEditable);
        this.optionsValue.setBehavior(2);
        this.optionsValue.setBorder(BorderFactory.createLoweredBevelBorder());
        this.drillTableValue.setEditable(bEditable);
        this.drillTableLibraryValue.setEditable(bEditable);
        this.drillOptionsValue.setEditable(bEditable);
        this.drillOptionsValue.setBehavior(2);
        this.drillOptionsValue.setBorder(BorderFactory.createLoweredBevelBorder());
    }

    public void moveDataToView() throws MdException, RemoteException {
        this.typeValue.setText(this.typeName);
        this.tableLibraryValue.setText(this.tableLibrary);
        this.inputTableValue.setText(this.tableName);
        this.optionsValue.setText(this.options);
        this.drillTableLibraryValue.setText(this.drillTableLibrary);
        this.drillTableValue.setText(this.drillTableName);
        if (Utilities.isBlank((String)this.drillTableName)) {
            this.drillPropertiesButton.setEnabled(false);
        } else {
            this.drillPropertiesButton.setEnabled(true);
        }
        this.drillOptionsValue.setText(this.drillOptions);
    }

    public void populateStore() throws MdException, RemoteException {
        try {
            this.typeName = this.olapCube.getTableSet().getLoadType();
            if (this.olapCube.getType().equals("HOLAP")) {
                this.typeName = this.typeName.concat(bundle.getString("Properties.Input.TypeHolap.txt"));
            }
            this.loadTable = this.olapCube.getTableSet().getLoadTable();
            this.tableName = this.loadTable.toString();
            this.tableLibrary = this.loadTable.getSASLibrary().toString();
            this.options = this.olapCube.getTableSet().getLoadTable().getTableOptions();
            this.drillTable = this.olapCube.getTableSet().getReachThruTable();
            if (this.drillTable != null) {
                this.drillTableLibrary = this.drillTable.getSASLibrary().toString();
                this.drillTableName = this.drillTable.toString();
                this.drillOptions = this.drillTable.getTableOptions();
            }
        }
        catch (OLAPException e) {
            ExceptionHandler.handleException((Exception)((Object)e));
        }
    }

    protected class cTablePropertiesListener
    implements ActionListener {
        protected cTablePropertiesListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            PhysicalTable table = PropertiesInputPanel.this.loadTable.getTable();
            try {
                SimpleObjectImpl obj = new SimpleObjectImpl(table.getName(), table.getFQID(), table.getCMetadataType(), table.getPublicType());
                PropertiesAction.showTablePropertySheet((Window)Workspace.getWorkspace(), (SimpleObject)obj, false);
            }
            catch (RemoteException e) {
                ExceptionHandler.handleException((Exception)e);
            }
        }
    }

    class cDrillTablePropertiesListener
    implements ActionListener {
        cDrillTablePropertiesListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            if (PropertiesInputPanel.this.drillTableName != null && !PropertiesInputPanel.this.drillTableName.equals("")) {
                PhysicalTable table = PropertiesInputPanel.this.drillTable.getTable();
                try {
                    SimpleObjectImpl obj = new SimpleObjectImpl(table.getName(), table.getFQID(), table.getCMetadataType(), table.getPublicType());
                    PropertiesAction.showTablePropertySheet((Window)Workspace.getWorkspace(), (SimpleObject)obj, false);
                }
                catch (RemoteException e) {
                    ExceptionHandler.handleException((Exception)e);
                }
            }
        }
    }
}

