/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.properties;

import com.sas.metadata.remote.MdException;
import com.sas.olapadmin.utilities.Utilities;
import com.sas.swing.visuals.tableview.TableView;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsAbstractTableColumn;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsDefaultTableCellRenderer;
import com.sas.workspace.WsStringTableColumn;
import java.awt.Component;
import java.awt.Font;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class GenerationsTableModel
extends WsAbstractTableModel {
    private static final long serialVersionUID = 1L;
    private static WAdminResource bundle = new WAdminResource(GenerationsTableModel.class);
    private static final int TOTAL_COLS = 5;
    private static final int TOTAL_HIDDEN_COLS = 0;
    private static final int NAME = 0;
    private static final int DESCRIPTION = 1;
    private static final int RACKCOUNT = 2;
    private static final int CREATED = 3;
    private static final int MODIFIED = 4;
    private List names;
    private List description;
    private List rackCount;
    private List dateCreated;
    private List dateModified;
    private String selectedCubeName;
    private int cubeRow;

    public GenerationsTableModel(String inputName) {
        this.selectedCubeName = inputName;
        this.m_aColumns = new WsAbstractTableColumn[this.getColumnCount() + this.getHiddenColumnCount()];
        this.m_aColumns[0] = new WsStringTableColumn(0, bundle.getString("StructurePanel.Name.ColumnHeader.txt"), 150, 32);
        this.m_aColumns[0].setEditable(false);
        this.m_aColumns[1] = new WsStringTableColumn(1, bundle.getString("StructurePanel.Description.ColumnHeader.txt"), 130, 256);
        this.m_aColumns[1].setEditable(false);
        this.m_aColumns[2] = new WsStringTableColumn(2, bundle.getString("GenerationsPanel.RackCount.txt"), 130, 32, "1");
        this.m_aColumns[2].setEditable(false);
        this.m_aColumns[3] = new WsStringTableColumn(3, bundle.getString("GenerationsPanel.Table.DateCreated.ColumnHeader.txt"), 125, 32);
        this.m_aColumns[3].setEditable(false);
        this.m_aColumns[4] = new WsStringTableColumn(4, bundle.getString("GenerationsPanel.Table.DateModified.ColumnHeader.txt"), 125, 32);
        this.m_aColumns[4].setEditable(false);
        this.names = new ArrayList();
        this.description = new ArrayList();
        this.rackCount = new ArrayList();
        this.dateCreated = new ArrayList();
        this.dateModified = new ArrayList();
        this.m_aColumns[0].setCellRenderer((TableCellRenderer)((Object)new BoldCellRenderer()));
        this.m_aColumns[1].setCellRenderer((TableCellRenderer)((Object)new BoldCellRenderer()));
        this.m_aColumns[2].setCellRenderer((TableCellRenderer)((Object)new BoldCellRenderer()));
        this.m_aColumns[3].setCellRenderer((TableCellRenderer)((Object)new BoldCellRenderer()));
        this.m_aColumns[4].setCellRenderer((TableCellRenderer)((Object)new BoldCellRenderer()));
    }

    public int getColumnCount() {
        return 5;
    }

    public int getHiddenColumnCount() {
        return 0;
    }

    public String getToolTipAt(int iRow, int iCol) {
        ArrayList row = (ArrayList)this.m_lData.get(iRow);
        String tip = (String)row.get(iCol);
        if (Utilities.isBlank((String)tip)) {
            tip = null;
        }
        return tip;
    }

    public void populateStore() throws MdException, RemoteException {
    }

    public void moveDataToModel() throws MdException, RemoteException {
        int nRows = this.m_lData.size();
        if (nRows > 0) {
            this.m_lData.clear();
            this.fireTableRowsDeleted(0, nRows - 1);
        }
        nRows = this.names.size();
        for (int i = 0; i < nRows; ++i) {
            ArrayList<String> alRow = new ArrayList<String>(this.getColumnCount() + this.getHiddenColumnCount());
            String nextName = (String)this.names.get(i);
            if (this.selectedCubeName.equalsIgnoreCase(nextName)) {
                this.cubeRow = i;
            }
            alRow.add(nextName);
            alRow.add(1, (String)this.description.get(i));
            alRow.add(2, (String)this.rackCount.get(i));
            alRow.add(3, (String)this.dateCreated.get(i));
            alRow.add(4, (String)this.dateModified.get(i));
            this.m_lData.add(alRow);
        }
        if (nRows > 0) {
            this.fireTableRowsInserted(0, nRows - 1);
        }
        this.m_nRowInstances = nRows;
    }

    public void moveDataToStore() throws MdException, RemoteException {
    }

    public void setLists(List newNames, List newDescription, List newRackCount, List newCreated, List newModified) throws MdException, RemoteException {
        this.names.clear();
        this.description.clear();
        this.rackCount.clear();
        this.dateCreated.clear();
        this.dateModified.clear();
        this.names.addAll(newNames);
        this.description.addAll(newDescription);
        this.rackCount.addAll(newRackCount);
        this.dateCreated.addAll(newCreated);
        this.dateModified.addAll(newModified);
        this.moveDataToModel();
    }

    protected class BoldCellRenderer
    extends WsDefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        protected BoldCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable tbl, Object value, boolean bSelected, boolean bFocused, int iRow, int iCol) {
            super.getTableCellRendererComponent(tbl, value, bSelected, bFocused, iRow, iCol);
            iRow = ((TableView)tbl).convertRowIndexToModel(iRow);
            if (iRow == GenerationsTableModel.this.cubeRow) {
                Font font = this.getFont();
                this.setFont(font.deriveFont(1));
            }
            return this;
        }
    }
}

