/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.designer.visuals;

import com.sas.olapadmin.designer.model.ModelUtilities;
import com.sas.swing.visuals.dualselector.BaseDualSelector;
import com.sas.swing.visuals.util.Util;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceFile;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JLabel;

public class VisualUtilities {
    private static Vector cubePaths;
    private static Vector dimensionPaths;
    private static WorkspaceFile fileAppDefaults;
    public static String CUBE_PATHS;
    public static String SHARED_DIM_PATHS;
    public static String AGGREGATION_ARMLOG_PATHS;
    public static String AGGREGATION_DATA_PATHS;
    public static String AGGREGATION_INDEX_PATHS;
    public static String GLOBAL_DATA_PATHS;
    public static String GLOBAL_INDEX_PATHS;
    public static int MAX_PATHS;
    public static String SAVE_PROC_CODE_PATHS;
    public static String SHARED_DIM_SAVE_PROC_CODE_PATHS;
    public static String WORK_PATHS;
    public static String SAVE_SHORT_PROC_CODE_PATHS;
    public static String SHARED_DIM_SAVE_SHORT_PROC_CODE_PATHS;
    public static String SAVE_ADD_DATA_PATHS;
    public static String DISPLAY_VALIDVARNAME_MESSAGE;
    public static String SAVE_LONG_FORM;
    public static String SAVE_SHORT_FORM;
    public static String SHARED_DIM_SAVE_LONG_FORM;
    public static String SHARED_DIM_SAVE_SHORT_FORM;
    public static String VERIFY_SPEC_CHARACTERS;
    public static String VERSION_WARNING_SHARED_DIM;
    public static String VERSION_WARNING_DEFAULT_MEM;

    public static void setButtonTextAndMnemonic(AbstractButton field, String item) {
        String text = Util.getLabelWithoutMnemonic((String)item);
        field.setText(text);
        int index = Util.getDisplayedMnemonicIndex((String)item);
        if (index > -1) {
            int mnemonic = Util.getDisplayedMnemonic((String)item);
            field.setMnemonic(mnemonic);
            field.setDisplayedMnemonicIndex(index);
        }
    }

    public static void setLabelTextAndMnemonic(JLabel field, String item) throws IllegalArgumentException {
        String text = Util.getLabelWithoutMnemonic((String)item);
        field.setText(text);
        int index = Util.getDisplayedMnemonicIndex((String)item);
        if (index > -1) {
            int mnemonic = Util.getDisplayedMnemonic((String)item);
            field.setDisplayedMnemonic(mnemonic);
            field.setDisplayedMnemonicIndex(index);
        }
    }

    public static void setDualSelectorTextAndMnemonic(BaseDualSelector field, String sourceItem, String targetItem) throws IllegalArgumentException {
        JLabel label;
        int mnemonic;
        String sourceText = Util.getLabelWithoutMnemonic((String)sourceItem);
        field.setSourceLabel(sourceText);
        String targetText = Util.getLabelWithoutMnemonic((String)targetItem);
        field.setTargetLabel(targetText);
        int index = Util.getDisplayedMnemonicIndex((String)sourceItem);
        if (index > -1) {
            mnemonic = Util.getDisplayedMnemonic((String)sourceItem);
            label = (JLabel)field.getSourceLabelComponent();
            label.setDisplayedMnemonic(mnemonic);
        }
        if ((index = Util.getDisplayedMnemonicIndex((String)targetItem)) > -1) {
            mnemonic = Util.getDisplayedMnemonic((String)targetItem);
            label = (JLabel)field.getTargetLabelComponent();
            label.setDisplayedMnemonic(mnemonic);
        }
    }

    private static Vector getPaths(String key) {
        Vector pathsFromOlapdefTxt = null;
        if (key.equals(CUBE_PATHS) && cubePaths == null) {
            cubePaths = new Vector();
            pathsFromOlapdefTxt = cubePaths;
        } else if (key.equals(SHARED_DIM_PATHS) && dimensionPaths == null) {
            dimensionPaths = new Vector();
            pathsFromOlapdefTxt = dimensionPaths;
        } else {
            pathsFromOlapdefTxt = new Vector();
        }
        if (pathsFromOlapdefTxt.isEmpty()) {
            for (int i = 0; i < MAX_PATHS; ++i) {
                String path = fileAppDefaults.getPropertyString(key + i);
                if (ModelUtilities.isBlank((String)path)) continue;
                pathsFromOlapdefTxt.add(path);
            }
        }
        return pathsFromOlapdefTxt;
    }

    public static Vector getCubePaths() {
        if (cubePaths == null) {
            cubePaths = VisualUtilities.getPaths(CUBE_PATHS);
        }
        return cubePaths;
    }

    public static Vector getSharedDimPaths() {
        if (dimensionPaths == null) {
            dimensionPaths = VisualUtilities.getPaths(SHARED_DIM_PATHS);
        }
        return dimensionPaths;
    }

    public static Vector getWorkPaths() {
        return VisualUtilities.getPaths(WORK_PATHS);
    }

    public static Vector getGlobalDataPaths() {
        return VisualUtilities.getPaths(GLOBAL_DATA_PATHS);
    }

    public static Vector getAggregationDataPaths() {
        return VisualUtilities.getPaths(AGGREGATION_DATA_PATHS);
    }

    public static Vector getGlobalIndexPaths() {
        return VisualUtilities.getPaths(GLOBAL_INDEX_PATHS);
    }

    public static Vector getAggregationIndexPaths() {
        return VisualUtilities.getPaths(AGGREGATION_INDEX_PATHS);
    }

    public static Vector getSaveProcCodePaths() {
        return VisualUtilities.getPaths(SAVE_PROC_CODE_PATHS);
    }

    public static Vector getShortSaveProcCodePaths() {
        return VisualUtilities.getPaths(SAVE_SHORT_PROC_CODE_PATHS);
    }

    public static Vector getSharedDimSaveProcCodePaths() {
        return VisualUtilities.getPaths(SHARED_DIM_SAVE_PROC_CODE_PATHS);
    }

    public static Vector getSharedDimShortSaveProcCodePaths() {
        return VisualUtilities.getPaths(SHARED_DIM_SAVE_SHORT_PROC_CODE_PATHS);
    }

    public static Vector getAddDataSaveProcCodePaths() {
        return VisualUtilities.getPaths(SAVE_ADD_DATA_PATHS);
    }

    public static boolean getDisplayValidVarnameMessage() {
        return fileAppDefaults.getPropertyBoolean(DISPLAY_VALIDVARNAME_MESSAGE, true);
    }

    public static boolean getShortForm() {
        return fileAppDefaults.getPropertyBoolean(SAVE_SHORT_FORM, false);
    }

    public static boolean getLongForm() {
        return fileAppDefaults.getPropertyBoolean(SAVE_LONG_FORM, false);
    }

    public static boolean getSharedDimShortForm() {
        return fileAppDefaults.getPropertyBoolean(SHARED_DIM_SAVE_SHORT_FORM, false);
    }

    public static boolean getSharedDimLongForm() {
        return fileAppDefaults.getPropertyBoolean(SHARED_DIM_SAVE_LONG_FORM, false);
    }

    private static void setPaths(String key, Vector newPaths) {
        Vector paths = null;
        paths = key.equals(CUBE_PATHS) ? cubePaths : (key.equals(SHARED_DIM_PATHS) ? dimensionPaths : newPaths);
        if (paths.size() == MAX_PATHS + 1) {
            paths.remove(paths.size() - 1);
        }
        int size = paths.size();
        for (int i = 0; i < size; ++i) {
            String path = (String)paths.get(i);
            fileAppDefaults.setPropertyString(key + i, path);
        }
    }

    public static void setCubePaths() {
        VisualUtilities.setPaths(CUBE_PATHS, null);
    }

    public static void setSharedDimPaths() {
        VisualUtilities.setPaths(SHARED_DIM_PATHS, null);
    }

    public static void setWorkPaths(Vector newPaths) {
        VisualUtilities.setPaths(WORK_PATHS, newPaths);
    }

    public static void setGlobalDataPaths(Vector newPaths) {
        VisualUtilities.setPaths(GLOBAL_DATA_PATHS, newPaths);
    }

    public static void setGlobalIndexPaths(Vector newPaths) {
        VisualUtilities.setPaths(GLOBAL_INDEX_PATHS, newPaths);
    }

    public static void setAggregationDataPaths(Vector newPaths) {
        VisualUtilities.setPaths(AGGREGATION_DATA_PATHS, newPaths);
    }

    public static void setAggregationIndexPaths(Vector newPaths) {
        VisualUtilities.setPaths(AGGREGATION_INDEX_PATHS, newPaths);
    }

    public static void setSaveProcCodePaths(Vector newPaths) {
        VisualUtilities.setPaths(SAVE_PROC_CODE_PATHS, newPaths);
    }

    public static void setShortSaveProcCodePaths(Vector newPaths) {
        VisualUtilities.setPaths(SAVE_SHORT_PROC_CODE_PATHS, newPaths);
    }

    public static void setSharedDimSaveProcCodePaths(Vector newPaths) {
        VisualUtilities.setPaths(SHARED_DIM_SAVE_PROC_CODE_PATHS, newPaths);
    }

    public static void setSharedDimShortSaveProcCodePaths(Vector newPaths) {
        VisualUtilities.setPaths(SHARED_DIM_SAVE_SHORT_PROC_CODE_PATHS, newPaths);
    }

    public static void setAddDataSaveProcCodePaths(Vector newPaths) {
        VisualUtilities.setPaths(SAVE_ADD_DATA_PATHS, newPaths);
    }

    public static void setDisplayValidVarnameMessage(boolean display) {
        fileAppDefaults.setPropertyBoolean(DISPLAY_VALIDVARNAME_MESSAGE, display);
    }

    public static void setShortForm(boolean saveShortFormSetting) {
        fileAppDefaults.setPropertyBoolean(SAVE_SHORT_FORM, saveShortFormSetting);
    }

    public static void setLongForm(boolean saveLongFormSetting) {
        fileAppDefaults.setPropertyBoolean(SAVE_LONG_FORM, saveLongFormSetting);
    }

    public static void setSharedDimShortForm(boolean saveShortFormSetting) {
        fileAppDefaults.setPropertyBoolean(SHARED_DIM_SAVE_SHORT_FORM, saveShortFormSetting);
    }

    public static void setSharedDimLongForm(boolean saveLongFormSetting) {
        fileAppDefaults.setPropertyBoolean(SHARED_DIM_SAVE_LONG_FORM, saveLongFormSetting);
    }

    static {
        CUBE_PATHS = "CubeDesigner.CubePath.";
        SHARED_DIM_PATHS = "SharedDimDesigner.SharedDimPath.";
        AGGREGATION_ARMLOG_PATHS = "CubeDesigner.Aggregation.ArmLogPath.";
        AGGREGATION_DATA_PATHS = "CubeDesigner.Aggregation.DataPath.";
        AGGREGATION_INDEX_PATHS = "CubeDesigner.Aggregation.IndexPath.";
        GLOBAL_DATA_PATHS = "CubeDesigner.Global.DataPath.";
        GLOBAL_INDEX_PATHS = "CubeDesigner.Global.IndexPath.";
        MAX_PATHS = 5;
        SAVE_PROC_CODE_PATHS = "CubeDesigner.SaveProcCodePath.";
        SHARED_DIM_SAVE_PROC_CODE_PATHS = "SharedDimDesigner.SaveProcCodePath.";
        WORK_PATHS = "CubeDesigner.WorkPath.";
        SAVE_SHORT_PROC_CODE_PATHS = "CubeDesigner.SaveShortProcCodePath";
        SHARED_DIM_SAVE_SHORT_PROC_CODE_PATHS = "SharedDimDesigner.SaveShortProcCodePath";
        SAVE_ADD_DATA_PATHS = "CubeUpdate.SaveProcCodePath";
        DISPLAY_VALIDVARNAME_MESSAGE = "CubeDesigner.ValidVarName";
        SAVE_LONG_FORM = "CubeDesigner.SaveLongFormSetting";
        SAVE_SHORT_FORM = "CubeDesigner.SaveShortFormSetting";
        SHARED_DIM_SAVE_LONG_FORM = "SharedDimDesigner.SaveLongFormSetting";
        SHARED_DIM_SAVE_SHORT_FORM = "SharedDimDesigner.SaveShortFormSetting";
        VERIFY_SPEC_CHARACTERS = "CubeDesigner.VerifySpecCharacters";
        VERSION_WARNING_SHARED_DIM = "CubeDesigner.SharedDim.Version.Number.Warning";
        VERSION_WARNING_DEFAULT_MEM = "CubeDesigner.DefaultMember.Version.Number.Warning";
        fileAppDefaults = Workspace.getWorkspace().getAppDefaultsFile();
    }
}

