/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.designer.visuals;

import com.sas.metadata.remote.PhysicalTable;
import com.sas.olapadmin.designer.model.AbstractOLAPModel;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPList;
import com.sas.olapadmin.designer.model.OLAPMemberPropertySet;
import com.sas.olapadmin.designer.model.OLAPSharedDimension;
import com.sas.olapadmin.designer.model.SharedDimensionTable;
import com.sas.olapadmin.designer.visuals.MapLoadTableLevelsTab;
import com.sas.olapadmin.designer.visuals.MapLoadTableOLAPMemberPropertiesTab;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.workspace.WAPropertyDialog;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAdminResource;
import java.awt.Dialog;

public class SharedDimTableMapDialog
extends WAPropertyDialog {
    private static final long serialVersionUID = 1L;
    private static WAdminResource bundle = new WAdminResource(SharedDimTableMapDialog.class);
    private OLAPSharedDimension sharedDim;
    private PhysicalTable mappedTable;
    private MapLoadTableLevelsTab mapLoadTableLevelsTab;
    private MapLoadTableOLAPMemberPropertiesTab mapLoadTableMemberPropertiesTab;

    public SharedDimTableMapDialog(Dialog owner, AbstractOLAPModel inputObject, PhysicalTable inputMappedTable) {
        super(owner, bundle.getString("CubeDesigner.MapLoadTable.title.txt"), true);
        this.sharedDim = (OLAPSharedDimension)inputObject;
        this.mappedTable = inputMappedTable;
        try {
            this.mapLoadTableLevelsTab = new MapLoadTableLevelsTab(inputObject, this.mappedTable);
            this.mapLoadTableLevelsTab.setName("mapLevelsTab");
            this.addTab(bundle.getString("MapLoadTable.Levels.tab.txt"), (WAPropertyTab)this.mapLoadTableLevelsTab);
            OLAPMemberPropertySet propertySet = this.sharedDim.getOLAPMemberPropertySet();
            OLAPList properties = propertySet.getOLAPProperties();
            int size = properties.size();
            if (size > 0) {
                this.mapLoadTableMemberPropertiesTab = new MapLoadTableOLAPMemberPropertiesTab(propertySet, this.mappedTable);
                this.mapLoadTableMemberPropertiesTab.setName("mapPropertiesTab");
                this.addTab(bundle.getString("MapLoadTable.MemberProperties.tab.txt"), (WAPropertyTab)this.mapLoadTableMemberPropertiesTab);
            }
            this.setHelpProduct("olapadmin");
            this.setHelpTopic("cd_map_new_table");
        }
        catch (OLAPException error) {
            ExceptionHandler.handleException((Exception)((Object)error));
        }
    }

    protected void initialize() {
        super.initialize();
    }

    protected boolean onOK() {
        try {
            SharedDimensionTable dimTable = this.sharedDim.getSharedDimensionTable();
            StringBuffer mappedMessage = dimTable.getMappedMessage();
            if (mappedMessage.length() > 0) {
                this.mapLoadTableLevelsTab.saveToModel();
                if (this.mapLoadTableMemberPropertiesTab != null) {
                    this.mapLoadTableMemberPropertiesTab.saveToModel();
                }
            }
        }
        catch (OLAPException error) {
            ExceptionHandler.handleException((Exception)((Object)error));
        }
        return true;
    }
}

