/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.designer.visuals;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPList;
import com.sas.olapadmin.designer.model.OLAPMemberProperty;
import com.sas.olapadmin.designer.model.OLAPMemberPropertySet;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractTableColumn;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsStringTableColumn;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MapLoadTableOLAPMemberPropertiesTableModel
extends WsAbstractTableModel {
    private static final long serialVersionUID = 1L;
    private static WAdminResource bundle = WAdminResource.getBundle(MapLoadTableOLAPMemberPropertiesTableModel.class);
    static final int MEMBER_PROPERTY_NAME = 0;
    static final int COLUMN_NAME = 1;
    private final int LEVEL_NAME = 2;
    private final int CAPTION = 3;
    private static final int TOTAL_COLS = 4;
    private static final int TOTAL_HIDDEN_COLS = 0;
    private List memberProperties;
    private OLAPMemberPropertySet propertySet;
    private PhysicalTable mappedTable;
    private String[] columns;
    private Map columnMap;

    public MapLoadTableOLAPMemberPropertiesTableModel(OLAPMemberPropertySet inputPropertySet, PhysicalTable inputMappedTable) throws OLAPException {
        int i;
        this.propertySet = inputPropertySet;
        this.mappedTable = inputMappedTable;
        OLAPList olapMemberProperties = this.propertySet.getOLAPProperties();
        olapMemberProperties.sort();
        ArrayList<OLAPMemberProperty> missingColumn = new ArrayList<OLAPMemberProperty>();
        this.memberProperties = new ArrayList();
        for (i = olapMemberProperties.size() - 1; i >= 0; --i) {
            OLAPMemberProperty property = (OLAPMemberProperty)olapMemberProperties.get(i);
            Column column = this.propertySet.getMappedMemberProperty(property);
            if (column == null) {
                missingColumn.add(property);
                continue;
            }
            this.memberProperties.add(property);
        }
        for (i = missingColumn.size() - 1; i >= 0; --i) {
            this.memberProperties.add(0, missingColumn.get(i));
        }
        try {
            this.columnMap = new HashMap();
            AssociationList jomaColumns = this.mappedTable.getColumns(false);
            this.columns = new String[jomaColumns.size()];
            int count = 0;
            for (int i2 = jomaColumns.size() - 1; i2 >= 0; --i2) {
                Column column = (Column)jomaColumns.get(i2);
                String name = column.getSASColumnName();
                this.columnMap.put(name, column);
                this.columns[count] = column.getSASColumnName();
                ++count;
            }
        }
        catch (MdException jomaColumns) {
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        this.createColumnDefinitions();
    }

    protected void createColumnDefinitions() {
        this.m_aColumns = new WsAbstractTableColumn[this.getColumnCount() + this.getHiddenColumnCount()];
        this.m_aColumns[0] = new WsStringTableColumn(0, bundle.getString("MapLoadTable.OLAPMemberPropertyDetail.Name.txt"), 100, 32);
        this.m_aColumns[0].setEditable(false);
        this.m_aColumns[1] = new WsStringTableColumn(1, bundle.getString("MapLoadTable.Detail.Column.txt"), 100, this.columns);
        this.m_aColumns[1].setEditable(true);
        this.m_aColumns[2] = new WsStringTableColumn(2, bundle.getString("MapLoadTable.LevelsDetail.Name.txt"), 100, 10);
        this.m_aColumns[2].setEditable(false);
        this.m_aColumns[3] = new WsStringTableColumn(3, bundle.getString("CubeDesigner.MeasuresModel.Caption.header.title"), 200, 200);
        this.m_aColumns[3].setEditable(false);
    }

    public int getColumnCount() {
        return 4;
    }

    Column getColumn(String name) {
        return (Column)this.columnMap.get(name);
    }

    public int getHiddenColumnCount() {
        return 0;
    }

    public void moveDataToModel() {
        try {
            int nRows = this.m_lData.size();
            if (nRows > 0) {
                this.m_lData.clear();
                this.fireTableRowsDeleted(0, nRows - 1);
            }
            nRows = this.memberProperties.size();
            for (int i = 0; i < nRows; ++i) {
                ArrayList<Object> alRow = new ArrayList<Object>(this.getColumnCount() + this.getHiddenColumnCount());
                OLAPMemberProperty property = (OLAPMemberProperty)this.memberProperties.get(i);
                alRow.add(0, property);
                Column column = this.propertySet.getMappedMemberProperty((OLAPMemberProperty)this.memberProperties.get(i));
                if (column != null) {
                    alRow.add(1, column.getSASColumnName());
                } else {
                    alRow.add(1, "");
                }
                try {
                    alRow.add(2, property.getAssociatedLevel());
                }
                catch (OLAPException oLAPException) {
                    // empty catch block
                }
                alRow.add(3, property.getDesc());
                this.m_lData.add(alRow);
            }
            if (nRows > 0) {
                this.fireTableRowsInserted(0, nRows - 1);
            }
            this.m_nRowInstances = nRows;
        }
        catch (RemoteException e) {
            ExceptionHandler.handleException((Exception)e);
        }
    }

    public void moveDataToStore() throws MdException, RemoteException {
    }

    public void populateStore() {
    }

    public void setValueAt(Object value, int iRow, int iCol) {
        super.setValueAt(value, iRow, iCol);
    }
}

