/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.designer.visuals;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.olapadmin.designer.model.LoadTable;
import com.sas.olapadmin.designer.model.MeasureSet;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPList;
import com.sas.olapadmin.designer.model.OLAPMeasure;
import com.sas.olapadmin.designer.model.TableSet;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractTableColumn;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsStringTableColumn;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MapLoadTableMeasuresTableModel
extends WsAbstractTableModel {
    private static final long serialVersionUID = 1L;
    private static WAdminResource bundle = WAdminResource.getBundle(MapLoadTableMeasuresTableModel.class);
    static final int MEASURE_NAME = 0;
    static final int COLUMN_NAME = 1;
    private final int STATISTIC_NAME = 2;
    private final int CAPTION = 3;
    private final int TOTAL_COLS = 4;
    private final int TOTAL_HIDDEN_COLS = 0;
    private List measures;
    private MeasureSet measureSet;
    private PhysicalTable mappedTable;
    private String[] columns;
    private Map columnMap;

    public MapLoadTableMeasuresTableModel(MeasureSet inputMeasureSet, PhysicalTable inputMappedTable) throws OLAPException {
        this.measureSet = inputMeasureSet;
        this.mappedTable = inputMappedTable;
        this.measures = new ArrayList();
        OLAPCube owningCube = this.measureSet.getOwningCube();
        TableSet tableSet = owningCube.getTableSet();
        LoadTable loadTable = tableSet.getLoadTable();
        OLAPList olapMeasures = null;
        olapMeasures = tableSet.isLoadClassicSAS() ? this.measureSet.getStoredMeasures() : this.measureSet.getMeasures();
        for (int i = olapMeasures.size() - 1; i >= 0; --i) {
            OLAPMeasure measure = (OLAPMeasure)olapMeasures.get(i);
            if (measure.isNunique().booleanValue()) continue;
            Column column = loadTable.getMappedMeasure(measure);
            if (column == null) {
                this.measures.add(0, measure);
                continue;
            }
            this.measures.add(measure);
        }
        try {
            this.columnMap = new HashMap();
            AssociationList jomaColumns = this.mappedTable.getColumns(false);
            this.columns = new String[jomaColumns.size()];
            int count = 0;
            for (int i = jomaColumns.size() - 1; i >= 0; --i) {
                Column column = (Column)jomaColumns.get(i);
                if (!column.getSASColumnType().equalsIgnoreCase("N")) continue;
                String name = column.getSASColumnName();
                this.columnMap.put(name.toUpperCase(), column);
                this.columns[count] = column.getSASColumnName();
                ++count;
            }
        }
        catch (MdException jomaColumns) {
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        this.createColumnDefinitions();
    }

    Column getColumn(String name) {
        return (Column)this.columnMap.get(name.toUpperCase());
    }

    protected void createColumnDefinitions() {
        this.m_aColumns = new WsAbstractTableColumn[this.getColumnCount() + this.getHiddenColumnCount()];
        this.m_aColumns[0] = new WsStringTableColumn(0, bundle.getString("CubeDesigner.MeasuresModel.Name.header.title"), 100, 32);
        this.m_aColumns[0].setEditable(false);
        this.m_aColumns[1] = new WsStringTableColumn(1, bundle.getString("MapLoadTable.Detail.Column.txt"), 100, this.columns);
        this.m_aColumns[1].setEditable(true);
        this.m_aColumns[2] = new WsStringTableColumn(2, bundle.getString("CubeDesigner.MeasuresDetail.Stat.txt"), 100, 10);
        this.m_aColumns[2].setEditable(false);
        this.m_aColumns[3] = new WsStringTableColumn(3, bundle.getString("CubeDesigner.MeasuresModel.Caption.header.title"), 200, 200);
        this.m_aColumns[3].setEditable(false);
    }

    public int getColumnCount() {
        return 4;
    }

    public int getHiddenColumnCount() {
        return 0;
    }

    public void moveDataToModel() {
        try {
            int nRows = this.m_lData.size();
            if (nRows > 0) {
                this.m_lData.clear();
                this.fireTableRowsDeleted(0, nRows - 1);
            }
            nRows = this.measures.size();
            for (int i = 0; i < nRows; ++i) {
                ArrayList<Object> alRow = new ArrayList<Object>(this.getColumnCount() + this.getHiddenColumnCount());
                OLAPMeasure measure = (OLAPMeasure)this.measures.get(i);
                alRow.add(0, measure);
                Column column = this.measureSet.getMappedMeasure((OLAPMeasure)this.measures.get(i));
                if (column != null) {
                    alRow.add(1, column.getSASColumnName());
                } else {
                    alRow.add(1, "");
                }
                alRow.add(2, measure.getStatistic().getName());
                alRow.add(3, measure.getDesc());
                this.m_lData.add(alRow);
            }
            if (nRows > 0) {
                this.fireTableRowsInserted(0, nRows - 1);
            }
            this.m_nRowInstances = nRows;
        }
        catch (RemoteException e) {
            ExceptionHandler.handleException((Exception)e);
        }
    }

    public void moveDataToStore() throws MdException, RemoteException {
    }

    public void populateStore() {
    }

    public void setValueAt(Object value, int iRow, int iCol) {
        super.setValueAt(value, iRow, iCol);
    }
}

