/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.designer.visuals;

import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.olapadmin.designer.model.AbstractOLAPModel;
import com.sas.olapadmin.designer.model.MLSCaptionTable;
import com.sas.olapadmin.designer.model.ModelUtilities;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPDimension;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPList;
import com.sas.olapadmin.designer.model.TableSet;
import com.sas.olapadmin.designer.visuals.MLSCaptionsTab;
import com.sas.olapadmin.designer.visuals.MLSCaptionsTabIdentifiers;
import com.sas.olapadmin.designer.visuals.VisualUtilities;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.olapadmin.utilities.studio.PhysicalTableSelector;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WATextArea;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractTableColumn;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsDefaultTableCellRenderer;
import com.sas.workspace.WsDefaultTableColumnHeaderRenderer;
import com.sas.workspace.WsDialogTableCellEditor;
import com.sas.workspace.WsDialogTableCellEditorInterface;
import com.sas.workspace.WsObjectTableColumn;
import com.sas.workspace.WsStringTableColumn;
import com.sas.workspace.WsTable;
import com.sas.workspace.WsUIUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class MLSCaptionsTabTables
extends WAPropertyTab {
    private static final long serialVersionUID = 1L;
    private static final WAdminResource bundle = new WAdminResource(MLSCaptionsTabTables.class);
    public OLAPCube olapCube;
    private JCheckBox cubeTableCheckBox;
    private WATextField cubeCaptionTable;
    private JButton selectCubeTable;
    private JLabel tableLabel;
    private DimTablesModel dimTablesModel;
    private WsTable dimTables;
    private boolean initialized;
    private WAWizardDialog parentDialog;
    private String none;
    private String useCube;
    private MLSCaptionTable mlsTable;
    private WATextArea cubeInstructions;
    private TableSet tableSet;
    private WATextArea dimInstructions;
    private MLSCaptionsTab.CaptionsTabber tabber;

    public MLSCaptionsTabTables(OLAPCube olapCube2, MLSCaptionsTab.CaptionsTabber tabber2) {
        this.olapCube = olapCube2;
        this.tabber = tabber2;
        this.layoutWidgets();
        this.initialized = false;
        this.setHelpProduct("olapadmin");
        this.setHelpTopic("caption_tables");
    }

    public void moveDataToView() throws MdException, RemoteException {
        if (!this.initialized) {
            this.parentDialog = (WAWizardDialog)this.getTopLevelAncestor();
            this.none = bundle.getString("CubeDesigner.MLSCaptions.cubeTable.none.txt");
            this.useCube = bundle.getString("CubeDesigner.MLSCaptions.dimTable.useCube.txt");
            this.initialized = true;
            this.tableSet = this.olapCube.getTableSet();
        }
        try {
            this.mlsTable = this.olapCube.getMLSCaptionTable();
            String tableName = this.none;
            if (this.mlsTable != null) {
                tableName = this.mlsTable.getSASTableName();
            }
            this.cubeCaptionTable.setText(tableName);
            this.dimTablesModel.moveDataToModel();
            this.cubeTableCheckBox.setSelected(this.dimTablesModel.isDimTableSpecified() || !this.none.equals(tableName));
            this.tableLabel.setEnabled(this.cubeTableCheckBox.isSelected());
            this.cubeCaptionTable.setEnabled(this.cubeTableCheckBox.isSelected());
            this.selectCubeTable.setEnabled(this.cubeTableCheckBox.isSelected());
            this.dimTables.setEditable(this.cubeTableCheckBox.isSelected());
            this.dimTables.setSortingEnabled(this.cubeTableCheckBox.isSelected());
            this.dimTables.setRowsReorderable(this.cubeTableCheckBox.isSelected());
            this.cubeInstructions.setEnabled(this.cubeTableCheckBox.isSelected());
            this.dimInstructions.setEnabled(this.cubeTableCheckBox.isSelected());
            if (this.cubeTableCheckBox.isSelected() && (this.mlsTable != null || this.dimTablesModel.isDimTableSpecified())) {
                this.tabber.setTabEnabled(1, true);
            } else {
                this.tabber.setTabEnabled(1, false);
            }
        }
        catch (OLAPException e) {
            ExceptionHandler.handleException((Exception)((Object)e));
        }
    }

    public void populateStore() throws MdException, RemoteException {
        this.setStorePopulated(true);
    }

    protected void layoutWidgets() {
        this.setLayout(new GridBagLayout());
        this.cubeTableCheckBox = new JCheckBox();
        VisualUtilities.setButtonTextAndMnemonic(this.cubeTableCheckBox, bundle.getString("CubeDesigner.MLSCaptions.cubeTable.checkbox.label"));
        this.add(this.cubeTableCheckBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 0, 5, 0), 0, 0));
        this.cubeTableCheckBox.addActionListener(new CubeTableCheckBoxListener());
        WAPanel outerPanel = new WAPanel();
        outerPanel.setLayout((LayoutManager)new GridBagLayout());
        outerPanel.setBorder(BorderFactory.createEtchedBorder());
        this.cubeInstructions = new WATextArea(bundle.getString("CubeDesigner.MLSCaptions.cubeTable.instructions.txt"));
        JLabel l = new JLabel();
        this.cubeInstructions.setFont(l.getFont());
        this.cubeInstructions.setBehavior(1);
        this.cubeInstructions.setBackground((Color)SystemColor.control);
        this.cubeInstructions.setAutosize(true);
        outerPanel.add((Component)this.cubeInstructions, (Object)new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 5, 0), 0, 0));
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        this.tableLabel = new JLabel();
        VisualUtilities.setLabelTextAndMnemonic(this.tableLabel, bundle.getString("CubeDesigner.MLSCaptions.cubeTable.control.label"));
        this.cubeCaptionTable = new WATextField();
        this.cubeCaptionTable.setBehavior(2);
        this.tableLabel.setLabelFor((Component)this.cubeCaptionTable);
        this.selectCubeTable = new JButton();
        VisualUtilities.setButtonTextAndMnemonic(this.selectCubeTable, bundle.getString("CubeDesigner.MLSCaptions.cubeTableSelect.action.label"));
        this.selectCubeTable.addActionListener(new SelectCubeTableListener());
        panel.add((Component)this.tableLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)this.cubeCaptionTable, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)this.selectCubeTable, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        outerPanel.add((Component)panel, (Object)new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 10, 0), 0, 0));
        this.dimInstructions = new WATextArea(bundle.getString("CubeDesigner.MLSCaptions.dimTables.instructions.txt"));
        this.dimInstructions.setFont(l.getFont());
        this.dimInstructions.setBehavior(1);
        this.dimInstructions.setBackground((Color)SystemColor.control);
        this.dimInstructions.setAutosize(true);
        outerPanel.add((Component)this.dimInstructions, (Object)new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.dimTablesModel = new DimTablesModel();
        this.dimTables = new WsTable((WsAbstractTableModel)this.dimTablesModel);
        this.dimTables.setSortingEnabled(true);
        this.dimTables.setColumnHidingEnabled(false);
        this.dimTables.setColumnsReorderable(false);
        this.dimTables.setRowHoldingEnabled(false);
        this.dimTables.setColumnHeaderPopupMenuEnabled(false);
        this.dimTables.setOriginPopupMenuEnabled(false);
        this.dimTables.setPopupMenuEnabled(false);
        this.dimTables.setRowHeaderPopupMenuEnabled(false);
        this.dimTables.setTablePopupMenuEnabled(false);
        this.dimTables.setViewportPopupMenuEnabled(false);
        this.dimTables.setPreferredScrollableViewportSize(new Dimension(75, 50));
        this.dimTables.setAutoResizeMode(0);
        this.dimTables.setNonEditableCellBackground(UIManager.getColor("TextField.inactiveBackground"));
        TableColumnModel colModel = this.dimTables.getColumnModel();
        int numCols = colModel.getColumnCount();
        for (int i = 0; i < numCols; ++i) {
            TableColumn col = colModel.getColumn(i);
            col.setHeaderRenderer((TableCellRenderer)((Object)new DisabledColumnHeaderRenderer()));
        }
        JScrollPane scrollPane = new JScrollPane((Component)this.dimTables);
        outerPanel.add((Component)scrollPane, (Object)new GridBagConstraints(0, 4, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)outerPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public boolean validateData() {
        TableCellEditor ce = this.dimTables.getCellEditor();
        if (ce != null) {
            ce.stopCellEditing();
        }
        return true;
    }

    public boolean verifyTabData() {
        boolean dataOK = true;
        if (this.cubeTableCheckBox.isSelected()) {
            if (this.mlsTable == null && !this.dimTablesModel.isDimTableSpecified()) {
                int choice = MessageUtil.displayMessage((String)bundle.getString("CubeDesigner.MLSCaptions.NoTable.txt"), (String)bundle.getString("CubeDesigner.MLSCaptions.Messages.window.title"), (int)1, (int)0);
                boolean bl = dataOK = choice == 0;
            }
            if (dataOK) {
                String tableName;
                ArrayList<String> tableNames = new ArrayList<String>();
                ArrayList<Object> objectsToRemoveMLSTablesFrom = new ArrayList<Object>();
                MLSCaptionsTabIdentifiers idTab = (MLSCaptionsTabIdentifiers)this.tabber.getTabAt(1);
                if (this.mlsTable != null && !idTab.doesTableHaveIds(tableName = this.mlsTable.getSASTableName())) {
                    objectsToRemoveMLSTablesFrom.add(this.olapCube);
                    tableNames.add(tableName);
                }
                int count = this.dimTablesModel.getRowCount();
                for (int i = 0; i < count; ++i) {
                    List rowObjs = this.dimTablesModel.getRowValues(i);
                    String tableName2 = (String)rowObjs.get(1);
                    if (this.none.equals(tableName2) || this.useCube.equals(tableName2) || idTab.doesTableHaveIds(tableName2)) continue;
                    tableNames.add(tableName2);
                    OLAPDimension dim = (OLAPDimension)rowObjs.get(2);
                    objectsToRemoveMLSTablesFrom.add(dim);
                }
                if (!tableNames.isEmpty()) {
                    dataOK = false;
                    String indentBuffer = "   ";
                    String delimiter = ", ";
                    StringBuffer tables = ModelUtilities.stringListFormatter(tableNames, (String)indentBuffer, (String)delimiter);
                    int choice = MessageUtil.displayMessage((String)bundle.formatString("CubeDesigner.MLSCaptions.NoIds.fmt.txt", (Object)tables), (String)bundle.getString("CubeDesigner.MLSCaptions.Messages.window.title"), (int)1, (int)0);
                    if (choice == 0) {
                        dataOK = true;
                        for (int i = 0; i < objectsToRemoveMLSTablesFrom.size(); ++i) {
                            AbstractOLAPModel olapObj = (AbstractOLAPModel)objectsToRemoveMLSTablesFrom.get(i);
                            if (olapObj instanceof OLAPCube) {
                                this.olapCube.setMLSCaptionTable(null);
                                continue;
                            }
                            OLAPDimension dim = (OLAPDimension)olapObj;
                            dim.setMLSCaptionTable(null);
                        }
                    }
                }
            }
        }
        return dataOK;
    }

    private class DimTablesModel
    extends WsAbstractTableModel {
        private static final long serialVersionUID = 1L;
        private static final int TOTAL_COLS = 2;
        private static final int TOTAL_HIDDEN_COLS = 2;
        private static final int DIMENSION_NAME = 0;
        private static final int TABLE_NAME = 1;
        private static final int DIMENSION_OBJECT = 2;
        private static final int DIMENSION_MLS_TABLE = 3;
        private int tableCount;

        public DimTablesModel() {
            this.createColumnDefinitions();
        }

        public void removeAllTables() {
            TableCellEditor ce = MLSCaptionsTabTables.this.dimTables.getCellEditor();
            if (ce != null) {
                ce.stopCellEditing();
            }
            for (int i = 0; i < this.m_lData.size(); ++i) {
                ArrayList row = (ArrayList)this.m_lData.get(i);
                OLAPDimension dim = (OLAPDimension)row.get(2);
                dim.setMLSCaptionTable(null);
                row.set(3, null);
                if (MLSCaptionsTabTables.this.mlsTable == null) {
                    row.set(1, MLSCaptionsTabTables.this.none);
                    continue;
                }
                row.set(1, MLSCaptionsTabTables.this.useCube);
            }
            this.tableCount = 0;
            this.fireTableRowsUpdated(0, this.m_lData.size());
        }

        public void updateTableNames() {
            TableCellEditor ce = MLSCaptionsTabTables.this.dimTables.getCellEditor();
            if (ce != null) {
                ce.stopCellEditing();
            }
            int firstRow = -1;
            int lastRow = -1;
            for (int i = 0; i < this.m_lData.size(); ++i) {
                ArrayList row = (ArrayList)this.m_lData.get(i);
                String tableName = (String)row.get(1);
                if (!MLSCaptionsTabTables.this.none.equals(tableName) && !MLSCaptionsTabTables.this.useCube.equals(tableName)) continue;
                tableName = MLSCaptionsTabTables.this.mlsTable == null ? MLSCaptionsTabTables.this.none : MLSCaptionsTabTables.this.useCube;
                row.set(1, tableName);
                if (firstRow == -1) {
                    firstRow = i;
                }
                if (i <= lastRow) continue;
                lastRow = i;
            }
            this.fireTableRowsUpdated(firstRow, lastRow);
        }

        public boolean isDimTableSpecified() {
            return this.tableCount > 0;
        }

        private void createColumnDefinitions() {
            this.m_aColumns = new WsAbstractTableColumn[this.getColumnCount() + this.getHiddenColumnCount()];
            this.m_aColumns[0] = new WsStringTableColumn(0, bundle.getString("CubeDesigner.MLSCaptions.dimTable.Dimension.header.title"), 100);
            this.m_aColumns[0].setEditable(false);
            this.m_aColumns[0].setCellRenderer((TableCellRenderer)((Object)new DisabledColumnRenderer()));
            this.m_aColumns[1] = new WsStringTableColumn(1, bundle.getString("CubeDesigner.MLSCaptions.dimTable.Table.header.title"), 200);
            WsDialogTableCellEditor cellEditor = new WsDialogTableCellEditor();
            cellEditor.setDialog((WsDialogTableCellEditorInterface)new TableSelectionEditor());
            cellEditor.setClicksToStart(1);
            cellEditor.setStopEditingOnDialogClose(true);
            cellEditor.setTextEditable(false);
            this.m_aColumns[1].setCellEditor((TableCellEditor)cellEditor);
            this.m_aColumns[1].setCellRenderer((TableCellRenderer)((Object)new MemberValueCellRenderer()));
            this.m_aColumns[2] = new WsObjectTableColumn();
            this.m_aColumns[3] = new WsObjectTableColumn();
        }

        public int getColumnCount() {
            return 2;
        }

        public int getHiddenColumnCount() {
            return 2;
        }

        public void moveDataToModel() throws MdException, RemoteException {
            int nRows = this.m_lData.size();
            if (nRows > 0) {
                this.m_lData.clear();
                this.fireTableRowsDeleted(0, nRows - 1);
            }
            nRows = 0;
            this.tableCount = 0;
            try {
                OLAPList dims = MLSCaptionsTabTables.this.olapCube.getDimensionSet().getCubeDimensions();
                dims.sort();
                for (int dimNum = 0; dimNum < dims.size(); ++dimNum) {
                    OLAPDimension dim = (OLAPDimension)dims.get(dimNum);
                    ArrayList<String> alRow = new ArrayList<String>(this.getColumnCount() + this.getHiddenColumnCount());
                    alRow.add(0, dim.getName());
                    MLSCaptionTable dimTable = dim.getMLSCaptionTable();
                    String tableName = "";
                    tableName = MLSCaptionsTabTables.this.mlsTable != null ? MLSCaptionsTabTables.this.useCube : MLSCaptionsTabTables.this.none;
                    if (dimTable != null) {
                        tableName = dimTable.getSASTableName();
                    }
                    if (!(MLSCaptionsTabTables.this.useCube.equals(tableName) || MLSCaptionsTabTables.this.none.equals(tableName) || ModelUtilities.isBlank((String)tableName))) {
                        ++this.tableCount;
                    }
                    alRow.add(1, tableName);
                    alRow.add(2, (String)dim);
                    alRow.add(3, (String)dimTable);
                    this.m_lData.add(alRow);
                }
            }
            catch (OLAPException e) {
                ExceptionHandler.handleException((Exception)((Object)e));
            }
            nRows = this.m_lData.size();
            if (nRows > 0) {
                this.fireTableRowsInserted(0, nRows - 1);
            }
            this.m_nRowInstances = nRows;
        }

        public void moveDataToStore() throws MdException, RemoteException {
        }

        public void populateStore() throws MdException, RemoteException {
        }
    }

    private class CubeTableCheckBoxListener
    implements ActionListener {
        private CubeTableCheckBoxListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                int choice = 0;
                if (!MLSCaptionsTabTables.this.cubeCaptionTable.getText().equals(MLSCaptionsTabTables.this.none) || MLSCaptionsTabTables.this.dimTablesModel.isDimTableSpecified()) {
                    choice = MessageUtil.displayMessage((String)bundle.getString("CubeDesigner.MLSCaptions.confirmRemoveCubeTable.txt"), (String)bundle.getString("CubeDesigner.MLSCaptions.Messages.window.title"), (int)1, (int)0);
                }
                if (choice == 0) {
                    if (!MLSCaptionsTabTables.this.cubeTableCheckBox.isSelected()) {
                        MLSCaptionsTabTables.this.olapCube.removeAllIds();
                        MLSCaptionsTabTables.this.tabber.setTabEnabled(1, false);
                        MLSCaptionsTabTables.this.olapCube.setMLSCaptionTable(null);
                        MLSCaptionsTabTables.this.mlsTable = null;
                        MLSCaptionsTabTables.this.cubeCaptionTable.setText(MLSCaptionsTabTables.this.none);
                        MLSCaptionsTabTables.this.dimTablesModel.removeAllTables();
                        MLSCaptionsTabTables.this.dimTablesModel.updateTableNames();
                    }
                    MLSCaptionsTabTables.this.tableLabel.setEnabled(MLSCaptionsTabTables.this.cubeTableCheckBox.isSelected());
                    MLSCaptionsTabTables.this.cubeCaptionTable.setEnabled(MLSCaptionsTabTables.this.cubeTableCheckBox.isSelected());
                    MLSCaptionsTabTables.this.selectCubeTable.setEnabled(MLSCaptionsTabTables.this.cubeTableCheckBox.isSelected());
                    MLSCaptionsTabTables.this.dimTables.setEditable(MLSCaptionsTabTables.this.cubeTableCheckBox.isSelected());
                    MLSCaptionsTabTables.this.dimTables.setSortingEnabled(MLSCaptionsTabTables.this.cubeTableCheckBox.isSelected());
                    MLSCaptionsTabTables.this.dimTables.setRowsReorderable(MLSCaptionsTabTables.this.cubeTableCheckBox.isSelected());
                    MLSCaptionsTabTables.this.dimTables.revalidate();
                    MLSCaptionsTabTables.this.cubeInstructions.setEnabled(MLSCaptionsTabTables.this.cubeTableCheckBox.isSelected());
                    MLSCaptionsTabTables.this.dimInstructions.setEnabled(MLSCaptionsTabTables.this.cubeTableCheckBox.isSelected());
                } else {
                    MLSCaptionsTabTables.this.cubeTableCheckBox.setSelected(true);
                }
            }
            catch (OLAPException ex) {
                ExceptionHandler.handleException((Exception)((Object)ex));
            }
        }
    }

    private class SelectCubeTableListener
    implements ActionListener {
        private SelectCubeTableListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PhysicalTable table = null;
            if (MLSCaptionsTabTables.this.mlsTable != null) {
                table = MLSCaptionsTabTables.this.mlsTable.getTable();
            }
            TableSelectorDialog dialog = new TableSelectorDialog((Dialog)MLSCaptionsTabTables.this.parentDialog, bundle.getString("CubeDesigner.MLSCaptions.TableSeletor.window.title"), true, table, null);
            dialog.setResizable(true);
            dialog.setHelpProduct("olapadmin");
            dialog.setHelpTopic("select_table_generic");
            dialog.show();
            PhysicalTable selectedTable = dialog.getSelectedTable();
            try {
                if (dialog.getReturnValue() == 1) {
                    if (selectedTable != null) {
                        String name = selectedTable.getName();
                        MLSCaptionsTabTables.this.cubeCaptionTable.setText(name);
                        MLSCaptionsTabTables.this.olapCube.setMLSCaptionTable(MLSCaptionsTabTables.this.tableSet.getMLSCaptionTable(selectedTable));
                        MLSCaptionsTabTables.this.mlsTable = MLSCaptionsTabTables.this.tableSet.getMLSCaptionTable(selectedTable);
                        MLSCaptionsTabTables.this.tabber.setTabEnabled(1, true);
                    } else {
                        MLSCaptionsTabTables.this.cubeCaptionTable.setText(MLSCaptionsTabTables.this.none);
                        MLSCaptionsTabTables.this.olapCube.setMLSCaptionTable(null);
                        MLSCaptionsTabTables.this.mlsTable = null;
                        if (MLSCaptionsTabTables.this.dimTablesModel.isDimTableSpecified()) {
                            MLSCaptionsTabTables.this.tabber.setTabEnabled(1, true);
                        } else {
                            MLSCaptionsTabTables.this.tabber.setTabEnabled(1, false);
                        }
                    }
                    MLSCaptionsTabTables.this.dimTablesModel.updateTableNames();
                    MLSCaptionsTabTables.this.olapCube.removeOnlyCubeIds();
                    OLAPList dims = MLSCaptionsTabTables.this.olapCube.getDimensionSet().getCubeDimensions();
                    for (int dimNum = 0; dimNum < dims.size(); ++dimNum) {
                        OLAPDimension dim = (OLAPDimension)dims.get(dimNum);
                        MLSCaptionTable dimTable = dim.getMLSCaptionTable();
                        if (dimTable != null) continue;
                        dim.removeDimensionIds();
                    }
                }
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
            catch (OLAPException ex) {
                ExceptionHandler.handleException((Exception)((Object)ex));
            }
        }
    }

    private class DisabledColumnHeaderRenderer
    extends WsDefaultTableColumnHeaderRenderer {
        private static final long serialVersionUID = 1L;

        private DisabledColumnHeaderRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int rowIndex, int vColIndex) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, rowIndex, vColIndex);
            WsTable t = (WsTable)table;
            this.setEnabled(t.isEditable());
            return this;
        }
    }

    private class DisabledColumnRenderer
    extends WsDefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        private DisabledColumnRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean bSelected, boolean bFocused, int row, int column) {
            super.getTableCellRendererComponent(table, value, bSelected, bFocused, row, column);
            WsTable t = (WsTable)table;
            this.setEnabled(t.isEditable());
            return this;
        }
    }

    private class TableSelectorDialog
    extends WAStandardDialog {
        private static final long serialVersionUID = 1L;
        private PhysicalTableSelector tree;

        public TableSelectorDialog(Dialog dlgOwner, String title, boolean modal, PhysicalTable currentTable, OLAPDimension dim) {
            super(dlgOwner, title, modal);
            this.tree = dim != null ? new PhysicalTableSelector((AbstractOLAPModel)dim, 1, true, false, true, false, false) : new PhysicalTableSelector((AbstractOLAPModel)MLSCaptionsTabTables.this.olapCube, 1, true, false, true, false, false);
            this.tree.setPreferredSize(new Dimension(600, 400));
            if (currentTable != null) {
                this.tree.initializeSelectedTable(currentTable);
            }
            this.setMainPanel(this.tree);
        }

        public PhysicalTable getSelectedTable() {
            return this.tree.getSelectedTable();
        }
    }

    private class TableSelectionEditor
    implements WsDialogTableCellEditorInterface {
        private TableSelectionEditor() {
        }

        public String showDialog(JTable tbl, int row, int col, String value) {
            PhysicalTable table = null;
            OLAPDimension dim = (OLAPDimension)MLSCaptionsTabTables.this.dimTablesModel.getValueAt(row, 2);
            MLSCaptionTable dimMlsTable = (MLSCaptionTable)MLSCaptionsTabTables.this.dimTablesModel.getValueAt(row, 3);
            if (dimMlsTable != null) {
                table = dimMlsTable.getTable();
            }
            TableSelectorDialog dialog = new TableSelectorDialog((Dialog)MLSCaptionsTabTables.this.parentDialog, bundle.getString("CubeDesigner.MLSCaptions.TableSeletor.window.title"), true, table, dim);
            dialog.setResizable(true);
            dialog.setHelpProduct("olapadmin");
            dialog.setHelpTopic("select_table_generic");
            dialog.show();
            String name = (String)MLSCaptionsTabTables.this.dimTablesModel.getValueAt(row, 1);
            if (dialog.getReturnValue() == 1) {
                try {
                    PhysicalTable selectedTable = dialog.getSelectedTable();
                    if (selectedTable != null) {
                        name = selectedTable.getName();
                        dimMlsTable = MLSCaptionsTabTables.this.tableSet.getMLSCaptionTable(selectedTable, dim);
                        dim.setMLSCaptionTable(dimMlsTable);
                        MLSCaptionsTabTables.this.dimTablesModel.setValueAt(dimMlsTable, row, 3);
                        MLSCaptionsTabTables.this.dimTablesModel.tableCount++;
                        MLSCaptionsTabTables.this.tabber.setTabEnabled(1, true);
                    } else {
                        if (MLSCaptionsTabTables.this.mlsTable != null) {
                            name = MLSCaptionsTabTables.this.useCube;
                            MLSCaptionsTabTables.this.tabber.setTabEnabled(1, true);
                        } else {
                            name = MLSCaptionsTabTables.this.none;
                            MLSCaptionsTabTables.this.tabber.setTabEnabled(1, false);
                        }
                        dim.setMLSCaptionTable(null);
                        MLSCaptionsTabTables.this.dimTablesModel.setValueAt(null, row, 3);
                        MLSCaptionsTabTables.this.dimTablesModel.tableCount--;
                        dim.removeDimensionIds();
                    }
                }
                catch (RemoteException e) {
                    Workspace.handleRemoteException((RemoteException)e);
                }
                catch (OLAPException e) {
                    ExceptionHandler.handleException((Exception)((Object)e));
                }
            }
            return name;
        }
    }

    private class MemberValueCellRenderer
    extends WsDefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        private MemberValueCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean bSelected, boolean bFocused, int row, int column) {
            super.getTableCellRendererComponent(table, value, bSelected, bFocused, row, column);
            WsTable t = (WsTable)table;
            this.setEnabled(t.isEditable());
            JPanel pnl = new JPanel(new BorderLayout());
            pnl.add((Component)((Object)this), "Center");
            pnl.setBackground(table.getBackground());
            if (table.isCellEditable(row, column)) {
                JButton btn = WsUIUtilities.createBrowseButton();
                btn.setEnabled(true);
                pnl.add((Component)btn, "East");
            }
            pnl.setEnabled(t.isEditable());
            return pnl;
        }
    }
}

