/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.designer.visuals;

import com.sas.metadata.remote.MdException;
import com.sas.olapadmin.designer.model.AbstractOLAPModel;
import com.sas.olapadmin.designer.model.DefinedMemberSet;
import com.sas.olapadmin.designer.model.DimensionSet;
import com.sas.olapadmin.designer.model.MLSCaptionTable;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPDefinedMember;
import com.sas.olapadmin.designer.model.OLAPDimension;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPHierarchy;
import com.sas.olapadmin.designer.model.OLAPLevel;
import com.sas.olapadmin.designer.model.OLAPList;
import com.sas.olapadmin.designer.model.OLAPMeasure;
import com.sas.olapadmin.designer.model.OLAPMemberProperty;
import com.sas.olapadmin.designer.visuals.MLSCaptionsTab;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WATextArea;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractTableColumn;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsIntegerTableColumn;
import com.sas.workspace.WsObjectTableColumn;
import com.sas.workspace.WsStringTableColumn;
import com.sas.workspace.WsTable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.table.TableCellEditor;

public class MLSCaptionsTabIdentifiers
extends WAPropertyTab {
    private static final long serialVersionUID = 1L;
    private static final WAdminResource bundle = new WAdminResource(MLSCaptionsTabIdentifiers.class);
    private WsTable idTable;
    private OLAPCube olapCube;
    private IdCaptionTableModel tableModel;
    private HashMap idsByTable;

    public MLSCaptionsTabIdentifiers(OLAPCube olapCube, MLSCaptionsTab.CaptionsTabber tabber) {
        this.olapCube = olapCube;
        this.idsByTable = new HashMap();
        this.layoutWidgets();
        this.setHelpProduct("olapadmin");
        this.setHelpTopic("caption_identifiers");
    }

    public boolean doesTableHaveIds(String tableName) {
        boolean tableHasId = false;
        try {
            if (this.idsByTable.isEmpty()) {
                this.tableModel.moveDataToModel();
            }
            if (this.idsByTable.containsKey(tableName)) {
                List tableIds = (List)this.idsByTable.get(tableName);
                tableHasId = tableIds.size() > 0;
            }
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
        }
        catch (MdException e) {
            ExceptionHandler.handleException((Exception)((Object)e));
        }
        return tableHasId;
    }

    public void moveDataToView() throws MdException, RemoteException {
        this.tableModel.moveDataToModel();
    }

    public void populateStore() throws MdException, RemoteException {
        this.setStorePopulated(true);
    }

    public boolean validateData() {
        TableCellEditor ce = this.idTable.getCellEditor();
        if (ce != null) {
            ce.stopCellEditing();
        }
        boolean tableError = this.tableModel.isInError();
        this.tableModel.resetError();
        return !tableError;
    }

    protected void layoutWidgets() {
        this.setLayout(new GridBagLayout());
        WATextArea identifierInstructions = new WATextArea(bundle.getString("CubeDesigner.MLSCaptions.Identifiers.instructions.txt"));
        JLabel l = new JLabel();
        identifierInstructions.setFont(l.getFont());
        identifierInstructions.setBehavior(1);
        identifierInstructions.setBackground((Color)SystemColor.control);
        identifierInstructions.setAutosize(true);
        this.add((Component)identifierInstructions, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.tableModel = new IdCaptionTableModel();
        this.idTable = new WsTable((WsAbstractTableModel)this.tableModel);
        this.idTable.setSortingEnabled(true);
        this.idTable.setColumnHidingEnabled(false);
        this.idTable.setColumnsReorderable(false);
        this.idTable.setRowHoldingEnabled(false);
        this.idTable.setColumnHeaderPopupMenuEnabled(false);
        this.idTable.setOriginPopupMenuEnabled(false);
        this.idTable.setPopupMenuEnabled(false);
        this.idTable.setRowHeaderPopupMenuEnabled(false);
        this.idTable.setTablePopupMenuEnabled(false);
        this.idTable.setViewportPopupMenuEnabled(false);
        this.idTable.setPreferredScrollableViewportSize(new Dimension(75, 100));
        this.idTable.setAutoResizeMode(0);
        this.idTable.setNonEditableCellBackground(UIManager.getColor("TextField.inactiveBackground"));
        JScrollPane topPanel = new JScrollPane((Component)this.idTable);
        this.add(topPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    private class IdCaptionTableModel
    extends WsAbstractTableModel {
        private static final long serialVersionUID = 1L;
        public static final int COMPONENT = 2;
        public static final int TYPE = 3;
        public static final int ID = 0;
        public static final int TABLE = 1;
        public static final int OBJECT = 4;
        private static final int TOTAL_COLS = 4;
        private static final int TOTAL_HIDDEN_COLS = 1;
        private String none;
        private boolean tableModelError;

        public IdCaptionTableModel() {
            this.createColumnDefinitions();
            this.none = bundle.getString("CubeDesigner.MLSCaptions.cubeTable.none.txt");
        }

        protected void createColumnDefinitions() {
            this.m_aColumns = new WsAbstractTableColumn[this.getColumnCount() + this.getHiddenColumnCount()];
            this.m_aColumns[0] = new WsIntegerTableColumn(0, bundle.getString("CubeDesigner.MLSCaptions.identifier.header.title"), 100);
            ((WsIntegerTableColumn)this.m_aColumns[0]).setAllowNegative(false);
            ((WsIntegerTableColumn)this.m_aColumns[0]).setMissingValue(Integer.valueOf(Integer.MIN_VALUE));
            ((WsIntegerTableColumn)this.m_aColumns[0]).setMinimumValue(1);
            this.m_aColumns[1] = new WsStringTableColumn(1, bundle.getString("CubeDesigner.MLSCaptions.table.header.title"), 100, 32);
            this.m_aColumns[1].setEditable(false);
            this.m_aColumns[2] = new WsStringTableColumn(2, bundle.getString("CubeDesigner.MLSCaptions.cubeComponent.header.title"), 100, 32);
            this.m_aColumns[2].setEditable(false);
            this.m_aColumns[3] = new WsStringTableColumn(3, bundle.getString("CubeDesigner.MLSCaptions.componentType.header.title"), 100, 32);
            this.m_aColumns[3].setEditable(false);
            this.m_aColumns[this.getColumnCount()] = new WsObjectTableColumn();
        }

        public int getColumnCount() {
            return 4;
        }

        public int getHiddenColumnCount() {
            return 1;
        }

        public void moveDataToModel() throws MdException, RemoteException {
            int nRows = this.m_lData.size();
            if (nRows > 0) {
                this.m_lData.clear();
                MLSCaptionsTabIdentifiers.this.idsByTable.clear();
                this.fireTableRowsDeleted(0, nRows - 1);
            }
            try {
                ArrayList<Object> alRow = new ArrayList<Object>(this.getColumnCount() + this.getHiddenColumnCount());
                Integer mlsid = MLSCaptionsTabIdentifiers.this.olapCube.getMLSID();
                if (mlsid == null) {
                    mlsid = Integer.MIN_VALUE;
                }
                MLSCaptionTable cubeTable = MLSCaptionsTabIdentifiers.this.olapCube.getMLSCaptionTable();
                String cubeTableName = "";
                cubeTableName = cubeTable != null ? cubeTable.getSASTableName() : this.none;
                alRow.add(0, mlsid);
                alRow.add(1, cubeTableName);
                ArrayList ids = null;
                if (!this.none.equals(cubeTableName)) {
                    if (!MLSCaptionsTabIdentifiers.this.idsByTable.containsKey(cubeTableName)) {
                        ids = new ArrayList();
                        MLSCaptionsTabIdentifiers.this.idsByTable.put(cubeTableName, ids);
                    } else {
                        ids = (ArrayList)MLSCaptionsTabIdentifiers.this.idsByTable.get(cubeTableName);
                    }
                    if (mlsid != null && !mlsid.equals(Integer.MIN_VALUE)) {
                        ids.add(mlsid);
                    }
                }
                alRow.add(2, MLSCaptionsTabIdentifiers.this.olapCube.getName());
                alRow.add(3, bundle.getString("CubeDesigner.MLSCaptions.cubeType.txt"));
                alRow.add(4, MLSCaptionsTabIdentifiers.this.olapCube);
                this.m_lData.add(alRow);
                DimensionSet dimSet = MLSCaptionsTabIdentifiers.this.olapCube.getDimensionSet();
                OLAPList dims = dimSet.getCubeDimensions();
                dims.sort();
                for (int dimNum = 0; dimNum < dims.size(); ++dimNum) {
                    alRow = new ArrayList(this.getColumnCount() + this.getHiddenColumnCount());
                    OLAPDimension dim = (OLAPDimension)dims.get(dimNum);
                    mlsid = dim.getMLSID();
                    if (mlsid == null) {
                        mlsid = Integer.MIN_VALUE;
                    }
                    alRow.add(0, mlsid);
                    MLSCaptionTable dimTable = dim.getMLSCaptionTable();
                    if (dimTable == null) {
                        dimTable = cubeTable;
                    }
                    String dimTableName = "";
                    dimTableName = dimTable == null ? this.none : dimTable.getSASTableName();
                    if (!this.none.equals(dimTableName)) {
                        if (!MLSCaptionsTabIdentifiers.this.idsByTable.containsKey(dimTableName)) {
                            ids = new ArrayList();
                            MLSCaptionsTabIdentifiers.this.idsByTable.put(dimTableName, ids);
                        } else {
                            ids = (ArrayList)MLSCaptionsTabIdentifiers.this.idsByTable.get(dimTableName);
                        }
                        if (mlsid != null && !mlsid.equals(Integer.MIN_VALUE)) {
                            ids.add(mlsid);
                        }
                    }
                    alRow.add(1, dimTableName);
                    alRow.add(2, dim.getName());
                    alRow.add(3, bundle.getString("CubeDesigner.MLSCaptions.dimensionType.txt"));
                    alRow.add(4, dim);
                    this.m_lData.add(alRow);
                    OLAPList hiers = dim.getHierarchies();
                    hiers.sort();
                    for (int hierNum = 0; hierNum < hiers.size(); ++hierNum) {
                        alRow = new ArrayList(this.getColumnCount() + this.getHiddenColumnCount());
                        OLAPHierarchy hier = (OLAPHierarchy)hiers.get(hierNum);
                        mlsid = hier.getMLSID();
                        if (mlsid == null) {
                            mlsid = Integer.MIN_VALUE;
                        }
                        alRow.add(0, mlsid);
                        alRow.add(1, dimTableName);
                        if (!this.none.equals(dimTableName)) {
                            if (!MLSCaptionsTabIdentifiers.this.idsByTable.containsKey(dimTableName)) {
                                ids = new ArrayList();
                                MLSCaptionsTabIdentifiers.this.idsByTable.put(dimTableName, ids);
                            } else {
                                ids = (ArrayList)MLSCaptionsTabIdentifiers.this.idsByTable.get(dimTableName);
                            }
                            if (mlsid != null && !mlsid.equals(Integer.MIN_VALUE)) {
                                ids.add(mlsid);
                            }
                        }
                        alRow.add(2, hier.getName());
                        alRow.add(3, bundle.getString("CubeDesigner.MLSCaptions.hierarchyType.txt"));
                        alRow.add(4, hier);
                        this.m_lData.add(alRow);
                        alRow = new ArrayList(this.getColumnCount() + this.getHiddenColumnCount());
                        String allMember = hier.getAllMember();
                        mlsid = hier.getAllMemberMLSID();
                        if (mlsid == null) {
                            mlsid = Integer.MIN_VALUE;
                        }
                        alRow.add(0, mlsid);
                        alRow.add(1, dimTableName);
                        if (!this.none.equals(dimTableName)) {
                            if (!MLSCaptionsTabIdentifiers.this.idsByTable.containsKey(dimTableName)) {
                                ids = new ArrayList();
                                MLSCaptionsTabIdentifiers.this.idsByTable.put(dimTableName, ids);
                            } else {
                                ids = (ArrayList)MLSCaptionsTabIdentifiers.this.idsByTable.get(dimTableName);
                            }
                            if (mlsid != null && !mlsid.equals(Integer.MIN_VALUE)) {
                                ids.add(mlsid);
                            }
                        }
                        alRow.add(2, allMember);
                        alRow.add(3, bundle.getString("CubeDesigner.MLSCaptions.allMemberType.txt"));
                        alRow.add(4, hier);
                        this.m_lData.add(alRow);
                    }
                    OLAPList levels = dim.getLevels();
                    levels.sort();
                    for (int levNum = 0; levNum < levels.size(); ++levNum) {
                        alRow = new ArrayList(this.getColumnCount() + this.getHiddenColumnCount());
                        OLAPLevel level = (OLAPLevel)levels.get(levNum);
                        mlsid = level.getMLSID();
                        if (mlsid == null) {
                            mlsid = Integer.MIN_VALUE;
                        }
                        alRow.add(0, mlsid);
                        alRow.add(1, dimTableName);
                        if (!this.none.equals(dimTableName)) {
                            if (!MLSCaptionsTabIdentifiers.this.idsByTable.containsKey(dimTableName)) {
                                ids = new ArrayList();
                                MLSCaptionsTabIdentifiers.this.idsByTable.put(dimTableName, ids);
                            } else {
                                ids = (ArrayList)MLSCaptionsTabIdentifiers.this.idsByTable.get(dimTableName);
                            }
                            if (mlsid != null && !mlsid.equals(Integer.MIN_VALUE)) {
                                ids.add(mlsid);
                            }
                        }
                        alRow.add(2, level.getName());
                        alRow.add(3, bundle.getString("CubeDesigner.MLSCaptions.levelType.txt"));
                        alRow.add(4, level);
                        this.m_lData.add(alRow);
                        OLAPList mbrProps = level.getOLAPProperties();
                        mbrProps.sort();
                        for (int mbrNum = 0; mbrNum < mbrProps.size(); ++mbrNum) {
                            alRow = new ArrayList(this.getColumnCount() + this.getHiddenColumnCount());
                            OLAPMemberProperty mbr = (OLAPMemberProperty)mbrProps.get(mbrNum);
                            mlsid = mbr.getMLSID();
                            if (mlsid == null) {
                                mlsid = Integer.MIN_VALUE;
                            }
                            alRow.add(0, mlsid);
                            alRow.add(1, dimTableName);
                            if (!this.none.equals(dimTableName)) {
                                if (!MLSCaptionsTabIdentifiers.this.idsByTable.containsKey(dimTableName)) {
                                    ids = new ArrayList();
                                    MLSCaptionsTabIdentifiers.this.idsByTable.put(dimTableName, ids);
                                } else {
                                    ids = (ArrayList)MLSCaptionsTabIdentifiers.this.idsByTable.get(dimTableName);
                                }
                                if (mlsid != null && !mlsid.equals(Integer.MIN_VALUE)) {
                                    ids.add(mlsid);
                                }
                            }
                            alRow.add(2, mbr.getName());
                            alRow.add(3, bundle.getString("CubeDesigner.MLSCaptions.memberPropertyType.txt"));
                            alRow.add(4, mbr);
                            this.m_lData.add(alRow);
                        }
                    }
                    DefinedMemberSet definedMembers = MLSCaptionsTabIdentifiers.this.olapCube.getDefinedMemberSet();
                    OLAPList dimsDefinedMbrs = definedMembers.getCalculatedMembersByDimension(dim);
                    dimsDefinedMbrs.sort();
                    for (int defMbrNum = 0; defMbrNum < dimsDefinedMbrs.size(); ++defMbrNum) {
                        alRow = new ArrayList(this.getColumnCount() + this.getHiddenColumnCount());
                        OLAPDefinedMember mbr = (OLAPDefinedMember)dimsDefinedMbrs.get(defMbrNum);
                        mlsid = mbr.getMLSID();
                        if (mlsid == null) {
                            mlsid = Integer.MIN_VALUE;
                        }
                        alRow.add(0, mlsid);
                        alRow.add(1, cubeTableName);
                        if (!this.none.equals(cubeTableName)) {
                            if (!MLSCaptionsTabIdentifiers.this.idsByTable.containsKey(cubeTableName)) {
                                ids = new ArrayList();
                                MLSCaptionsTabIdentifiers.this.idsByTable.put(cubeTableName, ids);
                            } else {
                                ids = (ArrayList)MLSCaptionsTabIdentifiers.this.idsByTable.get(cubeTableName);
                            }
                            if (mlsid != null && !mlsid.equals(Integer.MIN_VALUE)) {
                                ids.add(mlsid);
                            }
                        }
                        alRow.add(2, mbr.getName());
                        alRow.add(3, bundle.getString("CubeDesigner.MLSCaptions.calcMemberType.txt"));
                        alRow.add(4, mbr);
                        this.m_lData.add(alRow);
                    }
                }
                OLAPList measures = MLSCaptionsTabIdentifiers.this.olapCube.getMeasureSet().getMeasures();
                OLAPList calcMeasures = MLSCaptionsTabIdentifiers.this.olapCube.getDefinedMemberSet().getCalculatedMeasures();
                ArrayList allMeasures = new ArrayList();
                allMeasures.addAll(measures);
                allMeasures.addAll(calcMeasures);
                Collections.sort(allMeasures);
                for (int measureNum = 0; measureNum < allMeasures.size(); ++measureNum) {
                    alRow = new ArrayList(this.getColumnCount() + this.getHiddenColumnCount());
                    AbstractOLAPModel obj = (AbstractOLAPModel)allMeasures.get(measureNum);
                    mlsid = obj instanceof OLAPDefinedMember ? ((OLAPDefinedMember)obj).getMLSID() : obj.getMLSID();
                    if (mlsid == null) {
                        mlsid = Integer.MIN_VALUE;
                    }
                    alRow.add(0, mlsid);
                    alRow.add(1, cubeTableName);
                    if (!this.none.equals(cubeTableName)) {
                        if (!MLSCaptionsTabIdentifiers.this.idsByTable.containsKey(cubeTableName)) {
                            ids = new ArrayList();
                            MLSCaptionsTabIdentifiers.this.idsByTable.put(cubeTableName, ids);
                        } else {
                            ids = (ArrayList)MLSCaptionsTabIdentifiers.this.idsByTable.get(cubeTableName);
                        }
                        if (mlsid != null && !mlsid.equals(Integer.MIN_VALUE)) {
                            ids.add(mlsid);
                        }
                    }
                    alRow.add(2, obj.getName());
                    if (obj instanceof OLAPMeasure) {
                        alRow.add(3, bundle.getString("CubeDesigner.MLSCaptions.measureType.txt"));
                    } else {
                        alRow.add(3, bundle.getString("CubeDesigner.MLSCaptions.calcMeasureType.txt"));
                    }
                    alRow.add(4, obj);
                    this.m_lData.add(alRow);
                }
            }
            catch (OLAPException e) {
                ExceptionHandler.handleException((Exception)((Object)e));
            }
            nRows = this.m_lData.size();
            if (nRows > 0) {
                this.fireTableRowsInserted(0, nRows - 1);
            }
        }

        public void moveDataToStore() throws MdException, RemoteException {
        }

        public void populateStore() throws MdException, RemoteException {
        }

        public boolean isInError() {
            return this.tableModelError;
        }

        public void resetError() {
            this.tableModelError = false;
        }

        public void setValueAt(Object value, int row, int col) {
            this.tableModelError = false;
            if (col == 0) {
                ArrayList rowObj = (ArrayList)this.m_lData.get(row);
                String tableName = (String)rowObj.get(1);
                Object obj = rowObj.get(4);
                try {
                    if (obj instanceof AbstractOLAPModel) {
                        ArrayList ids = null;
                        if (MLSCaptionsTabIdentifiers.this.idsByTable.containsKey(tableName)) {
                            ids = (ArrayList)MLSCaptionsTabIdentifiers.this.idsByTable.get(tableName);
                        } else {
                            ids = new ArrayList();
                            MLSCaptionsTabIdentifiers.this.idsByTable.put(tableName, ids);
                        }
                        AbstractOLAPModel olapObj = (AbstractOLAPModel)obj;
                        String type = (String)rowObj.get(3);
                        String allMbrTypeString = bundle.getString("CubeDesigner.MLSCaptions.allMemberType.txt");
                        if (allMbrTypeString.equals(type)) {
                            OLAPHierarchy hier = (OLAPHierarchy)olapObj;
                            Integer oldMlsid = hier.getAllMemberMLSID();
                            if (oldMlsid != null) {
                                ids.remove(oldMlsid);
                            }
                            if (value != null && !value.equals(Integer.MIN_VALUE)) {
                                hier.setAllMemberMLSID((Integer)value);
                                ids.add((Integer)value);
                            } else {
                                hier.setAllMemberMLSID(null);
                            }
                        } else {
                            Integer oldMlsid = null;
                            oldMlsid = olapObj instanceof OLAPDefinedMember ? ((OLAPDefinedMember)olapObj).getMLSID() : olapObj.getMLSID();
                            if (oldMlsid != null) {
                                ids.remove(oldMlsid);
                            }
                            if (value != null && !value.equals(Integer.MIN_VALUE)) {
                                if (olapObj instanceof OLAPDefinedMember) {
                                    ((OLAPDefinedMember)olapObj).setMLSID((Integer)value);
                                } else {
                                    olapObj.setMLSID((Integer)value);
                                }
                                ids.add((Integer)value);
                            } else {
                                olapObj.setMLSID(null);
                            }
                        }
                    }
                }
                catch (OLAPException e) {
                    ExceptionHandler.handleException((Exception)((Object)e));
                }
            }
            super.setValueAt(value, row, col);
        }

        public boolean isCellEditable(int row, int col) {
            boolean editable = super.isCellEditable(row, col);
            if (col == 0) {
                ArrayList rowobjs = (ArrayList)this.m_lData.get(row);
                String tablename = (String)rowobjs.get(1);
                editable = !this.none.equals(tablename);
            }
            return editable;
        }
    }
}

