/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.designer.visuals;

import com.sas.metadata.remote.MdException;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.visuals.MLSCaptionsTabIdentifiers;
import com.sas.olapadmin.designer.visuals.MLSCaptionsTabTables;
import com.sas.workspace.WATabbedPanel;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsDescriptionWizardTab;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.rmi.RemoteException;
import javax.swing.JTabbedPane;

public class MLSCaptionsTab
extends WsDescriptionWizardTab {
    private static final long serialVersionUID = 1L;
    private static final WAdminResource bundle = new WAdminResource(MLSCaptionsTab.class);
    private OLAPCube olapCube;
    private CaptionsTabber tabber;
    private MLSCaptionsTabTables tablesTab;
    private MLSCaptionsTabIdentifiers idTab;

    public MLSCaptionsTab(OLAPCube cube) {
        super(bundle.getString("CubeDesigner.MLSCaptions.Instructions.txt"));
        this.olapCube = cube;
        this.layoutWidgets();
    }

    public boolean doDataExchange(boolean saveToModel) throws MdException, RemoteException {
        if (saveToModel) {
            this.tabber.moveDataToStore();
        } else {
            this.tabber.populateStore();
            this.tabber.moveDataToView();
        }
        return true;
    }

    public String getHelpProduct() {
        return this.tabber.getHelpProduct();
    }

    public String getHelpTopic() {
        return this.tabber.getHelpTopic();
    }

    public boolean validateData() {
        boolean dataOK = this.tabber.validateData();
        if (dataOK) {
            dataOK = this.tablesTab.verifyTabData();
        }
        return dataOK;
    }

    protected void layoutWidgets() {
        this.setLayout(new GridBagLayout());
        this.tabber = new CaptionsTabber();
        this.tablesTab = new MLSCaptionsTabTables(this.olapCube, this.tabber);
        this.tabber.addTab(bundle.getString("CubeDesigner.MLSCaptions.Tables.tab.title"), this.tablesTab);
        this.idTab = new MLSCaptionsTabIdentifiers(this.olapCube, this.tabber);
        this.tabber.addTab(bundle.getString("CubeDesigner.MLSCaptions.Identifiers.tab.title"), this.idTab);
        this.add((Component)((Object)this.tabber), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    class CaptionsTabber
    extends WATabbedPanel {
        private static final long serialVersionUID = 1L;

        CaptionsTabber() {
        }

        public void setTabEnabled(int i, boolean state) {
            JTabbedPane tabPane = (JTabbedPane)this.m_Tabs.getComponent();
            tabPane.setEnabledAt(i, state);
        }
    }
}

