/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.designer.visuals;

import com.sas.graphics.map.ESRIConnection;
import com.sas.graphics.map.ESRIException;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Property;
import com.sas.olapadmin.designer.model.OLAPColumn;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPLevel;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsAbstractTableColumn;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsStringTableColumn;
import java.rmi.RemoteException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;

public class ESRITestTableModel
extends WsAbstractTableModel {
    private static final long serialVersionUID = 1L;
    private static WAdminResource bundle = new WAdminResource(ESRITestTableModel.class);
    public static final int LEVEL = 0;
    public static final int LAYER = 1;
    public static final int MAPID = 2;
    public static final int CUBEID = 3;
    public static final int MATCH = 4;
    public static final int SUGGEST = 5;
    private ResultSet resultSet;
    private ESRIConnection esriConnection;
    private Object[][] layers;
    private DefaultListModel levelModel;
    private static final int TOTAL_COLS = 6;
    private static final int TOTAL_HIDDEN_COLS = 0;

    public ESRITestTableModel(ResultSet results, ESRIConnection connection, Object[][] levelLayers, DefaultListModel levelsModel) {
        this.resultSet = results;
        this.esriConnection = connection;
        this.layers = levelLayers;
        this.levelModel = levelsModel;
        this.createColumnDefinitions();
    }

    private void createColumnDefinitions() {
        this.m_aColumns = new WsAbstractTableColumn[this.getColumnCount() + this.getHiddenColumnCount()];
        this.m_aColumns[0] = new WsStringTableColumn(0, bundle.getString("ESRITestTableModel.Level.header.title"), 100, 32);
        this.m_aColumns[0].setEditable(false);
        this.m_aColumns[1] = new WsStringTableColumn(1, bundle.getString("ESRITestTableModel.Layer.header.title"), 100, 32);
        this.m_aColumns[1].setEditable(false);
        this.m_aColumns[2] = new WsStringTableColumn(2, bundle.getString("ESRITestTableModel.Mapid.header.title"), 100, 32);
        this.m_aColumns[2].setEditable(false);
        this.m_aColumns[3] = new WsStringTableColumn(3, bundle.getString("ESRITestTableModel.Cubeid.header.title"), 100, 32);
        this.m_aColumns[3].setEditable(false);
        this.m_aColumns[4] = new WsStringTableColumn(4, bundle.getString("ESRITestTableModel.Match.header.title"), 100, 32);
        this.m_aColumns[4].setEditable(false);
        this.m_aColumns[5] = new WsStringTableColumn(5, bundle.getString("ESRITestTableModel.Suggest.header.title"), 120, 32);
        this.m_aColumns[5].setEditable(false);
    }

    public int getColumnCount() {
        return 6;
    }

    public int getHiddenColumnCount() {
        return 0;
    }

    public void moveDataToModel() throws MdException, RemoteException {
        int nRows = this.m_lData.size();
        if (nRows > 0) {
            this.m_lData.clear();
            this.fireTableRowsDeleted(0, nRows - 1);
        }
        try {
            for (int i = 0; i < this.levelModel.size(); ++i) {
                if (this.resultSet == null || this.layers[i][0] == null || !(this.layers[i][0] instanceof OLAPColumn) || this.layers[i][1] == null || this.layers[i][1] instanceof String || this.layers[i][2] == null || this.layers[i][2] instanceof String) continue;
                ArrayList<String> alRow = new ArrayList<String>(this.getColumnCount() + this.getHiddenColumnCount());
                alRow.add(0, ((OLAPLevel)this.levelModel.elementAt(i)).getName());
                String layerName = ((OLAPColumn)this.layers[i][0]).getSASColumnName();
                alRow.add(1, layerName);
                String fieldName = ((Property)this.layers[i][1]).getPropertyName();
                alRow.add(2, fieldName);
                String cubeIdName = ((OLAPColumn)this.layers[i][2]).getSASColumnName();
                alRow.add(3, ((OLAPColumn)this.layers[i][2]).getSASColumnName());
                ArrayList<String> list = new ArrayList<String>();
                this.resultSet.setFetchSize(1000);
                this.resultSet.beforeFirst();
                while (this.resultSet.next()) {
                    list.add(this.resultSet.getString(cubeIdName));
                }
                Object[] vals = new String[list.size()];
                list.toArray(vals);
                double[] values = this.esriConnection.testData(vals, layerName, fieldName);
                alRow.add(4, String.valueOf(values[0] * 100.0));
                OLAPColumn layer = (OLAPColumn)this.layers[i][0];
                List ids = layer.getProperties();
                String[] possibleIds = new String[ids.size()];
                for (int j = 0; j < ids.size(); ++j) {
                    possibleIds[j] = ids.get(j).toString();
                }
                String suggestedName = this.esriConnection.chooseField(vals, layerName, possibleIds, -1);
                alRow.add(5, suggestedName);
                this.m_lData.add(alRow);
            }
        }
        catch (SQLException e) {
            ExceptionHandler.handleException((Exception)e);
        }
        catch (ESRIException e) {
            ExceptionHandler.handleException((Exception)((Object)e));
        }
        catch (OLAPException e) {
            ExceptionHandler.handleException((Exception)((Object)e));
        }
        nRows = this.m_lData.size();
        if (nRows > 0) {
            this.fireTableRowsInserted(0, nRows - 1);
        }
        this.m_nRowInstances = nRows;
    }

    public void moveDataToStore() throws MdException, RemoteException {
    }

    public void populateStore() throws MdException, RemoteException {
    }
}

