/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.designer.visuals;

import com.sas.olapadmin.designer.model.DimensionSet;
import com.sas.olapadmin.designer.model.ModelUtilities;
import com.sas.olapadmin.designer.model.OLAPColumn;
import com.sas.olapadmin.designer.model.OLAPDimension;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPHierarchy;
import com.sas.olapadmin.designer.model.OLAPLevel;
import com.sas.olapadmin.designer.model.OLAPList;
import com.sas.olapadmin.designer.visuals.DimLevelSuppliedDialog;
import com.sas.olapadmin.designer.visuals.DimLevelSuppliedTableModel;
import com.sas.olapadmin.designer.visuals.VisualUtilities;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.olapadmin.utilities.studio.AggregationPreviewLevelsPanel;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsTable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class DimLevelSuppliedPanel
extends WAPanel {
    private static final long serialVersionUID = 1L;
    protected static WAdminResource bundle = new WAdminResource(DimLevelSuppliedPanel.class);
    private OLAPDimension dimensionModel;
    private WAComboBox inpColumnBox;
    private DimLevelSuppliedTableModel tableModel;
    private WsTable detailsTable;
    private JLabel informatValue;
    private JLabel formatValue;
    private List dateColumns;
    private AggregationPreviewLevelsPanel displayLevels;

    public DimLevelSuppliedPanel(OLAPDimension inDimensionModel, List inDateColumns) {
        this.dimensionModel = inDimensionModel;
        this.dateColumns = inDateColumns;
        this.setLayout(new GridBagLayout());
        this._layoutWidgets();
    }

    public boolean doDataExchange(boolean saveToModel) {
        if (!saveToModel) {
            this.tableModel.setDialog((DimLevelSuppliedDialog)((Object)this.getTopLevelAncestor()));
            Collections.sort(this.dateColumns);
            this.inpColumnBox.addItems(this.dateColumns);
            this.inpColumnBox.addActionListener((ActionListener)new ColumnBoxActionListener());
            if (this.inpColumnBox.getItemCount() > 0) {
                this.inpColumnBox.setSelectedIndex(0);
            }
            this.tableModel.moveDataToModel();
            try {
                OLAPList listOfHierarchies = this.dimensionModel.getHierarchies();
                Collections.sort(listOfHierarchies);
                this.displayLevels.setSelectedHierarchies((List)listOfHierarchies);
            }
            catch (OLAPException oError) {
                ExceptionHandler.handleException((Exception)((Object)oError));
            }
        } else {
            List listOfSelectedRows = this.tableModel.getSelectedCheckboxValues();
            this.createLevels(listOfSelectedRows);
        }
        return true;
    }

    private void _layoutWidgets() {
        WAPanel columnPanel = new WAPanel();
        columnPanel.setLayout((LayoutManager)new GridBagLayout());
        TitledBorder titledBorder1 = new TitledBorder(bundle.getString("DimDesigner.AddSupplied.Column.groupbox.title"));
        columnPanel.setBorder((Border)titledBorder1);
        JLabel columnBoxLabel = new JLabel();
        VisualUtilities.setLabelTextAndMnemonic(columnBoxLabel, bundle.getString("DimDesigner.AddSupplied.InputColumn.control.label"));
        this.inpColumnBox = new WAComboBox();
        columnBoxLabel.setName("ColumnBoxLabel");
        this.inpColumnBox.setName("ColumnBox");
        this.inpColumnBox.setPreferredSize(new Dimension(65, 20));
        JLabel informatTextLabel = new JLabel(bundle.getString("DimDesigner.AddSupplied.Informat.control.label"));
        informatTextLabel.setName("SuppliedInformatLabel");
        this.informatValue = new JLabel();
        this.informatValue.setName("SuppliedInformatValue");
        JLabel formatTextLabel = new JLabel(bundle.getString("DimDesigner.AddSupplied.Format.control.label"));
        formatTextLabel.setName("SuppliedFormatLabel");
        this.formatValue = new JLabel();
        this.formatValue.setName("SuppliedFormatValue");
        columnPanel.add((Component)columnBoxLabel, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 10), 0, 0));
        columnPanel.add((Component)this.inpColumnBox, (Object)new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(5, 5, 5, 10), 0, 0));
        columnPanel.add((Component)informatTextLabel, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 10), 0, 0));
        columnPanel.add((Component)this.informatValue, (Object)new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 17, 2, new Insets(5, 5, 5, 10), 0, 0));
        columnPanel.add((Component)formatTextLabel, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 10), 0, 0));
        columnPanel.add((Component)this.formatValue, (Object)new GridBagConstraints(1, 2, 1, 1, 1.0, 1.0, 17, 2, new Insets(5, 5, 5, 10), 0, 0));
        WAPanel suppliedPanel = new WAPanel();
        suppliedPanel.setLayout((LayoutManager)new GridBagLayout());
        TitledBorder titledBorder2 = new TitledBorder(bundle.getString("DimDesigner.AddSupplied.SuppliedHierarchies.groupbox.title"));
        suppliedPanel.setBorder((Border)titledBorder2);
        this.tableModel = new DimLevelSuppliedTableModel();
        this.detailsTable = new WsTable((WsAbstractTableModel)this.tableModel);
        this.detailsTable.setSortingEnabled(false);
        this.detailsTable.setColumnHidingEnabled(false);
        this.detailsTable.setColumnsReorderable(false);
        this.detailsTable.setRowHoldingEnabled(false);
        this.detailsTable.setRowsReorderable(false);
        this.detailsTable.setColumnHeaderPopupMenuEnabled(false);
        this.detailsTable.setOriginPopupMenuEnabled(false);
        this.detailsTable.setPopupMenuEnabled(false);
        this.detailsTable.setRowHeaderPopupMenuEnabled(false);
        this.detailsTable.setTablePopupMenuEnabled(false);
        this.detailsTable.setViewportPopupMenuEnabled(false);
        this.detailsTable.setName("SuppliedHierarhiesTable");
        this.detailsTable.setPreferredScrollableViewportSize(new Dimension(375, 175));
        this.detailsTable.setAutoResizeMode(0);
        JScrollPane topPanel = new JScrollPane((Component)this.detailsTable);
        suppliedPanel.add((Component)topPanel, (Object)new GridBagConstraints(0, 0, 3, 3, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)columnPanel, new GridBagConstraints(0, 0, 7, 3, 0.0, 0.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)suppliedPanel, new GridBagConstraints(0, 3, 4, 3, 1.0, 1.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        JPanel previewList = new JPanel();
        previewList.setLayout(new GridBagLayout());
        JLabel previewLabel = new JLabel(bundle.getString("DimDesigner.AddSupplied.PreviewHierarchies.control.label"));
        this.displayLevels = new AggregationPreviewLevelsPanel(null);
        this.displayLevels.setPreferredSize(new Dimension(200, 175));
        previewList.add((Component)previewLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        previewList.add((Component)((Object)this.displayLevels), new GridBagConstraints(0, 1, 3, 3, 1.0, 1.0, 17, 1, new Insets(5, 0, 3, 0), 0, 0));
        this.add(previewList, new GridBagConstraints(4, 3, 3, 3, 0.0, 0.0, 13, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    public boolean validateData() {
        return true;
    }

    public void createLevels(List inSelectedRows) {
        try {
            ArrayList<OLAPLevel> hierarchyLevels = new ArrayList<OLAPLevel>();
            DimensionSet dimensionSet = this.dimensionModel.getDimensionSet();
            OLAPColumn inputColumn = (OLAPColumn)this.inpColumnBox.getSelectedItem();
            OLAPLevel levelModel = null;
            Integer levelType = null;
            int size = inSelectedRows.size();
            for (int i = 0; i < size; ++i) {
                hierarchyLevels.clear();
                Integer nextRow = (Integer)inSelectedRows.get(i);
                int selectedRow = nextRow;
                List rowValues = this.tableModel.getRowValues(selectedRow);
                String hierarchyValue = (String)rowValues.get(1);
                List listOfLevels = (List)this.tableModel.mapOfHierarchyLevels.get(hierarchyValue);
                List listOfLevelNames = dimensionSet.getLevelsByColumn(inputColumn);
                int sizeT = listOfLevels.size();
                for (int t = 0; t < sizeT; ++t) {
                    String levelName = (String)listOfLevels.get(t);
                    levelModel = null;
                    levelType = (Integer)this.tableModel.mapOfTypes.get(levelName);
                    if (listOfLevelNames != null) {
                        int sizeAll = listOfLevelNames.size();
                        for (int j = 0; j < sizeAll && levelModel == null; ++j) {
                            OLAPLevel level = (OLAPLevel)listOfLevelNames.get(j);
                            if (levelType.intValue() != level.getType()) continue;
                            levelModel = level;
                        }
                    }
                    if (levelModel == null) {
                        String dimensionSort = this.dimensionModel.getSortOrder();
                        levelModel = this.dimensionModel.createOLAPSuppliedTimeLevel(inputColumn, levelName);
                        levelModel.setDesc(levelName);
                        levelModel.setSortOrder(dimensionSort);
                        levelModel.setFormat((String)this.tableModel.mapOfFormats.get(levelName));
                        levelModel.setType(levelType.intValue());
                    }
                    hierarchyLevels.add(levelModel);
                }
                this.createHierarchy(hierarchyValue, hierarchyLevels);
            }
        }
        catch (OLAPException oError) {
            ExceptionHandler.handleException((Exception)((Object)oError));
        }
    }

    public void createHierarchy(String name, List inLevelsList) {
        OLAPHierarchy hierarchy = null;
        try {
            String nameOfHierarchy = this.dimensionModel.getUniqueHierarchyName(name);
            hierarchy = this.dimensionModel.createOLAPHierarchy();
            hierarchy.setName(nameOfHierarchy);
            hierarchy.setDesc(nameOfHierarchy);
            hierarchy.setAllMember(bundle.formatString("DimDesigner.AllMember.txt", (Object)nameOfHierarchy));
            OLAPList hierModelLevels = hierarchy.getLevels();
            int size = inLevelsList.size();
            for (int i = 0; i < size; ++i) {
                hierModelLevels.add(inLevelsList.get(i));
            }
            hierarchy.verifyHierarchyLevelsList();
            hierarchy.verifyMaximumLevelsPerHierarchy();
        }
        catch (OLAPException oError) {
            ExceptionHandler.handleException((Exception)((Object)oError));
            try {
                hierarchy.delete();
            }
            catch (OLAPException hierError) {
                ExceptionHandler.handleException((Exception)((Object)hierError));
            }
        }
    }

    private class ColumnBoxActionListener
    implements ActionListener {
        private ColumnBoxActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            String columnInformat;
            OLAPColumn inputColumn = (OLAPColumn)DimLevelSuppliedPanel.this.inpColumnBox.getSelectedItem();
            String columnFormat = inputColumn.getSASFormat();
            if (columnFormat == null || ModelUtilities.isBlank((String)columnFormat)) {
                columnFormat = bundle.getString("DimDesigner.Format.None.txt");
            }
            if ((columnInformat = inputColumn.getSASInFormat()) == null || ModelUtilities.isBlank((String)columnInformat)) {
                columnInformat = bundle.getString("DimDesigner.Format.None.txt");
            }
            DimLevelSuppliedPanel.this.informatValue.setText(columnInformat);
            DimLevelSuppliedPanel.this.formatValue.setText(columnFormat);
        }
    }
}

