/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.designer.visuals;

import com.sas.olapadmin.designer.model.AbstractOLAPModel;
import com.sas.olapadmin.designer.model.DimensionSet;
import com.sas.olapadmin.designer.model.MeasureSet;
import com.sas.olapadmin.designer.model.OLAPDimension;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPHierarchy;
import com.sas.olapadmin.designer.model.OLAPLevel;
import com.sas.olapadmin.designer.model.OLAPList;
import com.sas.olapadmin.designer.model.OLAPMemberProperty;
import com.sas.olapadmin.designer.visuals.DimDimensionRenameDialog;
import com.sas.olapadmin.designer.visuals.DimHierDetailsDialog;
import com.sas.olapadmin.designer.visuals.VisualUtilities;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.olapadmin.utilities.studio.AggregationPreviewLevelsPanel;
import com.sas.olapadmin.utilities.studio.CubeButtons;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class DimHierPanel
extends WAPropertyTab {
    private static final long serialVersionUID = 1L;
    protected static WAdminResource bundle = new WAdminResource(DimHierPanel.class);
    private CubeButtons buttons;
    private JButton AddButton;
    private JButton ModifyButton;
    private JButton DeleteButton;
    private WAComboBox defaultHierarchyBox;
    private DefaultListModel listModel;
    private JList list;
    private OLAPDimension dimensionModel;
    private OLAPList availableHiers;
    private List selectedHierarchies;
    private boolean initialized;
    private AggregationPreviewLevelsPanel displayLevels;
    private String blank;
    private LevelSelectionListener listSelectionListener;
    private DefaultBoxActionListener defaultActionListener;
    private OLAPHierarchy currentDefaultHierarchy;
    private WAWizardDialog parent;

    public DimHierPanel(OLAPDimension indimension) {
        this.dimensionModel = indimension;
        this.setLayout(new GridBagLayout());
        this._layoutWidgets();
    }

    public boolean doDataExchange(boolean saveToModel) {
        if (!saveToModel) {
            if (!this.initialized) {
                this.initialize();
            } else if (this.listModel.size() > 0) {
                try {
                    this.availableHiers = this.dimensionModel.getHierarchies();
                }
                catch (OLAPException e) {
                    ExceptionHandler.handleException((Exception)((Object)e));
                }
                this.defaultHierarchyBox.removeActionListener((ActionListener)this.defaultActionListener);
                this.list.removeListSelectionListener(this.listSelectionListener);
                if (this.availableHiers.isEmpty()) {
                    this.defaultHierarchyBox.setEnabled(false);
                }
                if (this.parent.getWizardData("LEVELSCHANGED") == "1") {
                    this.displayLevels.clear();
                    this.parent.addWizardData("LEVELSCHANGED", (Object)"0");
                }
                this.defaultHierarchyBox.removeAllItems();
                this.defaultHierarchyBox.addItem((Object)this.blank);
                Collections.sort(this.availableHiers);
                this.listModel.clear();
                int hierarchySize = this.availableHiers.size();
                for (int i = 0; i < hierarchySize; ++i) {
                    this.listModel.addElement(this.availableHiers.get(i));
                }
                this.defaultHierarchyBox.addItems((List)this.availableHiers);
                if (this.currentDefaultHierarchy == null) {
                    this.defaultHierarchyBox.setSelectedItem((Object)this.blank);
                } else if (!this.availableHiers.contains((Object)this.currentDefaultHierarchy)) {
                    this.defaultHierarchyBox.setSelectedItem((Object)this.blank);
                } else {
                    this.defaultHierarchyBox.setSelectedItem((Object)this.currentDefaultHierarchy);
                }
                this.defaultHierarchyBox.addActionListener((ActionListener)this.defaultActionListener);
                this.list.addListSelectionListener(this.listSelectionListener);
            }
            Object selected = this.list.getSelectedValue();
            if (selected != null) {
                this.DeleteButton.setEnabled(true);
                this.ModifyButton.setEnabled(true);
            } else {
                this.DeleteButton.setEnabled(false);
                this.ModifyButton.setEnabled(false);
            }
        } else {
            try {
                if (this.listModel.size() > 1) {
                    this.availableHiers.addDefaultHierarchy(this.currentDefaultHierarchy);
                }
                int size = this.listModel.size();
                for (int i = 0; i < size; ++i) {
                    OLAPHierarchy hierarchy = (OLAPHierarchy)this.listModel.elementAt(i);
                    hierarchy.apply();
                }
                this.dimensionModel.apply();
                OLAPList listOfLevels = this.dimensionModel.getLevels();
                int size2 = listOfLevels.size();
                for (int i = 0; i < size2; ++i) {
                    OLAPLevel level = (OLAPLevel)listOfLevels.get(i);
                    level.apply();
                }
                DimensionSet dimensionSet = this.dimensionModel.getDimensionSet();
                if (dimensionSet.hasDimensionsChanged()) {
                    MeasureSet measureSet = this.dimensionModel.getOwningCube().getMeasureSet();
                    measureSet.synchNuniqueLevel();
                    measureSet.synchNuniqueHierarchy();
                }
            }
            catch (OLAPException e) {
                return ExceptionHandler.handleException((Exception)((Object)e));
            }
        }
        return true;
    }

    protected void initialize() {
        int sizeOfHierarchies;
        this.parent = (WAWizardDialog)this.getTopLevelAncestor();
        this.blank = "               ";
        this.selectedHierarchies = new ArrayList();
        this.listSelectionListener = new LevelSelectionListener();
        this.list.addListSelectionListener(this.listSelectionListener);
        this.defaultActionListener = new DefaultBoxActionListener();
        try {
            this.availableHiers = this.dimensionModel.getHierarchies();
        }
        catch (OLAPException e) {
            ExceptionHandler.handleException((Exception)((Object)e));
        }
        this.defaultHierarchyBox.removeAllItems();
        if (this.availableHiers.isEmpty()) {
            this.defaultHierarchyBox.setEnabled(false);
        }
        if ((sizeOfHierarchies = this.availableHiers.size()) > 0) {
            this.currentDefaultHierarchy = (OLAPHierarchy)this.availableHiers.get(0);
            this.dimensionModel.setDefault(this.currentDefaultHierarchy);
            Collections.sort(this.availableHiers);
            for (int i = 0; i < sizeOfHierarchies; ++i) {
                this.listModel.addElement(this.availableHiers.get(i));
            }
            this.defaultHierarchyBox.addItems((List)this.availableHiers);
            this.defaultHierarchyBox.setSelectedItem((Object)this.currentDefaultHierarchy);
            this.defaultHierarchyBox.addActionListener((ActionListener)this.defaultActionListener);
            this.list.setSelectedIndex(0);
        } else {
            this.defaultHierarchyBox.addItem((Object)this.blank);
        }
        this.AddButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                OLAPHierarchy hierarchy = null;
                try {
                    hierarchy = DimHierPanel.this.dimensionModel.createOLAPHierarchy();
                }
                catch (OLAPException e) {
                    ExceptionHandler.handleException((Exception)((Object)e));
                }
                DimHierDetailsDialog hierdialog = new DimHierDetailsDialog((Dialog)DimHierPanel.this.parent, bundle.getString("DimDesigner.Hierarchy.Define.txt"), DimHierPanel.this.dimensionModel, hierarchy);
                hierdialog.show();
                try {
                    int ok = hierdialog.getReturnValue();
                    if (ok == 1) {
                        DimHierPanel.this.defaultHierarchyBox.removeActionListener((ActionListener)DimHierPanel.this.defaultActionListener);
                        DimHierPanel.this.defaultHierarchyBox.setEnabled(true);
                        DimHierPanel.this.list.removeListSelectionListener(DimHierPanel.this.listSelectionListener);
                        DimHierPanel.this.availableHiers = DimHierPanel.this.dimensionModel.getHierarchies();
                        Collections.sort(DimHierPanel.this.availableHiers);
                        DimHierPanel.this.listModel.clear();
                        int size = DimHierPanel.this.availableHiers.size();
                        for (int i = 0; i < size; ++i) {
                            DimHierPanel.this.listModel.addElement(DimHierPanel.this.availableHiers.get(i));
                        }
                        DimHierPanel.this.defaultHierarchyBox.removeAllItems();
                        DimHierPanel.this.defaultHierarchyBox.addItems((List)DimHierPanel.this.availableHiers);
                        DimHierPanel.this.list.setModel(DimHierPanel.this.listModel);
                        if (DimHierPanel.this.currentDefaultHierarchy == null) {
                            DimHierPanel.this.defaultHierarchyBox.setSelectedItem((Object)hierarchy);
                            DimHierPanel.this.currentDefaultHierarchy = hierarchy;
                        } else {
                            DimHierPanel.this.defaultHierarchyBox.setSelectedItem((Object)DimHierPanel.this.currentDefaultHierarchy);
                        }
                        DimHierPanel.this.defaultHierarchyBox.addActionListener((ActionListener)DimHierPanel.this.defaultActionListener);
                        DimHierPanel.this.list.addListSelectionListener(DimHierPanel.this.listSelectionListener);
                    } else {
                        hierarchy.delete();
                    }
                }
                catch (OLAPException e) {
                    ExceptionHandler.handleException((Exception)((Object)e));
                }
            }
        });
        this.ModifyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                int selecteditem = DimHierPanel.this.list.getSelectedIndex();
                OLAPHierarchy hierarchy = (OLAPHierarchy)DimHierPanel.this.listModel.elementAt(selecteditem);
                DimHierDetailsDialog hierdialog = new DimHierDetailsDialog((Dialog)DimHierPanel.this.parent, bundle.getString("DimDesigner.Hierarchy.Define.txt"), DimHierPanel.this.dimensionModel, hierarchy);
                hierdialog.show();
                int ok = hierdialog.getReturnValue();
                try {
                    if (ok == 1) {
                        DimHierPanel.this.displayLevels.updateChildren((AbstractOLAPModel)hierarchy, hierarchy.getLevels());
                    }
                    DimHierPanel.this.list.setModel(DimHierPanel.this.listModel);
                }
                catch (OLAPException e) {
                    ExceptionHandler.handleException((Exception)((Object)e));
                }
            }
        });
        this.DeleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Object[] selectedHierarchies = DimHierPanel.this.list.getSelectedValues();
                int choice = 0;
                OLAPHierarchy hierarchy = null;
                if (selectedHierarchies.length == 1) {
                    hierarchy = (OLAPHierarchy)selectedHierarchies[0];
                    choice = MessageUtil.displayMessage((String)bundle.formatString("CubeDesigner.Delete.Message.fmt.txt", (Object)hierarchy.getName()), (String)bundle.getString("CubeDesigner.DeleteHierarchy.window.title"), (int)1, (int)0);
                } else if (selectedHierarchies.length > 1) {
                    choice = MessageUtil.displayMessage((String)bundle.getString("CubeDesigner.DeleteHierarchies.txt"), (String)bundle.getString("CubeDesigner.DeleteHierarchies.window.title"), (int)1, (int)0);
                }
                if (choice == 0) {
                    DimHierPanel.this.defaultHierarchyBox.removeActionListener((ActionListener)DimHierPanel.this.defaultActionListener);
                    boolean defaultHierarchyRemoved = false;
                    for (int i = selectedHierarchies.length - 1; i >= 0; --i) {
                        hierarchy = (OLAPHierarchy)selectedHierarchies[i];
                        DimHierPanel.this.listModel.removeElement(hierarchy);
                        try {
                            hierarchy.delete();
                            DimHierPanel.this.displayLevels.removeNode((AbstractOLAPModel)hierarchy);
                            DimHierPanel.this.defaultHierarchyBox.removeItem((Object)hierarchy);
                            if (DimHierPanel.this.currentDefaultHierarchy == null || !DimHierPanel.this.currentDefaultHierarchy.equals(hierarchy)) continue;
                            defaultHierarchyRemoved = true;
                            continue;
                        }
                        catch (OLAPException e) {
                            ExceptionHandler.handleException((Exception)((Object)e));
                        }
                    }
                    if (defaultHierarchyRemoved) {
                        int itemsRemaining = DimHierPanel.this.defaultHierarchyBox.getItemCount();
                        if (itemsRemaining > 0) {
                            DimHierPanel.this.currentDefaultHierarchy = (OLAPHierarchy)DimHierPanel.this.defaultHierarchyBox.getItemAt(0);
                            DimHierPanel.this.defaultHierarchyBox.setSelectedIndex(0);
                        } else {
                            DimHierPanel.this.defaultHierarchyBox.addItem((Object)DimHierPanel.this.blank);
                            DimHierPanel.this.defaultHierarchyBox.setEnabled(false);
                        }
                    }
                    DimHierPanel.this.defaultHierarchyBox.addActionListener((ActionListener)DimHierPanel.this.defaultActionListener);
                }
            }
        });
        this.initialized = true;
    }

    private void _layoutWidgets() {
        JLabel defaultHierLabel = new JLabel();
        JLabel text1 = new JLabel(bundle.getString("DimDesigner.Hierarchy.bottom.instructions1.txt"));
        JLabel text2 = new JLabel(bundle.getString("DimDesigner.Hierarchy.bottom.instructions2.txt"));
        JPanel textBox = new JPanel();
        textBox.setLayout(new GridBagLayout());
        textBox.add((Component)text1, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 0, 5, 5), 0, 0));
        textBox.add((Component)text2, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 5), 0, 0));
        this.defaultHierarchyBox = new WAComboBox();
        this.defaultHierarchyBox.setMinimumSize(new Dimension(75, 25));
        this.defaultHierarchyBox.setName("DefaultHierarchyDropDownBox");
        VisualUtilities.setLabelTextAndMnemonic(defaultHierLabel, bundle.getString("DimDesigner.Hierarchy.default.control.label"));
        defaultHierLabel.setLabelFor((Component)this.defaultHierarchyBox);
        defaultHierLabel.setName("DefaultHierarchyLabelField");
        JPanel defaultHierPanel = new JPanel();
        defaultHierPanel.setLayout(new GridBagLayout());
        defaultHierPanel.add((Component)defaultHierLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0));
        defaultHierPanel.add((Component)this.defaultHierarchyBox, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        this.buttons = new CubeButtons();
        this.listModel = new DefaultListModel();
        this.list = new JList(this.listModel);
        JLabel labelListBox = new JLabel();
        VisualUtilities.setLabelTextAndMnemonic(labelListBox, bundle.getString("DimDesigner.Hierarchy.level.control.label"));
        labelListBox.setLabelFor(this.list);
        this.AddButton = this.buttons.getAddButton();
        this.list.setName("HierarchiesDefined");
        JScrollPane topPanel = new JScrollPane(this.list);
        topPanel.setPreferredSize(new Dimension(250, 200));
        this.displayLevels = new AggregationPreviewLevelsPanel(null);
        this.displayLevels.setPreferredSize(new Dimension(200, 200));
        JLabel previewLabel = new JLabel();
        VisualUtilities.setLabelTextAndMnemonic(previewLabel, bundle.getString("DimDesigner.Hierarchy.Preview.control.label"));
        previewLabel.setLabelFor((Component)((Object)this.displayLevels));
        this.ModifyButton = this.buttons.getModifyButton();
        this.DeleteButton = this.buttons.getDeleteButton();
        this.AddButton.setName("HierarchyAddButton");
        this.ModifyButton.setName("HierarchyModifyButton");
        this.DeleteButton.setName("HierarchyDeleteButton");
        this.buttons.removeResetButton();
        this.buttons.removeApplyButton();
        this.buttons.removeDefaultButton();
        this.displayLevels.enableNoItemsMessage(true);
        JPanel hierarchyList = new JPanel();
        hierarchyList.setLayout(new GridBagLayout());
        hierarchyList.add((Component)labelListBox, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        hierarchyList.add((Component)topPanel, new GridBagConstraints(0, 1, 1, 6, 1.0, 1.0, 10, 1, new Insets(5, 0, 2, 5), 0, 0));
        JPanel previewList = new JPanel();
        previewList.setLayout(new GridBagLayout());
        previewList.add((Component)previewLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        previewList.add((Component)((Object)this.displayLevels), new GridBagConstraints(0, 1, 1, 6, 1.0, 1.0, 10, 1, new Insets(5, 0, 2, 5), 0, 0));
        this.add(defaultHierPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 0, 5, 5), 0, 0));
        this.add(hierarchyList, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 0, 5, 5), 0, 0));
        this.add(previewList, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)((Object)this.buttons), new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 12, 2, new Insets(18, 5, 0, 5), 0, 0));
        this.add(textBox, new GridBagConstraints(0, 2, 3, 1, 1.0, 1.0, 17, 1, new Insets(5, 0, 5, 5), 0, 0));
    }

    public boolean validateData() {
        OLAPList listOfHierarchies = null;
        try {
            listOfHierarchies = this.dimensionModel.getHierarchies();
        }
        catch (OLAPException OLAPError) {
            return ExceptionHandler.handleException((Exception)((Object)OLAPError));
        }
        int numberofhiers = listOfHierarchies.size();
        String dimensionType = this.dimensionModel.getType();
        if (numberofhiers == 0) {
            OLAPHierarchy defaultHierarchy = null;
            try {
                defaultHierarchy = this.dimensionModel.createOLAPHierarchy();
                WAWizardDialog parent = (WAWizardDialog)this.getTopLevelAncestor();
                List listOfLevels = (List)parent.getWizardData("ORDEROFLEVELS");
                OLAPList listOfHierarchyLevels = defaultHierarchy.getLevels();
                if (listOfLevels == null) {
                    listOfLevels = this.dimensionModel.getLevels();
                }
                int size = listOfLevels.size();
                for (int i = 0; i < size; ++i) {
                    listOfHierarchyLevels.add(listOfLevels.get(i));
                }
                defaultHierarchy.verifyMaximumLevelsPerDefaultHierarchy();
                String dimensionName = this.dimensionModel.getName();
                defaultHierarchy.setName(dimensionName);
                defaultHierarchy.setDesc(dimensionName);
                defaultHierarchy.setAllMember(bundle.formatString("DimDesigner.AllMember.txt", (Object)dimensionName));
                this.listModel.addElement(defaultHierarchy);
                this.dimensionModel.setDefault(defaultHierarchy);
                this.list.setModel(this.listModel);
            }
            catch (OLAPException OLAPError) {
                try {
                    if (defaultHierarchy != null) {
                        defaultHierarchy.delete();
                    }
                }
                catch (OLAPException OError) {
                    return ExceptionHandler.handleException((Exception)((Object)OError));
                }
                return ExceptionHandler.handleException((Exception)((Object)OLAPError));
            }
        }
        try {
            this.dimensionModel.verifyAllLevelsUsed();
        }
        catch (OLAPException OLAPError) {
            return ExceptionHandler.handleException((Exception)((Object)OLAPError));
        }
        numberofhiers = listOfHierarchies.size();
        OLAPHierarchy nextHierarchy = null;
        try {
            if (dimensionType.equals("TIME")) {
                for (int ii = 0; ii < numberofhiers; ++ii) {
                    nextHierarchy = (OLAPHierarchy)listOfHierarchies.get(ii);
                    nextHierarchy.verifyHierarchyTimeDrillOrder();
                }
            }
        }
        catch (OLAPException OLAPError) {
            try {
                boolean found = false;
                if (nextHierarchy != null) {
                    nextHierarchy.orderTimeLevels();
                }
                nextHierarchy.verifyHierarchyTimeDrillOrder();
            }
            catch (OLAPException oError) {
                return ExceptionHandler.handleException((Exception)((Object)OLAPError));
            }
        }
        if (listOfHierarchies.size() == 1) {
            String hierarchyCaption;
            OLAPHierarchy isdefault = (OLAPHierarchy)this.listModel.elementAt(0);
            String name = isdefault.getName();
            String newHierarchyName = null;
            boolean levelNameIsFound = false;
            OLAPList listOfLevels = null;
            try {
                listOfLevels = this.dimensionModel.getLevels();
            }
            catch (OLAPException OLAPError) {
                return ExceptionHandler.handleException((Exception)((Object)OLAPError));
            }
            String dimensionName = this.dimensionModel.getName();
            int i = 0;
            int size = listOfLevels.size();
            while (i < size & !levelNameIsFound) {
                OLAPLevel nextLevel = (OLAPLevel)listOfLevels.get(i);
                String levelName = nextLevel.getName();
                if (levelName.equalsIgnoreCase(dimensionName)) {
                    levelNameIsFound = true;
                }
                ++i;
            }
            if (levelNameIsFound) {
                Workspace m_workspace = Workspace.getWorkspace();
                DimDimensionRenameDialog renameDialog = new DimDimensionRenameDialog(m_workspace, bundle.getString("DimDesigner.RenameDimension.Title.txt"), this.dimensionModel);
                renameDialog.show();
                newHierarchyName = renameDialog.getDimensionName();
                if (newHierarchyName == null) {
                    return false;
                }
            } else {
                if (!name.equalsIgnoreCase(dimensionName)) {
                    MessageUtil.displayMessage((String)bundle.getString("DimDesigner.Hierarchy.Rename.Hierarchy.txt"));
                }
                newHierarchyName = dimensionName;
            }
            if ((hierarchyCaption = isdefault.getDesc()).equals(isdefault.getName())) {
                isdefault.setDesc(newHierarchyName);
            }
            if (levelNameIsFound) {
                this.dimensionModel.setName(newHierarchyName);
            }
            try {
                String checkForOldName = bundle.formatString("DimDesigner.AllMember.txt", (Object)isdefault.getName());
                isdefault.setName(newHierarchyName);
                if (checkForOldName.equalsIgnoreCase(isdefault.getAllMember())) {
                    isdefault.setAllMember(bundle.formatString("DimDesigner.AllMember.txt", (Object)newHierarchyName));
                }
            }
            catch (OLAPException oError) {
                ExceptionHandler.handleException((Exception)((Object)oError));
            }
        }
        try {
            OLAPList levels = this.dimensionModel.getLevels();
            for (int levNum = 0; levNum < levels.size(); ++levNum) {
                OLAPLevel level = (OLAPLevel)levels.get(levNum);
                OLAPList mbrProps = level.getOLAPProperties();
                for (int propNum = 0; propNum < mbrProps.size(); ++propNum) {
                    OLAPMemberProperty prop = (OLAPMemberProperty)mbrProps.get(propNum);
                    OLAPList hierarchies = prop.getHierarchies();
                    if (!hierarchies.isEmpty()) continue;
                    OLAPList levHiers = level.getHierarchies();
                    hierarchies.addAll((Collection)levHiers);
                }
            }
        }
        catch (OLAPException e) {
            ExceptionHandler.handleException((Exception)((Object)e));
        }
        return true;
    }

    class LevelSelectionListener
    implements ListSelectionListener {
        LevelSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            if (DimHierPanel.this.list.getSelectedIndex() == -1) {
                DimHierPanel.this.DeleteButton.setEnabled(false);
                DimHierPanel.this.ModifyButton.setEnabled(false);
            } else if (DimHierPanel.this.list.getSelectedIndex() == 0) {
                DimHierPanel.this.DeleteButton.setEnabled(true);
                DimHierPanel.this.ModifyButton.setEnabled(DimHierPanel.this.list.getSelectedIndices().length == 1);
            } else {
                DimHierPanel.this.DeleteButton.setEnabled(true);
                DimHierPanel.this.ModifyButton.setEnabled(DimHierPanel.this.list.getSelectedIndices().length == 1);
            }
            int[] selectedItems = DimHierPanel.this.list.getSelectedIndices();
            if (selectedItems.length < 1) {
                return;
            }
            DimHierPanel.this.selectedHierarchies.clear();
            DimHierPanel.this.displayLevels.clear();
            int size = selectedItems.length;
            for (int i = 0; i < size; ++i) {
                OLAPHierarchy hierarchy = (OLAPHierarchy)DimHierPanel.this.listModel.get(selectedItems[i]);
                DimHierPanel.this.selectedHierarchies.add(hierarchy);
            }
            if (!DimHierPanel.this.selectedHierarchies.isEmpty()) {
                Collections.sort(DimHierPanel.this.selectedHierarchies);
                DimHierPanel.this.displayLevels.setSelectedHierarchies(DimHierPanel.this.selectedHierarchies);
            }
        }
    }

    private class DefaultBoxActionListener
    implements ActionListener {
        private DefaultBoxActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (DimHierPanel.this.defaultHierarchyBox.getSelectedItem() != DimHierPanel.this.blank) {
                OLAPHierarchy newDefault = (OLAPHierarchy)DimHierPanel.this.defaultHierarchyBox.getSelectedItem();
                if (newDefault != null && !newDefault.equals(DimHierPanel.this.currentDefaultHierarchy)) {
                    DimHierPanel.this.dimensionModel.setDefault(newDefault);
                    DimHierPanel.this.currentDefaultHierarchy = newDefault;
                }
            } else if (DimHierPanel.this.currentDefaultHierarchy != null) {
                DimHierPanel.this.defaultHierarchyBox.setSelectedItem((Object)DimHierPanel.this.currentDefaultHierarchy);
            }
        }
    }
}

