/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.designer.visuals;

import com.sas.olapadmin.designer.model.ModelUtilities;
import com.sas.olapadmin.designer.model.OLAPDimension;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPHierarchy;
import com.sas.olapadmin.designer.model.OLAPLevel;
import com.sas.olapadmin.designer.model.OLAPList;
import com.sas.olapadmin.designer.model.OLAPMemberProperty;
import com.sas.olapadmin.designer.visuals.DimHierDetailsDialog;
import com.sas.olapadmin.designer.visuals.VisualUtilities;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.swing.visuals.dualselector.BaseDualSelector;
import com.sas.swing.visuals.dualselector.DualListSelector;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WATextArea;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAdminResource;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class DimHierDetailsPanel
extends WAPanel {
    private static final long serialVersionUID = 1L;
    protected static WAdminResource bundle = new WAdminResource(DimHierDetailsPanel.class);
    private static final String SAS_MEMBER_DATE = "SAS_MEMBER_DATE";
    private JLabel label_dimName;
    private JLabel label_dimdescription;
    private JLabel label_dimnotes;
    private WATextArea inp_dimnotes;
    private WATextField inp_dimName;
    private WATextField inp_dimdescription;
    private JLabel label_allmember;
    private WATextField inp_allmember;
    private JScrollPane ScrollNotes;
    private DefaultListModel available;
    private DefaultListModel selected;
    private DualListSelector listbox;
    private OLAPHierarchy hierModel;
    protected DimHierDetailsDialog dialogparent;
    private OLAPList selectedLevels;
    private List backUpLevels;
    private String modifyname;
    private OLAPDimension dimensionModel;
    private List availableLevels;
    private boolean initialized;
    private String lastName;

    public DimHierDetailsPanel(OLAPDimension dimension, OLAPHierarchy inhierarchy) {
        this.dimensionModel = dimension;
        this.hierModel = inhierarchy;
        this.setLayout(new GridBagLayout());
        this._layoutWidgets();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean doDataExchange(boolean saveToModel) {
        if (!saveToModel) {
            this.modifyname = " ";
            this.available.clear();
            try {
                this.availableLevels = this.dimensionModel.getLevels();
            }
            catch (OLAPException OLAPError) {
                return ExceptionHandler.handleException((Exception)((Object)OLAPError));
            }
            int listSize = this.availableLevels.size();
            for (int ii = 0; ii < listSize; ++ii) {
                this.available.addElement(this.availableLevels.get(ii));
            }
            this.listbox.setModel((ListModel)this.available);
            this.listbox.setTargetModel((ListModel)this.selected);
            this.backUpLevels = new ArrayList();
            try {
                String hierarchyName;
                this.selectedLevels = this.hierModel.getLevels();
                this.lastName = hierarchyName = this.hierModel.getName();
                if (!ModelUtilities.isBlank((String)this.hierModel.getAllMember())) {
                    int selectedSize = this.selectedLevels.size();
                    for (int t = 0; t < selectedSize; ++t) {
                        OLAPLevel levelSelected = (OLAPLevel)this.selectedLevels.get(t);
                        this.available.removeElement(levelSelected);
                        this.selected.addElement(levelSelected);
                        this.backUpLevels.add(levelSelected);
                    }
                    this.inp_dimdescription.setText(this.hierModel.getDesc());
                    this.inp_dimnotes.setText(this.hierModel.getNotes());
                    this.inp_allmember.setText(this.hierModel.getAllMember());
                } else {
                    String first = bundle.formatString("DimDesigner.AllMember.txt", (Object)hierarchyName);
                    this.inp_allmember.setText(first);
                }
                this.inp_dimName.setText(hierarchyName);
                this.modifyname = hierarchyName;
                if (this.initialized) return true;
                this._initialize();
                return true;
            }
            catch (OLAPException OLAPError) {
                return ExceptionHandler.handleException((Exception)((Object)OLAPError));
            }
        }
        String descriptionText = this.inp_dimdescription.getText();
        if (ModelUtilities.isBlank((String)descriptionText)) {
            descriptionText = this.hierModel.getName();
        }
        this.hierModel.setDesc(descriptionText);
        String current_dimnotes = this.inp_dimnotes.getText();
        if (!ModelUtilities.isBlank((String)current_dimnotes)) {
            this.hierModel.setNotes(current_dimnotes);
        }
        String allMember = this.inp_allmember.getText();
        this.hierModel.setAllMember(allMember);
        return true;
    }

    private void _initialize() {
        this.listbox.setTargetControlsVisible(true);
        this.initialized = true;
        this.inp_dimName.getDocument().addDocumentListener(new NameListener());
    }

    private void _layoutWidgets() {
        WAPanel toppanel = new WAPanel();
        toppanel.setLayout((LayoutManager)new GridBagLayout());
        this.label_dimName = new JLabel();
        VisualUtilities.setLabelTextAndMnemonic(this.label_dimName, bundle.getString("DimDesigner.General.dimname.txt"));
        this.inp_dimName = new WATextField(32);
        this.inp_dimName.setMaxCharacters(32);
        this.inp_dimName.setPreferredSize(new Dimension(40, 20));
        this.label_dimName.setName("HierarchyNameLabel");
        this.inp_dimName.setName("HierarchyName");
        this.label_dimdescription = new JLabel();
        VisualUtilities.setLabelTextAndMnemonic(this.label_dimdescription, bundle.getString("Common.Description.txt"));
        this.inp_dimdescription = new WATextField(32);
        this.inp_dimdescription.setMaxCharacters(256);
        this.inp_dimdescription.setName("HierarchyCaption");
        this.label_dimdescription.setName("HierarchyCaptionLabel");
        this.label_dimnotes = new JLabel();
        VisualUtilities.setLabelTextAndMnemonic(this.label_dimnotes, bundle.getString("Common.Notes.txt"));
        this.inp_dimnotes = new WATextArea(2, 1);
        this.inp_dimnotes.setLineWrap(true);
        this.inp_dimnotes.setWrapStyleWord(true);
        this.ScrollNotes = new JScrollPane((Component)this.inp_dimnotes);
        this.inp_dimnotes.setToolTipText(bundle.getString("DimDesigner.General.ToolTip.notes.txt"));
        this.label_dimnotes.setName("HierarchyNotesLabel");
        this.inp_dimnotes.setName("HierarchyNotes");
        this.ScrollNotes.setName("HierarchyScrollPane");
        this.label_allmember = new JLabel();
        VisualUtilities.setLabelTextAndMnemonic(this.label_allmember, bundle.getString("DimDesigner.Hierarchy.AllMember.txt"));
        this.inp_allmember = new WATextField(32);
        this.inp_allmember.setMaxCharacters(256);
        this.label_allmember.setName("HierarchyAllMemberCaptionLabel");
        this.inp_allmember.setName("HierarchyAllMemberCaption");
        this.inp_allmember.setToolTipText(bundle.getString("DimDesigner.Hierarchy.ToolTip.Allmember.txt"));
        this.label_allmember.setLabelFor((Component)this.inp_allmember);
        this.available = new DefaultListModel();
        this.selected = new DefaultListModel();
        this.listbox = new DualListSelector();
        this.listbox.setName("HierarchyListBox");
        this.inp_dimName.setToolTipText(bundle.getString("DimDesigner.Hierarchy.ToolTip.name.txt"));
        this.label_dimName.setLabelFor((Component)this.inp_dimName);
        this.inp_dimdescription.setToolTipText(bundle.getString("DimDesigner.Hierarchy.ToolTip.description.txt"));
        this.label_dimdescription.setLabelFor((Component)this.inp_dimdescription);
        this.inp_dimnotes.setToolTipText(bundle.getString("DimDesigner.Hierarchy.ToolTip.notes.txt"));
        this.label_dimnotes.setLabelFor((Component)this.inp_dimnotes);
        VisualUtilities.setDualSelectorTextAndMnemonic((BaseDualSelector)this.listbox, bundle.getString("CubeDesigner.DualListbox.leftlistbox.txt"), bundle.getString("CubeDesigner.DualListbox.rightlistbox.txt"));
        toppanel.add((Component)this.label_dimName, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 5, 5), 0, 0));
        toppanel.add((Component)this.inp_dimName, (Object)new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(5, 5, 5, 10), 0, 0));
        toppanel.add((Component)this.label_dimdescription, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 5, 5), 0, 0));
        toppanel.add((Component)this.inp_dimdescription, (Object)new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 17, 2, new Insets(5, 5, 5, 10), 0, 0));
        toppanel.add((Component)this.label_dimnotes, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 5, 5), 0, 0));
        toppanel.add((Component)this.ScrollNotes, (Object)new GridBagConstraints(1, 2, 2, 1, 1.0, 1.0, 17, 2, new Insets(5, 5, 5, 10), 0, 0));
        toppanel.add((Component)this.label_allmember, (Object)new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 5, 5), 0, 0));
        toppanel.add((Component)this.inp_allmember, (Object)new GridBagConstraints(1, 3, 1, 1, 1.0, 1.0, 17, 2, new Insets(5, 5, 5, 10), 0, 0));
        this.listbox.setPreferredSize(new Dimension(400, 150));
        toppanel.add((Component)this.listbox, (Object)new GridBagConstraints(0, 4, 2, 2, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)toppanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    public boolean validateData() {
        int size;
        int choice;
        int numberToDelete = 0;
        String hierarchyName = this.inp_dimName.getText();
        String backUpName = null;
        backUpName = this.hierModel.getName();
        this.hierModel.setName(hierarchyName);
        if (ModelUtilities.isBlank((String)hierarchyName) || !hierarchyName.equals(this.modifyname)) {
            try {
                this.hierModel.verifyName();
            }
            catch (OLAPException oError) {
                this.hierModel.setName(backUpName);
                return ExceptionHandler.handleException((Exception)((Object)oError));
            }
        }
        for (int i = this.backUpLevels.size() - 1; i >= 0; --i) {
            OLAPLevel level = (OLAPLevel)this.backUpLevels.get(i);
            if (this.selected.indexOf(level) >= 0) continue;
            ++numberToDelete;
        }
        if (numberToDelete > 0 && (choice = MessageUtil.displayMessage((String)bundle.getString("CubeDesigner.DeleteLevelsHierarchy.txt"), (String)bundle.getString("CubeDesigner.DeleteLevelsHierarchy.window.title"), (int)1, (int)2)) == 2) {
            return false;
        }
        String dimensionType = this.dimensionModel.getType();
        if (this.backUpLevels.isEmpty() || !this.backUpLevels.toString().equals(this.selected.toString())) {
            this.selectedLevels.clear();
            for (int ii = 0; ii < this.selected.size(); ++ii) {
                this.selectedLevels.add(this.selected.elementAt(ii));
            }
            try {
                this.hierModel.verifyHierarchyLevelsList();
                this.hierModel.verifyMaximumLevelsPerHierarchy();
                if (dimensionType.equals("TIME")) {
                    this.hierModel.verifyHierarchyTimeDrillOrder();
                    size = this.selectedLevels.size();
                    for (int i = 0; i < size; ++i) {
                        OLAPLevel nextLevel = (OLAPLevel)this.selectedLevels.get(i);
                        OLAPList memberProperties = nextLevel.getOLAPProperties();
                        int sizeMP = memberProperties.size();
                        for (int t = 0; t < sizeMP; ++t) {
                            OLAPList hierarchies;
                            OLAPMemberProperty memProp = (OLAPMemberProperty)memberProperties.get(t);
                            String name = memProp.getName();
                            if (!name.equals(SAS_MEMBER_DATE) || (hierarchies = memProp.getHierarchies()).contains(this.hierModel)) continue;
                            hierarchies.add(this.hierModel);
                        }
                    }
                }
            }
            catch (OLAPException oError) {
                if (this.backUpLevels.size() > 0) {
                    this.selectedLevels.clear();
                    int size2 = this.backUpLevels.size();
                    for (int i = 0; i < size2; ++i) {
                        this.selectedLevels.add(this.backUpLevels.get(i));
                    }
                }
                return ExceptionHandler.handleException((Exception)((Object)oError));
            }
        }
        size = this.backUpLevels.size();
        for (int i = 0; i < size; ++i) {
            OLAPLevel level = (OLAPLevel)this.backUpLevels.get(i);
            if (this.selectedLevels.contains((Object)level)) continue;
            this.selectedLevels.remove((Object)level);
        }
        try {
            this.hierModel.verifyAllMember(this.inp_allmember.getText());
        }
        catch (OLAPException oError) {
            return ExceptionHandler.handleException((Exception)((Object)oError));
        }
        return true;
    }

    public class NameListener
    implements DocumentListener {
        @Override
        public void insertUpdate(DocumentEvent arg0) {
            this.changeAllMember();
        }

        private void changeAllMember() {
            String defaultAll = bundle.formatString("DimDesigner.AllMember.txt", (Object)DimHierDetailsPanel.this.lastName);
            String current_allMember = DimHierDetailsPanel.this.inp_allmember.getText();
            String newName = DimHierDetailsPanel.this.inp_dimName.getText();
            if (defaultAll.toUpperCase().equals(current_allMember.toUpperCase())) {
                String newDefault = bundle.formatString("DimDesigner.AllMember.txt", (Object)newName);
                DimHierDetailsPanel.this.inp_allmember.setText(newDefault);
            }
            DimHierDetailsPanel.this.lastName = newName;
        }

        @Override
        public void removeUpdate(DocumentEvent arg0) {
            this.changeAllMember();
        }

        @Override
        public void changedUpdate(DocumentEvent arg0) {
            this.changeAllMember();
        }
    }
}

