/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.designer.visuals;

import com.sas.metadata.remote.PhysicalTable;
import com.sas.olapadmin.designer.model.DimensionSet;
import com.sas.olapadmin.designer.model.DimensionTable;
import com.sas.olapadmin.designer.model.ModelUtilities;
import com.sas.olapadmin.designer.model.OLAPColumn;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPDimension;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPList;
import com.sas.olapadmin.designer.model.OLAPTable;
import com.sas.olapadmin.designer.model.TableSet;
import com.sas.olapadmin.designer.visuals.CubeDimensionPanel;
import com.sas.olapadmin.designer.visuals.DimGeneralAdvancedDialog;
import com.sas.olapadmin.designer.visuals.VisualUtilities;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.olapadmin.utilities.Utilities;
import com.sas.wadmin.viewdata2.impl.PhysicalTablePanel;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WATextArea;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

public class DimGeneralPanel
extends WAPropertyTab {
    private static final long serialVersionUID = 1L;
    protected static WAdminResource bundle = new WAdminResource(DimGeneralPanel.class);
    private WAPanel starPanel;
    private JLabel label_dimtable;
    private JButton advanced;
    private WAComboBox inp_dimtable;
    private JButton btnViewData;
    private JButton btnFactViewData;
    private JLabel label_dimkey;
    private WAComboBox inp_dimkey;
    private JLabel label_factkey;
    private WAComboBox inp_factkey;
    private JLabel label_dimName;
    private WATextField inp_dimName;
    private JLabel label_dimdescription;
    private WATextField inp_dimdescription;
    private JLabel label_dimtype;
    private WAComboBox inp_dimtype;
    private JLabel label_dimsortorder;
    private WAComboBox inp_dimsortorder;
    private JLabel label_dimnotes;
    private WATextArea inp_dimnotes;
    private JCheckBox update;
    private JScrollPane ScrollNotes;
    private JCheckBox useFactTable;
    private OLAPDimension dimensionModel;
    private OLAPCube cubeModel;
    private boolean initialized;
    private List dimColumns;
    private DimensionTable factTable;
    private DimensionTable selectedTable;
    private boolean isStar;
    private dimensionKeyListener dimkeyListener;
    private DimensionTableListener dimTableListener;
    private WATextArea datasetoptions;
    private JLabel label_datasetoptions;
    private JScrollPane DataScrollNotes;
    private String modifyname;
    private boolean modifyMode;
    private boolean readOnly_flag;
    private OLAPColumn factkey;
    private OLAPColumn dimensionKey;
    private String oldDimensionType;
    private DimensionSet dimensionSet;
    private TableSet tableSet;
    private boolean factTableSelected;
    private OLAPColumn backUpDimensionKey;
    private DimensionTable backUpDimensionTable;
    private OLAPColumn backUpDimensionFactKey;

    public DimGeneralPanel(OLAPDimension indimension) {
        this.dimensionModel = indimension;
        this.dimensionSet = this.dimensionModel.getDimensionSet();
        this.cubeModel = this.dimensionSet.getOwningCube();
        this.tableSet = this.cubeModel.getTableSet();
        this.setLayout(new GridBagLayout());
        this._layoutWidgets();
    }

    public boolean doDataExchange(boolean saveToModel) {
        if (!saveToModel) {
            if (!this.initialized) {
                this.initialize();
            }
            this.modifyname = this.dimensionModel.getName();
            if (!ModelUtilities.isBlank((String)this.modifyname)) {
                this.modifyMode = true;
                this.inp_dimName.setText(this.dimensionModel.getName());
                this.inp_dimtype.setSelectedItem((Object)this.dimensionModel.getType());
                this.oldDimensionType = this.dimensionModel.getType();
                this.inp_dimsortorder.setSelectedIndex(this.dimensionSet.getDisplaySort(this.dimensionModel.getSortOrder()));
                this.inp_dimdescription.setText(this.dimensionModel.getDesc());
                try {
                    this.inp_dimnotes.setText(this.dimensionModel.getNotes());
                }
                catch (OLAPException OLAPError) {
                    ExceptionHandler.handleException((Exception)((Object)OLAPError));
                }
                if (this.isStar) {
                    try {
                        DimensionTable dimensionTable;
                        this.backUpDimensionTable = dimensionTable = this.dimensionModel.getTable();
                        this.inp_dimtable.removeActionListener((ActionListener)this.dimTableListener);
                        if (dimensionTable.equals((OLAPTable)this.factTable)) {
                            this.useFactTable.setSelected(true);
                            this.useFactTable.setEnabled(false);
                            this.inp_dimtable.setEnabled(false);
                            this.inp_factkey.setEnabled(false);
                            this.inp_dimtable.addActionListener((ActionListener)this.dimTableListener);
                            this.selectedTable = this.factTable;
                        } else {
                            this.useFactTable.setEnabled(false);
                            this.inp_dimkey.setEnabled(true);
                            this.inp_dimtable.addItem((Object)dimensionTable);
                            this.inp_dimtable.setSelectedItem((Object)dimensionTable);
                            this.btnViewData.setEnabled(true);
                            this.selectedTable = dimensionTable;
                            this.inp_dimtable.setEnabled(false);
                            try {
                                this.dimensionKey = this.dimensionModel.getDimensionKey();
                            }
                            catch (OLAPException OLAPError) {
                                return ExceptionHandler.handleException((Exception)((Object)OLAPError));
                            }
                            this.backUpDimensionKey = this.dimensionKey;
                            this.inp_dimkey.removeAllItems();
                            this.dimColumns = dimensionTable.getColumns();
                            int size = this.dimColumns.size();
                            for (int t = 0; t < size; ++t) {
                                this.inp_dimkey.addItem(this.dimColumns.get(t));
                            }
                            this.inp_dimkey.setSelectedItem((Object)this.dimensionKey);
                            this.backUpDimensionFactKey = this.factkey = this.dimensionModel.getFactKey();
                            if (this.factkey != null) {
                                if (this.inp_factkey.getIndexOf((Object)this.factkey) < 0) {
                                    this.inp_factkey.addItem((Object)this.factkey);
                                }
                                this.inp_factkey.setSelectedItem((Object)this.factkey);
                            }
                        }
                        this.datasetoptions.setText(this.dimensionModel.getTableOptions());
                        this.inp_dimtable.addActionListener((ActionListener)this.dimTableListener);
                    }
                    catch (OLAPException OLAPError) {
                        ExceptionHandler.handleException((Exception)((Object)OLAPError));
                    }
                }
            }
        } else {
            String description_input = this.inp_dimdescription.getText();
            String dimName = this.dimensionModel.getName();
            if (ModelUtilities.isBlank((String)description_input)) {
                this.dimensionModel.setDesc(dimName);
            } else if (this.modifyMode && description_input.equals(this.modifyname)) {
                this.dimensionModel.setDesc(dimName);
            } else {
                this.dimensionModel.setDesc(description_input);
            }
            this.dimensionModel.setNotes(this.inp_dimnotes.getText());
            try {
                if (this.update.isSelected()) {
                    this.dimensionModel.setUpdateable("0");
                } else {
                    this.dimensionModel.setUpdateable("1");
                }
                if (this.isStar) {
                    this.dimensionModel.setTableOptions(this.datasetoptions.getText());
                }
            }
            catch (OLAPException oError) {
                return ExceptionHandler.handleException((Exception)((Object)oError));
            }
        }
        return true;
    }

    protected void initialize() {
        try {
            this.inp_dimtype.addItem((Object)"STANDARD");
            this.inp_dimtype.addItem((Object)"GEO");
            this.inp_dimtype.addItem((Object)"TIME");
            this.inp_dimsortorder.addItem((Object)bundle.getString("DimDesigner.General.dimsortascending.txt"));
            this.inp_dimsortorder.addItem((Object)bundle.getString("DimDesigner.General.dimsortdescending.txt"));
            this.inp_dimsortorder.addItem((Object)bundle.getString("DimDesigner.General.dimsortascformatted.txt"));
            this.inp_dimsortorder.addItem((Object)bundle.getString("DimDesigner.General.dimsortdescformatted.txt"));
            this.inp_dimsortorder.addItem((Object)bundle.getString("DimDesigner.General.dimsortdsorder.txt"));
            FactTableListener factTableListener = new FactTableListener();
            this.useFactTable.addActionListener(factTableListener);
            AdvancedListener advanceButton = new AdvancedListener();
            this.advanced.addActionListener(advanceButton);
            ViewDataListener viewData = new ViewDataListener();
            this.btnViewData.addActionListener(viewData);
            this.btnViewData.setEnabled(false);
            this.btnFactViewData.addActionListener(viewData);
            this.btnFactViewData.setEnabled(false);
            if (this.dimensionSet.allUpdateableDimensions != CubeDimensionPanel.UPDATE_SOMETIMES) {
                this.update.setEnabled(false);
            }
            if (this.dimensionSet.allUpdateableDimensions == CubeDimensionPanel.UPDATE_NEVER) {
                this.update.setSelected(false);
            } else if (this.dimensionSet.allUpdateableDimensions == CubeDimensionPanel.UPDATE_ALWAYS) {
                this.update.setSelected(true);
            } else if (this.dimensionSet.allUpdateableDimensions == CubeDimensionPanel.UPDATE_SOMETIMES) {
                this.update.setSelected(this.dimensionModel.isUpdateable());
            }
            if (this.tableSet.isLoadStarSchema()) {
                this.isStar = true;
            }
            if (!this.isStar) {
                this.starPanel.setEnabled(false);
                this.useFactTable.setEnabled(false);
                this.label_dimtable.setEnabled(false);
                this.inp_dimtable.setEnabled(false);
                this.label_dimkey.setEnabled(false);
                this.inp_dimkey.setEnabled(false);
                this.label_factkey.setEnabled(false);
                this.inp_factkey.setEnabled(false);
                this.label_datasetoptions.setEnabled(false);
                this.datasetoptions.setEnabled(false);
                this.datasetoptions.setBackground((Color)SystemColor.control);
            } else {
                this.btnFactViewData.setEnabled(true);
                this.inp_dimkey.setEnabled(false);
                this.inp_factkey.setEnabled(false);
                this.dimkeyListener = new dimensionKeyListener();
                this.inp_dimkey.addActionListener((ActionListener)this.dimkeyListener);
                this.inp_dimtable.addItem((Object)" ");
                OLAPList dimTables = this.dimensionSet.getTables();
                int size = dimTables.size();
                for (int i = 0; i < size; ++i) {
                    this.inp_dimtable.addItem(dimTables.get(i));
                }
                this.factTable = this.tableSet.getDimensionTable(this.tableSet.getLoadTable().getTable());
                this.inp_factkey.addItem((Object)" ");
                OLAPList availablekeys = this.factTable.getColumns();
                int size2 = availablekeys.size();
                for (int i = 0; i < size2; ++i) {
                    this.inp_factkey.addItem(availablekeys.get(i));
                }
                this.dimTableListener = new DimensionTableListener();
                this.inp_dimtable.addActionListener((ActionListener)this.dimTableListener);
            }
            this.initialized = true;
        }
        catch (OLAPException OLAPError) {
            ExceptionHandler.handleException((Exception)((Object)OLAPError));
        }
    }

    private void _layoutWidgets() {
        WAPanel dimGeneral = new WAPanel();
        dimGeneral.setLayout((LayoutManager)new GridBagLayout());
        EmptyBorder dimGeneralBorder = new EmptyBorder(5, 5, 0, 5);
        dimGeneral.setBorder((Border)dimGeneralBorder);
        this.label_dimName = new JLabel();
        VisualUtilities.setLabelTextAndMnemonic(this.label_dimName, bundle.getString("DimDesigner.General.dimname.txt"));
        this.inp_dimName = new WATextField(15);
        this.inp_dimName.setMaxCharacters(60);
        this.label_dimName.setName("DimensionNameLabel");
        this.inp_dimName.setName("DimensionName");
        this.inp_dimName.setToolTipText(bundle.getString("DimDesigner.General.ToolTip.name.txt"));
        this.label_dimdescription = new JLabel();
        VisualUtilities.setLabelTextAndMnemonic(this.label_dimdescription, bundle.getString("Common.Description.txt"));
        this.inp_dimdescription = new WATextField(15);
        this.inp_dimdescription.setMaxCharacters(256);
        this.inp_dimdescription.setToolTipText(bundle.getString("DimDesigner.General.ToolTip.caption.txt"));
        this.label_dimdescription.setName("DimensionDescriptionLabel");
        this.inp_dimdescription.setName("DimensionDescription");
        this.inp_dimdescription.setPreferredSize(new Dimension(65, 20));
        this.label_dimnotes = new JLabel();
        VisualUtilities.setLabelTextAndMnemonic(this.label_dimnotes, bundle.getString("Common.Notes.txt"));
        this.inp_dimnotes = new WATextArea(2, 1);
        this.inp_dimnotes.setLineWrap(true);
        this.inp_dimnotes.setWrapStyleWord(true);
        this.ScrollNotes = new JScrollPane((Component)this.inp_dimnotes);
        this.inp_dimnotes.setToolTipText(bundle.getString("DimDesigner.General.ToolTip.notes.txt"));
        this.label_dimnotes.setName("DimensionNotesLabel");
        this.label_dimtype = new JLabel();
        VisualUtilities.setLabelTextAndMnemonic(this.label_dimtype, bundle.getString("Common.Type.txt"));
        this.inp_dimtype = new WAComboBox();
        this.inp_dimtype.setToolTipText(bundle.getString("DimDesigner.General.ToolTip.type.txt"));
        this.label_dimtype.setName("DimensionTypeLabel");
        this.inp_dimtype.setName("DimensionType");
        this.label_dimsortorder = new JLabel();
        VisualUtilities.setLabelTextAndMnemonic(this.label_dimsortorder, bundle.getString("DimDesigner.General.sortorder.txt"));
        this.inp_dimsortorder = new WAComboBox();
        this.inp_dimsortorder.setToolTipText(bundle.getString("DimDesigner.General.ToolTip.sort.txt"));
        this.label_dimsortorder.setName("DimensionSortOrderLabel");
        this.inp_dimsortorder.setName("DimensionSortOrder");
        this.label_dimName.setLabelFor((Component)this.inp_dimName);
        this.label_dimdescription.setLabelFor((Component)this.inp_dimdescription);
        this.label_dimnotes.setLabelFor((Component)this.inp_dimnotes);
        this.label_dimtype.setLabelFor((Component)this.inp_dimtype);
        this.label_dimsortorder.setLabelFor((Component)this.inp_dimsortorder);
        this.advanced = new JButton(bundle.getString("Common.AdvancedButton.txt"));
        this.advanced.setName("GeneralAdvanced");
        this.advanced.setToolTipText(bundle.getString("CubeDesigner.General.Advanced.tooltip.txt"));
        VisualUtilities.setButtonTextAndMnemonic(this.advanced, bundle.getString("Common.AdvancedButton.txt"));
        this.update = new JCheckBox();
        this.update.setName("DimGeneralNoUpdate");
        VisualUtilities.setButtonTextAndMnemonic(this.update, bundle.getString("DimDesigner.General.UpdateableDimension.control.label"));
        this.update.setToolTipText(bundle.getString("DimDesigner.NoDimensionUpdate.checkbox.ToolTip.txt"));
        dimGeneral.add((Component)this.label_dimName, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        dimGeneral.add((Component)this.inp_dimName, (Object)new GridBagConstraints(1, 0, 2, 1, 1.0, 1.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        dimGeneral.add((Component)this.label_dimdescription, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        dimGeneral.add((Component)this.inp_dimdescription, (Object)new GridBagConstraints(1, 1, 2, 1, 1.0, 1.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        dimGeneral.add((Component)this.label_dimnotes, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 5, 0, 5), 0, 0));
        dimGeneral.add((Component)this.ScrollNotes, (Object)new GridBagConstraints(1, 2, 2, 2, 1.0, 1.0, 17, 1, new Insets(5, 5, 0, 5), 0, 0));
        dimGeneral.add((Component)this.label_dimtype, (Object)new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        dimGeneral.add((Component)this.inp_dimtype, (Object)new GridBagConstraints(1, 4, 1, 1, 1.0, 1.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        dimGeneral.add((Component)this.update, (Object)new GridBagConstraints(2, 4, 1, 1, 1.0, 1.0, 17, 0, new Insets(5, 22, 0, 5), 0, 0));
        dimGeneral.add((Component)this.label_dimsortorder, (Object)new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 20), 0, 0));
        dimGeneral.add((Component)this.inp_dimsortorder, (Object)new GridBagConstraints(1, 5, 1, 1, 1.0, 1.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        dimGeneral.add((Component)this.advanced, (Object)new GridBagConstraints(2, 5, 1, 1, 1.0, 1.0, 17, 0, new Insets(5, 25, 0, 5), 0, 0));
        this.add((Component)dimGeneral, new GridBagConstraints(0, 0, 3, 1, 1.0, 1.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.starPanel = new WAPanel();
        this.starPanel.setLayout((LayoutManager)new GridBagLayout());
        TitledBorder titledBorder1 = new TitledBorder(bundle.getString("DimDesigner.StarSchemaPanel.title.txt"));
        this.starPanel.setBorder((Border)titledBorder1);
        this.useFactTable = new JCheckBox();
        this.useFactTable.setName("DimGeneralUseFactTable");
        VisualUtilities.setButtonTextAndMnemonic(this.useFactTable, bundle.getString("DimDesigner.General.UseFactTable.txt"));
        this.useFactTable.setToolTipText(bundle.getString("DimDesigner.General.UseFactTable.ToolTip.txt"));
        this.label_dimtable = new JLabel();
        VisualUtilities.setLabelTextAndMnemonic(this.label_dimtable, bundle.getString("DimDesigner.StarSchemaPanel.table.txt"));
        this.inp_dimtable = new WAComboBox();
        this.label_dimtable.setName("DimensionTableLabel");
        this.inp_dimtable.setName("DimensionTable");
        this.btnViewData = new JButton();
        this.btnViewData.setToolTipText(bundle.getString("DimDesigner.StarSchemaPanel.ViewData.tooltip.txt"));
        VisualUtilities.setButtonTextAndMnemonic(this.btnViewData, bundle.getString("DimDesigner.StarSchemaPanel.ViewData.txt"));
        this.btnViewData.setPreferredSize(new Dimension(170, 25));
        this.btnFactViewData = new JButton();
        this.btnFactViewData.setToolTipText(bundle.getString("DimDesigner.StarSchemaPanel.FactViewData.tip"));
        VisualUtilities.setButtonTextAndMnemonic(this.btnFactViewData, bundle.getString("DimDesigner.StarSchemaPanel.FactViewData.txt"));
        this.btnFactViewData.setPreferredSize(new Dimension(170, 25));
        this.label_dimkey = new JLabel();
        VisualUtilities.setLabelTextAndMnemonic(this.label_dimkey, bundle.getString("DimDesigner.StarSchemaPanel.dimkey.txt"));
        this.inp_dimkey = new WAComboBox();
        this.label_dimkey.setName("DimensionKeyLabel");
        this.inp_dimkey.setName("DimensionKey");
        this.label_factkey = new JLabel();
        VisualUtilities.setLabelTextAndMnemonic(this.label_factkey, bundle.getString("DimDesigner.StarSchemaPanel.factkey.txt"));
        this.inp_factkey = new WAComboBox();
        this.label_factkey.setName("DimensionFactKeyLabel");
        this.inp_factkey.setName("DimensionFactKey");
        this.inp_dimtable.setToolTipText(bundle.getString("DimDesigner.General.ToolTip.dimtable.txt"));
        this.inp_dimkey.setToolTipText(bundle.getString("DimDesigner.General.ToolTip.dimkey.txt"));
        this.inp_factkey.setToolTipText(bundle.getString("DimDesigner.General.ToolTip.factkey.txt"));
        this.label_dimtable.setLabelFor((Component)this.inp_dimtable);
        this.label_dimkey.setLabelFor((Component)this.inp_dimkey);
        this.label_factkey.setLabelFor((Component)this.inp_factkey);
        this.datasetoptions = new WATextArea(2, 1);
        this.label_datasetoptions = new JLabel();
        VisualUtilities.setLabelTextAndMnemonic(this.label_datasetoptions, bundle.getString("DimDesigner.General.TableOptions.Label.txt"));
        this.datasetoptions.setLineWrap(true);
        this.datasetoptions.setWrapStyleWord(true);
        this.label_datasetoptions.setLabelFor((Component)this.datasetoptions);
        this.DataScrollNotes = new JScrollPane((Component)this.datasetoptions);
        this.datasetoptions.setToolTipText(bundle.getString("DimDesigner.General.TableOptions.ToolTip.txt"));
        this.datasetoptions.setName("DimensionDataSetOptions");
        this.starPanel.add((Component)this.useFactTable, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 2, 0, 5), 0, 0));
        this.starPanel.add((Component)this.btnFactViewData, (Object)new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.starPanel.add((Component)this.label_dimtable, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 5), 0, 0));
        this.starPanel.add((Component)this.inp_dimtable, (Object)new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 17, 2, new Insets(10, 5, 0, 5), 0, 0));
        this.starPanel.add((Component)this.btnViewData, (Object)new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 5), 0, 0));
        this.starPanel.add((Component)this.label_dimkey, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.starPanel.add((Component)this.inp_dimkey, (Object)new GridBagConstraints(1, 2, 1, 1, 1.0, 1.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.starPanel.add((Component)this.label_factkey, (Object)new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.starPanel.add((Component)this.inp_factkey, (Object)new GridBagConstraints(1, 3, 1, 1, 1.0, 1.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.starPanel.add((Component)this.label_datasetoptions, (Object)new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.starPanel.add((Component)this.DataScrollNotes, (Object)new GridBagConstraints(1, 4, 2, 2, 1.0, 1.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this.starPanel, new GridBagConstraints(0, 6, 3, 1, 1.0, 1.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
    }

    public boolean validateData() {
        String type_input;
        if (!Utilities.isConnectedToMetadataServer((boolean)true)) {
            return false;
        }
        String dimName = this.inp_dimName.getText().trim();
        this.dimensionModel.setName(dimName);
        if (ModelUtilities.isBlank((String)this.modifyname) || !this.modifyname.equalsIgnoreCase(dimName)) {
            try {
                this.dimensionModel.verifyName();
            }
            catch (OLAPException OLAPError) {
                this.dimensionModel.setName(this.modifyname);
                return ExceptionHandler.handleException((Exception)((Object)OLAPError));
            }
        }
        String procSort = this.dimensionSet.getProcSort(this.inp_dimsortorder.getSelectedIndex());
        this.dimensionModel.setSortOrder(procSort);
        if (this.isStar) {
            this.factTableSelected = this.useFactTable.isSelected();
            if (this.selectedTable == null && !this.factTableSelected) {
                MessageUtil.displayMessage((String)bundle.getString("DimDesigner.General.NoTable.txt"), (int)0);
                return false;
            }
            if (!this.factTableSelected) {
                this.dimensionModel.setTable(this.selectedTable);
                OLAPColumn dimensionKey = (OLAPColumn)this.inp_dimkey.getSelectedItem();
                this.dimensionModel.setDimensionKey(dimensionKey);
                try {
                    this.dimensionModel.verifyStarSchemaKey();
                    this.dimensionModel.verifyStarSchemaTable();
                }
                catch (OLAPException OLAPError) {
                    this.dimensionModel.setTable(this.backUpDimensionTable);
                    this.dimensionModel.setDimensionKey(this.backUpDimensionKey);
                    return ExceptionHandler.handleException((Exception)((Object)OLAPError));
                }
                OLAPColumn factKey = null;
                int factSelection = this.inp_factkey.getSelectedIndex();
                if (factSelection > 0) {
                    factKey = (OLAPColumn)this.inp_factkey.getSelectedItem();
                }
                this.dimensionModel.setFactKey(factKey);
                try {
                    this.dimensionModel.verifyFactKey();
                }
                catch (OLAPException OLAPError) {
                    this.dimensionModel.setFactKey(this.backUpDimensionFactKey);
                    return ExceptionHandler.handleException((Exception)((Object)OLAPError));
                }
            }
            this.dimensionModel.setTable(this.factTable);
            this.dimensionModel.setFactKey(null);
            this.dimensionModel.setDimensionKey(null);
        }
        if (!(type_input = (String)this.inp_dimtype.getSelectedItem()).equals(this.dimensionModel.getType())) {
            this.dimensionModel.setType(type_input);
        }
        if (!this.modifyMode || !this.oldDimensionType.equals("TIME")) {
            try {
                this.dimensionModel.verifyUniqueTimeDimension();
            }
            catch (OLAPException OLAPError) {
                this.inp_dimtype.setSelectedIndex(0);
                this.dimensionModel.setType("STANDARD");
                return ExceptionHandler.handleException((Exception)((Object)OLAPError));
            }
        }
        if (!this.modifyMode || !this.oldDimensionType.equals("GEO")) {
            try {
                this.dimensionModel.verifyUniqueGeoDimension();
            }
            catch (OLAPException OLAPError) {
                this.inp_dimtype.setSelectedIndex(0);
                this.dimensionModel.setType("STANDARD");
                return ExceptionHandler.handleException((Exception)((Object)OLAPError));
            }
        }
        WAWizardDialog parent = (WAWizardDialog)this.getTopLevelAncestor();
        parent.addWizardData("DIMENSIONNAME", (Object)this.dimensionModel.getName());
        return true;
    }

    private class DimensionTableListener
    implements ActionListener {
        private DimensionTableListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            try {
                if (DimGeneralPanel.this.inp_dimtable.getSelectedIndex() != 0) {
                    DimGeneralPanel.this.inp_dimkey.removeActionListener((ActionListener)DimGeneralPanel.this.dimkeyListener);
                    DimGeneralPanel.this.selectedTable = (DimensionTable)DimGeneralPanel.this.inp_dimtable.getSelectedItem();
                    DimGeneralPanel.this.dimensionModel.setTable(DimGeneralPanel.this.selectedTable);
                    DimGeneralPanel.this.backUpDimensionTable = DimGeneralPanel.this.selectedTable;
                    if (!DimGeneralPanel.this.readOnly_flag) {
                        DimGeneralPanel.this.inp_dimkey.setEnabled(true);
                    }
                    DimGeneralPanel.this.inp_dimkey.removeAllItems();
                    DimGeneralPanel.this.inp_factkey.setEnabled(true);
                    DimGeneralPanel.this.dimColumns = (List)DimGeneralPanel.this.selectedTable.getColumns();
                    int size = DimGeneralPanel.this.dimColumns.size();
                    for (int i = 0; i < size; ++i) {
                        DimGeneralPanel.this.inp_dimkey.addItem(DimGeneralPanel.this.dimColumns.get(i));
                    }
                    DimGeneralPanel.this.inp_dimkey.addActionListener((ActionListener)DimGeneralPanel.this.dimkeyListener);
                    DimGeneralPanel.this.dimensionModel.setDimensionKey(null);
                    DimGeneralPanel.this.dimensionModel.setFactKey(null);
                    DimGeneralPanel.this.inp_dimkey.setSelectedItem((Object)DimGeneralPanel.this.dimensionModel.getDimensionKey());
                    DimGeneralPanel.this.inp_factkey.setSelectedItem((Object)DimGeneralPanel.this.dimensionModel.getFactKey());
                    DimGeneralPanel.this.btnViewData.setEnabled(true);
                } else {
                    DimGeneralPanel.this.inp_dimkey.removeAllItems();
                    DimGeneralPanel.this.inp_dimkey.setEnabled(false);
                    DimGeneralPanel.this.inp_factkey.setSelectedIndex(0);
                    DimGeneralPanel.this.inp_factkey.setEnabled(false);
                    DimGeneralPanel.this.selectedTable = null;
                    DimGeneralPanel.this.btnViewData.setEnabled(false);
                }
            }
            catch (OLAPException OLAPError) {
                ExceptionHandler.handleException((Exception)((Object)OLAPError));
            }
        }
    }

    private class dimensionKeyListener
    implements ActionListener {
        private dimensionKeyListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (DimGeneralPanel.this.selectedTable != null && !DimGeneralPanel.this.selectedTable.equals((OLAPTable)DimGeneralPanel.this.factTable) && !DimGeneralPanel.this.readOnly_flag) {
                DimGeneralPanel.this.inp_factkey.setEnabled(true);
            }
        }
    }

    private class FactTableListener
    implements ActionListener {
        private FactTableListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            DimGeneralPanel.this.inp_dimtable.removeActionListener((ActionListener)DimGeneralPanel.this.dimTableListener);
            if (DimGeneralPanel.this.useFactTable.isSelected()) {
                DimGeneralPanel.this.selectedTable = DimGeneralPanel.this.factTable;
                DimGeneralPanel.this.label_dimtable.setEnabled(false);
                DimGeneralPanel.this.inp_dimtable.setEnabled(false);
                DimGeneralPanel.this.label_dimkey.setEnabled(false);
                DimGeneralPanel.this.inp_dimkey.setEnabled(false);
                DimGeneralPanel.this.label_factkey.setEnabled(false);
                DimGeneralPanel.this.inp_factkey.setEnabled(false);
                DimGeneralPanel.this.label_datasetoptions.setEnabled(true);
                DimGeneralPanel.this.datasetoptions.setEnabled(true);
                DimGeneralPanel.this.inp_factkey.setSelectedIndex(0);
                DimGeneralPanel.this.inp_dimkey.removeAllItems();
                DimGeneralPanel.this.inp_dimtable.setSelectedIndex(0);
            } else {
                DimGeneralPanel.this.label_dimtable.setEnabled(true);
                DimGeneralPanel.this.inp_dimtable.setEnabled(true);
                DimGeneralPanel.this.label_dimkey.setEnabled(true);
                DimGeneralPanel.this.inp_dimkey.setEnabled(true);
                DimGeneralPanel.this.label_factkey.setEnabled(true);
                DimGeneralPanel.this.inp_factkey.setEnabled(true);
                DimGeneralPanel.this.label_datasetoptions.setEnabled(true);
                DimGeneralPanel.this.datasetoptions.setEnabled(true);
                DimGeneralPanel.this.selectedTable = null;
            }
            DimGeneralPanel.this.inp_dimtable.addActionListener((ActionListener)DimGeneralPanel.this.dimTableListener);
        }
    }

    private class AdvancedListener
    implements ActionListener {
        private AdvancedListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            DimGeneralAdvancedDialog advancedDialog = new DimGeneralAdvancedDialog(Workspace.getWorkspace(), bundle.getString("DimDesigner.General.Advanced.Title.txt"), DimGeneralPanel.this.dimensionModel);
            advancedDialog.show();
        }
    }

    private class ViewDataListener
    implements ActionListener {
        private ViewDataListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            WAWizardDialog parent = (WAWizardDialog)DimGeneralPanel.this.getTopLevelAncestor();
            try {
                PhysicalTable sourceTable = null;
                sourceTable = event.getSource().equals(DimGeneralPanel.this.btnViewData) ? DimGeneralPanel.this.selectedTable.getTable() : DimGeneralPanel.this.tableSet.getLoadTable().getTable();
                PhysicalTablePanel pnl2 = new PhysicalTablePanel(sourceTable, false);
                WAStandardDialog dlg = new WAStandardDialog((Dialog)parent, bundle.formatString("DimDesigner.StarSchemaPanel.ViewData.Title.fmt.txt", (Object)sourceTable.getName()), true, (WAPanel)pnl2);
                dlg.setApplyButtonVisible(false);
                dlg.setOKButtonVisible(false);
                dlg.setCancelButtonVisible(false);
                dlg.setCloseButtonVisible(true);
                dlg.setHelpButtonVisible(true);
                dlg.setHelpProduct("wdb");
                dlg.setHelpProduct("wdb");
                dlg.setResizable(true);
                dlg.setPreferredSize(new Dimension(700, 700));
                dlg.show();
            }
            catch (OLAPException e) {
                ExceptionHandler.handleException((Exception)((Object)e));
            }
            catch (RemoteException e) {
                ExceptionHandler.handleException((Exception)e);
            }
        }
    }
}

