/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.designer.visuals;

import com.sas.olapadmin.designer.model.AbstractOLAPModel;
import com.sas.olapadmin.designer.model.ModelUtilities;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPDimension;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.visuals.VisualUtilities;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.olapadmin.utilities.studio.RaggedMissingValuesPanel;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WATextArea;
import com.sas.workspace.WAdminResource;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;

public class DimGeneralAdvancedPanel
extends WAPanel {
    private static final long serialVersionUID = 1L;
    protected static WAdminResource bundle = new WAdminResource(DimGeneralAdvancedPanel.class);
    RaggedMissingValuesPanel raggedMissingPanel;
    OLAPDimension dimensionModel;
    WATextArea inheritMissingChar;
    WATextArea inheritMissingNum;
    JCheckBox inheritCubeSettings;
    OLAPCube olapCube;

    public DimGeneralAdvancedPanel(OLAPDimension inObject) {
        this.dimensionModel = inObject;
        this.setLayout(new GridBagLayout());
        this._layoutWidgets();
    }

    public boolean doDataExchange(boolean bSaveToModel) {
        if (!bSaveToModel) {
            try {
                this.raggedMissingPanel.doDataExchange(false);
                this.olapCube = this.dimensionModel.getOwningCube();
                String ignoreEmpty = null;
                ignoreEmpty = this.dimensionModel.getIgnoreEmpty();
                String cubeEmptyChar = this.olapCube.getEmptyChar();
                String cubeEmptyNum = this.olapCube.getEmptyNum();
                if (ignoreEmpty == null) {
                    if (this.raggedMissingPanel.skipMissingChar.isSelected() && this.raggedMissingPanel.skipMissingNum.isSelected()) {
                        this.inheritCubeSettings.setSelected(false);
                    } else {
                        this.inheritCubeSettings.setSelected(true);
                    }
                } else if (ignoreEmpty.equals("1")) {
                    this.inheritCubeSettings.setSelected(false);
                } else if (this.raggedMissingPanel.skipMissingChar.isSelected() && this.raggedMissingPanel.skipMissingNum.isSelected()) {
                    this.inheritCubeSettings.setSelected(false);
                } else {
                    this.inheritCubeSettings.setSelected(true);
                }
                if (cubeEmptyChar != null) {
                    if (ModelUtilities.isBlank((String)cubeEmptyChar)) {
                        this.inheritMissingChar.setText(bundle.getString("DimDesigner.RaggedMissing.Inherit.blankspace.txt"));
                    } else {
                        this.inheritMissingChar.setText(cubeEmptyChar);
                    }
                } else {
                    this.inheritMissingChar.setText(bundle.getString("DimDesigner.RaggedMissing.Inherit.default.txt"));
                }
                if (cubeEmptyNum != null) {
                    if (cubeEmptyNum.equals(".")) {
                        this.inheritMissingNum.setText(bundle.getString("DimDesigner.RaggedMissing.Inherit.singleperiod.txt"));
                    }
                    this.inheritMissingNum.setText(cubeEmptyNum);
                }
                this.inheritMissingNum.setText(bundle.getString("DimDesigner.RaggedMissing.Inherit.default.txt"));
            }
            catch (OLAPException oError) {
                return ExceptionHandler.handleException((Exception)((Object)oError));
            }
        } else {
            try {
                if (this.inheritCubeSettings.isSelected()) {
                    this.dimensionModel.setIgnoreEmpty("0");
                } else if (!this.inheritCubeSettings.isSelected()) {
                    if (!this.raggedMissingPanel.skipMissingChar.isSelected() || !this.raggedMissingPanel.skipMissingNum.isSelected()) {
                        this.dimensionModel.setIgnoreEmpty("1");
                    } else {
                        this.dimensionModel.setIgnoreEmpty("0");
                    }
                }
                this.raggedMissingPanel.saveDataToModel();
            }
            catch (OLAPException oError) {
                return ExceptionHandler.handleException((Exception)((Object)oError));
            }
        }
        return true;
    }

    public void _layoutWidgets() {
        this.inheritCubeSettings = new JCheckBox();
        VisualUtilities.setButtonTextAndMnemonic(this.inheritCubeSettings, bundle.getString("DimDesigner.RaggedMissing.Inherit.checkbox.label"));
        this.inheritCubeSettings.setName("RaggedInheritCubeSettings");
        this.inheritMissingChar = new WATextArea(2, 1);
        this.inheritMissingChar.setLineWrap(true);
        this.inheritMissingChar.setWrapStyleWord(true);
        this.inheritMissingChar.setBehavior(1);
        this.inheritMissingChar.setBackground((Color)SystemColor.control);
        JScrollPane inheritScrollChar = new JScrollPane((Component)this.inheritMissingChar);
        JLabel missingCharLabel = new JLabel();
        this.inheritMissingNum = new WATextArea(2, 1);
        this.inheritMissingNum.setLineWrap(true);
        this.inheritMissingNum.setWrapStyleWord(true);
        this.inheritMissingNum.setBehavior(1);
        this.inheritMissingNum.setBackground((Color)SystemColor.control);
        JScrollPane inheritScrollNum = new JScrollPane((Component)this.inheritMissingNum);
        this.inheritMissingChar.setName("RaggedInheritMissingChar");
        this.inheritMissingNum.setName("RaggedInheritMissingNum");
        JLabel missingNumLabel = new JLabel();
        VisualUtilities.setLabelTextAndMnemonic(missingCharLabel, bundle.getString("DimDesigner.RaggedMissing.Inherit.Char.control.label"));
        missingCharLabel.setLabelFor((Component)this.inheritMissingChar);
        VisualUtilities.setLabelTextAndMnemonic(missingNumLabel, bundle.getString("DimDesigner.RaggedMissing.Inherit.Num.control.label"));
        missingNumLabel.setLabelFor((Component)this.inheritMissingNum);
        this.raggedMissingPanel = new RaggedMissingValuesPanel((AbstractOLAPModel)this.dimensionModel);
        this.raggedMissingPanel.skipMissingChar.addActionListener(new disableInheritListener());
        this.raggedMissingPanel.skipMissingNum.addActionListener(new disableInheritListener());
        TitledBorder titledBorder = new TitledBorder(bundle.getString("DimDesigner.General.Advanced.BorderTitle.groupbox.title"));
        this.setBorder(titledBorder);
        this.add(this.inheritCubeSettings, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.add(missingCharLabel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 22, 0, 5), 0, 0));
        this.add(inheritScrollChar, new GridBagConstraints(2, 1, 2, 2, 0.0, 0.0, 17, 1, new Insets(0, 0, 10, 5), 0, 0));
        this.add(missingNumLabel, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 22, 0, 5), 0, 0));
        this.add(inheritScrollNum, new GridBagConstraints(2, 4, 2, 2, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 5), 0, 0));
        this.add((Component)((Object)this.raggedMissingPanel), new GridBagConstraints(0, 6, 3, 3, 0.0, 0.0, 18, 1, new Insets(0, 0, 5, 5), 0, 0));
    }

    public boolean validateData() {
        return true;
    }

    public class disableInheritListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent event) {
            if (DimGeneralAdvancedPanel.this.raggedMissingPanel.skipMissingChar.isSelected() && DimGeneralAdvancedPanel.this.raggedMissingPanel.skipMissingNum.isSelected()) {
                DimGeneralAdvancedPanel.this.inheritCubeSettings.setSelected(false);
            } else if (!DimGeneralAdvancedPanel.this.raggedMissingPanel.skipMissingChar.isSelected() || !DimGeneralAdvancedPanel.this.raggedMissingPanel.skipMissingNum.isSelected()) {
                DimGeneralAdvancedPanel.this.inheritCubeSettings.setSelected(true);
            }
        }
    }
}

