/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.designer.visuals;

import com.sas.olapadmin.designer.model.OLAPDimension;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPLevel;
import com.sas.olapadmin.designer.model.OLAPList;
import com.sas.olapadmin.designer.visuals.DimDimensionRenameDialog;
import com.sas.olapadmin.designer.visuals.VisualUtilities;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAdminResource;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class DimDimensionRenamePanel
extends WAPanel {
    private static final long serialVersionUID = 1L;
    protected static WAdminResource bundle = new WAdminResource(DimDimensionRenamePanel.class);
    protected JTextField inp_Name;
    protected JLabel label_Name;
    protected JLabel label_directions;
    protected OLAPDimension dimensionObject;

    public DimDimensionRenamePanel(OLAPDimension inDimensionObject) {
        this.dimensionObject = inDimensionObject;
        this.setLayout(new GridBagLayout());
        this._layoutWidgets();
    }

    public boolean validateData() {
        String newName = this.inp_Name.getText();
        if (newName.length() < 1) {
            MessageUtil.displayMessage((String)bundle.getString("DimDesigner.No.Name.txt"), (int)2);
            return false;
        }
        boolean levelNameIsFound = false;
        OLAPList availableLevels = null;
        try {
            availableLevels = this.dimensionObject.getLevels();
        }
        catch (OLAPException OLAPError) {
            return ExceptionHandler.handleException((Exception)((Object)OLAPError));
        }
        int i = 0;
        int size = availableLevels.size();
        while (i < size & !levelNameIsFound) {
            OLAPLevel level = (OLAPLevel)availableLevels.get(i);
            String levelName = level.getName();
            if (levelName.equalsIgnoreCase(newName)) {
                levelNameIsFound = true;
            }
            ++i;
        }
        if (levelNameIsFound) {
            MessageUtil.displayMessage((String)bundle.getString("DimDesigner.No.Name.txt"), (int)2);
            return false;
        }
        return true;
    }

    public boolean doDataExchange(boolean saveToModel) {
        if (saveToModel) {
            String newName = this.inp_Name.getText();
            DimDimensionRenameDialog parent = (DimDimensionRenameDialog)((Object)this.getTopLevelAncestor());
            parent.setDimensionName(newName);
        }
        return true;
    }

    private void _layoutWidgets() {
        this.label_directions = new JLabel(bundle.getString("DimDesigner.Change.DimensionName.tooltip.txt"));
        this.label_Name = new JLabel();
        VisualUtilities.setLabelTextAndMnemonic(this.label_Name, bundle.getString("DimDesigner.General.dimname.txt"));
        this.inp_Name = new JTextField();
        this.inp_Name.setName("DimensionNameChange");
        this.label_Name.setName("DimensionNameChangeLabel");
        this.inp_Name.setToolTipText(bundle.getString("DimDesigner.Change.DimensionName.tooltip.txt"));
        this.label_Name.setLabelFor(this.inp_Name);
        this.add(this.label_directions, new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 17, 1, new Insets(5, 10, 5, 10), 0, 0));
        this.add(this.label_Name, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 10, 5, 10), 0, 0));
        this.add(this.inp_Name, new GridBagConstraints(1, 1, 2, 1, 1.0, 1.0, 17, 1, new Insets(5, 10, 5, 10), 0, 0));
    }
}

