/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.designer.visuals;

import com.sas.olapadmin.designer.model.ModelUtilities;
import com.sas.olapadmin.designer.model.OLAPDimension;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPHierarchy;
import com.sas.olapadmin.designer.model.OLAPLevel;
import com.sas.olapadmin.designer.model.OLAPList;
import com.sas.olapadmin.designer.visuals.DimDetailLevelTab;
import com.sas.olapadmin.designer.visuals.DimGeneralTab;
import com.sas.olapadmin.designer.visuals.DimHierTab;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WAdminResource;
import java.awt.Frame;
import javax.swing.ImageIcon;

public class DimDesigner
extends WAWizardDialog {
    private static final long serialVersionUID = 1L;
    protected static WAdminResource bundle = new WAdminResource(DimDesigner.class);
    protected boolean modifyMode = false;
    protected OLAPDimension dimensionModel;

    public DimDesigner(Frame frame, String title, OLAPDimension inputDimensionModel) {
        super(frame, title, true);
        this.setCanFinishEarly(false);
        this.dimensionModel = inputDimensionModel;
        ImageIcon image = bundle.getImageIcon("DimDesigner.General.image");
        ImageIcon image2 = bundle.getImageIcon("DimDesigner.LevelDetail.image");
        ImageIcon image3 = bundle.getImageIcon("DimDesigner.Hierarchy.image");
        String imagename = bundle.getString("DimDesigner.General.image");
        String imagename2 = bundle.getString("DimDesigner.LevelDetail.image");
        String imagename3 = bundle.getString("DimDesigner.Hierarchy.image");
        this.addTab(bundle.getString("DimDesigner.General.top.txt"), "tab1", (WAPropertyTab)new DimGeneralTab(this.dimensionModel), imagename, image, false);
        this.addTab(bundle.getString("DimDesigner.DetailLevel.top.txt"), "tab2", (WAPropertyTab)new DimDetailLevelTab(this.dimensionModel), imagename2, image2, false);
        this.addTab(bundle.getString("DimDesigner.Hierarchypanel.txt"), "tab3", (WAPropertyTab)new DimHierTab(this.dimensionModel), imagename3, image3, true);
    }

    public boolean onCancel() {
        try {
            this.dimensionModel.undo();
            OLAPList listOfLevels = this.dimensionModel.getLevels();
            int size = listOfLevels.size();
            for (int i = 0; i < size; ++i) {
                OLAPLevel level = (OLAPLevel)listOfLevels.get(i);
                level.undo();
            }
            OLAPList listOfHierarchies = this.dimensionModel.getHierarchies();
            int size2 = listOfHierarchies.size();
            for (int i = 0; i < size2; ++i) {
                OLAPHierarchy hierarchy = (OLAPHierarchy)listOfHierarchies.get(i);
                hierarchy.undo();
            }
            if (ModelUtilities.isBlank((String)this.dimensionModel.getName())) {
                this.dimensionModel.delete();
            }
        }
        catch (OLAPException oError) {
            ExceptionHandler.handleException((Exception)((Object)oError));
        }
        return true;
    }
}

