/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.designer.visuals;

import com.sas.olapadmin.designer.model.AggregationSet;
import com.sas.olapadmin.designer.model.OLAPAggregation;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPList;
import com.sas.olapadmin.designer.visuals.CubeUserAggregationsHolapAddDialog;
import com.sas.olapadmin.designer.visuals.VisualUtilities;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.olapadmin.utilities.studio.CubeButtons;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WAdminResource;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class CubeUserAggregationsHolapPanel
extends WAPanel {
    private static final long serialVersionUID = 1L;
    private static WAdminResource bundle = new WAdminResource(CubeUserAggregationsHolapPanel.class);
    private JList aggregations;
    private JButton add;
    private JButton modify;
    private JButton delete;
    private DefaultListModel aggregationsDisplayed;
    private OLAPCube olapCube;
    private boolean initialized;
    private AggregationSet aggregationSet;

    public CubeUserAggregationsHolapPanel(OLAPCube inputOlapCube) {
        this.olapCube = inputOlapCube;
        this.setLayout(new GridBagLayout());
        this.layoutWidgets();
        this.initialized = false;
    }

    public boolean validateData() {
        return true;
    }

    protected void initialize() {
        this.aggregationSet = this.olapCube.getAggregationSet();
        this.aggregations.addListSelectionListener(new LevelSelectionListener());
        this.add.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    OLAPAggregation aggregation = CubeUserAggregationsHolapPanel.this.aggregationSet.createOLAPAggregation();
                    WAStandardDialog parent = (WAStandardDialog)CubeUserAggregationsHolapPanel.this.getTopLevelAncestor();
                    CubeUserAggregationsHolapAddDialog userAggregationDialog = new CubeUserAggregationsHolapAddDialog((Dialog)parent, bundle.getString("CubeDesigner.HOLAPUserAggregations.Contruct.txt"), CubeUserAggregationsHolapPanel.this.olapCube, aggregation);
                    userAggregationDialog.show();
                    if (userAggregationDialog.getReturnValue() == 1) {
                        CubeUserAggregationsHolapPanel.this.aggregationsDisplayed.addElement(aggregation);
                    } else {
                        aggregation.delete();
                    }
                }
                catch (OLAPException oError) {
                    ExceptionHandler.handleException((Exception)((Object)oError));
                }
            }
        });
        this.modify.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                OLAPAggregation aggregation = (OLAPAggregation)CubeUserAggregationsHolapPanel.this.aggregations.getSelectedValue();
                WAStandardDialog parent = (WAStandardDialog)CubeUserAggregationsHolapPanel.this.getTopLevelAncestor();
                CubeUserAggregationsHolapAddDialog userAggregationDialog = new CubeUserAggregationsHolapAddDialog((Dialog)parent, bundle.getString("CubeDesigner.HOLAPUserAggregations.Contruct.txt"), CubeUserAggregationsHolapPanel.this.olapCube, aggregation);
                userAggregationDialog.show();
                if (userAggregationDialog.getReturnValue() == 1) {
                    int where = CubeUserAggregationsHolapPanel.this.aggregationsDisplayed.indexOf(aggregation);
                    CubeUserAggregationsHolapPanel.this.aggregationsDisplayed.removeElement(aggregation);
                    CubeUserAggregationsHolapPanel.this.aggregationsDisplayed.add(where, aggregation);
                }
            }
        });
        this.delete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Object[] selectedAggregations = CubeUserAggregationsHolapPanel.this.aggregations.getSelectedValues();
                OLAPAggregation tempAggregation = null;
                int choice = 0;
                if (selectedAggregations.length == 1) {
                    tempAggregation = (OLAPAggregation)selectedAggregations[0];
                    choice = MessageUtil.displayMessage((String)bundle.formatString("CubeDesigner.Delete.Message.fmt.txt", (Object)tempAggregation.getName()), (String)bundle.getString("CubeDesigner.DeleteAggregation.window.title"), (int)1, (int)0);
                } else if (selectedAggregations.length > 1) {
                    choice = MessageUtil.displayMessage((String)bundle.getString("CubeDesigner.DeleteAggregations.txt"), (String)bundle.getString("CubeDesigner.DeleteAggregations.window.title"), (int)1, (int)0);
                }
                if (choice == 0) {
                    for (int i = selectedAggregations.length - 1; i >= 0; --i) {
                        tempAggregation = (OLAPAggregation)selectedAggregations[i];
                        CubeUserAggregationsHolapPanel.this.aggregationsDisplayed.removeElement(tempAggregation);
                        try {
                            tempAggregation.delete();
                        }
                        catch (OLAPException error) {
                            ExceptionHandler.handleException((Exception)((Object)error));
                        }
                        CubeUserAggregationsHolapPanel.this.modify.setEnabled(false);
                        CubeUserAggregationsHolapPanel.this.delete.setEnabled(false);
                    }
                }
            }
        });
        this.initialized = true;
    }

    public boolean doDataExchange(boolean saveToModel) {
        if (!saveToModel) {
            if (!this.initialized) {
                this.initialize();
            }
            this.add.setEnabled(true);
            this.modify.setEnabled(false);
            this.delete.setEnabled(false);
            OLAPList existingAggrs = null;
            try {
                existingAggrs = this.aggregationSet.getStoredAggregations();
                this.aggregationsDisplayed.clear();
                int size = existingAggrs.size();
                for (int i = 0; i < size; ++i) {
                    OLAPAggregation aggregation = (OLAPAggregation)existingAggrs.get(i);
                    if (aggregation.isNway()) {
                        this.aggregationsDisplayed.add(0, aggregation);
                        continue;
                    }
                    this.aggregationsDisplayed.addElement(aggregation);
                }
            }
            catch (OLAPException error) {
                return ExceptionHandler.handleException((Exception)((Object)error));
            }
            this.initialized = true;
        }
        return true;
    }

    protected void layoutWidgets() {
        this.aggregationsDisplayed = new DefaultListModel();
        this.aggregations = new JList(this.aggregationsDisplayed);
        this.aggregations.setName("HOLAPDefinedAggregations");
        JLabel labelListBox = new JLabel();
        VisualUtilities.setLabelTextAndMnemonic(labelListBox, bundle.getString("CubeDesigner.HOLAPAggregations.defined.control.label"));
        labelListBox.setLabelFor(this.aggregations);
        CubeButtons topbuttons = new CubeButtons();
        this.add = topbuttons.getAddButton();
        this.modify = topbuttons.getModifyButton();
        this.delete = topbuttons.getDeleteButton();
        this.add.setName("HOLAPAggregationsAdd");
        this.modify.setName("HOLAPAggregationsModify");
        this.delete.setName("HOLAPAggregationsDelete");
        topbuttons.removeApplyButton();
        topbuttons.removeDefaultButton();
        topbuttons.removeResetButton();
        this.aggregations.setToolTipText(bundle.getString("CubeDesigner.UserAggregationsHolap.ListBox.tooltip.txt"));
        this.add.setToolTipText(bundle.getString("CubeDesigner.UserAggregationsHolap.Add.tooltip.txt"));
        this.modify.setToolTipText(bundle.getString("CubeDesigner.UserAggregationsHolap.Modify.tooltip.txt"));
        this.delete.setToolTipText(bundle.getString("CubeDesigner.UserAggregationsHolap.Delete.tooltip.txt"));
        topbuttons.setName("ROLAPButtons");
        JScrollPane topPanel = new JScrollPane(this.aggregations);
        topPanel.setName("ScrollPaneAggregationsDefined");
        topPanel.setPreferredSize(new Dimension(350, 200));
        this.add(labelListBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.add(topPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 0, 0, 5), 0, 0));
        this.add((Component)((Object)topbuttons), new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 5, 0, 0), 0, 0));
    }

    class LevelSelectionListener
    implements ListSelectionListener {
        LevelSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            if (CubeUserAggregationsHolapPanel.this.aggregations.getSelectedIndex() == -1) {
                CubeUserAggregationsHolapPanel.this.delete.setEnabled(false);
                CubeUserAggregationsHolapPanel.this.modify.setEnabled(false);
            } else if (CubeUserAggregationsHolapPanel.this.aggregations.getSelectedIndex() == 0) {
                OLAPAggregation aggregation = (OLAPAggregation)CubeUserAggregationsHolapPanel.this.aggregationsDisplayed.elementAt(0);
                if (aggregation.isNway()) {
                    CubeUserAggregationsHolapPanel.this.modify.setEnabled(false);
                    CubeUserAggregationsHolapPanel.this.delete.setEnabled(false);
                } else {
                    CubeUserAggregationsHolapPanel.this.modify.setEnabled(CubeUserAggregationsHolapPanel.this.aggregations.getSelectedIndices().length == 1);
                    CubeUserAggregationsHolapPanel.this.delete.setEnabled(true);
                }
            } else {
                CubeUserAggregationsHolapPanel.this.delete.setEnabled(true);
                CubeUserAggregationsHolapPanel.this.modify.setEnabled(CubeUserAggregationsHolapPanel.this.aggregations.getSelectedIndices().length == 1);
            }
        }
    }
}

