/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.designer.visuals;

import com.sas.metadata.remote.PhysicalTable;
import com.sas.olapadmin.designer.model.AggregationSet;
import com.sas.olapadmin.designer.model.AggregationTable;
import com.sas.olapadmin.designer.model.ModelUtilities;
import com.sas.olapadmin.designer.model.OLAPAggregation;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPLevel;
import com.sas.olapadmin.designer.model.OLAPList;
import com.sas.olapadmin.designer.model.OLAPTable;
import com.sas.olapadmin.designer.model.TableSet;
import com.sas.olapadmin.designer.visuals.VisualUtilities;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.swing.visuals.dualselector.BaseDualSelector;
import com.sas.swing.visuals.dualselector.DualListSelector;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WATextArea;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAdminResource;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.border.TitledBorder;

public class CubeUserAggregationsHolapAddPanel
extends WAPanel {
    private static final long serialVersionUID = 1L;
    protected static WAdminResource bundle = new WAdminResource(CubeUserAggregationsHolapAddPanel.class);
    private JLabel label_aggrname;
    private WATextField inp_aggrname;
    private JLabel label_table;
    private WATextArea datasetoptions;
    private JLabel label_datasetoptions;
    private WAComboBox inp_table;
    private JScrollPane ScrollNotes;
    private DualListSelector selector;
    private DefaultListModel available;
    private DefaultListModel selected;
    private WAPanel addaggr;
    private TitledBorder titledBorder2;
    private OLAPCube olapCube;
    private boolean modifyflag;
    private OLAPList availableLevels;
    private OLAPAggregation aggregation;
    private String subsetclause;

    public CubeUserAggregationsHolapAddPanel(OLAPCube CM, OLAPAggregation inputAggregation) {
        this.olapCube = CM;
        this.aggregation = inputAggregation;
        this.setLayout(new GridBagLayout());
        this._layoutWidgets();
    }

    public boolean validateData() {
        TableSet tableSet = this.olapCube.getTableSet();
        String name = this.inp_aggrname.getText();
        String backUpName = this.aggregation.getName();
        AggregationTable aggrTable = null;
        AggregationTable backUpTable = null;
        PhysicalTable physicalTable = null;
        Object tempTable = this.inp_table.getSelectedItem();
        if (tempTable instanceof PhysicalTable) {
            physicalTable = (PhysicalTable)tempTable;
        }
        this.aggregation.setName(name);
        try {
            if (physicalTable != null) {
                aggrTable = tableSet.getAggregationTable(physicalTable);
            }
            backUpTable = this.aggregation.getAggregationTable();
            this.aggregation.setAggregationTable(aggrTable);
        }
        catch (OLAPException OLAPError) {
            return ExceptionHandler.handleException((Exception)((Object)OLAPError));
        }
        if (name == null || ModelUtilities.isBlank((String)name) || !name.equalsIgnoreCase(backUpName)) {
            try {
                this.aggregation.verifyName();
            }
            catch (OLAPException OLAPError) {
                this.aggregation.setName(backUpName);
                return ExceptionHandler.handleException((Exception)((Object)OLAPError));
            }
        }
        if (aggrTable == null || backUpTable != null && !aggrTable.equals((OLAPTable)backUpTable)) {
            try {
                this.aggregation.verifyTable();
            }
            catch (OLAPException OLAPError) {
                try {
                    this.aggregation.setAggregationTable(backUpTable);
                }
                catch (OLAPException oError) {
                    return ExceptionHandler.handleException((Exception)((Object)oError));
                }
                return ExceptionHandler.handleException((Exception)((Object)OLAPError));
            }
        }
        String datasettext = this.datasetoptions.getText();
        try {
            this.aggregation.setTableOptions(datasettext);
        }
        catch (OLAPException oError) {
            return ExceptionHandler.handleException((Exception)((Object)oError));
        }
        OLAPList aggregateList = null;
        try {
            aggregateList = this.aggregation.getLevels();
        }
        catch (OLAPException oError) {
            return ExceptionHandler.handleException((Exception)((Object)oError));
        }
        ArrayList<Object> backUpAggrs = new ArrayList<Object>();
        for (int i = 0; i < aggregateList.size(); ++i) {
            backUpAggrs.add(aggregateList.get(i));
        }
        aggregateList.clear();
        int size = this.selected.size();
        for (int ii = 0; ii < size; ++ii) {
            aggregateList.add(this.selected.elementAt(ii));
        }
        try {
            this.aggregation.verifyDrillPath();
            this.aggregation.verifyDuplicated();
        }
        catch (OLAPException OLAPError) {
            aggregateList.clear();
            for (int i = 0; i < backUpAggrs.size(); ++i) {
                aggregateList.add(backUpAggrs.get(i));
            }
            return ExceptionHandler.handleException((Exception)((Object)OLAPError));
        }
        try {
            this.aggregation.setType("ROLAP");
        }
        catch (OLAPException oError) {
            return ExceptionHandler.handleException((Exception)((Object)oError));
        }
        return true;
    }

    protected void initialize() {
        this.inp_table.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                CubeUserAggregationsHolapAddPanel.this.available.clear();
                CubeUserAggregationsHolapAddPanel.this.selected.clear();
                if (CubeUserAggregationsHolapAddPanel.this.inp_table.getSelectedIndex() > 0) {
                    try {
                        TableSet tableSet = CubeUserAggregationsHolapAddPanel.this.olapCube.getTableSet();
                        PhysicalTable selectedtable = (PhysicalTable)CubeUserAggregationsHolapAddPanel.this.inp_table.getSelectedItem();
                        AggregationTable aggrTable = tableSet.getAggregationTable(selectedtable);
                        CubeUserAggregationsHolapAddPanel.this.availableLevels = aggrTable.getPossibleLevels();
                    }
                    catch (OLAPException OLAPError) {
                        ExceptionHandler.handleException((Exception)((Object)OLAPError));
                    }
                    int size = CubeUserAggregationsHolapAddPanel.this.availableLevels.size();
                    for (int i = 0; i < size; ++i) {
                        CubeUserAggregationsHolapAddPanel.this.available.addElement(CubeUserAggregationsHolapAddPanel.this.availableLevels.get(i));
                    }
                }
            }
        });
    }

    public boolean doDataExchange(boolean saveToModel) {
        if (!saveToModel) {
            AggregationSet aggregationSet = this.olapCube.getAggregationSet();
            this.initialize();
            this.modifyflag = !ModelUtilities.isBlank((String)this.aggregation.getName());
            this.inp_table.removeAllItems();
            String nullstring = " ";
            this.inp_table.addItem((Object)nullstring);
            OLAPList aggregationTables = null;
            try {
                aggregationTables = aggregationSet.getTables();
            }
            catch (OLAPException OLAPError) {
                return ExceptionHandler.handleException((Exception)((Object)OLAPError));
            }
            int size = aggregationTables.size();
            for (int i = 0; i < size; ++i) {
                AggregationTable table = (AggregationTable)aggregationTables.get(i);
                this.inp_table.addItem((Object)table.getTable());
            }
            if (this.modifyflag) {
                OLAPList useraggregations = null;
                AggregationTable selectedtable = null;
                try {
                    useraggregations = this.aggregation.getLevels();
                    selectedtable = this.aggregation.getAggregationTable();
                    this.availableLevels = selectedtable.getPossibleLevels();
                    String useraggrname = this.aggregation.getName();
                    this.inp_aggrname.setText(useraggrname);
                    this.subsetclause = this.aggregation.getTableOptions();
                    if (this.subsetclause != null && !ModelUtilities.isBlank((String)this.subsetclause)) {
                        this.datasetoptions.setText(this.subsetclause);
                    }
                }
                catch (OLAPException OLAPError) {
                    return ExceptionHandler.handleException((Exception)((Object)OLAPError));
                }
                this.inp_table.setSelectedItem((Object)selectedtable.getTable());
                boolean found = false;
                this.selected.removeAllElements();
                this.available.removeAllElements();
                if (this.availableLevels != null) {
                    int size2 = this.availableLevels.size();
                    for (int jj = 0; jj < size2; ++jj) {
                        OLAPLevel level = (OLAPLevel)this.availableLevels.get(jj);
                        found = false;
                        int x = 0;
                        while (x < useraggregations.size() & !found) {
                            OLAPLevel levelSelected = (OLAPLevel)useraggregations.get(x);
                            if (levelSelected.equals(level)) {
                                found = true;
                                this.selected.addElement(level);
                            }
                            ++x;
                        }
                        if (found) continue;
                        this.available.addElement(level);
                    }
                } else {
                    MessageUtil.displayMessage((String)bundle.getString("CubeDesigner.UserAggregationsHolap.AggrTableDeleted.txt"));
                    return false;
                }
            }
            this.selector.setModel((ListModel)this.available);
            this.selector.setTargetModel((ListModel)this.selected);
        }
        return true;
    }

    private void _layoutWidgets() {
        this.selector = new DualListSelector();
        this.selector.setToolTipText(bundle.getString("CubeDesigner.UserAggregationsHolap.DualListBox.tooltip.txt"));
        this.inp_table = new WAComboBox();
        this.label_table = new JLabel();
        this.label_table.setName("HOLAPAggregationTableLabel");
        this.inp_table.setName("HOLAPAggregationTable");
        this.available = new DefaultListModel();
        this.selected = new DefaultListModel();
        this.addaggr = new WAPanel();
        this.addaggr.setLayout((LayoutManager)new GridBagLayout());
        VisualUtilities.setDualSelectorTextAndMnemonic((BaseDualSelector)this.selector, bundle.getString("CubeDesigner.DualListbox.leftlistbox.txt"), bundle.getString("CubeDesigner.DualListbox.rightlistbox.txt"));
        this.selector.setTargetControlsVisible(true);
        this.selector.setName("ROLAPLevelListBox");
        this.inp_aggrname = new WATextField(10);
        this.inp_aggrname.setMaxCharacters(60);
        this.inp_aggrname.setName("ROLAPAggregationName");
        this.inp_table.setToolTipText(bundle.getString("CubeDesigner.UserAggregationsHolap.Table.tooltip.txt"));
        this.label_aggrname = new JLabel();
        this.inp_aggrname.setToolTipText(bundle.getString("CubeDesigner.UserAggregationsHolap.Name.tooltip.txt"));
        VisualUtilities.setLabelTextAndMnemonic(this.label_aggrname, bundle.getString("DimDesigner.General.dimname.txt"));
        this.label_aggrname.setLabelFor((Component)this.inp_aggrname);
        this.label_aggrname.setName("ROLAPAggregationNameLabel");
        VisualUtilities.setLabelTextAndMnemonic(this.label_table, bundle.getString("CubeDesigner.UserAggregationsHolap.Label.txt"));
        this.label_table.setLabelFor((Component)this.inp_table);
        this.add(this.label_aggrname, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 10), 0, 0));
        this.add((Component)this.inp_aggrname, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(5, 0, 5, 10), 0, 0));
        this.add(this.label_table, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 10), 0, 0));
        this.add((Component)this.inp_table, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 17, 2, new Insets(5, 0, 5, 30), 0, 0));
        this.datasetoptions = new WATextArea();
        this.label_datasetoptions = new JLabel();
        VisualUtilities.setLabelTextAndMnemonic(this.label_datasetoptions, bundle.getString("CubeDesigner.UserAggregationsHolap.TableOptions.Label.txt"));
        this.label_datasetoptions.setName("DataSetOptionsLabel");
        this.datasetoptions.setLineWrap(true);
        this.datasetoptions.setWrapStyleWord(true);
        this.label_datasetoptions.setLabelFor((Component)this.datasetoptions);
        this.ScrollNotes = new JScrollPane((Component)this.datasetoptions);
        this.ScrollNotes.setPreferredSize(new Dimension(200, 50));
        this.datasetoptions.setToolTipText(bundle.getString("CubeDesigner.UserAggregationsHolap.TableOptions.ToolTip.txt"));
        this.ScrollNotes.setName("ScrollDataSetoptions");
        this.datasetoptions.setName("DataSetOptions");
        this.add(this.label_datasetoptions, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 10), 0, 0));
        this.add(this.ScrollNotes, new GridBagConstraints(1, 2, 2, 2, 1.0, 1.0, 17, 2, new Insets(5, 0, 5, 10), 0, 0));
        this.selector.setPreferredSize(new Dimension(300, 200));
        this.selector.setDragAndDropEnabled(false);
        this.add((Component)this.selector, new GridBagConstraints(0, 4, 2, 2, 0.0, 0.0, 17, 1, new Insets(5, 0, 5, 10), 0, 0));
        this.setBorder(this.titledBorder2);
    }
}

