/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.designer.visuals;

import com.sas.olapadmin.designer.model.ModelUtilities;
import com.sas.olapadmin.designer.model.OLAPAggregation;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPLevel;
import com.sas.olapadmin.designer.model.OLAPList;
import com.sas.olapadmin.designer.visuals.VisualUtilities;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.olapadmin.utilities.studio.CubeButtons;
import com.sas.swing.visuals.dualselector.BaseDualSelector;
import com.sas.swing.visuals.dualselector.DualListSelector;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAdminResource;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.border.TitledBorder;

public class CubeUserAggregationAddPanel
extends WAPanel {
    private static final long serialVersionUID = 1L;
    protected static WAdminResource bundle = new WAdminResource(CubeUserAggregationAddPanel.class);
    protected JList aggregations;
    protected JLabel label_aggrname;
    protected WATextField inp_aggrname;
    protected CubeButtons topbuttons = new CubeButtons();
    protected CubeButtons botbuttons = new CubeButtons();
    protected JButton add;
    protected JButton modify;
    protected JButton delete;
    protected JButton apply;
    protected JButton reset;
    protected DefaultListModel aggrlistModel;
    protected DualListSelector selector;
    protected DefaultListModel available;
    protected DefaultListModel selected;
    protected JCheckBox inp_noNWAY = new JCheckBox(bundle.getString("CubeDesigner.General.NONWAY.txt"));
    protected int availableSize;
    protected WAPanel addaggr;
    protected TitledBorder titledBorder2;
    protected OLAPCube cubeModel;
    protected boolean initialized = false;
    protected boolean modifyflag = false;
    protected boolean addmodifyselected = false;
    protected OLAPAggregation UAM;
    protected List allLevels;

    public CubeUserAggregationAddPanel(OLAPCube CM, OLAPAggregation inUAM, List inallLevels) {
        this.cubeModel = CM;
        this.allLevels = inallLevels;
        this.UAM = inUAM;
        this.setLayout(new GridBagLayout());
        this._layoutWidgets();
    }

    public boolean validateData() {
        String backUpName = this.UAM.getName();
        String name = this.inp_aggrname.getText();
        ArrayList<Object> backUpAggrs = null;
        this.UAM.setName(name);
        OLAPList aggregateList = null;
        try {
            aggregateList = this.UAM.getLevels();
        }
        catch (OLAPException oError) {
            return ExceptionHandler.handleException((Exception)((Object)oError));
        }
        backUpAggrs = new ArrayList<Object>();
        for (int i = 0; i < aggregateList.size(); ++i) {
            backUpAggrs.add(aggregateList.get(i));
        }
        aggregateList.clear();
        int size = this.selected.size();
        for (int ii = 0; ii < size; ++ii) {
            aggregateList.add(this.selected.elementAt(ii));
        }
        try {
            this.UAM.verifyName();
        }
        catch (OLAPException OLAPError) {
            this.UAM.setName(backUpName);
            return ExceptionHandler.handleException((Exception)((Object)OLAPError));
        }
        try {
            this.UAM.verifyDrillPath();
            this.UAM.verifyDuplicated();
        }
        catch (OLAPException OLAPError) {
            aggregateList.clear();
            for (int i = 0; i < backUpAggrs.size(); ++i) {
                aggregateList.add(backUpAggrs.get(i));
            }
            return ExceptionHandler.handleException((Exception)((Object)OLAPError));
        }
        return true;
    }

    public boolean doDataExchange(boolean saveToModel) {
        if (!saveToModel) {
            OLAPList aggregationLevels = null;
            this.selected.clear();
            this.available.clear();
            if (!ModelUtilities.isBlank((String)this.UAM.getName())) {
                this.modifyflag = true;
                String aggrname = this.UAM.getName();
                this.inp_aggrname.setText(aggrname);
            } else {
                this.inp_aggrname.setText("");
                this.modifyflag = false;
            }
            try {
                aggregationLevels = this.UAM.getLevels();
            }
            catch (OLAPException e) {
                return ExceptionHandler.handleException((Exception)((Object)e));
            }
            int size = aggregationLevels.size();
            for (int x = 0; x < size; ++x) {
                this.selected.addElement(aggregationLevels.get(x));
            }
            for (int jj = 0; jj < this.allLevels.size(); ++jj) {
                OLAPLevel LM = (OLAPLevel)this.allLevels.get(jj);
                String availablelevelname = LM.getName();
                boolean found = false;
                int x = 0;
                int size2 = aggregationLevels.size();
                while (x < size2 & !found) {
                    OLAPLevel LMSelected = (OLAPLevel)aggregationLevels.get(x);
                    String selectedlevelname = LMSelected.getName();
                    if (selectedlevelname.equalsIgnoreCase(availablelevelname)) {
                        found = true;
                    }
                    ++x;
                }
                if (found) continue;
                this.available.addElement(LM);
            }
            this.selector.setModel((ListModel)this.available);
            this.availableSize = this.available.size();
            this.selector.setTargetModel((ListModel)this.selected);
        } else {
            try {
                this.UAM.setType("MOLAP");
            }
            catch (OLAPException oError) {
                return ExceptionHandler.handleException((Exception)((Object)oError));
            }
        }
        return true;
    }

    private void _layoutWidgets() {
        this.selector = new DualListSelector();
        this.selector.setToolTipText(bundle.getString("CubeDesigner.UserAggregations.DualListBox.tooltip.txt"));
        this.selector.setName("MOLAPAggregationListBox");
        this.inp_aggrname = new WATextField(20);
        this.inp_aggrname.setMaxCharacters(60);
        this.inp_aggrname.setName("MOLAPAggregationName");
        this.label_aggrname = new JLabel();
        VisualUtilities.setLabelTextAndMnemonic(this.label_aggrname, bundle.getString("DimDesigner.General.dimname.txt"));
        this.label_aggrname.setLabelFor((Component)this.inp_aggrname);
        this.label_aggrname.setName("MOLAPAggregationNameLabel");
        this.inp_aggrname.setToolTipText(bundle.getString("CubeDesigner.UserAggregations.Name.tooltip.txt"));
        this.available = new DefaultListModel();
        this.selected = new DefaultListModel();
        VisualUtilities.setDualSelectorTextAndMnemonic((BaseDualSelector)this.selector, bundle.getString("CubeDesigner.DualListbox.leftlistbox.txt"), bundle.getString("CubeDesigner.DualListbox.rightlistbox.txt"));
        this.titledBorder2 = new TitledBorder(bundle.getString("CubeDesigner.UserAggregations.Contruct.txt"));
        this.selector.setTargetControlsVisible(true);
        this.add(this.label_aggrname, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 5, 10), 0, 0));
        this.add((Component)this.inp_aggrname, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(5, 10, 5, 10), 0, 0));
        this.selector.setPreferredSize(new Dimension(375, 250));
        this.selector.setDragAndDropEnabled(false);
        this.add((Component)this.selector, new GridBagConstraints(0, 2, 2, 3, 1.0, 1.0, 17, 1, new Insets(5, 10, 5, 10), 0, 0));
    }
}

