/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.designer.visuals;

import com.sas.metadata.remote.MdException;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.visuals.VisualUtilities;
import com.sas.olapadmin.utilities.Utilities;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAdminResource;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.rmi.RemoteException;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class CubeRenamePanel
extends WAPanel {
    private static final long serialVersionUID = 1L;
    private OLAPCube cubeModel;
    private JTextField input;
    private JLabel label;
    private JLabel directions;
    protected static WAdminResource bundle = new WAdminResource(CubeRenamePanel.class);

    public CubeRenamePanel(String newname, OLAPCube inModel) {
        this.cubeModel = inModel;
        this.setHelpProduct("olapadmin");
        this.setHelpTopic("cube_rename");
        this.setLayout(new GridBagLayout());
        this._layoutWidgets();
        this.input.setText(newname);
    }

    private void _layoutWidgets() {
        this.directions = new JLabel(bundle.getString("CubeDesigner.RenameCube.Instructions.txt"));
        this.add(this.directions, new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.label = new JLabel();
        VisualUtilities.setLabelTextAndMnemonic(this.label, bundle.getString("CubeDesigner.RenameCube.Label.txt"));
        this.add(this.label, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
        this.input = new JTextField();
        this.input.setName("CubeNameChange");
        this.input.setToolTipText(bundle.getString("CubeDesigner.RenameCube.Input.tooltip.txt"));
        this.label.setLabelFor(this.input);
        this.add(this.input, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 0, 0), 0, 0));
    }

    public String getName() {
        return this.input.getText();
    }

    public boolean validateData() {
        if (!Utilities.isConnectedToMetadataServer((boolean)true)) {
            return false;
        }
        try {
            this.cubeModel.setName(this.input.getText());
            this.cubeModel.verifyName();
        }
        catch (OLAPException e) {
            MessageUtil.displayMessage((String)bundle.getString("CubeDesigner.RenameCube.NotUnique.txt"));
            return false;
        }
        return true;
    }

    public boolean doDataExchange(boolean saveToModel) throws MdException, RemoteException {
        return true;
    }
}

