/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.designer.visuals;

import com.sas.olapadmin.designer.model.DimensionSet;
import com.sas.olapadmin.designer.model.ModelUtilities;
import com.sas.olapadmin.designer.model.OLAPColumn;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPHierarchy;
import com.sas.olapadmin.designer.model.OLAPLevel;
import com.sas.olapadmin.designer.model.OLAPList;
import com.sas.olapadmin.designer.model.OLAPMemberProperty;
import com.sas.olapadmin.designer.model.OLAPSharedDimension;
import com.sas.olapadmin.designer.model.TableSet;
import com.sas.olapadmin.designer.visuals.VisualUtilities;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.olapadmin.utilities.Utilities;
import com.sas.swing.visuals.dualselector.BaseDualSelector;
import com.sas.swing.visuals.dualselector.DualListSelector;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WATextArea;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAdminResource;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.border.TitledBorder;

public class CubeMemberPropertiesAddPanel
extends WAPanel {
    private static final long serialVersionUID = 1L;
    protected static WAdminResource bundle = new WAdminResource(CubeMemberPropertiesAddPanel.class);
    protected WATextField inp_level;
    protected WAComboBox inp_property;
    protected JLabel label_level;
    protected JLabel label_property;
    protected WATextField inp_caption;
    protected JLabel label_name;
    protected WATextField inp_format;
    protected JLabel label_format;
    protected WATextField inp_name;
    protected WATextArea inp_description;
    protected JLabel label_caption;
    protected JLabel label_description;
    protected int availableSize;
    protected TitledBorder titledBorder1;
    protected OLAPCube cubeModel;
    protected boolean initialized;
    protected OLAPMemberProperty olapProperty;
    protected DualListSelector selector = new DualListSelector();
    protected DefaultListModel selectedmodel = new DefaultListModel();
    protected DefaultListModel availablemodel = new DefaultListModel();
    protected List hierarchyList;
    protected List starSchemaColumns;
    protected List AvailableColumns;
    protected propertyListener inputPropertyListener;
    protected JScrollPane DataScrollNotes;
    protected boolean starSchemaflag;
    protected boolean modifyflag;
    protected TableSet tableSet;
    protected DimensionSet dimensionSet;
    protected List backUpHierarchies;
    protected OLAPLevel level;
    private OLAPSharedDimension sharedDim;
    private boolean isShared;

    public CubeMemberPropertiesAddPanel(OLAPCube CM, OLAPMemberProperty inolapProperty, List inHierarchyList, OLAPLevel inputLevel) {
        this.cubeModel = CM;
        this.olapProperty = inolapProperty;
        this.hierarchyList = inHierarchyList;
        this.level = inputLevel;
        this.setLayout(new GridBagLayout());
        this._layoutWidgets();
    }

    public CubeMemberPropertiesAddPanel(OLAPCube CM, OLAPMemberProperty inolapProperty, List inHierarchyList, List inStarSchemaColumns, OLAPLevel inputLevel) {
        this.cubeModel = CM;
        this.olapProperty = inolapProperty;
        this.hierarchyList = inHierarchyList;
        this.starSchemaColumns = inStarSchemaColumns;
        this.starSchemaflag = true;
        this.level = inputLevel;
        this.setLayout(new GridBagLayout());
        this._layoutWidgets();
    }

    public CubeMemberPropertiesAddPanel(OLAPSharedDimension inOLAPDim, OLAPMemberProperty inolapProperty, List inHierarchyList, List inStarSchemaColumns, OLAPLevel inputLevel) {
        this.sharedDim = inOLAPDim;
        this.olapProperty = inolapProperty;
        this.hierarchyList = inHierarchyList;
        this.starSchemaColumns = inStarSchemaColumns;
        this.starSchemaflag = true;
        this.level = inputLevel;
        this.isShared = true;
        this.setLayout(new GridBagLayout());
        this._layoutWidgets();
    }

    protected void initialize() {
        if (!this.isShared) {
            this.tableSet = this.cubeModel.getTableSet();
            this.dimensionSet = this.cubeModel.getDimensionSet();
        } else {
            this.tableSet = this.sharedDim.getTableSet();
            this.dimensionSet = this.sharedDim.getDimensionSet();
        }
        this.backUpHierarchies = new ArrayList();
        try {
            int i;
            this.inp_property.removeAllItems();
            if (!this.starSchemaflag) {
                this.AvailableColumns = this.tableSet.getLoadTable().getColumns();
                for (i = 0; i < this.AvailableColumns.size(); ++i) {
                    this.inp_property.addItem(this.AvailableColumns.get(i));
                }
            } else {
                int size = this.starSchemaColumns.size();
                for (i = 0; i < size; ++i) {
                    this.inp_property.addItem(this.starSchemaColumns.get(i));
                }
            }
        }
        catch (OLAPException OLAPError) {
            ExceptionHandler.handleException((Exception)((Object)OLAPError));
        }
        this.inp_property.addItem((Object)" ");
        this.inputPropertyListener = new propertyListener();
        this.inp_level.setText(this.level.toString());
        this.inp_level.setEnabled(false);
        this.inp_property.addActionListener((ActionListener)this.inputPropertyListener);
        if (!ModelUtilities.isBlank((String)this.olapProperty.getName())) {
            this.modifyflag = true;
            OLAPList hierarchies = null;
            try {
                hierarchies = this.olapProperty.getHierarchies();
            }
            catch (OLAPException OLAPError) {
                ExceptionHandler.handleException((Exception)((Object)OLAPError));
            }
            for (int i = 0; i < this.hierarchyList.size(); ++i) {
                OLAPHierarchy HM = (OLAPHierarchy)this.hierarchyList.get(i);
                if (hierarchies.contains(HM)) {
                    this.selectedmodel.addElement(HM);
                    this.backUpHierarchies.add(HM);
                    continue;
                }
                this.availablemodel.addElement(HM);
            }
            this.inp_property.setEnabled(false);
            this.inp_name.setText(this.olapProperty.getName());
            try {
                OLAPColumn levelLayer;
                if (this.olapProperty.getName().equalsIgnoreCase("SAS_SPATIAL_ID") && (levelLayer = this.olapProperty.getAssociatedLevel().getMapLayer()) != null) {
                    this.inp_name.setEnabled(false);
                    this.selector.setEnabled(false);
                }
                this.inp_property.setSelectedItem((Object)this.olapProperty.getColumn());
            }
            catch (OLAPException OLAPError) {
                ExceptionHandler.handleException((Exception)((Object)OLAPError));
            }
            this.inp_format.setText(this.olapProperty.getSASFormat());
            this.inp_caption.setText(this.olapProperty.getDesc());
            try {
                this.inp_description.setText(this.olapProperty.getNotes());
            }
            catch (OLAPException OLAPError) {
                ExceptionHandler.handleException((Exception)((Object)OLAPError));
            }
        } else {
            for (int i = 0; i < this.hierarchyList.size(); ++i) {
                this.selectedmodel.addElement(this.hierarchyList.get(i));
            }
        }
        VisualUtilities.setDualSelectorTextAndMnemonic((BaseDualSelector)this.selector, bundle.getString("CubeDesigner.DualListbox.leftlistbox.txt"), bundle.getString("CubeDesigner.DualListbox.rightlistbox.txt"));
        this.selector.setTargetControlsVisible(false);
        this.selector.setTransferAllControlsVisible(true);
        this.selector.setDragAndDropEnabled(false);
        this.initialized = true;
    }

    public boolean doDataExchange(boolean saveToModel) {
        if (!saveToModel) {
            String checkCube;
            if (!this.initialized) {
                this.initialize();
            }
            if (!this.isShared && (checkCube = this.cubeModel.getType()).equals("HOLAP")) {
                this.inp_format.setEnabled(false);
            }
        } else {
            String notesString;
            this.olapProperty.setSASFormat(this.inp_format.getText());
            String caption = this.inp_caption.getText();
            if (caption != null && !ModelUtilities.isBlank((String)caption)) {
                this.olapProperty.setDesc(caption);
            }
            if (!ModelUtilities.isBlank((String)(notesString = this.inp_description.getText()))) {
                this.olapProperty.setNotes(notesString);
            }
        }
        return true;
    }

    public boolean validateData() {
        String backUpName = null;
        OLAPColumn backUpColumn = null;
        try {
            backUpName = this.olapProperty.getName();
            this.olapProperty.setName(this.inp_name.getText());
            this.olapProperty.verifyName();
            this.olapProperty.setAssociatedLevel(this.level);
            this.olapProperty.verifyAssociatedLevel();
            backUpColumn = this.olapProperty.getColumn();
            int isPropertySelected = this.inp_property.getSelectedIndex();
            if (isPropertySelected > 0) {
                OLAPColumn checkingProperty = (OLAPColumn)this.inp_property.getSelectedItem();
                this.olapProperty.setColumn(checkingProperty);
            }
            this.olapProperty.verifyColumn();
        }
        catch (OLAPException oError) {
            this.olapProperty.setColumn(backUpColumn);
            return ExceptionHandler.handleException((Exception)((Object)oError));
        }
        OLAPList hierarchyList = null;
        try {
            OLAPHierarchy hierarchy;
            int i;
            hierarchyList = this.olapProperty.getHierarchies();
            for (i = hierarchyList.size() - 1; i >= 0; --i) {
                hierarchy = (OLAPHierarchy)hierarchyList.get(i);
                if (this.selectedmodel.contains(hierarchy)) continue;
                hierarchyList.remove((Object)hierarchy);
            }
            for (i = 0; i < this.selectedmodel.size(); ++i) {
                hierarchy = (OLAPHierarchy)this.selectedmodel.elementAt(i);
                if (hierarchyList.contains((Object)hierarchy)) continue;
                hierarchyList.add((Object)hierarchy);
            }
            this.olapProperty.verifyHierarchies();
            this.olapProperty.verifyUniqueOLAPMemberProperty();
        }
        catch (OLAPException OLAPError) {
            hierarchyList.clear();
            int size = this.backUpHierarchies.size();
            for (int i = 0; i < size; ++i) {
                hierarchyList.add(this.backUpHierarchies.get(i));
            }
            return ExceptionHandler.handleException((Exception)((Object)OLAPError));
        }
        return true;
    }

    private void _layoutWidgets() {
        this.setLayout(new GridBagLayout());
        this.inp_level = new WATextField();
        this.inp_level.setName("MemberPropertyLevel");
        this.inp_level.setToolTipText(bundle.getString("CubeDesigner.MemberProperty.Level.ToolTip.txt"));
        this.inp_level.setPreferredSize(new Dimension(40, 20));
        this.inp_property = new WAComboBox(true);
        this.inp_property.setName("MemberPropertyProperty");
        this.inp_property.setToolTipText(bundle.getString("CubeDesigner.MemberProperty.Property.ToolTip.txt"));
        this.inp_property.setPreferredSize(new Dimension(40, 20));
        this.label_level = new JLabel();
        VisualUtilities.setLabelTextAndMnemonic(this.label_level, bundle.getString("Common.Levelwithcolon.txt"));
        this.label_level.setName("MemberPropertyLevelLabel");
        this.label_level.setLabelFor((Component)this.inp_level);
        this.label_property = new JLabel();
        VisualUtilities.setLabelTextAndMnemonic(this.label_property, bundle.getString("Common.Properties.txt"));
        this.label_property.setLabelFor((Component)this.inp_property);
        this.label_property.setName("MemberPropertyPropertyLabel");
        this.inp_caption = new WATextField(30);
        this.inp_caption.setName("MemberPropertyCaption");
        this.inp_caption.setToolTipText(bundle.getString("CubeDesigner.MemberProperty.Caption.ToolTip.txt"));
        this.inp_caption.setPreferredSize(new Dimension(40, 20));
        this.inp_description = new WATextArea(2, 1);
        this.inp_description.setName("MemberPropertyDescription");
        this.inp_description.setToolTipText(bundle.getString("CubeDesigner.MemberProperty.Description.ToolTip.txt"));
        this.inp_description.setLineWrap(true);
        this.inp_description.setWrapStyleWord(true);
        this.DataScrollNotes = new JScrollPane((Component)this.inp_description);
        this.DataScrollNotes.setName("MemberPropertyNotes");
        this.DataScrollNotes.setToolTipText(bundle.getString("CubeDesigner.MemberProperty.Description.ToolTip.txt"));
        this.label_caption = new JLabel();
        this.label_caption.setName("MemberPropertyCaptionLabel");
        VisualUtilities.setLabelTextAndMnemonic(this.label_caption, bundle.getString("CubeDesigner.MemberProperty.Caption.Label.txt"));
        this.label_caption.setLabelFor((Component)this.inp_caption);
        this.label_description = new JLabel(bundle.getString("Common.Notes.txt"));
        this.label_description.setLabelFor((Component)this.inp_description);
        VisualUtilities.setLabelTextAndMnemonic(this.label_description, bundle.getString("Common.Notes.txt"));
        this.label_description.setLabelFor((Component)this.inp_description);
        this.label_description.setName("MemberPropertyDescriptionLabel");
        this.label_name = new JLabel();
        VisualUtilities.setLabelTextAndMnemonic(this.label_name, bundle.getString("DimDesigner.General.dimname.txt"));
        this.label_name.setName("MemberPropertyNameLabel");
        this.inp_name = new WATextField(30);
        this.inp_name.setToolTipText(bundle.getString("CubeDesigner.MemberProperty.Name.ToolTip.txt"));
        this.inp_name.setName("MemberPropertyName");
        this.inp_name.setPreferredSize(new Dimension(40, 20));
        this.label_name.setLabelFor((Component)this.inp_name);
        this.label_format = new JLabel();
        VisualUtilities.setLabelTextAndMnemonic(this.label_format, bundle.getString("CubeDesigner.MemberProperty.Format.txt"));
        this.label_format.setName("MemberPropertyFormatLabel");
        this.inp_format = new WATextField(30);
        this.inp_format.setToolTipText(bundle.getString("CubeDesigner.MemberProperty.Format.ToolTip.txt"));
        this.inp_format.setName("MemberPropertyFormat");
        this.inp_format.setPreferredSize(new Dimension(40, 20));
        this.label_format.setLabelFor((Component)this.inp_format);
        this.add(this.label_level, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(15, 0, 5, 10), 0, 0));
        this.add((Component)this.inp_level, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(15, 0, 5, 100), 0, 0));
        this.add(this.label_property, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 0, new Insets(15, 0, 5, 10), 0, 0));
        this.add((Component)this.inp_property, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 17, 2, new Insets(15, 0, 5, 100), 0, 0));
        this.add(this.label_name, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 17, 0, new Insets(15, 0, 5, 10), 0, 0));
        this.add((Component)this.inp_name, new GridBagConstraints(1, 2, 1, 1, 1.0, 1.0, 17, 2, new Insets(15, 0, 5, 100), 0, 0));
        this.add(this.label_format, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 17, 0, new Insets(15, 0, 5, 10), 0, 0));
        this.add((Component)this.inp_format, new GridBagConstraints(1, 3, 1, 1, 1.0, 1.0, 17, 2, new Insets(15, 0, 5, 100), 0, 0));
        this.add(this.label_caption, new GridBagConstraints(0, 4, 1, 1, 1.0, 1.0, 17, 0, new Insets(15, 0, 5, 10), 0, 0));
        this.add((Component)this.inp_caption, new GridBagConstraints(1, 4, 1, 1, 1.0, 1.0, 17, 2, new Insets(15, 0, 5, 10), 0, 0));
        this.add(this.label_description, new GridBagConstraints(0, 5, 1, 1, 1.0, 1.0, 17, 0, new Insets(15, 0, 5, 10), 0, 0));
        this.add(this.DataScrollNotes, new GridBagConstraints(1, 5, 1, 1, 1.0, 1.0, 17, 2, new Insets(15, 0, 5, 10), 0, 0));
        this.selector.setPreferredSize(new Dimension(150, 125));
        this.selector.setName("MemberPropertyHierarchyListBox");
        this.selector.setToolTipText(bundle.getString("CubeDesigner.MemberProperty.Hierarchy.ToolTip.txt"));
        this.selector.setTargetModel((ListModel)this.selectedmodel);
        this.selector.setModel((ListModel)this.availablemodel);
        this.add((Component)this.selector, new GridBagConstraints(0, 6, 2, 2, 1.0, 1.0, 17, 1, new Insets(15, 0, 5, 10), 0, 0));
    }

    public class propertyListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent event) {
            OLAPColumn CP;
            String returnColumn;
            if (!CubeMemberPropertiesAddPanel.this.modifyflag & !Utilities.isBlank((String)(returnColumn = CubeMemberPropertiesAddPanel.this.inp_property.getSelectedItem().toString())) && (CP = (OLAPColumn)CubeMemberPropertiesAddPanel.this.inp_property.getSelectedItem()) != null) {
                CubeMemberPropertiesAddPanel.this.inp_caption.setText(CP.getDescription());
                CubeMemberPropertiesAddPanel.this.inp_format.setText(CP.getSASFormat());
                CubeMemberPropertiesAddPanel.this.inp_name.setText(CP.getSASColumnName());
            }
        }
    }
}

