/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.designer.visuals;

import com.sas.metadata.remote.MdException;
import com.sas.olapadmin.designer.model.AggregationTable;
import com.sas.olapadmin.designer.model.ModelUtilities;
import com.sas.olapadmin.designer.model.OLAPColumn;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPLevel;
import com.sas.olapadmin.designer.model.OLAPList;
import com.sas.olapadmin.designer.model.OLAPMeasure;
import com.sas.olapadmin.designer.model.Statistic;
import com.sas.olapadmin.designer.visuals.CubeMeasuresSelectPanel;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.olapadmin.utilities.studio.PopulateOnDemandDisabledWideCombo;
import com.sas.visuals.Resources;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsAbstractTableColumn;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsIconTableColumn;
import com.sas.workspace.WsObjectTableColumn;
import com.sas.workspace.WsStringTableColumn;
import com.sas.workspace.WsTable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JTable;

public class CubeMeasuresSelectModel
extends WsAbstractTableModel {
    private static final long serialVersionUID = 1L;
    private static WAdminResource bundle = WAdminResource.getBundle(CubeMeasuresSelectModel.class);
    public static final int MEASURE_ICON = 0;
    public static final int COLUMN_NAME = 1;
    public static final int MEASURE_NAME = 2;
    public static final int STATISTIC = 3;
    public static final int CAPTION = 4;
    public static final int FORMAT = 5;
    public static final int UNITS = 6;
    public static final int DESC = 7;
    public static final int MEASURE = 8;
    public static final int STATISTICOBJ = 9;
    private static final int TOTAL_COLS = 8;
    private static final int TOTAL_HIDDEN_COLS = 2;
    private OLAPList measures;
    private List allstats;
    private AggregationTable aggrTable;
    private OLAPCube olapCube;
    private CubeMeasuresSelectPanel owningTab;
    private static final String SELECT_ONE = bundle.getString("Common.SelectOne.txt");
    private static final String NONE = bundle.getString("Common.None.txt");
    private static final String DERIVED = bundle.getString("Common.Derived.txt");
    private static final String NUNIQUE_INCLUDE = bundle.getString("MeasuresTab.MeasuresSelectInclude.txt");
    private static final String NUNIQUE_EXCLUDE = bundle.getString("MeasuresTab.MeasuresSelectExclude.txt");
    private boolean isHolap;
    private boolean error;

    public CubeMeasuresSelectModel(OLAPCube cube, CubeMeasuresSelectPanel measuresTab) {
        this.olapCube = cube;
        this.isHolap = this.olapCube.getType().equalsIgnoreCase("HOLAP");
        this.allstats = new ArrayList();
        this.owningTab = measuresTab;
        this.createColumnDefinitions();
    }

    public void addMeasures(List newmeasures) {
        if (newmeasures != null) {
            int start = this.getRowCount();
            for (int i = 0; i < newmeasures.size(); ++i) {
                OLAPMeasure measure = (OLAPMeasure)newmeasures.get(i);
                this.createRow(measure);
            }
            int end = this.getRowCount();
            if (start != end) {
                this.fireTableRowsInserted(start, end - 1);
            }
        }
    }

    protected void createColumnDefinitions() {
        this.m_aColumns = new WsAbstractTableColumn[this.getColumnCount() + this.getHiddenColumnCount()];
        this.m_aColumns[0] = new WsIconTableColumn(0, " ", 18);
        this.m_aColumns[1] = new WsStringTableColumn(1, bundle.getString("CubeDesigner.MeasuresModel.Column.header.title"), 100, 32);
        this.m_aColumns[1].setEditable(false);
        this.m_aColumns[3] = new StatisticsColumn(3, bundle.getString("CubeDesigner.MeasuresModel.Stat.header.title"), 150);
        this.m_aColumns[2] = new WsStringTableColumn(2, bundle.getString("CubeDesigner.MeasuresModel.Name.header.title"), 100, 32);
        this.m_aColumns[4] = new WsStringTableColumn(4, bundle.getString("CubeDesigner.MeasuresModel.Caption.header.title"), 200, 200);
        this.m_aColumns[5] = new WsStringTableColumn(5, bundle.getString("CubeDesigner.MeasuresModel.Formats.header.title"), 100, ModelUtilities.formats);
        this.m_aColumns[6] = new WsStringTableColumn(6, bundle.getString("CubeDesigner.MeasuresModel.Units.header.title"), 100, 32);
        this.m_aColumns[7] = new WsStringTableColumn(7, bundle.getString("CubeDesigner.MeasuresModel.Notes.header.title"), 100, 256);
        this.m_aColumns[8] = new WsObjectTableColumn();
        this.m_aColumns[9] = new WsObjectTableColumn();
    }

    private void createRow(OLAPMeasure measure) {
        ArrayList<Object> alRow = new ArrayList<Object>(this.getColumnCount() + this.getHiddenColumnCount());
        Statistic stat = null;
        try {
            if (measure.isNunique() != null && measure.isNunique().booleanValue()) {
                alRow.add(0, Resources.getImageIcon((String)"OLAPLevel.gif", (int)16));
                OLAPLevel level = measure.getLevel();
                if (level != null) {
                    alRow.add(1, level.getName());
                }
                alRow.add(2, measure.getName());
                boolean include = measure.getIncludeCalculatedMembers();
                if (include) {
                    alRow.add(3, NUNIQUE_INCLUDE);
                } else {
                    alRow.add(3, NUNIQUE_EXCLUDE);
                }
                stat = measure.getStatistic();
            } else {
                alRow.add(0, Resources.getImageIcon((String)"TypeNumeric.gif", (int)16));
                OLAPColumn column = measure.getInputColumn();
                if (column != null) {
                    alRow.add(1, column.getSASColumnName());
                } else {
                    alRow.add(1, SELECT_ONE);
                }
                alRow.add(2, measure.getName());
                stat = measure.getStatistic();
                if (stat != null) {
                    alRow.add(3, stat.getLabel());
                    String aggrColValue = SELECT_ONE;
                    if (this.isHolap && !stat.isDerived() && this.aggrTable != null) {
                        OLAPColumn aggrCol = measure.getAggregateColumn(this.aggrTable);
                        if (aggrCol != null) {
                            aggrColValue = aggrCol;
                        }
                    } else {
                        aggrColValue = NONE;
                    }
                }
            }
            alRow.add(4, measure.getDesc());
            alRow.add(5, measure.getSASFormat());
            alRow.add(6, measure.getUnits());
            alRow.add(7, measure.getNotes());
            alRow.add(8, measure);
            if (stat != null) {
                alRow.add(9, stat);
            }
        }
        catch (OLAPException e) {
            ExceptionHandler.handleException((Exception)((Object)e));
        }
        this.m_lData.add(alRow);
    }

    public int getColumnCount() {
        return 8;
    }

    public int getHiddenColumnCount() {
        return 2;
    }

    public OLAPMeasure getMeasureForRow(int rowNum) {
        return (OLAPMeasure)this.getValueAt(rowNum, 8);
    }

    public boolean isCellEditable(int row, int col) {
        OLAPMeasure measure;
        boolean isEditable = true;
        isEditable = col == 3 ? (measure = this.getMeasureForRow(row)).isNunique().booleanValue() : super.isCellEditable(row, col);
        return isEditable;
    }

    public boolean isInError() {
        return this.error;
    }

    public void moveDataToModel() {
        int nRows = this.m_lData.size();
        if (nRows > 0) {
            this.m_lData.clear();
            this.fireTableRowsDeleted(0, nRows - 1);
        }
        nRows = this.measures.size();
        for (int i = 0; i < nRows; ++i) {
            OLAPMeasure measure = (OLAPMeasure)this.measures.get(i);
            this.createRow(measure);
        }
        this.fireTableModelPopulated();
    }

    public void moveDataToStore() throws MdException, RemoteException {
    }

    public void populateStore() {
    }

    public void resetError() {
        this.error = false;
    }

    public void setValueAt(Object value, int iRow, int iCol) {
        this.error = false;
        String oldValue = (String)this.getValueAt(iRow, iCol);
        OLAPMeasure measure = (OLAPMeasure)this.getValueAt(iRow, 8);
        try {
            if (iCol == 2) {
                if (ModelUtilities.isBlank((String)value.toString())) {
                    value = oldValue;
                } else {
                    measure.setName((String)value);
                    try {
                        measure.verifyName();
                        value = measure.getName();
                    }
                    catch (OLAPException e) {
                        ExceptionHandler.handleException((Exception)((Object)e));
                        measure.setName(oldValue);
                        this.error = true;
                        return;
                    }
                }
            } else if (iCol == 3) {
                Statistic stat = (Statistic)this.getValueAt(iRow, 9);
                if (measure.isNunique() != null && measure.isNunique().booleanValue()) {
                    boolean include = measure.getIncludeCalculatedMembers();
                    if (include) {
                        measure.setIncludeCalculatedMembers("0");
                    } else {
                        measure.setIncludeCalculatedMembers("1");
                    }
                    stat = measure.getStatistic();
                } else if (stat != null) {
                    this.setStatisticDefaults(iRow, measure, stat);
                }
            } else if (iCol == 4) {
                if (ModelUtilities.isBlank((String)((String)value))) {
                    value = oldValue;
                } else {
                    measure.setDesc((String)value);
                }
            } else if (iCol == 5) {
                String format = (String)value;
                measure.setSASFormat((String)value);
                if (ModelUtilities.isBlank((String)format)) {
                    format = measure.getSASFormat();
                    MessageUtil.displayMessage((String)bundle.formatString("CubeDesigner.MeasuresModel.UseDefault.txt", (Object)format), (int)1);
                    value = format;
                }
                measure.setSASFormat((String)value);
            } else if (iCol == 6) {
                measure.setUnits((String)value);
            } else if (iCol == 7) {
                measure.setNotes((String)value);
            }
            super.setValueAt(value, iRow, iCol);
        }
        catch (OLAPException e) {
            ExceptionHandler.handleException((Exception)((Object)e));
        }
    }

    private void setStatisticDefaults(int iRow, OLAPMeasure measure, Statistic stat) throws OLAPException {
        String oldDefaultName = measure.getDefaultName();
        String oldName = (String)this.getValueAt(iRow, 2);
        String oldDefaultDesc = measure.getDefaultDesc();
        String oldDesc = (String)this.getValueAt(iRow, 4);
        String oldDefaultFmt = measure.getDefaultSASFormat();
        String oldFmt = (String)this.getValueAt(iRow, 5);
        measure.setStatistic(stat);
        if (oldDefaultName.equalsIgnoreCase(oldName)) {
            this.setValueAt(measure.getDefaultName(), iRow, 2);
        }
        if (oldDefaultDesc.equalsIgnoreCase(oldDesc)) {
            this.setValueAt(measure.getDefaultDesc(), iRow, 4);
        }
        if (oldDefaultFmt.equalsIgnoreCase(oldFmt)) {
            this.setValueAt(measure.getDefaultSASFormat(), iRow, 5);
        }
    }

    public void setLists(OLAPList measures2) {
        this.measures = measures2;
    }

    private class StatisticsColumn
    extends PopulateOnDemandDisabledWideCombo {
        private String[] nuniqueStats;

        public StatisticsColumn(int modelIndex, String name, int cxWidth) {
            super(modelIndex, name, cxWidth);
            this.nuniqueStats = new String[2];
            this.nuniqueStats[0] = NUNIQUE_EXCLUDE;
            this.nuniqueStats[1] = NUNIQUE_INCLUDE;
        }

        protected void populate(JTable table, int row, int column) {
            OLAPMeasure measure = (OLAPMeasure)CubeMeasuresSelectModel.this.getValueAt(row = ((WsTable)table).convertRowIndexToModel(row), 8);
            if (measure.isNunique() != null && measure.isNunique().booleanValue()) {
                this.setDefaultValue(this.nuniqueStats[0]);
                this.setPossibleValues(Arrays.asList(this.nuniqueStats));
            }
        }
    }
}

