/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.designer.visuals;

import com.sas.olapadmin.designer.model.MeasureSet;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPList;
import com.sas.olapadmin.designer.model.OLAPMeasure;
import com.sas.olapadmin.designer.visuals.CubeMeasuresHolapDetailTableModel;
import com.sas.olapadmin.designer.visuals.VisualUtilities;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsTable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;

public class CubeMeasuresHolapDetailPanel
extends WAPropertyTab
implements TableModelListener {
    private static final long serialVersionUID = 1L;
    protected static WAdminResource bundle = new WAdminResource(CubeMeasuresHolapDetailPanel.class);
    private WsTable detailsTable;
    private CubeMeasuresHolapDetailTableModel tableModel;
    private OLAPList measures;
    private OLAPCube olapCube;
    private WAComboBox defaultMeasureBox;
    private boolean initialized;
    private MeasureSet measureSet;

    public CubeMeasuresHolapDetailPanel(OLAPCube inputOLAPCube) {
        this.olapCube = inputOLAPCube;
        this.setLayout(new GridBagLayout());
        this.layoutWidgets();
        this.initialized = false;
    }

    public boolean doDataExchange(boolean saveToModel) {
        if (!saveToModel) {
            this.initialize();
        }
        return true;
    }

    protected void initialize() {
        try {
            if (this.measureSet == null) {
                this.measureSet = this.olapCube.getMeasureSet();
            }
            if (this.measures == null) {
                this.measures = this.measureSet.getMeasures();
            }
            CaseInsensitiveComparator sorter = new CaseInsensitiveComparator();
            ArrayList sortedList = new ArrayList(this.measures);
            Collections.sort(sortedList, sorter);
            OLAPMeasure defaultMeasure = null;
            this.defaultMeasureBox.removeAllItems();
            if (!this.measures.isEmpty()) {
                defaultMeasure = (OLAPMeasure)this.measures.get(0);
            }
            int size = sortedList.size();
            for (int i = 0; i < size; ++i) {
                this.defaultMeasureBox.addItem(sortedList.get(i));
            }
            if (defaultMeasure != null) {
                this.defaultMeasureBox.setSelectedItem((Object)defaultMeasure);
            }
            this.detailsTable.clearSortMemory();
            this.tableModel.setSortedList(sortedList);
            this.tableModel.moveDataToModel();
            if (!this.initialized) {
                this.initialized = true;
                this.defaultMeasureBox.addActionListener((ActionListener)new cDefaultBoxActionListener());
                this.detailsTable.getModel().addTableModelListener(this);
            }
        }
        catch (OLAPException error) {
            ExceptionHandler.handleException((Exception)((Object)error));
        }
        if (this.tableModel.getRowCount() > 0) {
            this.detailsTable.selectCell(0, 0);
        }
    }

    protected void layoutWidgets() {
        JLabel dfltMeasureLabel = new JLabel();
        this.defaultMeasureBox = new WAComboBox();
        dfltMeasureLabel.setName("defaultMeasureLabel");
        this.defaultMeasureBox.setName("defaultMeasureBox");
        VisualUtilities.setLabelTextAndMnemonic(dfltMeasureLabel, bundle.getString("CubeDesigner.MeasureDetail.defaultMeasureLabel.txt"));
        dfltMeasureLabel.setLabelFor((Component)this.defaultMeasureBox);
        this.add(dfltMeasureLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.add((Component)this.defaultMeasureBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 5, 5, 0), 0, 0));
        this.tableModel = new CubeMeasuresHolapDetailTableModel(this.olapCube);
        this.detailsTable = new WsTable((WsAbstractTableModel)this.tableModel);
        this.detailsTable.setSortingEnabled(true);
        this.detailsTable.setColumnHidingEnabled(false);
        this.detailsTable.setColumnsReorderable(false);
        this.detailsTable.setRowHoldingEnabled(false);
        this.detailsTable.setColumnHeaderPopupMenuEnabled(false);
        this.detailsTable.setOriginPopupMenuEnabled(false);
        this.detailsTable.setPopupMenuEnabled(false);
        this.detailsTable.setRowHeaderPopupMenuEnabled(false);
        this.detailsTable.setTablePopupMenuEnabled(false);
        this.detailsTable.setViewportPopupMenuEnabled(false);
        this.detailsTable.setToolTipText(bundle.getString("CubeDesigner.MeasureDetail.TableToolTip.txt"));
        this.detailsTable.setName("MeasuresDetailTable");
        this.detailsTable.setPreferredScrollableViewportSize(new Dimension(300, 200));
        this.detailsTable.setAutoResizeMode(0);
        JScrollPane topPanel = new JScrollPane((Component)this.detailsTable);
        this.add(topPanel, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 18, 1, new Insets(5, 0, 0, 0), 0, 0));
    }

    public boolean validateData() {
        TableCellEditor cellEditor = this.detailsTable.getCellEditor();
        if (cellEditor != null) {
            cellEditor.stopCellEditing();
        }
        boolean inError = this.tableModel.isInError();
        this.tableModel.resetError();
        return !inError;
    }

    public void onBack() {
        TableCellEditor ce = this.detailsTable.getCellEditor();
        if (ce != null) {
            ce.stopCellEditing();
        }
    }

    @Override
    public void tableChanged(TableModelEvent error) {
        this.defaultMeasureBox.repaint();
    }

    private class CaseInsensitiveComparator
    implements Comparator {
        private CaseInsensitiveComparator() {
        }

        public int compare(Object o1, Object o2) {
            String s1 = o1.toString();
            String s2 = o2.toString();
            return s1.compareToIgnoreCase(s2);
        }
    }

    private class cDefaultBoxActionListener
    implements ActionListener {
        private cDefaultBoxActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            TableCellEditor ce = CubeMeasuresHolapDetailPanel.this.detailsTable.getCellEditor();
            if (ce != null) {
                ce.stopCellEditing();
            }
            try {
                OLAPMeasure newDefaultMeasure = (OLAPMeasure)CubeMeasuresHolapDetailPanel.this.defaultMeasureBox.getSelectedItem();
                OLAPMeasure defaultMeasure = CubeMeasuresHolapDetailPanel.this.measureSet.getDefaultMeasure();
                if (newDefaultMeasure != null && !newDefaultMeasure.equals(defaultMeasure)) {
                    CubeMeasuresHolapDetailPanel.this.measureSet.setDefaultMeasure(newDefaultMeasure);
                    defaultMeasure = newDefaultMeasure;
                }
            }
            catch (OLAPException e) {
                ExceptionHandler.handleException((Exception)((Object)e));
            }
        }
    }
}

