/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.designer.visuals;

import com.sas.olapadmin.designer.model.MeasureSet;
import com.sas.olapadmin.designer.model.ModelUtilities;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPHierarchy;
import com.sas.olapadmin.designer.model.OLAPLevel;
import com.sas.olapadmin.designer.model.OLAPList;
import com.sas.olapadmin.designer.model.OLAPMeasure;
import com.sas.olapadmin.designer.model.Statistic;
import com.sas.olapadmin.designer.visuals.CubeMeasuresDistinctCountDialog;
import com.sas.olapadmin.designer.visuals.VisualUtilities;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.olapadmin.utilities.studio.CubeButtons;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAdminResource;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class CubeMeasuresHolapDerivedPanel
extends WAPanel {
    private static final long serialVersionUID = 1L;
    protected static WAdminResource bundle = new WAdminResource(CubeMeasuresHolapDerivedPanel.class);
    private boolean initialized;
    private CubeButtons topbuttons;
    private CubeButtons botbuttons;
    private JList derivedListBox;
    private DefaultListModel derivedListModel;
    private JLabel derivedStatLabel;
    private WAComboBox derivedStatSelectBox;
    private JLabel analysisGroupLabel;
    private WAComboBox analysisGroupSelectBox;
    private JLabel measNameLabel;
    private WATextField measNameSelectBox;
    private JButton add;
    private JButton modify;
    private JButton delete;
    private JButton apply;
    private JButton reset;
    private OLAPCube olapCube;
    private OLAPMeasure selectedMeasure;
    private MeasureSet measureSet;
    private DefaultListModel listModel;
    private JList NUniqueList;
    private JScrollPane NUniqueListScroll;
    private WAPanel definedNUniquePanel;
    private CubeMeasuresDistinctCountDialog defineDlg;
    private Map existingNunique;
    private JButton button_nunique;
    private Map selectedNunique;
    private OLAPMeasure measure;
    List sortedList;

    public CubeMeasuresHolapDerivedPanel(OLAPCube inputOLAPCube) {
        this.olapCube = inputOLAPCube;
        this.setLayout(new GridBagLayout());
        this.layoutWidgets();
        this.initialized = false;
        this.sortedList = new ArrayList();
    }

    public boolean doDataExchange(boolean saveToModel) {
        block10: {
            try {
                if (saveToModel) break block10;
                if (!this.initialized) {
                    this.initialize();
                }
                this.derivedStatSelectBox.setSelectedItem((Object)"");
                this.analysisGroupSelectBox.setSelectedItem((Object)"");
                this.measNameSelectBox.setText("");
                this.selectedMeasure = null;
                this.derivedListBox.clearSelection();
                this.derivedListBox.setEnabled(true);
                if (this.measureSet == null) {
                    this.measureSet = this.olapCube.getMeasureSet();
                }
                OLAPList possibleGroups = this.measureSet.getGroupNames();
                this.analysisGroupSelectBox.removeAllItems();
                int size = possibleGroups.size();
                for (int i = 0; i < size; ++i) {
                    String groupName = (String)possibleGroups.get(i);
                    OLAPList possibleDerivedStatistics = this.measureSet.getPossibleDerivedStatisticsByGroupName(groupName);
                    if (possibleDerivedStatistics.isEmpty()) continue;
                    this.analysisGroupSelectBox.addItem((Object)groupName);
                }
                this.add.setEnabled(true);
                this.add.requestFocus();
                this.modify.setEnabled(false);
                this.delete.setEnabled(false);
                this.apply.setEnabled(false);
                this.reset.setEnabled(false);
                this.derivedStatSelectBox.setEnabled(false);
                this.analysisGroupSelectBox.setEnabled(false);
                this.measNameSelectBox.setEnabled(false);
                OLAPList derivedMeasures = this.measureSet.getDerivedMeasures();
                Map existingNunique = this.getExistingNunique();
                OLAPList nuniqueMeasures = null;
                try {
                    nuniqueMeasures = this.measureSet.getNUniqueMeasures();
                }
                catch (OLAPException e) {
                    e.printStackTrace();
                }
                if (nuniqueMeasures.isEmpty()) {
                    this.listModel.clear();
                } else {
                    this.fillNuniqueListBox(existingNunique);
                }
                this.derivedListModel.clear();
                int size2 = derivedMeasures.size();
                for (int i = 0; i < size2; ++i) {
                    OLAPMeasure derivedMeasure = (OLAPMeasure)derivedMeasures.get(i);
                    if (derivedMeasure.isNunique().booleanValue()) continue;
                    this.derivedListModel.addElement(derivedMeasures.get(i));
                }
            }
            catch (OLAPException error) {
                ExceptionHandler.handleException((Exception)((Object)error));
            }
        }
        return true;
    }

    public void initialize() {
        this.derivedStatSelectBox.setEditable(false);
        if (!this.initialized) {
            this.derivedListBox.addListSelectionListener(new cListBoxListener());
            this.derivedListBox.clearSelection();
            this.add.addActionListener(new cTopButtonListener());
            this.modify.addActionListener(new cTopButtonListener());
            this.delete.addActionListener(new cTopButtonListener());
            this.apply.addActionListener(new cBottomButtonListener());
            this.reset.addActionListener(new cBottomButtonListener());
            this.analysisGroupSelectBox.addActionListener((ActionListener)new groupNameListener());
            this.initialized = true;
        }
    }

    public boolean validateData() {
        boolean returned = true;
        if (!this.add.isEnabled()) {
            MessageUtil.displayMessage((String)bundle.getString("CubeDesigner.Derived.MustApplyOrReset.txt"));
            returned = false;
        }
        return returned;
    }

    private void processDistinctCountSelections() {
        OLAPList existingNuniqueMeasures = null;
        OLAPLevel NuniqueLevel = null;
        OLAPHierarchy NuniqueHierarchy = null;
        try {
            existingNuniqueMeasures = this.measureSet.getNUniqueMeasures();
        }
        catch (OLAPException e) {
            ExceptionHandler.handleException((Exception)((Object)e));
        }
        for (int m = 0; m < existingNuniqueMeasures.size(); ++m) {
            boolean deleteFlag = true;
            OLAPMeasure measure = (OLAPMeasure)existingNuniqueMeasures.get(m);
            try {
                NuniqueLevel = measure.getLevel();
                NuniqueHierarchy = measure.getHierarchy();
            }
            catch (OLAPException e) {
                ExceptionHandler.handleException((Exception)((Object)e));
            }
            if (this.selectedNunique == null) {
                deleteFlag = false;
            } else if (this.selectedNunique.size() == 0) {
                deleteFlag = true;
            } else {
                Set levelKeys = this.selectedNunique.keySet();
                Object[] keySet = levelKeys.toArray();
                for (int i = keySet.length - 1; i >= 0; --i) {
                    OLAPLevel levelKey = (OLAPLevel)keySet[i];
                    if (!NuniqueLevel.equals(levelKey)) continue;
                    List hierarchyList = (List)this.selectedNunique.get(levelKey);
                    for (int p = 0; p < hierarchyList.size(); ++p) {
                        OLAPHierarchy selectedHierarchy = (OLAPHierarchy)hierarchyList.get(p);
                        if (!NuniqueHierarchy.equals(selectedHierarchy)) continue;
                        deleteFlag = false;
                    }
                }
            }
            if (!deleteFlag) continue;
            try {
                measure.delete();
                continue;
            }
            catch (OLAPException e) {
                ExceptionHandler.handleException((Exception)((Object)e));
            }
        }
        if (this.selectedNunique != null && !this.selectedNunique.isEmpty()) {
            this.createNUniqueMeasures();
        }
    }

    public void layoutWidgets() {
        this.derivedListModel = new DefaultListModel();
        this.derivedListBox = new JList(this.derivedListModel);
        JLabel labelListBox = new JLabel();
        VisualUtilities.setLabelTextAndMnemonic(labelListBox, bundle.getString("CubeDesigner.Derived.defined.control.label"));
        labelListBox.setLabelFor(this.derivedListBox);
        this.topbuttons = new CubeButtons();
        this.add = this.topbuttons.getAddButton();
        this.add.setActionCommand("add");
        this.add.setName("addButton");
        this.add.setToolTipText(bundle.getString("CubeDesigner.Derived.AddButton.tooltip.txt"));
        this.modify = this.topbuttons.getModifyButton();
        this.modify.setActionCommand("modify");
        this.modify.setName("modifyButton");
        this.modify.setToolTipText(bundle.getString("CubeDesigner.Derived.ModifyButton.tooltip.txt"));
        this.delete = this.topbuttons.getDeleteButton();
        this.delete.setActionCommand("delete");
        this.delete.setName("deleteButton");
        this.delete.setToolTipText(bundle.getString("CubeDesigner.Derived.DeleteButton.tooltip.txt"));
        this.topbuttons.removeApplyButton();
        this.topbuttons.removeDefaultButton();
        this.topbuttons.removeResetButton();
        this.topbuttons.setName("topButtons");
        JScrollPane definedPane = new JScrollPane(this.derivedListBox);
        definedPane.setPreferredSize(new Dimension(100, 100));
        definedPane.setName("definedDerivedListbox");
        this.add(labelListBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 10), 0, 0));
        this.add(definedPane, new GridBagConstraints(0, 1, 2, 2, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 10), 0, 0));
        this.add((Component)((Object)this.topbuttons), new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 13, 2, new Insets(0, 0, 0, 10), 0, 0));
        JPanel bottomPanel = new JPanel();
        TitledBorder bottomBorder = new TitledBorder(bundle.getString("CubeDesigner.Derived.specify.txt"));
        bottomPanel.setBorder(bottomBorder);
        bottomPanel.setLayout(new GridBagLayout());
        this.analysisGroupLabel = new JLabel(bundle.getString("CubeDesigner.Derived.analysis.txt"));
        bottomPanel.add((Component)this.analysisGroupLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 5, 10), 0, 0));
        this.analysisGroupSelectBox = new WAComboBox();
        VisualUtilities.setLabelTextAndMnemonic(this.analysisGroupLabel, bundle.getString("CubeDesigner.Derived.analysis.txt"));
        this.analysisGroupLabel.setLabelFor((Component)this.analysisGroupSelectBox);
        this.analysisGroupLabel.setName("analysisGroupLabel");
        this.analysisGroupSelectBox.setToolTipText(bundle.getString("CubeDesigner.Derived.analysis.tooltip.txt"));
        this.analysisGroupSelectBox.setName("analysisGroupSelectBox");
        bottomPanel.setName("bottomPanel");
        bottomPanel.add((Component)this.analysisGroupSelectBox, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 18, 2, new Insets(5, 0, 5, 10), 0, 0));
        this.derivedStatLabel = new JLabel(bundle.getString("CubeDesigner.Derived.stat.txt"));
        bottomPanel.add((Component)this.derivedStatLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 5, 10), 0, 0));
        this.derivedStatSelectBox = new WAComboBox();
        VisualUtilities.setLabelTextAndMnemonic(this.derivedStatLabel, bundle.getString("CubeDesigner.Derived.stat.txt"));
        this.derivedStatLabel.setLabelFor((Component)this.derivedStatSelectBox);
        this.derivedStatLabel.setName("statLabel");
        this.derivedStatSelectBox.setToolTipText(bundle.getString("CubeDesigner.Derived.stat.tooltip.txt"));
        this.derivedStatSelectBox.setName("statSelectBox");
        bottomPanel.setName("bottomPanel");
        bottomPanel.add((Component)this.derivedStatSelectBox, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 18, 2, new Insets(5, 0, 5, 10), 0, 0));
        this.measNameLabel = new JLabel(bundle.getString("CubeDesigner.Derived.name.txt"));
        bottomPanel.add((Component)this.measNameLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 5, 10), 0, 0));
        this.measNameSelectBox = new WATextField();
        VisualUtilities.setLabelTextAndMnemonic(this.measNameLabel, bundle.getString("CubeDesigner.Derived.name.txt"));
        this.measNameLabel.setLabelFor((Component)this.measNameSelectBox);
        this.measNameLabel.setName("measNameLabel");
        this.measNameSelectBox.setName("measNameSelectBox");
        this.measNameSelectBox.setToolTipText(bundle.getString("CubeDesigner.Derived.name.tooltip.txt"));
        bottomPanel.add((Component)this.measNameSelectBox, new GridBagConstraints(1, 2, 1, 1, 1.0, 1.0, 18, 2, new Insets(5, 0, 5, 10), 0, 0));
        this.add(bottomPanel, new GridBagConstraints(0, 3, 2, 2, 1.0, 1.0, 18, 1, new Insets(5, 0, 5, 10), 0, 0));
        this.botbuttons = new CubeButtons();
        this.apply = this.botbuttons.getApplyButton();
        this.apply.setActionCommand("apply");
        this.apply.setName("applyButton");
        this.apply.setToolTipText(bundle.getString("CubeDesigner.Derived.ApplyButton.tooltip.txt"));
        this.reset = this.botbuttons.getResetButton();
        this.reset.setActionCommand("reset");
        this.reset.setName("resetButton");
        this.reset.setToolTipText(bundle.getString("CubeDesigner.Derived.ResetButton.tooltip.txt"));
        this.botbuttons.removeAddButton();
        this.botbuttons.removeModifyButton();
        this.botbuttons.removeDeleteButton();
        this.botbuttons.removeDefaultButton();
        this.botbuttons.setName("bottomButtons");
        this.add((Component)((Object)this.botbuttons), new GridBagConstraints(2, 3, 1, 2, 0.0, 0.0, 12, 2, new Insets(7, 0, 5, 10), 0, 0));
        this.definedNUniquePanel = new WAPanel();
        this.definedNUniquePanel.setName("DefinedNUnique");
        this.definedNUniquePanel.setLayout((LayoutManager)new GridBagLayout());
        JLabel label_nunique = new JLabel(bundle.getString("CubeDesigner.MeasuresSelect.Nunique.panel.control.label"));
        this.listModel = new DefaultListModel();
        this.NUniqueList = new JList(this.listModel);
        this.NUniqueList.setEnabled(false);
        this.NUniqueListScroll = new JScrollPane(this.NUniqueList);
        label_nunique.setLabelFor(this.NUniqueList);
        this.NUniqueListScroll.setPreferredSize(new Dimension(150, 100));
        this.definedNUniquePanel.add((Component)label_nunique, (Object)new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 0, 5, 5), 0, 0));
        this.definedNUniquePanel.add((Component)this.NUniqueListScroll, (Object)new GridBagConstraints(0, 1, 2, 2, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 10), 0, 0));
        this.button_nunique = new JButton();
        VisualUtilities.setButtonTextAndMnemonic(this.button_nunique, bundle.getString("CubeDesigner.MeasuresSelect.Nunique.buttonDefine.action.label"));
        this.definedNUniquePanel.add((Component)this.button_nunique, (Object)new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 0, 5, 5), 0, 0));
        this.add((Component)this.definedNUniquePanel, new GridBagConstraints(0, 6, 3, 2, 1.0, 1.0, 17, 1, new Insets(0, 2, 0, 15), 0, 0));
        this.button_nunique.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                CubeMeasuresHolapDerivedPanel.this.existingNunique = CubeMeasuresHolapDerivedPanel.this.getExistingNunique();
                CubeMeasuresHolapDerivedPanel.this.defineDlg = new CubeMeasuresDistinctCountDialog((Dialog)((WAStandardDialog)CubeMeasuresHolapDerivedPanel.this.getTopLevelAncestor()), bundle.getString("CubeDesigner.MeasuresSelect.Nunique.title.txt"), CubeMeasuresHolapDerivedPanel.this.olapCube, CubeMeasuresHolapDerivedPanel.this.existingNunique);
                CubeMeasuresHolapDerivedPanel.this.defineDlg.setResizable(true);
                CubeMeasuresHolapDerivedPanel.this.defineDlg.show();
                CubeMeasuresHolapDerivedPanel.this.selectedNunique = CubeMeasuresHolapDerivedPanel.this.defineDlg.getSelectedNunique();
                CubeMeasuresHolapDerivedPanel.this.fillNuniqueListBox(CubeMeasuresHolapDerivedPanel.this.selectedNunique);
                CubeMeasuresHolapDerivedPanel.this.processDistinctCountSelections();
            }
        });
    }

    public void fillNuniqueListBox(Map selected) {
        String measureName = "";
        this.sortedList.clear();
        this.listModel.clear();
        Set levelKeys = selected.keySet();
        Object[] keySet = levelKeys.toArray();
        for (int i = keySet.length - 1; i >= 0; --i) {
            OLAPLevel levelKey = (OLAPLevel)keySet[i];
            List hierarchyList = (List)selected.get(levelKey);
            for (int m = 0; m < hierarchyList.size(); ++m) {
                OLAPHierarchy hierarchy = (OLAPHierarchy)hierarchyList.get(m);
                measureName = levelKey.toString() + "/" + hierarchy.toString();
                this.sortedList.add(measureName);
            }
        }
        Collections.sort(this.sortedList);
        for (int p = 0; p < this.sortedList.size(); ++p) {
            this.listModel.addElement(this.sortedList.get(p));
        }
    }

    private boolean applyAction() {
        boolean appliedAction;
        block6: {
            appliedAction = true;
            Statistic selectedStatistic = (Statistic)this.derivedStatSelectBox.getSelectedItem();
            String selectedGroupName = (String)this.analysisGroupSelectBox.getSelectedItem();
            String selectedName = this.measNameSelectBox.getText();
            OLAPMeasure measure = null;
            try {
                measure = this.selectedMeasure == null ? this.measureSet.createOLAPMeasure(null) : this.selectedMeasure;
                if (ModelUtilities.isBlank((String)measure.getGroupName())) {
                    measure.setGroupName(selectedGroupName);
                }
                measure.setStatistic(selectedStatistic);
                measure.setName(selectedName);
                measure.verifyName();
                if (measure != this.selectedMeasure) {
                    this.derivedListModel.addElement(measure);
                }
                this.derivedStatSelectBox.removeAllItems();
                this.analysisGroupSelectBox.removeAllItems();
                this.measNameSelectBox.setText("");
                this.derivedStatSelectBox.setEnabled(false);
                this.analysisGroupSelectBox.setEnabled(false);
                this.measNameSelectBox.setEnabled(false);
                this.apply.setEnabled(false);
                this.reset.setEnabled(false);
                this.modify.setEnabled(false);
                this.delete.setEnabled(false);
                this.add.setEnabled(true);
                this.add.requestFocus();
                this.derivedListBox.setEnabled(true);
                this.derivedListBox.clearSelection();
            }
            catch (OLAPException error) {
                appliedAction = ExceptionHandler.handleException((Exception)((Object)error));
                if (this.selectedMeasure != null) break block6;
                try {
                    measure.delete();
                }
                catch (OLAPException error2) {
                    ExceptionHandler.handleException((Exception)((Object)error2));
                }
            }
        }
        return appliedAction;
    }

    private void setPossibleDerivedStatistics(String groupName) {
        try {
            int i;
            OLAPList possibleDerivedStatistics = this.measureSet.getPossibleDerivedStatisticsByGroupName(groupName);
            OLAPList actualDerivedStatistics = this.measureSet.getDerivedMeasuresByGroupName(groupName);
            this.derivedStatSelectBox.removeAllItems();
            for (i = possibleDerivedStatistics.size() - 1; i >= 0; --i) {
                this.derivedStatSelectBox.addItem(possibleDerivedStatistics.get(i));
            }
            for (i = actualDerivedStatistics.size() - 1; i >= 0; --i) {
                this.derivedStatSelectBox.removeItem(actualDerivedStatistics.get(i));
            }
        }
        catch (OLAPException error) {
            ExceptionHandler.handleException((Exception)((Object)error));
        }
    }

    protected Map getExistingNunique() {
        HashMap existingNames = new HashMap();
        OLAPLevel NuniqueLevel = null;
        OLAPHierarchy NuniqueHierarchy = null;
        List<OLAPHierarchy> hierarchyList = null;
        OLAPList nuniqueMeasures = null;
        try {
            nuniqueMeasures = this.measureSet.getNUniqueMeasures();
        }
        catch (OLAPException e) {
            ExceptionHandler.handleException((Exception)((Object)e));
        }
        int numMeasures = nuniqueMeasures.size();
        for (int ii = numMeasures - 1; ii > -1; --ii) {
            OLAPMeasure measure = (OLAPMeasure)nuniqueMeasures.get(ii);
            if (!measure.isNunique().booleanValue()) continue;
            try {
                NuniqueLevel = measure.getLevel();
                NuniqueHierarchy = measure.getHierarchy();
            }
            catch (OLAPException e) {
                ExceptionHandler.handleException((Exception)((Object)e));
            }
            if (existingNames.containsKey(NuniqueLevel)) {
                hierarchyList = (List)existingNames.get(NuniqueLevel);
                hierarchyList.add(NuniqueHierarchy);
                continue;
            }
            hierarchyList = new ArrayList();
            hierarchyList.add(NuniqueHierarchy);
            existingNames.put(NuniqueLevel, hierarchyList);
        }
        return existingNames;
    }

    public void createNUniqueMeasures() {
        Set levelKeys = this.selectedNunique.keySet();
        Object[] keySet = levelKeys.toArray();
        for (int i = keySet.length - 1; i >= 0; --i) {
            OLAPLevel levelKey = (OLAPLevel)keySet[i];
            List hierarchyList = (List)this.selectedNunique.get(levelKey);
            for (int m = 0; m < hierarchyList.size(); ++m) {
                OLAPHierarchy hierarchy = (OLAPHierarchy)hierarchyList.get(m);
                String hierarchyName = hierarchy.toString();
                String levelName = levelKey.toString();
                boolean measureExists = false;
                this.existingNunique = this.getExistingNunique();
                if (this.existingNunique.isEmpty()) {
                    measureExists = false;
                } else {
                    OLAPHierarchy existingHier = null;
                    Set existingLevelKeys = this.existingNunique.keySet();
                    if (existingLevelKeys.contains(levelKey)) {
                        List existing_hList = (List)this.existingNunique.get(levelKey);
                        for (int p = 0; p < existing_hList.size(); ++p) {
                            existingHier = (OLAPHierarchy)existing_hList.get(p);
                            if (!hierarchy.equals(existingHier)) continue;
                            measureExists = true;
                            try {
                                OLAPMeasure nuniqueMeasure = this.measureSet.getNUniqueMeasure(levelKey, hierarchy);
                                if (levelKey.isCalculatedMembersIncluded(hierarchy)) {
                                    nuniqueMeasure.setIncludeCalculatedMembers("1");
                                    continue;
                                }
                                if (!nuniqueMeasure.getIncludeCalculatedMembers()) continue;
                                nuniqueMeasure.setIncludeCalculatedMembers("0");
                                continue;
                            }
                            catch (OLAPException oError) {
                                ExceptionHandler.handleException((Exception)((Object)oError));
                            }
                        }
                    }
                }
                if (measureExists) continue;
                try {
                    this.measure = this.measureSet.createOLAPMeasure(levelKey, hierarchy);
                    String measureName = levelName + "_NUNIQUE_" + hierarchyName;
                    if (measureName.length() > 32) {
                        measureName = measureName.substring(0, 32);
                    }
                    this.measure.setName(measureName);
                    String caption = this.measure.getStatistic().getDefaultMeasureCaption(levelName, hierarchyName);
                    this.measure.setDesc(caption);
                    if (levelKey.isCalculatedMembersIncluded(hierarchy)) {
                        this.measure.setIncludeCalculatedMembers("1");
                        continue;
                    }
                    this.measure.setIncludeCalculatedMembers("0");
                    continue;
                }
                catch (OLAPException e) {
                    ExceptionHandler.handleException((Exception)((Object)e));
                }
            }
        }
    }

    class cListBoxListener
    implements ListSelectionListener {
        cListBoxListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                if (CubeMeasuresHolapDerivedPanel.this.derivedListBox.getSelectedIndex() == -1) {
                    CubeMeasuresHolapDerivedPanel.this.modify.setEnabled(false);
                    CubeMeasuresHolapDerivedPanel.this.delete.setEnabled(false);
                } else {
                    CubeMeasuresHolapDerivedPanel.this.add.setEnabled(true);
                    CubeMeasuresHolapDerivedPanel.this.modify.setEnabled(CubeMeasuresHolapDerivedPanel.this.derivedListBox.getSelectedIndices().length == 1);
                    CubeMeasuresHolapDerivedPanel.this.delete.setEnabled(true);
                }
            }
        }
    }

    class cTopButtonListener
    implements ActionListener {
        cTopButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (event.getActionCommand().equals("add")) {
                CubeMeasuresHolapDerivedPanel.this.derivedListBox.setEnabled(false);
                CubeMeasuresHolapDerivedPanel.this.derivedListBox.clearSelection();
                if (this.possibleDerived()) {
                    CubeMeasuresHolapDerivedPanel.this.add.setEnabled(false);
                    CubeMeasuresHolapDerivedPanel.this.modify.setEnabled(false);
                    CubeMeasuresHolapDerivedPanel.this.delete.setEnabled(false);
                    CubeMeasuresHolapDerivedPanel.this.apply.setEnabled(true);
                    CubeMeasuresHolapDerivedPanel.this.reset.setEnabled(true);
                    CubeMeasuresHolapDerivedPanel.this.derivedStatSelectBox.setEnabled(true);
                    CubeMeasuresHolapDerivedPanel.this.analysisGroupSelectBox.setEnabled(true);
                    CubeMeasuresHolapDerivedPanel.this.measNameSelectBox.setEnabled(true);
                    CubeMeasuresHolapDerivedPanel.this.setPossibleDerivedStatistics((String)CubeMeasuresHolapDerivedPanel.this.analysisGroupSelectBox.getItemAt(0));
                    CubeMeasuresHolapDerivedPanel.this.analysisGroupSelectBox.requestFocus();
                } else {
                    CubeMeasuresHolapDerivedPanel.this.add.setEnabled(true);
                    CubeMeasuresHolapDerivedPanel.this.modify.setEnabled(false);
                    CubeMeasuresHolapDerivedPanel.this.delete.setEnabled(false);
                    CubeMeasuresHolapDerivedPanel.this.apply.setEnabled(false);
                    CubeMeasuresHolapDerivedPanel.this.reset.setEnabled(false);
                    CubeMeasuresHolapDerivedPanel.this.derivedStatSelectBox.setEnabled(false);
                    CubeMeasuresHolapDerivedPanel.this.analysisGroupSelectBox.setEnabled(false);
                    CubeMeasuresHolapDerivedPanel.this.measNameSelectBox.setEnabled(false);
                    CubeMeasuresHolapDerivedPanel.this.derivedListBox.setEnabled(true);
                    CubeMeasuresHolapDerivedPanel.this.derivedListBox.requestFocus();
                }
            } else if (event.getActionCommand().equals("modify")) {
                CubeMeasuresHolapDerivedPanel.this.derivedListBox.setEnabled(false);
                CubeMeasuresHolapDerivedPanel.this.apply.setEnabled(true);
                CubeMeasuresHolapDerivedPanel.this.reset.setEnabled(true);
                CubeMeasuresHolapDerivedPanel.this.add.setEnabled(false);
                CubeMeasuresHolapDerivedPanel.this.modify.setEnabled(false);
                CubeMeasuresHolapDerivedPanel.this.delete.setEnabled(false);
                CubeMeasuresHolapDerivedPanel.this.derivedStatSelectBox.setEnabled(true);
                CubeMeasuresHolapDerivedPanel.this.analysisGroupSelectBox.setEnabled(true);
                CubeMeasuresHolapDerivedPanel.this.measNameSelectBox.setEnabled(true);
                CubeMeasuresHolapDerivedPanel.this.selectedMeasure = (OLAPMeasure)CubeMeasuresHolapDerivedPanel.this.derivedListBox.getSelectedValue();
                Statistic statistic = CubeMeasuresHolapDerivedPanel.this.selectedMeasure.getStatistic();
                String groupName = null;
                try {
                    groupName = CubeMeasuresHolapDerivedPanel.this.selectedMeasure.getGroupName();
                }
                catch (OLAPException error) {
                    ExceptionHandler.handleException((Exception)((Object)error));
                }
                if (CubeMeasuresHolapDerivedPanel.this.analysisGroupSelectBox.getItemCount() == 0) {
                    CubeMeasuresHolapDerivedPanel.this.analysisGroupSelectBox.addItem((Object)groupName);
                }
                CubeMeasuresHolapDerivedPanel.this.analysisGroupSelectBox.setSelectedItem((Object)groupName);
                if (CubeMeasuresHolapDerivedPanel.this.derivedStatSelectBox.getItemCount() == 0) {
                    CubeMeasuresHolapDerivedPanel.this.derivedStatSelectBox.addItem((Object)statistic);
                }
                CubeMeasuresHolapDerivedPanel.this.derivedStatSelectBox.setSelectedItem((Object)statistic);
                CubeMeasuresHolapDerivedPanel.this.measNameSelectBox.setText(CubeMeasuresHolapDerivedPanel.this.selectedMeasure.getName());
                CubeMeasuresHolapDerivedPanel.this.derivedListBox.setEnabled(false);
                CubeMeasuresHolapDerivedPanel.this.analysisGroupSelectBox.requestFocus();
            } else if (event.getActionCommand().equals("delete")) {
                Object[] selectedMeasures = CubeMeasuresHolapDerivedPanel.this.derivedListBox.getSelectedValues();
                OLAPMeasure tempMeasure = null;
                int choice = 0;
                if (selectedMeasures.length == 1) {
                    tempMeasure = (OLAPMeasure)selectedMeasures[0];
                    choice = MessageUtil.displayMessage((String)bundle.formatString("CubeDesigner.Delete.Message.fmt.txt", (Object)tempMeasure.getName()), (String)bundle.getString("CubeDesigner.DeleteMeasure.window.title"), (int)1, (int)0);
                } else if (selectedMeasures.length > 1) {
                    choice = MessageUtil.displayMessage((String)bundle.getString("CubeDesigner.DeleteMeasures.txt"), (String)bundle.getString("CubeDesigner.DeleteMeasures.window.title"), (int)1, (int)0);
                }
                if (choice == 0) {
                    for (int i = selectedMeasures.length - 1; i >= 0; --i) {
                        tempMeasure = (OLAPMeasure)selectedMeasures[i];
                        try {
                            tempMeasure.delete();
                        }
                        catch (OLAPException error) {
                            ExceptionHandler.handleException((Exception)((Object)error));
                        }
                        CubeMeasuresHolapDerivedPanel.this.derivedListModel.removeElement(tempMeasure);
                    }
                    CubeMeasuresHolapDerivedPanel.this.modify.setEnabled(false);
                    CubeMeasuresHolapDerivedPanel.this.delete.setEnabled(false);
                    CubeMeasuresHolapDerivedPanel.this.derivedListBox.setEnabled(true);
                    CubeMeasuresHolapDerivedPanel.this.add.requestFocus();
                }
            }
        }

        private boolean possibleDerived() {
            boolean possible = true;
            OLAPList groupNames = null;
            try {
                String groupName;
                int i;
                groupNames = CubeMeasuresHolapDerivedPanel.this.measureSet.getGroupNames();
                CubeMeasuresHolapDerivedPanel.this.analysisGroupSelectBox.removeAllItems();
                for (i = groupNames.size() - 1; i >= 0; --i) {
                    groupName = (String)groupNames.get(i);
                    CubeMeasuresHolapDerivedPanel.this.analysisGroupSelectBox.addItem((Object)groupName);
                }
                for (i = groupNames.size() - 1; i >= 0; --i) {
                    groupName = (String)groupNames.get(i);
                    OLAPList possibleDerivedStatistics = CubeMeasuresHolapDerivedPanel.this.measureSet.getPossibleDerivedStatisticsByGroupName(groupName);
                    OLAPList actualDerivedStatistics = CubeMeasuresHolapDerivedPanel.this.measureSet.getDerivedMeasuresByGroupName(groupName);
                    if (possibleDerivedStatistics.size() != actualDerivedStatistics.size()) continue;
                    CubeMeasuresHolapDerivedPanel.this.analysisGroupSelectBox.removeItem((Object)groupName);
                }
                if (CubeMeasuresHolapDerivedPanel.this.analysisGroupSelectBox.getItemCount() == 0) {
                    possible = false;
                    MessageUtil.displayMessage((String)bundle.getString("CubeDesigner.MeasuresHolapDerivedPanel.NoDerivedPossible.txt"), (int)2);
                }
            }
            catch (OLAPException error) {
                possible = ExceptionHandler.handleException((Exception)((Object)error));
            }
            return possible;
        }
    }

    class cBottomButtonListener
    implements ActionListener {
        cBottomButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (event.getActionCommand().equals("apply")) {
                CubeMeasuresHolapDerivedPanel.this.applyAction();
            } else if (event.getActionCommand().equals("reset")) {
                CubeMeasuresHolapDerivedPanel.this.derivedListBox.setEnabled(true);
                CubeMeasuresHolapDerivedPanel.this.derivedListBox.clearSelection();
                CubeMeasuresHolapDerivedPanel.this.derivedStatSelectBox.removeAllItems();
                CubeMeasuresHolapDerivedPanel.this.analysisGroupSelectBox.removeAllItems();
                CubeMeasuresHolapDerivedPanel.this.measNameSelectBox.setText("");
                CubeMeasuresHolapDerivedPanel.this.measNameSelectBox.setEnabled(false);
                CubeMeasuresHolapDerivedPanel.this.derivedStatSelectBox.setEnabled(false);
                CubeMeasuresHolapDerivedPanel.this.analysisGroupSelectBox.setEnabled(false);
                CubeMeasuresHolapDerivedPanel.this.measNameSelectBox.setEnabled(false);
                CubeMeasuresHolapDerivedPanel.this.apply.setEnabled(false);
                CubeMeasuresHolapDerivedPanel.this.reset.setEnabled(false);
                CubeMeasuresHolapDerivedPanel.this.modify.setEnabled(false);
                CubeMeasuresHolapDerivedPanel.this.delete.setEnabled(false);
                CubeMeasuresHolapDerivedPanel.this.add.setEnabled(true);
                CubeMeasuresHolapDerivedPanel.this.add.requestFocus();
                CubeMeasuresHolapDerivedPanel.this.derivedListBox.setEnabled(true);
            }
            CubeMeasuresHolapDerivedPanel.this.selectedMeasure = null;
        }
    }

    class groupNameListener
    implements ActionListener {
        groupNameListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            WAComboBox WACB = (WAComboBox)event.getSource();
            CubeMeasuresHolapDerivedPanel.this.derivedStatSelectBox.removeAllItems();
            String groupName = (String)WACB.getSelectedItem();
            if (groupName != null) {
                CubeMeasuresHolapDerivedPanel.this.setPossibleDerivedStatistics(groupName);
            }
        }
    }
}

