/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.designer.visuals;

import com.sas.olapadmin.designer.model.MeasureSet;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPList;
import com.sas.olapadmin.designer.model.OLAPMeasure;
import com.sas.olapadmin.designer.visuals.CubeMeasuresHolapAssignStatGroupTable;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAdminResource;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableCellEditor;

public class CubeMeasuresHolapAssignStatGroupPanel
extends WAPropertyTab {
    private static final long serialVersionUID = 1L;
    private static WAdminResource bundle = new WAdminResource(CubeMeasuresHolapAssignStatGroupPanel.class);
    private CubeMeasuresHolapAssignStatGroupTable detailsTable;
    private OLAPList allMeasures;
    private List measures;
    private OLAPCube olapCube;
    private boolean initialized;
    private MeasureSet measureSet;

    public CubeMeasuresHolapAssignStatGroupPanel(OLAPCube inputOLAPCube) throws OLAPException {
        this.olapCube = inputOLAPCube;
        this.measureSet = this.olapCube.getMeasureSet();
        this.setLayout(new GridBagLayout());
        this.layoutWidgets();
    }

    public boolean doDataExchange(boolean saveToModel) {
        boolean returned = true;
        if (!saveToModel) {
            returned = this.initialize(this.initialized);
        }
        return returned;
    }

    private boolean initialize(boolean init) {
        try {
            if (!this.initialized) {
                this.measures = new ArrayList();
                this.allMeasures = this.measureSet.getMeasures();
                this.detailsTable.removeAll();
                this.detailsTable.addKeyListener(new KeyListener(){

                    @Override
                    public void keyReleased(KeyEvent e) {
                        int key = e.getKeyCode();
                        if (key == 10) {
                            CubeMeasuresHolapAssignStatGroupPanel.this.detailsTable.revalidate();
                            CubeMeasuresHolapAssignStatGroupPanel.this.detailsTable.repaint();
                        }
                    }

                    @Override
                    public void keyPressed(KeyEvent e) {
                    }

                    @Override
                    public void keyTyped(KeyEvent e) {
                    }
                });
                this.initialized = true;
            }
            this.measures.clear();
            int size = this.allMeasures.size();
            for (int i = 0; i < size; ++i) {
                OLAPMeasure measure = (OLAPMeasure)this.allMeasures.get(i);
                Boolean isStored = measure.isStoredStatistic();
                if (isStored != null && !isStored.booleanValue()) continue;
                this.measures.add(measure);
            }
            this.detailsTable.setMeasures(this.measures);
            this.detailsTable.revalidate();
        }
        catch (OLAPException error) {
            this.initialized = ExceptionHandler.handleException((Exception)((Object)error));
        }
        return this.initialized;
    }

    protected void layoutWidgets() {
        TitledBorder titledBorder1 = new TitledBorder(bundle.getString("CubeDesigner.MeasuresAssignStatGroupPanel.Label.txt"));
        this.detailsTable = new CubeMeasuresHolapAssignStatGroupTable(this.olapCube);
        this.detailsTable.setName("assignStatGroupTable");
        JScrollPane topPanel = new JScrollPane(this.detailsTable);
        topPanel.setBorder(titledBorder1);
        this.detailsTable.setPreferredScrollableViewportSize(new Dimension(300, 200));
        this.detailsTable.setAutoResizeMode(0);
        topPanel.setName("scrollablePanel");
        this.add(topPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public boolean validateData() {
        TableCellEditor ce = this.detailsTable.getCellEditor();
        if (ce != null) {
            ce.stopCellEditing();
        }
        boolean returned = true;
        try {
            this.measureSet.verifyStatistics();
            this.measureSet.verifyGroupNames();
        }
        catch (OLAPException error) {
            returned = ExceptionHandler.handleException((Exception)((Object)error));
        }
        return returned;
    }

    public void onBack() {
        TableCellEditor ce = this.detailsTable.getCellEditor();
        if (ce != null) {
            ce.stopCellEditing();
        }
    }
}

