/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.designer.visuals;

import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Measure;
import com.sas.olapadmin.designer.model.MeasureSet;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPDimension;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPHierarchy;
import com.sas.olapadmin.designer.model.OLAPLevel;
import com.sas.olapadmin.designer.model.OLAPList;
import com.sas.olapadmin.designer.model.OLAPMeasure;
import com.sas.olapadmin.designer.visuals.VisualUtilities;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.olapadmin.utilities.studio.OLAPDualTreeSelector;
import com.sas.visuals.Resources;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAdminResource;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class CubeMeasuresDistinctCountPanel
extends WAPanel {
    private static final long serialVersionUID = 1L;
    private static WAdminResource bundle = new WAdminResource(CubeMeasuresDistinctCountPanel.class);
    private OLAPList dimensionHierarchies;
    private OLAPList hierLevels;
    private OLAPCube olapCube;
    private DefaultTreeModel availableTreeModel;
    private DefaultTreeModel selectedTreeModel;
    private DefaultMutableTreeNode availableRootNode;
    private DefaultMutableTreeNode selectedRootNode;
    private DefaultMutableTreeNode dimensionNode;
    private DefaultMutableTreeNode hierarchyNode;
    private DefaultMutableTreeNode dimensionNodeTarget;
    private DefaultMutableTreeNode hierarchyNodeTarget;
    private DefaultMutableTreeNode levelNode;
    private JRadioButton include;
    private JRadioButton exclude;
    private JRadioButton invisible;
    private ButtonGroup buttonGroup;
    private OLAPDualTreeSelector treeSelector;
    private OLAPDimension dimension;
    private OLAPHierarchy hierarchy;
    private OLAPLevel level;
    private Object childDimension;
    private Object root;
    private TreeModel targetModel;
    private Map selectedMap;
    private List selectedNuniqueLevels;
    private Map existingNuniqueMeasureNames;
    private boolean okFlag;
    private OLAPList allMeasures;
    private IncludeExcludeListener includeExcludeListener;

    public CubeMeasuresDistinctCountPanel(OLAPCube oCube, Map existingNunique) {
        this.olapCube = oCube;
        this.existingNuniqueMeasureNames = existingNunique;
        this.setLayout(new GridBagLayout());
        this._layoutWidgets();
        if (this.selectedMap == null) {
            this.selectedMap = new HashMap();
        }
    }

    public boolean validateData() {
        this.createMapOfSelectedLevelsFromTarget();
        Object[] keys = this.existingNuniqueMeasureNames.keySet().toArray();
        int numberToDelete = 0;
        for (int i = keys.length - 1; i >= 0; --i) {
            OLAPLevel tempLevel = (OLAPLevel)keys[i];
            ArrayList selectedHierarchies = (ArrayList)this.selectedMap.get(tempLevel);
            if (selectedHierarchies == null) {
                selectedHierarchies = new ArrayList();
            }
            List existingHierarcies = (List)this.existingNuniqueMeasureNames.get(tempLevel);
            for (int j = existingHierarcies.size() - 1; j >= 0; --j) {
                OLAPHierarchy tempHierarchy = (OLAPHierarchy)existingHierarcies.get(j);
                if (selectedHierarchies.indexOf(tempHierarchy) >= 0) continue;
                ++numberToDelete;
            }
        }
        this.okFlag = true;
        return true;
    }

    public void saveSettingsAndCleanUp() {
        if (!this.okFlag) {
            this.selectedMap = this.existingNuniqueMeasureNames;
        }
    }

    public void populateStore() throws MdException, RemoteException {
        this.okFlag = false;
    }

    public void moveDataToStore() throws MdException, RemoteException {
        this.getSelectedNunique();
        Object[] keys = this.selectedMap.keySet().toArray();
        for (int i = keys.length - 1; i >= 0; --i) {
            OLAPLevel tempLevel = (OLAPLevel)keys[i];
            tempLevel.apply();
        }
    }

    public Map getSelectedNunique() {
        return this.selectedMap;
    }

    public void setSelectedNunique(Map selected) {
        this.selectedMap = selected;
    }

    public void createMapOfSelectedLevelsFromTarget() {
        this.targetModel = this.treeSelector.getTargetModel();
        this.root = this.targetModel.getRoot();
        int dimensionCount = this.targetModel.getChildCount(this.root);
        for (int j = 0; j < dimensionCount; ++j) {
            this.childDimension = this.targetModel.getChild(this.root, j);
            int hierarchyCount = this.targetModel.getChildCount(this.childDimension);
            for (int m = 0; m < hierarchyCount; ++m) {
                this.hierarchyNode = (DefaultMutableTreeNode)this.targetModel.getChild(this.childDimension, m);
                this.hierarchy = (OLAPHierarchy)this.hierarchyNode.getUserObject();
                int levelCount = this.targetModel.getChildCount(this.hierarchyNode);
                for (int p = 0; p < levelCount; ++p) {
                    List<OLAPHierarchy> hierarchyList = new ArrayList<OLAPHierarchy>();
                    this.levelNode = (DefaultMutableTreeNode)this.targetModel.getChild(this.hierarchyNode, p);
                    this.level = (OLAPLevel)this.levelNode.getUserObject();
                    if (this.selectedMap.containsKey(this.level)) {
                        hierarchyList = (List)this.selectedMap.get(this.level);
                        hierarchyList.add(this.hierarchy);
                        continue;
                    }
                    hierarchyList.add(this.hierarchy);
                    this.selectedMap.put(this.level, hierarchyList);
                }
            }
        }
    }

    private void _layoutWidgets() {
        this.treeSelector = new OLAPDualTreeSelector(bundle.getString("CubeDesigner.DeleteUniqueCount.window.title"), bundle.getString("CubeDesigner.DeleteUniqueCounts.window.title"), bundle.getString("CubeDesigner.DeleteUniqueCounts.txt"), bundle.getString("CubeDesigner.DeleteAllUniqueCounts.txt"));
        this.treeSelector.setSourceCellRenderer(new StructureTreeCellRenderer());
        this.treeSelector.setTargetCellRenderer(new StructureTreeCellRenderer());
        JLabel label = (JLabel)this.treeSelector.getSourceLabelComponent();
        VisualUtilities.setLabelTextAndMnemonic(label, bundle.getString("CubeDesigner.DistinctCountPanel.Nunique.available.control.label"));
        label = (JLabel)this.treeSelector.getTargetLabelComponent();
        VisualUtilities.setLabelTextAndMnemonic(label, bundle.getString("CubeDesigner.DistinctCountPanel.Nunique.selected.control.label"));
        this.treeSelector.setTargetControlsVisible(true);
        this.treeSelector.setPreferredSize(new Dimension(600, 350));
        this.treeSelector.setDragAndDropEnabled(false);
        this.treeSelector.setTargetControlsVisible(false);
        this.availableRootNode = new DefaultMutableTreeNode(this.olapCube);
        this.selectedRootNode = new DefaultMutableTreeNode(bundle.getString("StructurePanel.Dimensions.Title.txt"));
        this.availableTreeModel = new DefaultTreeModel(this.availableRootNode);
        this.treeSelector.setModel(this.availableTreeModel);
        this.selectedTreeModel = new DefaultTreeModel(this.selectedRootNode);
        this.treeSelector.setTargetModel(this.selectedTreeModel);
        this.add((Component)((Object)this.treeSelector), new GridBagConstraints(0, 0, 3, 3, 1.0, 1.0, 17, 1, new Insets(5, 5, 5, 10), 0, 0));
        this.include = new JRadioButton();
        VisualUtilities.setButtonTextAndMnemonic(this.include, bundle.getString("CubeDesigner.DistinctCountPanel.Include.radio.label"));
        this.exclude = new JRadioButton();
        VisualUtilities.setButtonTextAndMnemonic(this.exclude, bundle.getString("CubeDesigner.DistinctCountPanel.Exclude.radio.label"));
        this.invisible = new JRadioButton();
        this.buttonGroup = new ButtonGroup();
        this.buttonGroup.add(this.include);
        this.buttonGroup.add(this.exclude);
        this.buttonGroup.add(this.invisible);
        JTree selectedTree = (JTree)this.treeSelector.getTargetComponent();
        SelectedTreeListener treeListener = new SelectedTreeListener();
        selectedTree.addTreeSelectionListener(treeListener);
        this.includeExcludeListener = new IncludeExcludeListener();
        this.include.addActionListener(this.includeExcludeListener);
        this.exclude.addActionListener(this.includeExcludeListener);
        WAPanel radioButtonPanel = new WAPanel();
        radioButtonPanel.setLayout((LayoutManager)new GridBagLayout());
        JLabel buttonLabel = new JLabel(bundle.getString("CubeDesigner.DistinctCountPanel.radiobuttonlable.groupbox.title"));
        radioButtonPanel.add((Component)buttonLabel, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        radioButtonPanel.add((Component)this.include, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        radioButtonPanel.add((Component)this.exclude, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)radioButtonPanel, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 14, 0, new Insets(5, 5, 5, 70), 0, 0));
    }

    public void moveDataToView() throws MdException, RemoteException {
        try {
            MeasureSet measureSet = this.olapCube.getMeasureSet();
            OLAPList cubeDimensions = this.olapCube.getDimensionSet().getCubeDimensions();
            for (int j = 0; j < cubeDimensions.size(); ++j) {
                this.dimension = (OLAPDimension)cubeDimensions.get(j);
                String dimensiontype = this.dimension.getType();
                if (dimensiontype.equalsIgnoreCase("MEASURES")) continue;
                this.dimensionNode = new DefaultMutableTreeNode(this.dimension, true);
                this.dimensionNodeTarget = new DefaultMutableTreeNode(this.dimension, true);
                this.dimensionHierarchies = this.dimension.getHierarchies();
                for (int m = 0; m < this.dimensionHierarchies.size(); ++m) {
                    this.hierarchy = (OLAPHierarchy)this.dimensionHierarchies.get(m);
                    this.hierarchyNode = new DefaultMutableTreeNode(this.hierarchy, true);
                    this.hierarchyNodeTarget = new DefaultMutableTreeNode(this.hierarchy, true);
                    this.hierLevels = this.hierarchy.getLevels();
                    for (int p = 0; p < this.hierLevels.size(); ++p) {
                        List hier_list;
                        OLAPLevel level = (OLAPLevel)this.hierLevels.get(p);
                        this.levelNode = new DefaultMutableTreeNode(level, true);
                        boolean existingFlag = false;
                        if (this.existingNuniqueMeasureNames.containsKey(level) && (hier_list = (List)this.existingNuniqueMeasureNames.get(level)).contains(this.hierarchy)) {
                            existingFlag = true;
                        }
                        if (existingFlag) {
                            if (!this.selectedRootNode.isNodeChild(this.dimensionNodeTarget)) {
                                this.selectedTreeModel.insertNodeInto(this.dimensionNodeTarget, this.selectedRootNode, this.selectedRootNode.getChildCount());
                            }
                            if (!this.dimensionNodeTarget.isNodeChild(this.hierarchyNodeTarget)) {
                                this.selectedTreeModel.insertNodeInto(this.hierarchyNodeTarget, this.dimensionNodeTarget, this.dimensionNodeTarget.getChildCount());
                            }
                            this.selectedTreeModel.insertNodeInto(this.levelNode, this.hierarchyNodeTarget, this.hierarchyNodeTarget.getChildCount());
                            OLAPMeasure nuniqueMeasure = measureSet.getNUniqueMeasure(level, this.hierarchy);
                            boolean includeCalc = nuniqueMeasure.getIncludeCalculatedMembers();
                            if (!includeCalc) continue;
                            OLAPList includeList = level.getIncludeCalculatedMembers();
                            includeList.setAllowUndoSetup(false);
                            if (!includeList.contains((Object)this.hierarchy)) {
                                includeList.add((Object)this.hierarchy);
                            }
                            includeList.setAllowUndoSetup(true);
                            continue;
                        }
                        if (!this.availableRootNode.isNodeChild(this.dimensionNode)) {
                            this.availableTreeModel.insertNodeInto(this.dimensionNode, this.availableRootNode, this.availableRootNode.getChildCount());
                        }
                        if (!this.dimensionNode.isNodeChild(this.hierarchyNode)) {
                            this.availableTreeModel.insertNodeInto(this.hierarchyNode, this.dimensionNode, this.dimensionNode.getChildCount());
                        }
                        this.availableTreeModel.insertNodeInto(this.levelNode, this.hierarchyNode, this.hierarchyNode.getChildCount());
                    }
                }
            }
        }
        catch (OLAPException e) {
            ExceptionHandler.handleException((Exception)((Object)e));
        }
        this.availableTreeModel.reload();
        this.selectedTreeModel.reload();
        this.include.setEnabled(false);
        this.exclude.setEnabled(false);
    }

    protected void getExistingNunique() {
        this.selectedNuniqueLevels = new ArrayList();
        try {
            this.allMeasures = this.olapCube.getMeasureSet().getMeasures();
            if (this.allMeasures == null) {
                return;
            }
            int numMeasures = this.allMeasures.size();
            for (int ii = numMeasures - 1; ii > -1; --ii) {
                Measure measure = (Measure)this.allMeasures.get(ii);
                if (!measure.getStatistic().equals("NUNIQUE")) continue;
                String measureUniqueName = measure.getUniqueName();
                this.selectedNuniqueLevels.add(measureUniqueName);
            }
        }
        catch (OLAPException e) {
            ExceptionHandler.handleException((Exception)((Object)e));
        }
        catch (RemoteException e) {
            ExceptionHandler.handleException((Exception)e);
        }
    }

    class IncludeExcludeListener
    implements ActionListener {
        IncludeExcludeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            JTree selectedTree = (JTree)CubeMeasuresDistinctCountPanel.this.treeSelector.getTargetComponent();
            TreePath[] selectedPath = selectedTree.getSelectionPaths();
            if (selectedPath != null) {
                int size = selectedPath.length;
                for (int i = 0; i < size; ++i) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)selectedPath[i].getLastPathComponent();
                    if (node == null) {
                        return;
                    }
                    Object currentObject = node.getUserObject();
                    if (!(currentObject instanceof OLAPLevel)) continue;
                    DefaultMutableTreeNode treenode = (DefaultMutableTreeNode)node.getParent();
                    OLAPHierarchy hierarchy = (OLAPHierarchy)treenode.getUserObject();
                    OLAPLevel level = (OLAPLevel)currentObject;
                    OLAPList listOfHierarchies = level.getIncludeCalculatedMembers();
                    if (CubeMeasuresDistinctCountPanel.this.exclude.isSelected()) {
                        listOfHierarchies.remove((Object)hierarchy);
                        continue;
                    }
                    if (listOfHierarchies.contains((Object)hierarchy)) continue;
                    listOfHierarchies.add((Object)hierarchy);
                }
            }
            selectedTree.repaint();
        }
    }

    class StructureTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 1L;

        StructureTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            ImageIcon icon = null;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            Object userObject = node.getUserObject();
            if (userObject instanceof OLAPLevel) {
                OLAPLevel level = (OLAPLevel)userObject;
                icon = Resources.getImageIcon((String)"OLAPLevel.gif", (int)16);
                if (tree.equals(CubeMeasuresDistinctCountPanel.this.treeSelector.getTargetComponent())) {
                    DefaultMutableTreeNode treenode = (DefaultMutableTreeNode)node.getParent();
                    OLAPHierarchy hierarchy = (OLAPHierarchy)treenode.getUserObject();
                    if (level.isCalculatedMembersIncluded(hierarchy)) {
                        this.setText(level.getName() + " " + bundle.getString("CubeDesigner.DistinctCountPanel.SelectedListBox.includeText.txt"));
                    } else {
                        this.setText(level.getName() + " " + bundle.getString("CubeDesigner.DistinctCountPanel.SelectedListBox.excludeText.txt"));
                    }
                } else {
                    this.setText(level.getName());
                }
            } else if (userObject instanceof String) {
                icon = Resources.getImageIcon((String)"Folder.gif", (int)16);
            } else if (userObject instanceof OLAPCube) {
                icon = Resources.getImageIcon((String)"OLAPCube.gif", (int)16);
            } else if (userObject instanceof OLAPDimension) {
                icon = Resources.getImageIcon((String)"OLAPDimension.gif", (int)16);
            } else if (userObject instanceof OLAPHierarchy) {
                icon = Resources.getImageIcon((String)"OLAPHierarchy.gif", (int)16);
            }
            this.setIcon(icon);
            return this;
        }
    }

    class SelectedTreeListener
    implements TreeSelectionListener {
        SelectedTreeListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent tse) {
            JTree selectedTree = (JTree)CubeMeasuresDistinctCountPanel.this.treeSelector.getTargetComponent();
            TreePath[] selectedPath = selectedTree.getSelectionPaths();
            boolean first = false;
            if (selectedPath == null) {
                CubeMeasuresDistinctCountPanel.this.include.setEnabled(false);
                CubeMeasuresDistinctCountPanel.this.exclude.setEnabled(false);
                CubeMeasuresDistinctCountPanel.this.invisible.setSelected(true);
                return;
            }
            CubeMeasuresDistinctCountPanel.this.include.setEnabled(true);
            CubeMeasuresDistinctCountPanel.this.exclude.setEnabled(true);
            int size = selectedPath.length;
            for (int i = 0; i < size; ++i) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)selectedPath[i].getLastPathComponent();
                if (node == null) {
                    return;
                }
                Object currentObject = node.getUserObject();
                if (currentObject instanceof OLAPLevel) {
                    DefaultMutableTreeNode treenode = (DefaultMutableTreeNode)node.getParent();
                    OLAPHierarchy hierarchy = (OLAPHierarchy)treenode.getUserObject();
                    OLAPLevel level = (OLAPLevel)currentObject;
                    boolean includeOrExclude = level.isCalculatedMembersIncluded(hierarchy);
                    if (i == 0) {
                        first = includeOrExclude;
                        continue;
                    }
                    if (!(first & !includeOrExclude) && !(!first & includeOrExclude)) continue;
                    CubeMeasuresDistinctCountPanel.this.invisible.setSelected(true);
                    return;
                }
                CubeMeasuresDistinctCountPanel.this.include.setEnabled(false);
                CubeMeasuresDistinctCountPanel.this.exclude.setEnabled(false);
                CubeMeasuresDistinctCountPanel.this.invisible.setSelected(true);
                return;
            }
            CubeMeasuresDistinctCountPanel.this.include.removeActionListener(CubeMeasuresDistinctCountPanel.this.includeExcludeListener);
            CubeMeasuresDistinctCountPanel.this.exclude.removeActionListener(CubeMeasuresDistinctCountPanel.this.includeExcludeListener);
            if (first) {
                CubeMeasuresDistinctCountPanel.this.include.setSelected(true);
            } else {
                CubeMeasuresDistinctCountPanel.this.exclude.setSelected(true);
            }
            CubeMeasuresDistinctCountPanel.this.include.addActionListener(CubeMeasuresDistinctCountPanel.this.includeExcludeListener);
            CubeMeasuresDistinctCountPanel.this.exclude.addActionListener(CubeMeasuresDistinctCountPanel.this.includeExcludeListener);
        }
    }
}

