/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.designer.visuals;

import com.sas.olapadmin.designer.model.AggregationSet;
import com.sas.olapadmin.designer.model.AggregationTable;
import com.sas.olapadmin.designer.model.LoadTable;
import com.sas.olapadmin.designer.model.OLAPColumn;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPList;
import com.sas.olapadmin.designer.model.OLAPMeasure;
import com.sas.olapadmin.designer.model.TableSet;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class CubeMeasureMapTable
extends JTable {
    private static final long serialVersionUID = 1L;
    protected static WAdminResource bundle = new WAdminResource(CubeMeasureMapTable.class);
    public TableValues tablevalues = new TableValues();
    public Object[][] values;
    public TableColumnModel tcm;
    private List storedMeasures;
    private List aggregateColumnsVector;
    private List usedAggregateColumns;
    protected Map aggregationColumns;
    private OLAPCube cubeModel;
    private int match = 1;
    protected OLAPList aggrTables;

    public CubeMeasureMapTable() {
        this.setRowSelectionAllowed(true);
        this.setColumnSelectionAllowed(false);
        this.setCellSelectionEnabled(false);
    }

    public void _setReadOnly() {
        this.setEnabled(false);
    }

    public void _setMeasureModel(OLAPList MeasureModels, OLAPCube CM) {
        this.cubeModel = CM;
        if (this.storedMeasures == null) {
            this.storedMeasures = new ArrayList();
        }
        this.storedMeasures.clear();
        if (this.aggregationColumns == null) {
            this.aggregationColumns = new HashMap();
        }
        if (this.usedAggregateColumns == null) {
            this.usedAggregateColumns = new ArrayList();
        }
        this.usedAggregateColumns.clear();
        this.aggregationColumns.clear();
        for (int i = 0; i < MeasureModels.size(); ++i) {
            OLAPMeasure measureModel = (OLAPMeasure)MeasureModels.get(i);
            if (!measureModel.isStoredStatistic().booleanValue()) continue;
            this.storedMeasures.add(measureModel);
        }
        AggregationSet aggregationSet = this.cubeModel.getAggregationSet();
        if (this.aggregateColumnsVector == null) {
            this.aggregateColumnsVector = new ArrayList();
        }
        this.aggregateColumnsVector.clear();
        try {
            this.aggrTables = aggregationSet.getTables();
        }
        catch (OLAPException measureModel) {
            // empty catch block
        }
        LoadTable inputTable = null;
        TableSet tableSet = this.cubeModel.getTableSet();
        try {
            inputTable = tableSet.getLoadTable();
        }
        catch (OLAPException e) {
            ExceptionHandler.handleException((Exception)((Object)e));
        }
        int aggrtablesize = this.aggrTables.size();
        if (aggrtablesize > 0) {
            List columnpropfirst = null;
            AggregationTable firstTable = (AggregationTable)this.aggrTables.get(0);
            try {
                columnpropfirst = firstTable.getAllNumericColumns();
            }
            catch (OLAPException OLAPError) {
                ExceptionHandler.handleException((Exception)((Object)OLAPError));
            }
            for (int i = 0; i < columnpropfirst.size(); ++i) {
                ArrayList<OLAPColumn> aggregatecols = new ArrayList<OLAPColumn>();
                OLAPColumn CP = (OLAPColumn)columnpropfirst.get(i);
                String columnName = CP.getSASColumnName();
                this.match = 1;
                if (aggrtablesize > 1) {
                    for (int t = 1; t < aggrtablesize; ++t) {
                        AggregationTable Phytable = (AggregationTable)this.aggrTables.get(t);
                        List columns = null;
                        try {
                            columns = Phytable.getAllNumericColumns();
                        }
                        catch (OLAPException oLAPException) {
                            // empty catch block
                        }
                        for (int a = 0; a < columns.size(); ++a) {
                            OLAPColumn ColumnP = (OLAPColumn)columns.get(a);
                            String checkingname = ColumnP.getSASColumnName();
                            if (!columnName.equals(checkingname)) continue;
                            ++this.match;
                            aggregatecols.add(ColumnP);
                            a = columns.size();
                        }
                    }
                }
                if (this.match != aggrtablesize) continue;
                this.aggregateColumnsVector.add(columnName);
                aggregatecols.add(CP);
                this.aggregationColumns.put(columnName, aggregatecols);
            }
        }
        if (this.aggregateColumnsVector.size() < 1) {
            MessageUtil.displayMessage((String)bundle.getString("CubeDesigner.MeasureMap.noColumns.txt"), (int)2);
        }
        int testsize = MeasureModels.size();
        for (int i = 0; i < MeasureModels.size(); ++i) {
            OLAPMeasure MM = (OLAPMeasure)MeasureModels.get(i);
            if (MM.isStoredStatistic().booleanValue()) continue;
            --testsize;
        }
        this.values = new Object[testsize][4];
        int modelnumber = 0;
        AggregationTable phytable = null;
        phytable = this.aggrTables.indexOf((Object)inputTable) == 0 & aggrtablesize > 1 ? (AggregationTable)this.aggrTables.get(1) : (AggregationTable)this.aggrTables.get(0);
        for (int i = 0; i < MeasureModels.size(); ++i) {
            OLAPMeasure MM = (OLAPMeasure)MeasureModels.get(i);
            if (!MM.isStoredStatistic().booleanValue()) {
                ++modelnumber;
                continue;
            }
            this.values[i - modelnumber][0] = MM;
            OLAPColumn CPaggrcol = null;
            try {
                String inputcolname = MM.getInputColumn().getSASColumnName();
                this.values[i - modelnumber][1] = inputcolname;
                String statname = MM.getStatistic().getName();
                this.values[i - modelnumber][2] = statname;
                CPaggrcol = MM.getAggregateColumn(phytable);
            }
            catch (OLAPException OLAPError) {
                ExceptionHandler.handleException((Exception)((Object)OLAPError));
            }
            if (CPaggrcol != null && this.aggregateColumnsVector.contains(CPaggrcol.getSASColumnName())) {
                this.values[i - modelnumber][3] = CPaggrcol.getSASColumnName();
                this.usedAggregateColumns.add(i - modelnumber, CPaggrcol.getSASColumnName());
                continue;
            }
            this.usedAggregateColumns.add(i - modelnumber, "0");
        }
        this.setModel(this.tablevalues);
        this.tcm = this.getColumnModel();
        TableColumn MeasureName = this.tcm.getColumn(0);
        MeasureName.setPreferredWidth(150);
        TableColumn InputColumn = this.tcm.getColumn(1);
        InputColumn.setPreferredWidth(145);
        TableColumn Statistic2 = this.tcm.getColumn(2);
        Statistic2.setPreferredWidth(140);
        TableColumn Aggrcolumn = this.tcm.getColumn(3);
        JComboBox<Object> Typecombobox = new JComboBox<Object>(this.aggregateColumnsVector.toArray());
        Typecombobox.setName("AggregateColumn");
        Typecombobox.setEditable(false);
        DefaultCellEditor TypeEditor = new DefaultCellEditor(Typecombobox);
        Aggrcolumn.setCellEditor(TypeEditor);
        Aggrcolumn.setPreferredWidth(150);
    }

    class TableValues
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        public static final int MEASURE_NAME = 0;
        public static final int INPUT_NAME = 1;
        public static final int STAT = 2;
        public static final int AGGR_COL = 3;
        public final String[] columnNames = new String[]{bundle.getString("CubeDesigner.Measure.Name.txt"), bundle.getString("CubeDesigner.Measure.Input.name.txt"), bundle.getString("CubeDesigner.Measure.Statistic.txt"), bundle.getString("CubeDesigner.Measure.Aggr.column.txt")};

        TableValues() {
        }

        @Override
        public int getRowCount() {
            if (CubeMeasureMapTable.this.values == null) {
                return 0;
            }
            return CubeMeasureMapTable.this.values.length;
        }

        @Override
        public int getColumnCount() {
            if (CubeMeasureMapTable.this.values == null) {
                return 0;
            }
            return CubeMeasureMapTable.this.values[0].length;
        }

        @Override
        public Object getValueAt(int row, int column) {
            return CubeMeasureMapTable.this.values[row][column];
        }

        @Override
        public String getColumnName(int column) {
            return this.columnNames[column];
        }

        @Override
        public boolean isCellEditable(int row, int Column) {
            return !(Column == 0 | Column == 1 | Column == 2);
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
            this.fireTableCellUpdated(row, column);
            OLAPMeasure MModel = (OLAPMeasure)CubeMeasureMapTable.this.storedMeasures.get(row);
            switch (column) {
                case 3: {
                    String checkvalue = String.valueOf(value);
                    if (value == null) break;
                    if (CubeMeasureMapTable.this.usedAggregateColumns.contains(checkvalue) & CubeMeasureMapTable.this.usedAggregateColumns.indexOf(checkvalue) != row) {
                        MessageUtil.displayMessage((String)bundle.getString("CubeDesigner.Measure.Duplicate.txt"), (int)2);
                        break;
                    }
                    CubeMeasureMapTable.this.usedAggregateColumns.set(row, checkvalue);
                    List tablesvector = (List)CubeMeasureMapTable.this.aggregationColumns.get(checkvalue);
                    if (tablesvector == null) break;
                    for (int k = 0; k < tablesvector.size(); ++k) {
                        OLAPColumn col = (OLAPColumn)tablesvector.get(k);
                        try {
                            MModel.setAggregateColumn(col.getSASColumnName());
                            continue;
                        }
                        catch (OLAPException OLAPError) {
                            ExceptionHandler.handleException((Exception)((Object)OLAPError));
                        }
                    }
                    CubeMeasureMapTable.this.values[row][column] = value;
                }
            }
        }
    }
}

