/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.designer.visuals;

import com.sas.metadata.remote.PhysicalTable;
import com.sas.olapadmin.designer.model.AbstractOLAPModel;
import com.sas.olapadmin.designer.model.DimensionSet;
import com.sas.olapadmin.designer.model.LoadTable;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPDimension;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPList;
import com.sas.olapadmin.designer.model.OLAPMemberPropertySet;
import com.sas.olapadmin.designer.model.TableSet;
import com.sas.olapadmin.designer.visuals.MapLoadTableFactKeysTab;
import com.sas.olapadmin.designer.visuals.MapLoadTableLevelsTab;
import com.sas.olapadmin.designer.visuals.MapLoadTableMeasuresTab;
import com.sas.olapadmin.designer.visuals.MapLoadTableOLAPMemberPropertiesTab;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.workspace.WAPropertyDialog;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAdminResource;
import java.awt.Dialog;
import java.util.List;

public class CubeLoadTableMapDialog
extends WAPropertyDialog {
    private static final long serialVersionUID = 1L;
    private static WAdminResource bundle = new WAdminResource(CubeLoadTableMapDialog.class);
    private OLAPCube owningCube;
    private PhysicalTable mappedTable;
    private MapLoadTableLevelsTab mapLoadTableLevelsTab;
    private MapLoadTableMeasuresTab mapLoadTableMeasuresTab;
    private MapLoadTableOLAPMemberPropertiesTab mapLoadTableMemberPropertiesTab;
    private MapLoadTableFactKeysTab mapLoadTableFactKeysTab;

    public CubeLoadTableMapDialog(Dialog owner, AbstractOLAPModel inputObject, PhysicalTable inputMappedTable) {
        super(owner, bundle.getString("CubeDesigner.MapLoadTable.title.txt"), true);
        this.owningCube = (OLAPCube)inputObject;
        this.mappedTable = inputMappedTable;
        try {
            TableSet tableSet;
            DimensionSet dimensionSet = this.owningCube.getDimensionSet();
            boolean addLevelTab = false;
            List dimensions = dimensionSet.getAllCubeDimensions();
            for (int i = dimensions.size() - 1; i >= 0 && !addLevelTab; --i) {
                OLAPDimension dimension = (OLAPDimension)dimensions.get(i);
                addLevelTab = !dimension.isStarDimension();
            }
            if (addLevelTab) {
                this.mapLoadTableLevelsTab = new MapLoadTableLevelsTab((AbstractOLAPModel)this.owningCube, this.mappedTable);
                this.mapLoadTableLevelsTab.setName("mapLevelsTab");
                this.addTab(bundle.getString("MapLoadTable.Levels.tab.txt"), (WAPropertyTab)this.mapLoadTableLevelsTab);
            }
            this.mapLoadTableMeasuresTab = new MapLoadTableMeasuresTab(this.owningCube.getMeasureSet(), this.mappedTable);
            this.mapLoadTableMeasuresTab.setName("mapMeasuresTab");
            this.addTab(bundle.getString("MapLoadTable.Measures.tab.txt"), (WAPropertyTab)this.mapLoadTableMeasuresTab);
            OLAPMemberPropertySet propertySet = this.owningCube.getOLAPMemberPropertySet();
            OLAPList properties = propertySet.getOLAPProperties();
            OLAPList starSchemaProperties = propertySet.getStarSchemaProperties();
            if (properties.size() != starSchemaProperties.size()) {
                this.mapLoadTableMemberPropertiesTab = new MapLoadTableOLAPMemberPropertiesTab(propertySet, this.mappedTable);
                this.mapLoadTableMeasuresTab.setName("mapMeasuresTab");
                this.addTab(bundle.getString("MapLoadTable.MemberProperties.tab.txt"), (WAPropertyTab)this.mapLoadTableMemberPropertiesTab);
            }
            if ((tableSet = this.owningCube.getTableSet()).isLoadStarSchema()) {
                this.mapLoadTableFactKeysTab = new MapLoadTableFactKeysTab(this.owningCube.getDimensionSet(), this.mappedTable);
                this.mapLoadTableFactKeysTab.setName("mapFactKeysTab");
                this.addTab(bundle.getString("MapLoadTable.FactKeys.tab.txt"), (WAPropertyTab)this.mapLoadTableFactKeysTab);
            }
            this.setHelpProduct("olapadmin");
            this.setHelpTopic("cd_map_new_table");
        }
        catch (OLAPException error) {
            ExceptionHandler.handleException((Exception)((Object)error));
        }
    }

    protected void initialize() {
        super.initialize();
    }

    protected boolean onOK() {
        try {
            LoadTable loadTable = this.owningCube.getTableSet().getLoadTable();
            StringBuffer mappedMessage = loadTable.getMappedMessage();
            if (mappedMessage.length() > 0) {
                this.mapLoadTableMeasuresTab.saveToModel();
                if (this.mapLoadTableLevelsTab != null) {
                    this.mapLoadTableLevelsTab.saveToModel();
                }
                if (this.mapLoadTableMemberPropertiesTab != null) {
                    this.mapLoadTableMemberPropertiesTab.saveToModel();
                }
                if (this.mapLoadTableFactKeysTab != null) {
                    this.mapLoadTableFactKeysTab.saveToModel();
                }
            }
        }
        catch (OLAPException error) {
            ExceptionHandler.handleException((Exception)((Object)error));
        }
        return true;
    }
}

