/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.designer.visuals;

import com.sas.metadata.remote.MdException;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.TableSet;
import com.sas.olapadmin.designer.visuals.CubeInputPanel;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsDescriptionWizardTab;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.rmi.RemoteException;

public class CubeInputTab
extends WsDescriptionWizardTab {
    private static final long serialVersionUID = 1L;
    private static WAdminResource bundle = new WAdminResource(CubeInputTab.class);
    private CubeInputPanel m_appPanel;
    private OLAPCube olapCube;
    private static final String STAR_CUBE = "STAR";
    private static final String NON_STAR_CUBE = "NEXT";

    public CubeInputTab(OLAPCube cubeModel) {
        super(bundle.getString("CubeDesigner.Input.instruct.txt"));
        this.m_appPanel = new CubeInputPanel(cubeModel);
        this.olapCube = cubeModel;
        this.setHelpProduct("olapadmin");
        this.setHelpTopic("cd_input");
        this.setLayout(new GridBagLayout());
        this._layoutWidgets();
    }

    public String getConditionState() {
        this.m_conditionState = NON_STAR_CUBE;
        TableSet tableSet = this.olapCube.getTableSet();
        try {
            if (tableSet.isLoadStarSchema()) {
                this.m_conditionState = STAR_CUBE;
            }
        }
        catch (OLAPException e) {
            ExceptionHandler.handleException((Exception)((Object)e));
        }
        return this.m_conditionState;
    }

    public boolean validateData() {
        return this.m_appPanel.validateData();
    }

    public boolean doDataExchange(boolean bSaveToModel) throws MdException, RemoteException {
        this.m_appPanel.doDataExchange(bSaveToModel);
        return true;
    }

    public boolean hasTreeDataChanged() {
        return this.m_appPanel.hasTreeDataChanged();
    }

    public void _layoutWidgets() {
        this.add((Component)((Object)this.m_appPanel), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void saveSettingsAndCleanUp() {
        this.m_appPanel.saveSettingsAndCleanUp();
    }
}

