/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.designer.visuals;

import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.olapadmin.designer.model.AbstractOLAPModel;
import com.sas.olapadmin.designer.model.DimensionSet;
import com.sas.olapadmin.designer.model.LanguageSet;
import com.sas.olapadmin.designer.model.LoadTable;
import com.sas.olapadmin.designer.model.ModelUtilities;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPDimension;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPHierarchy;
import com.sas.olapadmin.designer.model.OLAPLevel;
import com.sas.olapadmin.designer.model.OLAPList;
import com.sas.olapadmin.designer.model.ReachThruTable;
import com.sas.olapadmin.designer.model.TableSet;
import com.sas.olapadmin.designer.visuals.CubeStructureMessagePanel;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.olapadmin.utilities.Utilities;
import com.sas.olapadmin.utilities.studio.DetailsMessage;
import com.sas.olapadmin.utilities.studio.DrillTableChangeEvent;
import com.sas.olapadmin.utilities.studio.DrillTableSelectionListener;
import com.sas.olapadmin.utilities.studio.PhysicalTableSelector;
import com.sas.services.ServiceException;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsDescriptionWizardTab;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;

public class CubeInputPanel
extends WAPanel
implements DrillTableSelectionListener {
    private static final long serialVersionUID = 1L;
    private static WAdminResource bundle = new WAdminResource(CubeInputPanel.class);
    private PhysicalTableSelector tree;
    private OLAPCube cubeModel;
    private PhysicalTable physTable;
    private String options;
    private TableSet tableSet;
    private boolean initialized = false;
    private boolean isStarSchema;
    private JCheckBox dtLangSupport;
    private LanguageSet languageSet;

    public CubeInputPanel(OLAPCube inputOLAPCube) {
        this.cubeModel = inputOLAPCube;
        this.setLayout(new GridBagLayout());
        this.tableSet = this.cubeModel.getTableSet();
        this.layoutWidgets();
    }

    public boolean validateData() {
        LoadTable loadTable;
        List nodes = this.tree.getSelectedTables();
        if (nodes == null || nodes.size() < 1) {
            if (this.isStarSchema) {
                MessageUtil.displayMessage((String)bundle.getString("CubeDesigner.InputPanel.NoFactTableError.txt"));
            } else {
                MessageUtil.displayMessage((String)bundle.getString("CubeDesigner.InputPanel.NoInputTableError.txt"));
            }
            return false;
        }
        if (!Utilities.isConnectedToMetadataServer((boolean)true)) {
            return false;
        }
        try {
            this.physTable = this.tree.getSelectedTable();
            loadTable = this.tableSet.getLoadTable();
            if (loadTable == null && this.physTable != null) {
                this.tableSet.setLoadTable(this.physTable);
                loadTable = this.tableSet.getLoadTable();
            } else if (loadTable != null && !loadTable.equals(this.physTable)) {
                if (loadTable != null && this.cubeModel.hasStructure()) {
                    loadTable.mapTable(this.physTable);
                }
                if (this.physTable != null) {
                    boolean setLoadTable = true;
                    boolean hasAdvancedOptions = false;
                    ArrayList<String> cubeOptions = new ArrayList<String>();
                    LanguageSet languageSet = this.cubeModel.getLanguageSet();
                    DimensionSet dimensionSet = this.cubeModel.getDimensionSet();
                    OLAPList listOfDimensions = dimensionSet.getCubeDimensions();
                    OLAPList listOfDimensionTables = dimensionSet.getTables();
                    if (listOfDimensions != null && !listOfDimensions.isEmpty() || listOfDimensionTables != null && !listOfDimensionTables.isEmpty() || !ModelUtilities.isBlank((String)this.cubeModel.getSASCode()) || !ModelUtilities.isBlank((String)this.cubeModel.getFormatSearchOptions()) || this.cubeModel.getEmptyChar() != null || this.cubeModel.getEmptyNum() != null || languageSet.getSelectedLocales().size() > 0 || this.cubeModel.getCompact() != null) {
                        String cubeOption = this.cubeModel.getSASCode();
                        cubeOptions.add(cubeOption);
                        hasAdvancedOptions = !ModelUtilities.isBlank((String)cubeOption);
                        cubeOption = this.cubeModel.getFormatSearchOptions();
                        cubeOptions.add(cubeOption);
                        hasAdvancedOptions = hasAdvancedOptions || !ModelUtilities.isBlank((String)cubeOption);
                        cubeOption = this.cubeModel.getEmptyChar();
                        cubeOptions.add(cubeOption);
                        hasAdvancedOptions = hasAdvancedOptions || !ModelUtilities.isBlank((String)cubeOption);
                        cubeOption = this.cubeModel.getEmptyNum();
                        cubeOptions.add(cubeOption);
                        boolean bl = hasAdvancedOptions = hasAdvancedOptions || !ModelUtilities.isBlank((String)cubeOption);
                        if (this.cubeModel.getLanguageSet().getSelectedLocales().size() > 0) {
                            cubeOptions.add("languages!");
                            hasAdvancedOptions = true;
                        } else {
                            cubeOptions.add(null);
                        }
                        cubeOption = this.cubeModel.getCompact();
                        cubeOptions.add(cubeOption);
                        hasAdvancedOptions = hasAdvancedOptions || !ModelUtilities.isBlank((String)cubeOption);
                    }
                    boolean validStructure = true;
                    if (!loadTable.mapHasValidStructure()) {
                        validStructure = false;
                    }
                    PhysicalTable mappedTable = null;
                    if (loadTable != null && this.cubeModel.hasStructure()) {
                        mappedTable = loadTable.getMappedTable();
                    }
                    boolean perfectMap = true;
                    if (mappedTable != null) {
                        perfectMap = loadTable.isPerfectMap();
                    }
                    boolean hasMapChanged = loadTable.isMapChanged();
                    if (mappedTable != null) {
                        if (!perfectMap || hasMapChanged) {
                            StringBuffer message = new StringBuffer();
                            if (loadTable != null) {
                                message.append(loadTable.getMappedMessage());
                            }
                            List messages = loadTable.getMappedTableStructureChanges();
                            int messagesSize = messages.size();
                            message.append(bundle.getString("CubeDesigner.General.InputChanged.Warning2.txt"));
                            if (!hasAdvancedOptions && messagesSize > 0) {
                                message.append(bundle.getString("CubeDesigner.InputPanel.MappedTableDetailsStructureOnly.txt"));
                            } else if (hasAdvancedOptions && messagesSize > 0) {
                                message.append(bundle.getString("CubeDesigner.InputPanel.MappedTableDetails.txt"));
                            } else if (hasAdvancedOptions && messagesSize < 1) {
                                message.append(bundle.getString("CubeDesigner.InputPanel.MappedTableDetailsOptionsOnly.txt"));
                            }
                            CubeStructureMessagePanel messagePanel = new CubeStructureMessagePanel(messages, (AbstractOLAPModel)this.cubeModel, cubeOptions);
                            int option = 0;
                            option = hasAdvancedOptions || messages.size() > 0 ? DetailsMessage.showDialog(message.toString(), bundle.getString("MapLoadTable.ChangeStructureMessage.title.txt"), 2, 0, messagePanel) : MessageUtil.displayMessage((String)message.toString(), (int)2, (int)0);
                            if (option == 0) {
                                messagePanel.saveToModel();
                                if (!validStructure) {
                                    this.cubeModel.reset();
                                    if (loadTable != null) {
                                        loadTable.clearMap();
                                    }
                                } else {
                                    this.cubeModel.resetOptions();
                                }
                                this.tableSet.setLoadTable(this.physTable);
                                setLoadTable = false;
                                WAWizardDialog parent = (WAWizardDialog)this.getTopLevelAncestor();
                                parent.addWizardData("TABLECHANGED", (Object)"YES");
                            }
                            if (option != 0) {
                                return false;
                            }
                        }
                    } else if (hasAdvancedOptions && this.cubeModel.hasStructure()) {
                        int option = 0;
                        CubeStructureMessagePanel messagePanel = new CubeStructureMessagePanel(null, (AbstractOLAPModel)this.cubeModel, cubeOptions);
                        option = MessageUtil.displayDetailsMessage((String)bundle.getString("CubeDesigner.InputPanel.MappedTableDetailsOptionsOnly.txt"), (String)bundle.getString("MapLoadTable.ChangeStructureMessage.title.txt"), (int)2, (int)2, (JComponent)messagePanel);
                        if (option == 0) {
                            messagePanel.saveToModel();
                            this.cubeModel.resetOptions();
                        } else {
                            return false;
                        }
                    }
                    if (setLoadTable) {
                        this.tableSet.setLoadTable(this.physTable);
                    }
                    if (loadTable != null) {
                        loadTable.clearMap();
                    }
                    if (loadTable == null) {
                        loadTable = this.tableSet.getLoadTable();
                    }
                    mappedTable = null;
                    for (int dimNum = 0; dimNum < listOfDimensions.size(); ++dimNum) {
                        OLAPDimension dim = (OLAPDimension)listOfDimensions.get(dimNum);
                        dim.apply();
                        OLAPList hierarchies = dim.getHierarchies();
                        for (int hierNum = 0; hierNum < hierarchies.size(); ++hierNum) {
                            OLAPHierarchy hier = (OLAPHierarchy)hierarchies.get(hierNum);
                            hier.apply();
                        }
                        OLAPList levels = dim.getLevels();
                        for (int levelNum = 0; levelNum < levels.size(); ++levelNum) {
                            OLAPLevel level = (OLAPLevel)levels.get(levelNum);
                            level.apply();
                        }
                    }
                }
            }
        }
        catch (OLAPException e) {
            return ExceptionHandler.handleException((Exception)((Object)e));
        }
        this.options = this.tree.getOptions();
        try {
            int choice;
            loadTable = this.tableSet.getLoadTable();
            loadTable.clearMap();
            this.cubeModel.setTableOptions(this.options);
            if (loadTable != null) {
                loadTable.setSASLibrary();
            }
            PhysicalTable drillPhysicalTable = this.tree.getSelectedDrillTable();
            ReachThruTable tempTable = this.tableSet.getReachThruTable();
            if (tempTable != null && drillPhysicalTable == null && (choice = MessageUtil.displayMessage((String)bundle.formatString("CubeDesigner.Delete.Message.fmt.txt", (Object)tempTable.getTable().getName()), (String)bundle.getString("CubeDesigner.DeleteReachthru.window.title"), (int)1, (int)0)) == 1) {
                return false;
            }
            String reachTableOptions = null;
            if (drillPhysicalTable != null) {
                if (this.dtLangSupport.isSelected()) {
                    List missingTables = this.tableSet.checkForLanguageTables(drillPhysicalTable);
                    if (!missingTables.isEmpty()) {
                        String message = bundle.getString("CubeDesigner.InputPanel.ReachThru.MissingLanguages.txt");
                        MessageUtil.displayListMessage((String)message, (List)missingTables, (String)bundle.getString("CubeDesigner.InputPanel.ReachThruConfirm.window.title"), (int)2, (int)-1);
                        return false;
                    }
                    this.cubeModel.setDrillThruMemPref(drillPhysicalTable.getSASTableName());
                } else {
                    this.cubeModel.setDrillThruMemPref(null);
                }
                reachTableOptions = this.tree.getDrillOptions();
                this.tableSet.setReachThruTable(drillPhysicalTable);
                this.tableSet.getReachThruTable().setTableOptions(reachTableOptions);
            } else {
                reachTableOptions = null;
                ReachThruTable reachthruTable = this.tableSet.getReachThruTable();
                if (reachthruTable != null) {
                    reachthruTable.setTableOptions("");
                }
                this.tableSet.setReachThruTable(drillPhysicalTable);
                this.cubeModel.setDrillThruMemPref(null);
            }
        }
        catch (RemoteException remoteError) {
            return ExceptionHandler.handleException((Exception)remoteError);
        }
        catch (OLAPException e) {
            return ExceptionHandler.handleException((Exception)((Object)e));
        }
        catch (ServiceException e) {
            Workspace.handleServiceException((ServiceException)e);
        }
        catch (MdException e) {
            return ExceptionHandler.handleException((Exception)((Object)e));
        }
        this.tree.dataChanged = false;
        return true;
    }

    public boolean doDataExchange(boolean saveToModel) throws MdException, RemoteException {
        if (!saveToModel & Utilities.isConnectedToMetadataServer((boolean)true)) {
            this.initializeView();
        }
        return true;
    }

    protected void initializeView() throws MdException, RemoteException {
        try {
            WsDescriptionWizardTab parentTab;
            this.isStarSchema = this.tableSet.isLoadStarSchema();
            WAWizardDialog parent = (WAWizardDialog)this.getTopLevelAncestor();
            if (this.isStarSchema) {
                this.tree.setStarGenericLabel();
                parentTab = (WsDescriptionWizardTab)this.getParent();
                parentTab.setDescription(bundle.getString("CubeDesigner.InputFactTable.instruct.txt"));
            } else {
                this.tree.setGenericLabel();
                parentTab = (WsDescriptionWizardTab)this.getParent();
                parentTab.setDescription(bundle.getString("CubeDesigner.Input.instruct.txt"));
            }
            LoadTable table = this.tableSet.getLoadTable();
            PhysicalTable selectedTable = null;
            String olapCubeReset = (String)parent.getWizardData("OLAPCUBE_RESET");
            boolean isOlapCubeReset = olapCubeReset != null && olapCubeReset.equals("TRUE");
            parent.addWizardData("OLAPCUBE_RESET", (Object)"FALSE");
            if (table == null) {
                selectedTable = this.tree.getSelectedTable();
            }
            if (table != null && !this.initialized) {
                this.tree.initializeSelectedTable(table.getTable());
                this.tree.setOptions(table.getTableOptions());
            } else if (selectedTable == null || isOlapCubeReset) {
                this.tree.initializeSelectedTable(null);
                this.tree.setOptions(null);
            }
            this.languageSet = this.cubeModel.getLanguageSet();
            boolean isMLS = this.languageSet.isCubeMultipleLanguageSupported();
            if (!isMLS) {
                this.dtLangSupport.setEnabled(false);
                this.dtLangSupport.setSelected(false);
                this.tree.removeDrillTableSelectionListener(this);
            } else {
                this.tree.removeDrillTableSelectionListener(this);
                this.tree.addDrillTableSelectionListener(this);
            }
            if (!this.initialized) {
                this.setCursor(Cursor.getPredefinedCursor(3));
                this.initialized = true;
                this.tree.populateStore();
                this.dtLangSupport.setEnabled(false);
                ReachThruTable reachThruTable = this.tableSet.getReachThruTable();
                if (reachThruTable != null) {
                    PhysicalTable physicalTable = reachThruTable.getTable();
                    String tableOptions = reachThruTable.getTableOptions();
                    if (!ModelUtilities.isBlank((String)tableOptions)) {
                        this.tree.setDrillOptions(tableOptions);
                    }
                    this.tree.initializeDrillTable(physicalTable);
                    if (isMLS) {
                        this.dtLangSupport.setEnabled(true);
                        boolean isMLSDT = this.languageSet.isCubeMLSDrillThruSupported();
                        this.dtLangSupport.setSelected(isMLSDT);
                    }
                }
                this.tree.moveDataToView();
                this.tree.setMapTableButton(false);
                this.setCursor(Cursor.getPredefinedCursor(0));
            } else if (this.initialized && isMLS && this.tree.getSelectedDrillTable() != null) {
                this.dtLangSupport.setEnabled(true);
            }
        }
        catch (OLAPException OLAPError) {
            ExceptionHandler.handleException((Exception)((Object)OLAPError));
        }
    }

    protected void layoutWidgets() {
        ArrayList<PhysicalTable> tables = new ArrayList<PhysicalTable>();
        if (!this.cubeModel.isNewObject()) {
            LoadTable loadTable = null;
            try {
                loadTable = this.tableSet.getLoadTable();
                if (loadTable != null && loadTable.getTable() != null) {
                    this.options = loadTable.getTableOptions();
                }
            }
            catch (OLAPException oLAPException) {
                // empty catch block
            }
            if (loadTable != null && loadTable.getTable() != null) {
                tables.add(loadTable.getTable());
            }
            this.tree = new PhysicalTableSelector(this.cubeModel, true);
        } else {
            this.tree = new PhysicalTableSelector(this.cubeModel);
        }
        this.add((Component)((Object)this.tree), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.dtLangSupport = new JCheckBox(bundle.getString("CubeDesigner.InputPanel.SupportMLSDrillThrough.checkbox.label"));
        this.add(this.dtLangSupport, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 0, 0), 0, 0));
    }

    @Override
    public void drillTableChanged(DrillTableChangeEvent e) {
        this.dtLangSupport.setEnabled(e.getDrillSelectedState());
        if (!e.getDrillSelectedState()) {
            this.dtLangSupport.setSelected(false);
        }
    }

    public boolean hasTreeDataChanged() {
        return this.tree.dataChanged;
    }

    public void saveSettingsAndCleanUp() {
        this.tree.removeDrillTableSelectionListener(this);
        this.tree.saveSettingsAndCleanUp();
    }
}

